/*
 * Decompiled with CFR 0.152.
 */
package com.roninpixels.dashboardhub.config.action;

import com.roninpixels.dashboardhub.config.DashboardHubConfig;
import com.roninpixels.dashboardhub.config.FrontendConfigurationService;
import com.roninpixels.dashboardhub.config.action.DHAction;
import com.roninpixels.dashboardhub.config.frontedModel.AppConfigModel;
import com.roninpixels.dashboardhub.config.frontedModel.FrontendConfigModel;
import com.roninpixels.dashboardhub.controllers.AccessManagementController;
import com.roninpixels.dashboardhub.controllers.BoardsControllerV2;
import com.roninpixels.dashboardhub.web.models.TokenContentModel;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHShowGlobalSettingsAction
implements DHAction {
    private static final Logger log = LoggerFactory.getLogger(DHShowGlobalSettingsAction.class);
    @Inject
    private FrontendConfigurationService configService;
    @Inject
    private DashboardHubConfig dashboardHubConfig;
    @Inject
    private BoardsControllerV2 boardsController;
    @Inject
    private AccessManagementController accessManagementController;
    private TokenContentModel tokenData;

    @Override
    public void setToken(TokenContentModel tokenContent) {
        this.tokenData = tokenContent;
    }

    @Override
    public DashboardHubConfig getDashboardHubConfig() {
        return this.dashboardHubConfig;
    }

    @Override
    public String getConfig() {
        try {
            FrontendConfigModel config = this.configService.createConfig();
            return this.configService.serializeConfig(config);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }

    @Override
    public String getAppConfig() {
        AppConfigModel appConfig = this.accessManagementController.getAdminConfig();
        try {
            return this.configService.serializeConfig(appConfig);
        }
        catch (IOException e) {
            log.error("Problems with configuration injection", (Throwable)e);
            return "ERROR";
        }
    }
}

