/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.util;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiException;

public final class Strings {
    private Strings() {
    }

    public static String escape(String s2) {
        StringBuilder sb = new StringBuilder(s2.length() + 10);
        block15: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\0");
                    continue block15;
                }
                case '\u0004': {
                    sb.append("\\E");
                    continue block15;
                }
                case '\u0007': {
                    sb.append("\\a");
                    continue block15;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block15;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block15;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block15;
                }
                case '\u000b': {
                    sb.append("\\v");
                    continue block15;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block15;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block15;
                }
                case '\u001b': {
                    sb.append("\\e");
                    continue block15;
                }
                case '\u001d': {
                    sb.append("\\G");
                    continue block15;
                }
                case '\u001e': {
                    sb.append("\\R");
                    continue block15;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block15;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        sb.append(c);
                        continue block15;
                    }
                    byte[] bytes = String.valueOf(c).getBytes(StandardCharsets.ISO_8859_1);
                    String hex = String.format("%02X", bytes[0] & 0xFF);
                    sb.append("\\x").append(hex);
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String s2, boolean lenient) {
        StringBuilder sb = new StringBuilder(s2.length());
        block16: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            if (i + 1 >= s2.length()) {
                String msg = "Error processing escape sequences: expected escape character, found end of string";
                throw new OkapiException(msg);
            }
            char c2 = s2.charAt(i + 1);
            switch (c2) {
                case '0': {
                    sb.append('\u0000');
                    ++i;
                    continue block16;
                }
                case 'E': {
                    sb.append('\u0004');
                    ++i;
                    continue block16;
                }
                case 'a': {
                    sb.append('\u0007');
                    ++i;
                    continue block16;
                }
                case 'b': {
                    sb.append('\b');
                    ++i;
                    continue block16;
                }
                case 't': {
                    sb.append('\t');
                    ++i;
                    continue block16;
                }
                case 'n': {
                    sb.append('\n');
                    ++i;
                    continue block16;
                }
                case 'v': {
                    sb.append('\u000b');
                    ++i;
                    continue block16;
                }
                case 'f': {
                    sb.append('\f');
                    ++i;
                    continue block16;
                }
                case 'r': {
                    sb.append('\r');
                    ++i;
                    continue block16;
                }
                case 'e': {
                    sb.append('\u001b');
                    ++i;
                    continue block16;
                }
                case 'G': {
                    sb.append('\u001d');
                    ++i;
                    continue block16;
                }
                case 'R': {
                    sb.append('\u001e');
                    ++i;
                    continue block16;
                }
                case '\\': {
                    sb.append('\\');
                    ++i;
                    continue block16;
                }
                case 'x': {
                    if (i + 3 >= s2.length()) {
                        String msg = "Error processing escape sequences: expected hex sequence, found end of string";
                        throw new OkapiException(msg);
                    }
                    char c3 = s2.charAt(i + 2);
                    char c4 = s2.charAt(i + 3);
                    if (Strings.isHex(c3) && Strings.isHex(c4)) {
                        byte b = (byte)Integer.parseInt("" + c3 + c4, 16);
                        sb.append(new String(new byte[]{b}, StandardCharsets.ISO_8859_1));
                        i += 3;
                        continue block16;
                    }
                    String msg = "Error processing escape sequences: expected hex sequence, found '" + c3 + c4 + "'";
                    throw new OkapiException(msg);
                }
                default: {
                    if (lenient) {
                        sb.append(c);
                        continue block16;
                    }
                    throw new OkapiException("Error processing escape sequences: expected valid escape character, found '" + c2 + "'");
                }
            }
        }
        return sb.toString();
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static void binaryAppend(StringBuilder s2, int value, int digits) {
        int start = 1 << digits - 1;
        for (int i = 0; i < digits; ++i) {
            if ((value & start >> i) == 0) {
                s2.append('0');
                continue;
            }
            s2.append('1');
        }
    }
}

