/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;

public class UspsPackage
extends Symbol {
    @Override
    protected void encode() {
        if (!this.content.matches("[0-9\\[\\]]+")) {
            throw new OkapiException("Invalid IMpb data");
        }
        if (this.content.length() % 2 != 0) {
            throw new OkapiException("Invalid IMpb data");
        }
        Code128 code128 = new Code128();
        code128.unsetCc();
        code128.setDataType(Symbol.DataType.GS1);
        code128.setContent(this.content);
        boolean fourTwenty = this.content.length() > 4 && this.content.charAt(1) == '4' && this.content.charAt(2) == '2' && this.content.charAt(3) == '0';
        String hrt = "";
        int bracketCount = 0;
        for (int i = 0; i < this.content.length(); ++i) {
            if (this.content.charAt(i) == '[') {
                ++bracketCount;
            }
            if (fourTwenty && bracketCount < 2 || this.content.charAt(i) < '0' || this.content.charAt(i) > '9') continue;
            hrt = hrt + this.content.charAt(i);
        }
        String spacedHrt = "";
        for (int i = 0; i < hrt.length(); ++i) {
            spacedHrt = spacedHrt + hrt.charAt(i);
            if (i % 4 != 3) continue;
            spacedHrt = spacedHrt + " ";
        }
        this.encodeInfo = code128.encodeInfo;
        this.readable = spacedHrt;
        this.pattern = new String[1];
        this.pattern[0] = code128.pattern[0];
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }

    @Override
    protected void plotSymbol() {
        int offset = 20;
        int yoffset = 15;
        String banner = "USPS TRACKING #";
        this.rectangles.clear();
        this.texts.clear();
        int y = yoffset;
        int h2 = 0;
        boolean black = true;
        int x = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            int w = this.pattern[0].charAt(xBlock) - 48;
            if (black) {
                h2 = this.row_height[0] == -1 ? this.default_height : this.row_height[0];
                if (w != 0 && h2 != 0) {
                    Rectangle2D.Double rect = new Rectangle2D.Double(x + offset, y, w, h2);
                    this.rectangles.add(rect);
                }
                this.symbol_width = x + w + 2 * offset;
            }
            black = !black;
            x += w;
        }
        this.symbol_height = h2 + 2 * yoffset;
        Rectangle2D.Double topBar = new Rectangle2D.Double(0.0, 0.0, this.symbol_width, 2.0);
        Rectangle2D.Double bottomBar = new Rectangle2D.Double(0.0, this.symbol_height - 2, this.symbol_width, 2.0);
        this.rectangles.add(topBar);
        this.rectangles.add(bottomBar);
        this.texts.add(new TextBox(0.0, (double)this.symbol_height - 6.0, this.symbol_width, this.readable, this.humanReadableAlignment));
        this.texts.add(new TextBox(0.0, 12.0, this.symbol_width, banner, this.humanReadableAlignment));
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }
}

