/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import uk.org.okapibarcode.backend.Hexagon;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.TextBox;
import uk.org.okapibarcode.util.Doubles;
import uk.org.okapibarcode.util.EciMode;
import uk.org.okapibarcode.util.Gs1;

public abstract class Symbol {
    protected static final int FNC1 = -1;
    protected static final int FNC2 = -2;
    protected static final int FNC3 = -3;
    protected static final int FNC4 = -4;
    protected static final String FNC1_STRING = "\\<FNC1>";
    protected static final String FNC2_STRING = "\\<FNC2>";
    protected static final String FNC3_STRING = "\\<FNC3>";
    protected static final String FNC4_STRING = "\\<FNC4>";
    private static char[] HIBC_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '.', ' ', '$', '/', '+', '%'};
    protected DataType inputDataType = DataType.ECI;
    protected boolean readerInit;
    protected int default_height = 40;
    protected int quietZoneHorizontal = 0;
    protected int quietZoneVertical = 0;
    protected int moduleWidth = 1;
    protected Font font;
    protected String fontName = "Helvetica";
    protected int fontSize = 8;
    protected HumanReadableLocation humanReadableLocation = HumanReadableLocation.BOTTOM;
    protected HumanReadableAlignment humanReadableAlignment = HumanReadableAlignment.CENTER;
    protected boolean emptyContentAllowed = false;
    protected String content;
    protected int eciMode = -1;
    protected int[] inputData;
    protected String readable = "";
    protected String[] pattern;
    protected int row_count = 0;
    protected int[] row_height;
    protected int symbol_height = 0;
    protected int symbol_width = 0;
    protected StringBuilder encodeInfo = new StringBuilder();
    protected List<Rectangle2D.Double> rectangles = new ArrayList<Rectangle2D.Double>();
    protected List<TextBox> texts = new ArrayList<TextBox>();
    protected List<Hexagon> hexagons = new ArrayList<Hexagon>();
    protected List<Ellipse2D.Double> target = new ArrayList<Ellipse2D.Double>();

    public void setDataType(DataType dataType) {
        if (dataType == DataType.GS1 && !this.gs1Supported()) {
            throw new IllegalArgumentException("This symbology type does not support GS1 data.");
        }
        this.inputDataType = dataType;
    }

    public DataType getDataType() {
        return this.inputDataType;
    }

    protected boolean gs1Supported() {
        return false;
    }

    public void setReaderInit(boolean readerInit) {
        this.readerInit = readerInit;
    }

    public boolean getReaderInit() {
        return this.readerInit;
    }

    public void setBarHeight(int barHeight) {
        this.default_height = barHeight;
    }

    public int getBarHeight() {
        return this.default_height;
    }

    public void setModuleWidth(int moduleWidth) {
        this.moduleWidth = moduleWidth;
    }

    public int getModuleWidth() {
        return this.moduleWidth;
    }

    public void setQuietZoneHorizontal(int quietZoneHorizontal) {
        this.quietZoneHorizontal = quietZoneHorizontal;
    }

    public int getQuietZoneHorizontal() {
        return this.quietZoneHorizontal;
    }

    public void setQuietZoneVertical(int quietZoneVertical) {
        this.quietZoneVertical = quietZoneVertical;
    }

    public int getQuietZoneVertical() {
        return this.quietZoneVertical;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontName = font.getFontName();
        this.fontSize = font.getSize();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontName(String fontName) {
        this.fontName = Objects.requireNonNull(fontName, "font name may not be null");
        this.font = null;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.font = null;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getWidth() {
        return this.symbol_width + 2 * this.quietZoneHorizontal;
    }

    public int getHeight() {
        return this.symbol_height + this.getHumanReadableHeight() + 2 * this.quietZoneVertical;
    }

    public int getHumanReadableHeight() {
        if (this.texts.isEmpty()) {
            return 0;
        }
        return this.getTheoreticalHumanReadableHeight();
    }

    protected int getTheoreticalHumanReadableHeight() {
        return (int)Math.ceil((double)this.fontSize * 1.2);
    }

    public String getEncodeInfo() {
        return this.encodeInfo.toString();
    }

    public int getEciMode() {
        return this.eciMode;
    }

    public void setHumanReadableLocation(HumanReadableLocation humanReadableLocation) {
        this.humanReadableLocation = humanReadableLocation;
    }

    public HumanReadableLocation getHumanReadableLocation() {
        return this.humanReadableLocation;
    }

    public void setHumanReadableAlignment(HumanReadableAlignment humanReadableAlignment) {
        this.humanReadableAlignment = humanReadableAlignment;
    }

    public HumanReadableAlignment getHumanReadableAlignment() {
        return this.humanReadableAlignment;
    }

    public List<Rectangle2D.Double> getRectangles() {
        return this.rectangles;
    }

    public List<TextBox> getTexts() {
        return this.texts;
    }

    public List<Hexagon> getHexagons() {
        return this.hexagons;
    }

    public List<Ellipse2D.Double> getTarget() {
        return this.target;
    }

    protected static String bin2pat(CharSequence bin) {
        int len = 0;
        boolean black = true;
        StringBuilder pattern = new StringBuilder(bin.length());
        for (int i = 0; i < bin.length(); ++i) {
            if (black) {
                if (bin.charAt(i) == '1') {
                    ++len;
                    continue;
                }
                black = false;
                pattern.append((char)(len + 48));
                len = 1;
                continue;
            }
            if (bin.charAt(i) == '0') {
                ++len;
                continue;
            }
            black = true;
            pattern.append((char)(len + 48));
            len = 1;
        }
        pattern.append((char)(len + 48));
        return pattern.toString();
    }

    public void setEmptyContentAllowed(boolean emptyContentAllowed) {
        this.emptyContentAllowed = emptyContentAllowed;
    }

    public boolean getEmptyContentAllowed() {
        return this.emptyContentAllowed;
    }

    public void setContent(String data) {
        if (data == null) {
            data = "";
        }
        this.encodeInfo.setLength(0);
        switch (this.inputDataType) {
            case GS1: {
                this.content = Gs1.verify(data, FNC1_STRING);
                this.readable = data.replace('[', '(').replace(']', ')');
                break;
            }
            case HIBC: {
                this.content = this.hibcProcess(data);
                break;
            }
            default: {
                this.content = data;
            }
        }
        if (this.content.isEmpty() && !this.emptyContentAllowed) {
            throw new OkapiException("No input data");
        }
        this.encode();
        this.plotSymbol();
        this.mergeVerticalBlocks();
    }

    public String getContent() {
        return this.content;
    }

    public String getHumanReadableText() {
        return this.readable;
    }

    protected void eciProcess() {
        EciMode eci = EciMode.of(this.content, "ISO8859_1", 3).or(this.content, "ISO8859_2", 4).or(this.content, "ISO8859_3", 5).or(this.content, "ISO8859_4", 6).or(this.content, "ISO8859_5", 7).or(this.content, "ISO8859_6", 8).or(this.content, "ISO8859_7", 9).or(this.content, "ISO8859_8", 10).or(this.content, "ISO8859_9", 11).or(this.content, "ISO8859_10", 12).or(this.content, "ISO8859_11", 13).or(this.content, "ISO8859_13", 15).or(this.content, "ISO8859_14", 16).or(this.content, "ISO8859_15", 17).or(this.content, "ISO8859_16", 18).or(this.content, "Windows_1250", 21).or(this.content, "Windows_1251", 22).or(this.content, "Windows_1252", 23).or(this.content, "Windows_1256", 24).or(this.content, "SJIS", 20).or(this.content, "UTF8", 26);
        if (EciMode.NONE.equals(eci)) {
            throw new OkapiException("Unable to determine ECI mode.");
        }
        this.eciMode = eci.mode;
        this.inputData = Symbol.toBytes(this.content, eci.charset, new int[0]);
        this.infoLine("ECI Mode: " + eci.mode);
        this.infoLine("ECI Charset: " + eci.charset.name());
    }

    protected static int[] toBytes(String s2, Charset charset, int ... suffix) {
        int k;
        if (!charset.newEncoder().canEncode(s2)) {
            return null;
        }
        byte[] fnc1 = FNC1_STRING.getBytes(charset);
        byte[] fnc2 = FNC2_STRING.getBytes(charset);
        byte[] fnc3 = FNC3_STRING.getBytes(charset);
        byte[] fnc4 = FNC4_STRING.getBytes(charset);
        byte[] bytes = s2.getBytes(charset);
        int[] data = new int[bytes.length + suffix.length];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            if (uk.org.okapibarcode.util.Arrays.containsAt(bytes, fnc1, i)) {
                data[j] = -1;
                i += fnc1.length - 1;
            } else if (uk.org.okapibarcode.util.Arrays.containsAt(bytes, fnc2, i)) {
                data[j] = -2;
                i += fnc1.length - 1;
            } else if (uk.org.okapibarcode.util.Arrays.containsAt(bytes, fnc3, i)) {
                data[j] = -3;
                i += fnc1.length - 1;
            } else if (uk.org.okapibarcode.util.Arrays.containsAt(bytes, fnc4, i)) {
                data[j] = -4;
                i += fnc1.length - 1;
            } else {
                data[j] = bytes[i] & 0xFF;
            }
            ++i;
            ++j;
        }
        for (k = 0; k < suffix.length; ++k) {
            data[j + k] = suffix[k];
        }
        if (j + k < i) {
            data = Arrays.copyOf(data, j + k);
        }
        return data;
    }

    protected abstract void encode();

    protected void plotSymbol() {
        this.rectangles.clear();
        this.texts.clear();
        int baseY = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        double h2 = 0.0;
        double y = baseY;
        for (int yBlock = 0; yBlock < this.row_count; ++yBlock) {
            boolean black = true;
            double x = 0.0;
            for (int xBlock = 0; xBlock < this.pattern[yBlock].length(); ++xBlock) {
                char c = this.pattern[yBlock].charAt(xBlock);
                double w = this.getModuleWidth(c - 48) * (double)this.moduleWidth;
                if (black) {
                    h2 = this.row_height[yBlock] == -1 ? (double)this.default_height : (double)this.row_height[yBlock];
                    if (w != 0.0 && h2 != 0.0) {
                        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h2);
                        this.rectangles.add(rect);
                    }
                    if (x + w > (double)this.symbol_width) {
                        this.symbol_width = (int)Math.ceil(x + w);
                    }
                }
                black = !black;
                x += w;
            }
            if (y - (double)baseY + h2 > (double)this.symbol_height) {
                this.symbol_height = (int)Math.ceil(y - (double)baseY + h2);
            }
            y += h2;
        }
        if (this.humanReadableLocation != HumanReadableLocation.NONE && !this.readable.isEmpty()) {
            double baseline = this.humanReadableLocation == HumanReadableLocation.TOP ? (double)this.fontSize : (double)(this.symbol_height + this.fontSize);
            this.texts.add(new TextBox(0.0, baseline, this.symbol_width, this.readable, this.humanReadableAlignment));
        }
    }

    protected double getModuleWidth(int originalWidth) {
        return originalWidth;
    }

    protected void mergeVerticalBlocks() {
        int before = this.rectangles.size();
        block0: for (int i = this.rectangles.size() - 1; i >= 0; --i) {
            Rectangle2D.Double rect1 = this.rectangles.get(i);
            for (int j = i - 1; j >= 0; --j) {
                Rectangle2D.Double rect2 = this.rectangles.get(j);
                if (!Doubles.roughlyEqual(rect1.y, rect2.y + rect2.height)) continue;
                if (Doubles.roughlyEqual(rect1.x, rect2.x) && Doubles.roughlyEqual(rect1.width, rect2.width)) {
                    rect2.height += rect1.height;
                    this.rectangles.remove(i);
                    continue block0;
                }
                if (rect2.x < rect1.x) continue block0;
            }
        }
        int after = this.rectangles.size();
        if (before != after) {
            this.infoLine("Blocks Merged: " + before + " -> " + after);
        }
    }

    private String hibcProcess(String source) {
        if (source.length() > 110) {
            throw new OkapiException("Data too long for HIBC LIC");
        }
        if (!(source = source.toUpperCase()).matches("[A-Z0-9-\\. \\$/+\\%]+?")) {
            throw new OkapiException("Invalid characters in input");
        }
        int counter = 41;
        for (int i = 0; i < source.length(); ++i) {
            counter += uk.org.okapibarcode.util.Arrays.positionOf(source.charAt(i), HIBC_CHAR_TABLE);
        }
        char checkDigit = HIBC_CHAR_TABLE[counter %= 43];
        this.infoLine("HIBC Check Digit Counter: " + counter);
        this.infoLine("HIBC Check Digit: " + checkDigit);
        return "+" + source + checkDigit;
    }

    protected int[] getCodewords() {
        throw new UnsupportedOperationException();
    }

    protected int[] getPatternAsCodewords(int size) {
        if (size >= 10) {
            throw new IllegalArgumentException("Pattern groups of 10 or more digits are likely to be too large to parse as integers.");
        }
        if (this.pattern == null || this.pattern.length == 0) {
            return new int[0];
        }
        int count = (int)Math.ceil((double)this.pattern[0].length() / (double)size);
        int[] codewords = new int[this.pattern.length * count];
        for (int i = 0; i < this.pattern.length; ++i) {
            String row = this.pattern[i];
            for (int j = 0; j < count; ++j) {
                int substringStart = j * size;
                int substringEnd = Math.min((j + 1) * size, row.length());
                codewords[i * count + j] = Integer.parseInt(row.substring(substringStart, substringEnd));
            }
        }
        return codewords;
    }

    protected void info(CharSequence s2) {
        this.encodeInfo.append(s2);
    }

    protected void infoSpace(int i) {
        this.encodeInfo.append(i).append(' ');
    }

    protected void infoSpace(char c) {
        this.encodeInfo.append(c).append(' ');
    }

    protected void infoLine(CharSequence s2) {
        this.encodeInfo.append(s2).append('\n');
    }

    protected void infoLine() {
        this.encodeInfo.append('\n');
    }

    public static enum DataType {
        ECI,
        GS1,
        HIBC;

    }
}

