/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.util.Locale;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class RoyalMail4State
extends Symbol {
    private static final String[] ROYAL_TABLE = new String[]{"TTFF", "TDAF", "TDFA", "DTAF", "DTFA", "DDAA", "TADF", "TFTF", "TFDA", "DATF", "DADA", "DFTA", "TAFD", "TFAD", "TFFT", "DAAD", "DAFT", "DFAT", "ATDF", "ADTF", "ADDA", "FTTF", "FTDA", "FDTA", "ATFD", "ADAD", "ADFT", "FTAD", "FTFT", "FDAT", "AADD", "AFTD", "AFDT", "FATD", "FADT", "FFTT"};
    private static final char[] KR_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    @Override
    protected void encode() {
        int top = 0;
        int bottom = 0;
        this.content = this.content.toUpperCase(Locale.ENGLISH);
        if (!this.content.matches("[0-9A-Z]+")) {
            throw new OkapiException("Invalid characters in data");
        }
        String dest = "A";
        for (int i = 0; i < this.content.length(); ++i) {
            int index = Arrays.positionOf(this.content.charAt(i), KR_SET);
            dest = dest + ROYAL_TABLE[index];
            top += (index + 1) % 6;
            bottom += (index / 6 + 1) % 6;
        }
        int row = top % 6 - 1;
        int column = bottom % 6 - 1;
        if (row == -1) {
            row = 5;
        }
        if (column == -1) {
            column = 5;
        }
        int check = 6 * row + column;
        dest = dest + ROYAL_TABLE[check];
        this.infoLine("Check Digit: " + check);
        dest = dest + "F";
        this.infoLine("Encoding: " + dest);
        this.readable = "";
        this.pattern = new String[1];
        this.pattern[0] = dest;
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int x = 0;
        boolean w = true;
        int y = 0;
        int h2 = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h2 = 5;
                    break;
                }
                case 'D': {
                    y = 3;
                    h2 = 5;
                    break;
                }
                case 'F': {
                    y = 0;
                    h2 = 8;
                    break;
                }
                case 'T': {
                    y = 3;
                    h2 = 2;
                }
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, (double)w, h2);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = this.pattern[0].length() * 3;
        this.symbol_height = 8;
    }
}

