/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

public class ReedSolomon {
    private int logmod;
    private int rlen;
    private int[] logt;
    private int[] alog;
    private int[] rspoly;
    public int[] res;

    public int getResult(int count) {
        return this.res[count];
    }

    public void init_gf(int poly) {
        int b;
        int m4 = 0;
        for (b = 1; b <= poly; b <<= 1) {
            ++m4;
        }
        b >>= 1;
        this.logmod = (1 << --m4) - 1;
        this.logt = new int[this.logmod + 1];
        this.alog = new int[this.logmod];
        int p = 1;
        for (int v = 0; v < this.logmod; ++v) {
            this.alog[v] = p;
            this.logt[p] = v;
            if (((p <<= 1) & b) == 0) continue;
            p ^= poly;
        }
    }

    public void init_code(int nsym, int index) {
        this.rspoly = new int[nsym + 1];
        this.rlen = nsym;
        this.rspoly[0] = 1;
        for (int i = 1; i <= nsym; ++i) {
            this.rspoly[i] = 1;
            for (int k = i - 1; k > 0; --k) {
                if (this.rspoly[k] != 0) {
                    this.rspoly[k] = this.alog[(this.logt[this.rspoly[k]] + index) % this.logmod];
                }
                int n = k;
                this.rspoly[n] = this.rspoly[n] ^ this.rspoly[k - 1];
            }
            this.rspoly[0] = this.alog[(this.logt[this.rspoly[0]] + index) % this.logmod];
            ++index;
        }
    }

    public void encode(int len, int[] data) {
        int i;
        this.res = new int[this.rlen];
        for (i = 0; i < this.rlen; ++i) {
            this.res[i] = 0;
        }
        for (i = 0; i < len; ++i) {
            int m4 = this.res[this.rlen - 1] ^ data[i];
            for (int k = this.rlen - 1; k > 0; --k) {
                this.res[k] = m4 != 0 && this.rspoly[k] != 0 ? this.res[k - 1] ^ this.alog[(this.logt[m4] + this.logt[this.rspoly[k]]) % this.logmod] : this.res[k - 1];
            }
            this.res[0] = m4 != 0 && this.rspoly[0] != 0 ? this.alog[(this.logt[m4] + this.logt[this.rspoly[0]]) % this.logmod] : 0;
        }
    }
}

