/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class GridMatrix
extends Symbol {
    private static final char[] SHIFT_SET = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'};
    private static final int[] GM_RECOMMEND_CW = new int[]{9, 30, 59, 114, 170, 237, 315, 405, 506, 618, 741, 875, 1021};
    private static final int[] GM_MAX_CW = new int[]{11, 40, 79, 146, 218, 305, 405, 521, 650, 794, 953, 1125, 1313};
    private static final int[] GM_DATA_CODEWORDS = new int[]{0, 15, 13, 11, 9, 45, 40, 35, 30, 25, 89, 79, 69, 59, 49, 146, 130, 114, 98, 81, 218, 194, 170, 146, 121, 305, 271, 237, 203, 169, 405, 360, 315, 270, 225, 521, 463, 405, 347, 289, 650, 578, 506, 434, 361, 794, 706, 618, 530, 441, 953, 847, 741, 635, 529, 1125, 1000, 875, 750, 625, 1313, 1167, 1021, 875, 729};
    private static final int[] GM_N1 = new int[]{18, 50, 98, 81, 121, 113, 113, 116, 121, 126, 118, 125, 122};
    private static final int[] GM_B1 = new int[]{1, 1, 1, 2, 2, 2, 2, 3, 2, 7, 5, 10, 6};
    private static final int[] GM_B2 = new int[]{0, 0, 0, 0, 0, 1, 2, 2, 4, 0, 4, 0, 6};
    private static final int[] GM_EBEB = new int[]{0, 0, 0, 0, 3, 1, 0, 0, 5, 1, 0, 0, 7, 1, 0, 0, 9, 1, 0, 0, 5, 1, 0, 0, 10, 1, 0, 0, 15, 1, 0, 0, 20, 1, 0, 0, 25, 1, 0, 0, 9, 1, 0, 0, 19, 1, 0, 0, 29, 1, 0, 0, 39, 1, 0, 0, 49, 1, 0, 0, 8, 2, 0, 0, 16, 2, 0, 0, 24, 2, 0, 0, 32, 2, 0, 0, 41, 1, 10, 1, 12, 2, 0, 0, 24, 2, 0, 0, 36, 2, 0, 0, 48, 2, 0, 0, 61, 1, 60, 1, 11, 3, 0, 0, 23, 1, 22, 2, 34, 2, 33, 1, 45, 3, 0, 0, 57, 1, 56, 2, 12, 1, 11, 3, 23, 2, 22, 2, 34, 3, 33, 1, 45, 4, 0, 0, 57, 1, 56, 3, 12, 2, 11, 3, 23, 5, 0, 0, 35, 3, 34, 2, 47, 1, 46, 4, 58, 4, 57, 1, 12, 6, 0, 0, 24, 6, 0, 0, 36, 6, 0, 0, 48, 6, 0, 0, 61, 1, 60, 5, 13, 4, 12, 3, 26, 1, 25, 6, 38, 5, 37, 2, 51, 2, 50, 5, 63, 7, 0, 0, 12, 6, 11, 3, 24, 4, 23, 5, 36, 2, 35, 7, 47, 9, 0, 0, 59, 7, 58, 2, 13, 5, 12, 5, 25, 10, 0, 0, 38, 5, 37, 5, 50, 10, 0, 0, 63, 5, 62, 5, 13, 1, 12, 11, 25, 3, 24, 9, 37, 5, 36, 7, 49, 7, 48, 5, 61, 9, 60, 3};
    private static final int[] GM_MACRO_MATRIX = new int[]{728, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 727, 624, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 651, 726, 623, 528, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 553, 652, 725, 622, 527, 440, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 463, 554, 653, 724, 621, 526, 439, 360, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 381, 464, 555, 654, 723, 620, 525, 438, 359, 288, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 307, 382, 465, 556, 655, 722, 619, 524, 437, 358, 287, 224, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 241, 308, 383, 466, 557, 656, 721, 618, 523, 436, 357, 286, 223, 168, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 183, 242, 309, 384, 467, 558, 657, 720, 617, 522, 435, 356, 285, 222, 167, 120, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 133, 184, 243, 310, 385, 468, 559, 658, 719, 616, 521, 434, 355, 284, 221, 166, 119, 80, 49, 50, 51, 52, 53, 54, 55, 56, 91, 134, 185, 244, 311, 386, 469, 560, 659, 718, 615, 520, 433, 354, 283, 220, 165, 118, 79, 48, 25, 26, 27, 28, 29, 30, 57, 92, 135, 186, 245, 312, 387, 470, 561, 660, 717, 614, 519, 432, 353, 282, 219, 164, 117, 78, 47, 24, 9, 10, 11, 12, 31, 58, 93, 136, 187, 246, 313, 388, 471, 562, 661, 716, 613, 518, 431, 352, 281, 218, 163, 116, 77, 46, 23, 8, 1, 2, 13, 32, 59, 94, 137, 188, 247, 314, 389, 472, 563, 662, 715, 612, 517, 430, 351, 280, 217, 162, 115, 76, 45, 22, 7, 0, 3, 14, 33, 60, 95, 138, 189, 248, 315, 390, 473, 564, 663, 714, 611, 516, 429, 350, 279, 216, 161, 114, 75, 44, 21, 6, 5, 4, 15, 34, 61, 96, 139, 190, 249, 316, 391, 474, 565, 664, 713, 610, 515, 428, 349, 278, 215, 160, 113, 74, 43, 20, 19, 18, 17, 16, 35, 62, 97, 140, 191, 250, 317, 392, 475, 566, 665, 712, 609, 514, 427, 348, 277, 214, 159, 112, 73, 42, 41, 40, 39, 38, 37, 36, 63, 98, 141, 192, 251, 318, 393, 476, 567, 666, 711, 608, 513, 426, 347, 276, 213, 158, 111, 72, 71, 70, 69, 68, 67, 66, 65, 64, 99, 142, 193, 252, 319, 394, 477, 568, 667, 710, 607, 512, 425, 346, 275, 212, 157, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 143, 194, 253, 320, 395, 478, 569, 668, 709, 606, 511, 424, 345, 274, 211, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 195, 254, 321, 396, 479, 570, 669, 708, 605, 510, 423, 344, 273, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 255, 322, 397, 480, 571, 670, 707, 604, 509, 422, 343, 272, 271, 270, 269, 268, 267, 266, 265, 264, 263, 262, 261, 260, 259, 258, 257, 256, 323, 398, 481, 572, 671, 706, 603, 508, 421, 342, 341, 340, 339, 338, 337, 336, 335, 334, 333, 332, 331, 330, 329, 328, 327, 326, 325, 324, 399, 482, 573, 672, 705, 602, 507, 420, 419, 418, 417, 416, 415, 414, 413, 412, 411, 410, 409, 408, 407, 406, 405, 404, 403, 402, 401, 400, 483, 574, 673, 704, 601, 506, 505, 504, 503, 502, 501, 500, 499, 498, 497, 496, 495, 494, 493, 492, 491, 490, 489, 488, 487, 486, 485, 484, 575, 674, 703, 600, 599, 598, 597, 596, 595, 594, 593, 592, 591, 590, 589, 588, 587, 586, 585, 584, 583, 582, 581, 580, 579, 578, 577, 576, 675, 702, 701, 700, 699, 698, 697, 696, 695, 694, 693, 692, 691, 690, 689, 688, 687, 686, 685, 684, 683, 682, 681, 680, 679, 678, 677, 676};
    private static final char[] MIXED_ALPHANUM_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' '};
    private StringBuilder binary;
    private int[] word = new int[1460];
    private boolean[] grid;
    private Mode appxDnextSection = Mode.NULL;
    private Mode appxDlastSection = Mode.NULL;
    private int preferredVersion = 0;
    private int preferredEccLevel = -1;

    public void setPreferredVersion(int version) {
        this.preferredVersion = version;
    }

    public void setPreferredEccLevel(int eccLevel) {
        this.preferredEccLevel = eccLevel;
    }

    @Override
    protected void encode() {
        int y;
        int x;
        int length;
        int i;
        boolean input_latch = false;
        StringBuilder bin = new StringBuilder();
        for (i = 0; i < 1460; ++i) {
            this.word[i] = 0;
        }
        try {
            Charset gb2312 = Charset.forName("GB2312");
            if (gb2312.newEncoder().canEncode(this.content)) {
                byte[] inputBytes = this.content.getBytes(gb2312);
                this.inputData = new int[inputBytes.length];
                length = 0;
                for (i = 0; i < inputBytes.length; ++i) {
                    if ((inputBytes[i] & 0xFF) >= 161 && (inputBytes[i] & 0xFF) <= 247) {
                        this.inputData[length] = (inputBytes[i] & 0xFF) * 256 + (inputBytes[i + 1] & 0xFF);
                        ++i;
                        ++length;
                        continue;
                    }
                    this.inputData[length] = inputBytes[i] & 0xFF;
                    ++length;
                }
                this.infoLine("Using GB2312 character encoding");
                this.eciMode = 29;
            } else {
                this.eciProcess();
                length = this.inputData.length;
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new OkapiException("Byte conversion encoding error");
        }
        int error_number = this.encodeGridMatrixBinary(length, this.readerInit);
        if (error_number != 0) {
            throw new OkapiException("Input data too long");
        }
        int data_cw = this.binary.length() / 7;
        int auto_layers = 1;
        for (i = 0; i < 13; ++i) {
            if (GM_RECOMMEND_CW[i] >= data_cw) continue;
            auto_layers = i + 1;
        }
        int min_layers = 13;
        for (i = 12; i > 0; --i) {
            if (GM_MAX_CW[i - 1] < data_cw) continue;
            min_layers = i;
        }
        int layers = auto_layers;
        int auto_ecc_level = 3;
        if (layers == 1) {
            auto_ecc_level = 5;
        }
        if (layers == 2 || layers == 3) {
            auto_ecc_level = 4;
        }
        int min_ecc_level = 1;
        if (layers == 1) {
            min_ecc_level = 4;
        }
        if (layers == 2 || layers == 3) {
            min_ecc_level = 2;
        }
        int ecc_level = auto_ecc_level;
        if (this.preferredVersion >= 1 && this.preferredVersion <= 13) {
            input_latch = true;
            layers = this.preferredVersion > min_layers ? this.preferredVersion : min_layers;
        }
        if (input_latch) {
            auto_ecc_level = 3;
            if (layers == 1) {
                auto_ecc_level = 5;
            }
            if (layers == 2 || layers == 3) {
                auto_ecc_level = 4;
            }
            if (data_cw > GM_DATA_CODEWORDS[5 * (layers - 1) + ((ecc_level = auto_ecc_level) - 1)]) {
                ++layers;
            }
        }
        if (!input_latch) {
            if (this.preferredEccLevel >= 1 && this.preferredEccLevel <= 5) {
                ecc_level = this.preferredEccLevel > min_ecc_level ? this.preferredEccLevel : min_ecc_level;
            }
            if (data_cw > GM_DATA_CODEWORDS[5 * (layers - 1) + (ecc_level - 1)]) {
                while (data_cw > GM_DATA_CODEWORDS[5 * (++layers - 1) + (ecc_level - 1)] && layers <= 13) {
                }
            }
        }
        int data_max = 1313;
        switch (ecc_level) {
            case 2: {
                data_max = 1167;
                break;
            }
            case 3: {
                data_max = 1021;
                break;
            }
            case 4: {
                data_max = 875;
                break;
            }
            case 5: {
                data_max = 729;
            }
        }
        if (data_cw > data_max) {
            throw new OkapiException("Input data too long");
        }
        this.addErrorCorrection(data_cw, layers, ecc_level);
        int size = 6 + layers * 12;
        int modules = 1 + layers * 2;
        this.infoLine("Layers: " + layers);
        this.infoLine("ECC Level: " + ecc_level);
        this.infoLine("Data Codewords: " + data_cw);
        this.infoLine("ECC Codewords: " + GM_DATA_CODEWORDS[(layers - 1) * 5 + (ecc_level - 1)]);
        this.infoLine("Grid Size: " + modules + " X " + modules);
        this.grid = new boolean[size * size];
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                this.grid[y * size + x] = false;
            }
        }
        this.placeDataInGrid(modules, size);
        this.addLayerId(size, layers, modules, ecc_level);
        for (x = 0; x < modules; ++x) {
            int dark = 1 - (x & 1);
            for (y = 0; y < modules; ++y) {
                if (dark == 1) {
                    for (i = 0; i < 5; ++i) {
                        this.grid[y * 6 * size + x * 6 + i] = true;
                        this.grid[(y * 6 + 5) * size + x * 6 + i] = true;
                        this.grid[(y * 6 + i) * size + x * 6] = true;
                        this.grid[(y * 6 + i) * size + x * 6 + 5] = true;
                    }
                    this.grid[(y * 6 + 5) * size + x * 6 + 5] = true;
                    dark = 0;
                    continue;
                }
                dark = 1;
            }
        }
        this.symbol_width = size;
        this.row_count = size;
        this.row_height = new int[this.row_count];
        this.pattern = new String[this.row_count];
        for (x = 0; x < size; ++x) {
            bin.setLength(0);
            for (y = 0; y < size; ++y) {
                if (this.grid[x * size + y]) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.row_height[x] = 1;
            this.pattern[x] = GridMatrix.bin2pat(bin);
        }
    }

    private int encodeGridMatrixBinary(int length, boolean reader) {
        int i;
        int glyph = 0;
        int p = 0;
        int punt = 0;
        int byte_count_posn = 0;
        int byte_count = 0;
        int[] numbuf = new int[3];
        Mode[] modeMap = this.calculateModeMap(length);
        this.binary = new StringBuilder();
        int sp = 0;
        Mode current_mode = Mode.NULL;
        int number_pad_posn = 0;
        this.info("Encoding: ");
        if (reader) {
            this.binary.append("1010");
            this.info("INIT ");
        }
        if (this.eciMode != 3 && this.eciMode != 29) {
            this.binary.append("1100");
            if (this.eciMode >= 0 && this.eciMode <= 1023) {
                this.binary.append('0');
                for (i = 512; i > 0; i >>= 1) {
                    if ((this.eciMode & i) != 0) {
                        this.binary.append('1');
                        continue;
                    }
                    this.binary.append('0');
                }
            }
            if (this.eciMode >= 1024 && this.eciMode <= Short.MAX_VALUE) {
                this.binary.append("10");
                for (i = 16384; i > 0; i >>= 1) {
                    if ((this.eciMode & i) != 0) {
                        this.binary.append('1');
                        continue;
                    }
                    this.binary.append('0');
                }
            }
            if (this.eciMode >= 32768 && this.eciMode <= 811799) {
                this.binary.append("11");
                for (i = 524288; i > 0; i >>= 1) {
                    if ((this.eciMode & i) != 0) {
                        this.binary.append('1');
                        continue;
                    }
                    this.binary.append('0');
                }
            }
            this.info("ECI ");
            this.infoSpace(this.eciMode);
        }
        do {
            Mode next_mode;
            if ((next_mode = modeMap[sp]) != current_mode) {
                block0 : switch (current_mode) {
                    case NULL: {
                        switch (next_mode) {
                            case GM_CHINESE: {
                                this.binary.append("0001");
                                break;
                            }
                            case GM_NUMBER: {
                                this.binary.append("0010");
                                break;
                            }
                            case GM_LOWER: {
                                this.binary.append("0011");
                                break;
                            }
                            case GM_UPPER: {
                                this.binary.append("0100");
                                break;
                            }
                            case GM_MIXED: {
                                this.binary.append("0101");
                                break;
                            }
                            case GM_BYTE: {
                                this.binary.append("0111");
                            }
                        }
                        break;
                    }
                    case GM_CHINESE: {
                        switch (next_mode) {
                            case GM_NUMBER: {
                                this.binary.append("1111111100001");
                                break;
                            }
                            case GM_LOWER: {
                                this.binary.append("1111111100010");
                                break;
                            }
                            case GM_UPPER: {
                                this.binary.append("1111111100011");
                                break;
                            }
                            case GM_MIXED: {
                                this.binary.append("1111111100100");
                                break;
                            }
                            case GM_BYTE: {
                                this.binary.append("1111111100101");
                            }
                        }
                        break;
                    }
                    case GM_NUMBER: {
                        switch (p) {
                            case 1: {
                                this.binary.insert(number_pad_posn, "10");
                                break;
                            }
                            case 2: {
                                this.binary.insert(number_pad_posn, "01");
                                break;
                            }
                            case 3: {
                                this.binary.insert(number_pad_posn, "00");
                            }
                        }
                        switch (next_mode) {
                            case GM_CHINESE: {
                                this.binary.append("1111111011");
                                break;
                            }
                            case GM_LOWER: {
                                this.binary.append("1111111100");
                                break;
                            }
                            case GM_UPPER: {
                                this.binary.append("1111111101");
                                break;
                            }
                            case GM_MIXED: {
                                this.binary.append("1111111110");
                                break;
                            }
                            case GM_BYTE: {
                                this.binary.append("1111111111");
                            }
                        }
                        break;
                    }
                    case GM_LOWER: 
                    case GM_UPPER: {
                        switch (next_mode) {
                            case GM_CHINESE: {
                                this.binary.append("11100");
                                break;
                            }
                            case GM_NUMBER: {
                                this.binary.append("11101");
                                break;
                            }
                            case GM_LOWER: 
                            case GM_UPPER: {
                                this.binary.append("11110");
                                break;
                            }
                            case GM_MIXED: {
                                this.binary.append("1111100");
                                break;
                            }
                            case GM_BYTE: {
                                this.binary.append("1111110");
                            }
                        }
                        break;
                    }
                    case GM_MIXED: {
                        switch (next_mode) {
                            case GM_CHINESE: {
                                this.binary.append("1111110001");
                                break;
                            }
                            case GM_NUMBER: {
                                this.binary.append("1111110010");
                                break;
                            }
                            case GM_LOWER: {
                                this.binary.append("1111110011");
                                break;
                            }
                            case GM_UPPER: {
                                this.binary.append("1111110100");
                                break;
                            }
                            case GM_BYTE: {
                                this.binary.append("1111110111");
                            }
                        }
                        break;
                    }
                    case GM_BYTE: {
                        this.addByteCount(byte_count_posn, byte_count);
                        byte_count = 0;
                        switch (next_mode) {
                            case GM_CHINESE: {
                                this.binary.append("0001");
                                break block0;
                            }
                            case GM_NUMBER: {
                                this.binary.append("0010");
                                break block0;
                            }
                            case GM_LOWER: {
                                this.binary.append("0011");
                                break block0;
                            }
                            case GM_UPPER: {
                                this.binary.append("0100");
                                break block0;
                            }
                            case GM_MIXED: {
                                this.binary.append("0101");
                            }
                        }
                    }
                }
                switch (next_mode) {
                    case GM_CHINESE: {
                        this.info("CHIN ");
                        break;
                    }
                    case GM_NUMBER: {
                        this.info("NUMB ");
                        break;
                    }
                    case GM_LOWER: {
                        this.info("LOWR ");
                        break;
                    }
                    case GM_UPPER: {
                        this.info("UPPR ");
                        break;
                    }
                    case GM_MIXED: {
                        this.info("MIXD ");
                        break;
                    }
                    case GM_BYTE: {
                        this.info("BYTE ");
                    }
                }
            }
            Mode last_mode = current_mode;
            current_mode = next_mode;
            switch (current_mode) {
                case GM_CHINESE: {
                    boolean done = false;
                    if (this.inputData[sp] > 255) {
                        int c1 = (this.inputData[sp] & 0xFF00) >> 8;
                        int c2 = this.inputData[sp] & 0xFF;
                        if (c1 >= 160 && c1 <= 169) {
                            glyph = 96 * (c1 - 161) + (c2 - 160);
                        }
                        if (c1 >= 176 && c1 <= 247) {
                            glyph = 96 * (c1 - 176 + 9) + (c2 - 160);
                        }
                        done = true;
                    }
                    if (!done && sp != length - 1) {
                        if (this.inputData[sp] == 13 && this.inputData[sp + 1] == 10) {
                            glyph = 7776;
                            ++sp;
                        }
                        done = true;
                    }
                    if (!done && sp != length - 1 && this.inputData[sp] >= 48 && this.inputData[sp] <= 57 && this.inputData[sp + 1] >= 48 && this.inputData[sp + 1] <= 57) {
                        glyph = 8033 + 10 * (this.inputData[sp] - 48) + (this.inputData[sp + 1] - 48);
                        ++sp;
                    }
                    if (!done) {
                        glyph = 7777 + this.inputData[sp];
                    }
                    this.infoSpace(glyph);
                    for (i = 4096; i > 0; i >>= 1) {
                        if ((glyph & i) != 0) {
                            this.binary.append('1');
                            continue;
                        }
                        this.binary.append('0');
                    }
                    ++sp;
                    break;
                }
                case GM_NUMBER: {
                    if (last_mode != current_mode) {
                        number_pad_posn = this.binary.length();
                    }
                    p = 0;
                    int ppos = -1;
                    numbuf[0] = 48;
                    numbuf[1] = 48;
                    numbuf[2] = 48;
                    do {
                        if (this.inputData[sp] >= 48 && this.inputData[sp] <= 57) {
                            numbuf[p] = this.inputData[sp];
                            ++p;
                        }
                        switch (this.inputData[sp]) {
                            case 32: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: {
                                punt = this.inputData[sp];
                                ppos = p;
                            }
                        }
                        if (sp >= length - 1 || this.inputData[sp] != 13 || this.inputData[sp + 1] != 10) continue;
                        punt = this.inputData[sp];
                        ++sp;
                        ppos = p;
                    } while (p < 3 && ++sp < length);
                    if (ppos != -1) {
                        switch (punt) {
                            case 32: {
                                glyph = 0;
                                break;
                            }
                            case 43: {
                                glyph = 3;
                                break;
                            }
                            case 45: {
                                glyph = 6;
                                break;
                            }
                            case 46: {
                                glyph = 9;
                                break;
                            }
                            case 44: {
                                glyph = 12;
                                break;
                            }
                            case 19: {
                                glyph = 15;
                            }
                        }
                        glyph += ppos;
                        this.infoSpace(glyph += 1000);
                        for (i = 512; i > 0; i >>= 1) {
                            if ((glyph & i) != 0) {
                                this.binary.append('1');
                                continue;
                            }
                            this.binary.append('0');
                        }
                    }
                    glyph = 100 * (numbuf[0] - 48) + 10 * (numbuf[1] - 48) + (numbuf[2] - 48);
                    this.infoSpace(glyph);
                    for (i = 512; i > 0; i >>= 1) {
                        if ((glyph & i) != 0) {
                            this.binary.append('1');
                            continue;
                        }
                        this.binary.append('0');
                    }
                    break;
                }
                case GM_BYTE: {
                    if (last_mode != current_mode) {
                        byte_count_posn = this.binary.length();
                    }
                    if (byte_count == 512) {
                        this.addByteCount(byte_count_posn, byte_count);
                        this.binary.append("0111");
                        byte_count_posn = this.binary.length();
                        byte_count = 0;
                    }
                    glyph = this.inputData[sp];
                    this.infoSpace(glyph);
                    for (i = 128; i > 0; i >>= 1) {
                        if ((glyph & i) != 0) {
                            this.binary.append('1');
                            continue;
                        }
                        this.binary.append('0');
                    }
                    ++sp;
                    ++byte_count;
                    break;
                }
                case GM_MIXED: {
                    boolean shift = true;
                    if (this.inputData[sp] >= 48 && this.inputData[sp] <= 57) {
                        shift = false;
                    }
                    if (this.inputData[sp] >= 65 && this.inputData[sp] <= 90) {
                        shift = false;
                    }
                    if (this.inputData[sp] >= 97 && this.inputData[sp] <= 122) {
                        shift = false;
                    }
                    if (this.inputData[sp] == 32) {
                        shift = false;
                    }
                    if (!shift) {
                        glyph = Arrays.positionOf((char)this.inputData[sp], MIXED_ALPHANUM_SET);
                        this.infoSpace(glyph);
                        for (i = 32; i > 0; i >>= 1) {
                            if ((glyph & i) != 0) {
                                this.binary.append('1');
                                continue;
                            }
                            this.binary.append('0');
                        }
                    } else {
                        this.binary.append("1111110110");
                        this.addShiftCharacter(this.inputData[sp]);
                    }
                    ++sp;
                    break;
                }
                case GM_UPPER: {
                    boolean shift = true;
                    if (this.inputData[sp] >= 65 && this.inputData[sp] <= 90) {
                        shift = false;
                    }
                    if (this.inputData[sp] == 32) {
                        shift = false;
                    }
                    if (!shift) {
                        glyph = Arrays.positionOf((char)this.inputData[sp], MIXED_ALPHANUM_SET) - 10;
                        if (glyph == 52) {
                            glyph = 26;
                        }
                        this.infoSpace(glyph);
                        for (i = 16; i > 0; i >>= 1) {
                            if ((glyph & i) != 0) {
                                this.binary.append('1');
                                continue;
                            }
                            this.binary.append('0');
                        }
                    } else {
                        this.binary.append("1111101");
                        this.addShiftCharacter(this.inputData[sp]);
                    }
                    ++sp;
                    break;
                }
                case GM_LOWER: {
                    boolean shift = true;
                    if (this.inputData[sp] >= 97 && this.inputData[sp] <= 122) {
                        shift = false;
                    }
                    if (this.inputData[sp] == 32) {
                        shift = false;
                    }
                    if (!shift) {
                        glyph = Arrays.positionOf((char)this.inputData[sp], MIXED_ALPHANUM_SET) - 36;
                        this.infoSpace(glyph);
                        for (i = 16; i > 0; i >>= 1) {
                            if ((glyph & i) != 0) {
                                this.binary.append('1');
                                continue;
                            }
                            this.binary.append('0');
                        }
                    } else {
                        this.binary.append("1111101");
                        this.addShiftCharacter(this.inputData[sp]);
                    }
                    ++sp;
                }
            }
            if (this.binary.length() <= 9191) continue;
            return 1;
        } while (sp < length);
        this.infoLine();
        if (current_mode == Mode.GM_NUMBER) {
            switch (p) {
                case 1: {
                    this.binary.insert(number_pad_posn, "10");
                    break;
                }
                case 2: {
                    this.binary.insert(number_pad_posn, "01");
                    break;
                }
                case 3: {
                    this.binary.insert(number_pad_posn, "00");
                }
            }
        }
        if (current_mode == Mode.GM_BYTE) {
            this.addByteCount(byte_count_posn, byte_count);
        }
        switch (current_mode) {
            case GM_CHINESE: {
                this.binary.append("1111111100000");
                break;
            }
            case GM_NUMBER: {
                this.binary.append("1111111010");
                break;
            }
            case GM_LOWER: 
            case GM_UPPER: {
                this.binary.append("11011");
                break;
            }
            case GM_MIXED: {
                this.binary.append("1111110000");
                break;
            }
            case GM_BYTE: {
                this.binary.append("0000");
            }
        }
        p = 7 - this.binary.length() % 7;
        if (p == 7) {
            p = 0;
        }
        for (i = 0; i < p; ++i) {
            this.binary.append('0');
        }
        if (this.binary.length() > 9191) {
            return 1;
        }
        return 0;
    }

    private Mode[] calculateModeMap(int length) {
        int i;
        Mode[] modeMap = new Mode[length];
        for (i = 0; i < length; ++i) {
            modeMap[i] = Mode.NULL;
            if (this.inputData[i] <= 255) continue;
            modeMap[i] = Mode.GM_CHINESE;
        }
        if (length > 3) {
            i = 1;
            do {
                if (this.inputData[i] == 13 && this.inputData[i + 1] == 10) {
                    if (modeMap[i - 1] == Mode.GM_CHINESE) {
                        modeMap[i] = Mode.GM_CHINESE;
                        modeMap[i + 1] = Mode.GM_CHINESE;
                    }
                    i += 2;
                    continue;
                }
                ++i;
            } while (i < length - 1);
            i = length - 3;
            do {
                if (this.inputData[i] == 13 && this.inputData[i + 1] == 10) {
                    if (modeMap[i + 2] == Mode.GM_CHINESE) {
                        modeMap[i] = Mode.GM_CHINESE;
                        modeMap[i + 1] = Mode.GM_CHINESE;
                    }
                    i -= 2;
                    continue;
                }
                --i;
            } while (i > 0);
        }
        boolean digits = false;
        int digitLength = 0;
        int digitStart = 0;
        for (i = 1; i < length - 1; ++i) {
            if (this.inputData[i] >= 48 && this.inputData[i] <= 57) {
                if (!digits) {
                    digits = true;
                    digitLength = 1;
                    digitStart = i;
                    continue;
                }
                ++digitLength;
                continue;
            }
            if (!digits) continue;
            if (digitLength % 2 == 0 && modeMap[digitStart - 1] == Mode.GM_CHINESE && modeMap[i] == Mode.GM_CHINESE) {
                for (int j = 0; j < digitLength; ++j) {
                    modeMap[i - j - 1] = Mode.GM_CHINESE;
                }
            }
            digits = false;
        }
        for (i = 0; i < length; ++i) {
            if (this.inputData[i] < 97 || this.inputData[i] > 122) continue;
            modeMap[i] = Mode.GM_LOWER;
        }
        for (i = 0; i < length; ++i) {
            if (this.inputData[i] < 65 || this.inputData[i] > 90) continue;
            modeMap[i] = Mode.GM_UPPER;
        }
        boolean spaces = false;
        int spaceLength = 0;
        int spaceStart = 0;
        for (i = 1; i < length - 1; ++i) {
            int j;
            if (this.inputData[i] == 32) {
                if (!spaces) {
                    spaces = true;
                    spaceLength = 1;
                    spaceStart = i;
                    continue;
                }
                ++spaceLength;
                continue;
            }
            if (!spaces) continue;
            Mode modeX = modeMap[spaceStart - 1];
            Mode modeY = modeMap[i];
            if (modeX == Mode.GM_LOWER || modeX == Mode.GM_UPPER) {
                for (j = 0; j < spaceLength; ++j) {
                    modeMap[i - j - 1] = modeX;
                }
            } else if (modeY == Mode.GM_LOWER || modeY == Mode.GM_UPPER) {
                for (j = 0; j < spaceLength; ++j) {
                    modeMap[i - j - 1] = modeY;
                }
            }
            spaces = false;
        }
        block14: for (i = 0; i < length; ++i) {
            if (modeMap[i] != Mode.NULL) continue;
            if (this.inputData[i] >= 48 && this.inputData[i] <= 57) {
                modeMap[i] = Mode.GM_NUMBER;
                continue;
            }
            switch (this.inputData[i]) {
                case 32: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    modeMap[i] = Mode.GM_NUMBER;
                    continue block14;
                }
                case 13: {
                    if (i >= length - 1 || this.inputData[i + 1] != 10) continue block14;
                    modeMap[i] = Mode.GM_NUMBER;
                    modeMap[i + 1] = Mode.GM_NUMBER;
                }
            }
        }
        for (i = 0; i < length; ++i) {
            if (modeMap[i] != Mode.NULL) continue;
            modeMap[i] = Mode.GM_BYTE;
        }
        int[] segmentLength = new int[length];
        Mode[] segmentType = new Mode[length];
        int[] segmentStart = new int[length];
        int segmentCount = 0;
        segmentLength[0] = 1;
        segmentType[0] = modeMap[0];
        segmentStart[0] = 0;
        for (i = 1; i < length; ++i) {
            if (modeMap[i] == modeMap[i - 1]) {
                int n = segmentCount;
                segmentLength[n] = segmentLength[n] + 1;
                continue;
            }
            segmentLength[++segmentCount] = 1;
            segmentType[segmentCount] = modeMap[i];
            segmentStart[segmentCount] = i;
        }
        if (segmentCount > 1) {
            for (i = 1; i < segmentCount; ++i) {
                if (segmentLength[i] > 3 || segmentType[i - 1] == Mode.GM_CHINESE) continue;
                boolean controlLatch = true;
                for (int j = 0; j < segmentLength[i]; ++j) {
                    boolean thischarLatch = false;
                    for (int k = 0; k < 63; ++k) {
                        if (this.inputData[segmentStart[i] + j] != SHIFT_SET[k]) continue;
                        thischarLatch = true;
                    }
                    if (thischarLatch) continue;
                    controlLatch = false;
                }
                if (!controlLatch) continue;
                segmentType[i] = Mode.GM_CONTROL;
            }
        }
        if (segmentCount >= 3) {
            for (i = 0; i < segmentCount - 1; ++i) {
                boolean lastSegment = false;
                Mode pm = i == 0 ? Mode.NULL : segmentType[i - 1];
                Mode tm = segmentType[i];
                int tl = segmentLength[i];
                Mode nm = segmentType[i + 1];
                int nl = segmentLength[i + 1];
                Mode lm = segmentType[i + 2];
                int ll = segmentLength[i + 2];
                int position = segmentStart[i];
                if (i + 2 == segmentCount) {
                    lastSegment = true;
                }
                segmentType[i] = this.getBestMode(pm, tm, nm, lm, tl, nl, ll, position, lastSegment);
                if (segmentType[i] != Mode.GM_CONTROL) continue;
                segmentType[i] = segmentType[i - 1];
            }
            segmentType[i] = this.appxDnextSection;
            segmentType[i + 1] = this.appxDlastSection;
            if (segmentType[i] == Mode.GM_CONTROL) {
                segmentType[i] = segmentType[i - 1];
            }
            if (segmentType[i + 1] == Mode.GM_CONTROL) {
                segmentType[i + 1] = segmentType[i];
            }
        }
        for (i = 0; i < segmentCount; ++i) {
            for (int j = 0; j < segmentLength[i]; ++j) {
                modeMap[segmentStart[i] + j] = segmentType[i];
            }
        }
        return modeMap;
    }

    private boolean isTransitionValid(Mode previousMode, Mode thisMode) {
        boolean isValid = false;
        switch (previousMode) {
            case GM_CHINESE: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_BYTE: {
                        isValid = true;
                    }
                }
                break;
            }
            case GM_NUMBER: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_NUMBER: 
                    case GM_MIXED: 
                    case GM_BYTE: {
                        isValid = true;
                    }
                }
                break;
            }
            case GM_LOWER: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_LOWER: 
                    case GM_MIXED: 
                    case GM_BYTE: {
                        isValid = true;
                    }
                }
                break;
            }
            case GM_UPPER: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_UPPER: 
                    case GM_MIXED: 
                    case GM_BYTE: {
                        isValid = true;
                    }
                }
                break;
            }
            case GM_CONTROL: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_BYTE: 
                    case GM_CONTROL: {
                        isValid = true;
                    }
                }
                break;
            }
            case GM_BYTE: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_BYTE: {
                        isValid = true;
                    }
                }
            }
        }
        return isValid;
    }

    private Mode intToMode(int input) {
        Mode retVal;
        switch (input) {
            case 1: {
                retVal = Mode.GM_CHINESE;
                break;
            }
            case 2: {
                retVal = Mode.GM_BYTE;
                break;
            }
            case 3: {
                retVal = Mode.GM_CONTROL;
                break;
            }
            case 4: {
                retVal = Mode.GM_MIXED;
                break;
            }
            case 5: {
                retVal = Mode.GM_UPPER;
                break;
            }
            case 6: {
                retVal = Mode.GM_LOWER;
                break;
            }
            case 7: {
                retVal = Mode.GM_NUMBER;
                break;
            }
            default: {
                retVal = Mode.NULL;
            }
        }
        return retVal;
    }

    private Mode getBestMode(Mode pm, Mode tm, Mode nm, Mode lm, int tl, int nl, int ll, int position, boolean lastSegment) {
        Mode bestMode = tm;
        int bestBinaryLength = Integer.MAX_VALUE;
        for (int tmi = 1; tmi < 8; ++tmi) {
            if (!this.isTransitionValid(tm, this.intToMode(tmi))) continue;
            for (int nmi = 1; nmi < 8; ++nmi) {
                if (!this.isTransitionValid(nm, this.intToMode(nmi))) continue;
                for (int lmi = 1; lmi < 8; ++lmi) {
                    int binaryLength;
                    if (!this.isTransitionValid(lm, this.intToMode(lmi)) || (binaryLength = this.getBinaryLength(pm, this.intToMode(tmi), this.intToMode(nmi), this.intToMode(lmi), tl, nl, ll, position, lastSegment)) > bestBinaryLength) continue;
                    bestMode = this.intToMode(tmi);
                    this.appxDnextSection = this.intToMode(nmi);
                    this.appxDlastSection = this.intToMode(lmi);
                    bestBinaryLength = binaryLength;
                }
            }
        }
        return bestMode;
    }

    private int getBinaryLength(Mode pm, Mode tm, Mode nm, Mode lm, int tl, int nl, int ll, int position, boolean lastSegment) {
        int binaryLength = this.getChunkLength(pm, tm, tl, position);
        binaryLength += this.getChunkLength(tm, nm, nl, position + tl);
        binaryLength += this.getChunkLength(nm, lm, ll, position + tl + nl);
        if (lastSegment) {
            switch (lm) {
                case GM_CHINESE: {
                    binaryLength += 13;
                    break;
                }
                case GM_NUMBER: {
                    binaryLength += 10;
                    break;
                }
                case GM_LOWER: 
                case GM_UPPER: {
                    binaryLength += 5;
                    break;
                }
                case GM_MIXED: {
                    binaryLength += 10;
                    break;
                }
                case GM_BYTE: {
                    binaryLength += 4;
                }
            }
        }
        return binaryLength;
    }

    private int getChunkLength(Mode lastMode, Mode thisMode, int thisLength, int position) {
        int byteLength;
        switch (thisMode) {
            case GM_CHINESE: {
                byteLength = this.calcChineseLength(position, thisLength);
                break;
            }
            case GM_NUMBER: {
                byteLength = this.calcNumberLength(position, thisLength);
                break;
            }
            case GM_LOWER: {
                byteLength = 5 * thisLength;
                break;
            }
            case GM_UPPER: {
                byteLength = 5 * thisLength;
                break;
            }
            case GM_MIXED: {
                byteLength = this.calcMixedLength(position, thisLength);
                break;
            }
            case GM_CONTROL: {
                byteLength = 6 * thisLength;
                break;
            }
            default: {
                byteLength = this.calcByteLength(position, thisLength);
            }
        }
        switch (lastMode) {
            case NULL: {
                byteLength += 4;
                break;
            }
            case GM_CHINESE: {
                if (thisMode == Mode.GM_CHINESE || thisMode == Mode.GM_CONTROL) break;
                byteLength += 13;
                break;
            }
            case GM_NUMBER: {
                if (thisMode == Mode.GM_CHINESE || thisMode == Mode.GM_CONTROL) break;
                byteLength += 10;
                break;
            }
            case GM_LOWER: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_NUMBER: 
                    case GM_UPPER: {
                        byteLength += 5;
                        break;
                    }
                    case GM_MIXED: 
                    case GM_BYTE: 
                    case GM_CONTROL: {
                        byteLength += 7;
                    }
                }
                break;
            }
            case GM_UPPER: {
                switch (thisMode) {
                    case GM_CHINESE: 
                    case GM_NUMBER: 
                    case GM_LOWER: {
                        byteLength += 5;
                        break;
                    }
                    case GM_MIXED: 
                    case GM_BYTE: 
                    case GM_CONTROL: {
                        byteLength += 7;
                    }
                }
                break;
            }
            case GM_MIXED: {
                if (thisMode == Mode.GM_MIXED) break;
                byteLength += 10;
                break;
            }
            case GM_BYTE: {
                if (thisMode == Mode.GM_BYTE) break;
                byteLength += 4;
            }
        }
        if (lastMode != Mode.GM_BYTE && thisMode == Mode.GM_BYTE) {
            byteLength += 9;
        }
        if (lastMode != Mode.GM_NUMBER && thisMode == Mode.GM_NUMBER) {
            byteLength += 2;
        }
        return byteLength;
    }

    private int calcChineseLength(int position, int length) {
        int i = 0;
        int bits = 0;
        do {
            bits += 13;
            if (i >= length) continue;
            if (this.inputData[position + i] == 13 && this.inputData[position + i + 1] == 10) {
                ++i;
            }
            if (this.inputData[position + i] < 48 || this.inputData[position + i] > 57 || this.inputData[position + i + 1] < 48 || this.inputData[position + i + 1] > 57) continue;
            ++i;
        } while (++i < length);
        return bits;
    }

    private int calcMixedLength(int position, int length) {
        int bits = 0;
        for (int i = 0; i < length; ++i) {
            bits += 6;
            for (int k = 0; k < 63; ++k) {
                if (this.inputData[position + i] != SHIFT_SET[k]) continue;
                bits += 10;
            }
        }
        return bits;
    }

    private int calcNumberLength(int position, int length) {
        int i;
        int bits = 0;
        int numbers = 0;
        int nonnumbers = 0;
        for (i = 0; i < length; ++i) {
            if (this.inputData[position + i] >= 48 && this.inputData[position + i] <= 57) {
                ++numbers;
            } else {
                ++nonnumbers;
            }
            if (i != 0 && this.inputData[position + i] == 10 && this.inputData[position + i - 1] == 13) {
                --nonnumbers;
            }
            if (numbers != 3) continue;
            bits = nonnumbers == 1 ? (bits += 20) : (bits += 10);
            if (nonnumbers > 1) {
                bits += 100;
            }
            numbers = 0;
            nonnumbers = 0;
        }
        if (numbers > 0) {
            bits = nonnumbers == 1 ? (bits += 20) : (bits += 10);
        }
        if (nonnumbers > 1) {
            bits += 100;
        }
        if (this.inputData[position + i - 1] < 48 || this.inputData[position + i - 1] > 57) {
            bits += 100;
        }
        return bits;
    }

    private int calcByteLength(int position, int length) {
        int bits = 0;
        for (int i = 0; i < length; ++i) {
            if (this.inputData[position + i] <= 255) {
                bits += 8;
                continue;
            }
            bits += 16;
        }
        return bits;
    }

    private void addByteCount(int byte_count_posn, int byte_count) {
        for (int i = 0; i < 9; ++i) {
            if ((byte_count & 256 >> i) != 0) {
                this.binary.insert(byte_count_posn + i, '0');
                continue;
            }
            this.binary.insert(byte_count_posn + i, '1');
        }
    }

    void addShiftCharacter(int shifty) {
        int i;
        int glyph = 0;
        for (i = 0; i < 64; ++i) {
            if (SHIFT_SET[i] != shifty) continue;
            glyph = i;
        }
        this.info("SHT/");
        this.infoSpace(glyph);
        for (i = 32; i > 0; i >>= 1) {
            if ((glyph & i) != 0) {
                this.binary.append('1');
                continue;
            }
            this.binary.append('0');
        }
    }

    private void addErrorCorrection(int data_posn, int layers, int ecc_level) {
        int j;
        int i;
        int[] data = new int[1320];
        int[] block = new int[130];
        int[] data_block = new int[115];
        int[] ecc_block = new int[70];
        ReedSolomon rs = new ReedSolomon();
        int data_cw = GM_DATA_CODEWORDS[(layers - 1) * 5 + (ecc_level - 1)];
        for (i = 0; i < 1320; ++i) {
            data[i] = 0;
        }
        for (i = 0; i < data_posn; ++i) {
            for (j = 0; j < 7; ++j) {
                if (this.binary.charAt(i * 7 + j) != '1') continue;
                int n = i;
                data[n] = data[n] + (64 >> j);
            }
        }
        this.info("Codewords: ");
        for (i = 0; i < data_posn; ++i) {
            this.infoSpace(data[i]);
        }
        this.infoLine();
        data[data_posn] = 0;
        for (i = data_posn + 1; i < data_cw; ++i) {
            data[i] = (i & 1) != 0 ? 126 : 0;
        }
        int n1 = GM_N1[layers - 1];
        int b1 = GM_B1[layers - 1];
        int n2 = n1 - 1;
        int b2 = GM_B2[layers - 1];
        int e1 = GM_EBEB[(layers - 1) * 20 + (ecc_level - 1) * 4];
        int b3 = GM_EBEB[(layers - 1) * 20 + (ecc_level - 1) * 4 + 1];
        int e2 = GM_EBEB[(layers - 1) * 20 + (ecc_level - 1) * 4 + 2];
        int wp = 0;
        for (i = 0; i < b1 + b2; ++i) {
            int block_size = i < b1 ? n1 : n2;
            int ecc_size = i < b3 ? e1 : e2;
            int data_size = block_size - ecc_size;
            for (j = 0; j < data_size; ++j) {
                data_block[j] = data[wp];
                ++wp;
            }
            rs.init_gf(137);
            rs.init_code(ecc_size, 1);
            rs.encode(data_size, data_block);
            for (j = 0; j < ecc_size; ++j) {
                ecc_block[j] = rs.getResult(j);
            }
            for (j = 0; j < data_size; ++j) {
                block[j] = data_block[j];
            }
            for (j = 0; j < ecc_size; ++j) {
                block[j + data_size] = ecc_block[ecc_size - j - 1];
            }
            for (j = 0; j < n2; ++j) {
                this.word[(b1 + b2) * j + i] = block[j];
            }
            if (block_size != n1) continue;
            this.word[(b1 + b2) * (n1 - 1) + i] = block[n1 - 1];
        }
    }

    private void placeDataInGrid(int modules, int size) {
        int offset = 13 - (modules - 1) / 2;
        for (int y = 0; y < modules; ++y) {
            for (int x = 0; x < modules; ++x) {
                int macromodule = GM_MACRO_MATRIX[(y + offset) * 27 + (x + offset)];
                this.placeMacroModule(x, y, this.word[macromodule * 2], this.word[macromodule * 2 + 1], size);
            }
        }
    }

    void placeMacroModule(int x, int y, int word1, int word2, int size) {
        int i = x * 6 + 1;
        int j = y * 6 + 1;
        if ((word2 & 0x40) != 0) {
            this.grid[j * size + i + 2] = true;
        }
        if ((word2 & 0x20) != 0) {
            this.grid[j * size + i + 3] = true;
        }
        if ((word2 & 0x10) != 0) {
            this.grid[(j + 1) * size + i] = true;
        }
        if ((word2 & 8) != 0) {
            this.grid[(j + 1) * size + i + 1] = true;
        }
        if ((word2 & 4) != 0) {
            this.grid[(j + 1) * size + i + 2] = true;
        }
        if ((word2 & 2) != 0) {
            this.grid[(j + 1) * size + i + 3] = true;
        }
        if ((word2 & 1) != 0) {
            this.grid[(j + 2) * size + i] = true;
        }
        if ((word1 & 0x40) != 0) {
            this.grid[(j + 2) * size + i + 1] = true;
        }
        if ((word1 & 0x20) != 0) {
            this.grid[(j + 2) * size + i + 2] = true;
        }
        if ((word1 & 0x10) != 0) {
            this.grid[(j + 2) * size + i + 3] = true;
        }
        if ((word1 & 8) != 0) {
            this.grid[(j + 3) * size + i] = true;
        }
        if ((word1 & 4) != 0) {
            this.grid[(j + 3) * size + i + 1] = true;
        }
        if ((word1 & 2) != 0) {
            this.grid[(j + 3) * size + i + 2] = true;
        }
        if ((word1 & 1) != 0) {
            this.grid[(j + 3) * size + i + 3] = true;
        }
    }

    private void addLayerId(int size, int layers, int modules, int ecc_level) {
        int j;
        int i;
        int[] layerid = new int[layers + 1];
        int[] id = new int[modules * modules];
        for (i = 0; i <= layers; ++i) {
            layerid[i] = ecc_level == 1 ? 3 - i % 4 : (i + 5 - ecc_level) % 4;
        }
        for (i = 0; i < modules; ++i) {
            for (j = 0; j < modules; ++j) {
                id[i * modules + j] = 0;
            }
        }
        int start = modules / 2;
        int stop = modules / 2;
        for (int layer = 0; layer <= layers; ++layer) {
            for (i = start; i <= stop; ++i) {
                id[start * modules + i] = layerid[layer];
                id[i * modules + start] = layerid[layer];
                id[(modules - start - 1) * modules + i] = layerid[layer];
                id[i * modules + (modules - start - 1)] = layerid[layer];
            }
            --start;
            ++stop;
        }
        for (i = 0; i < modules; ++i) {
            for (j = 0; j < modules; ++j) {
                if ((id[i * modules + j] & 2) != 0) {
                    this.grid[(i * 6 + 1) * size + j * 6 + 1] = true;
                }
                if ((id[i * modules + j] & 1) == 0) continue;
                this.grid[(i * 6 + 1) * size + j * 6 + 2] = true;
            }
        }
    }

    private static enum Mode {
        NULL,
        GM_NUMBER,
        GM_LOWER,
        GM_UPPER,
        GM_MIXED,
        GM_CONTROL,
        GM_BYTE,
        GM_CHINESE;

    }
}

