/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.org.okapibarcode.backend.DataBarLimited;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Strings;

public class DataBarExpanded
extends Symbol {
    private static final int[] G_SUM_EXP = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[] T_EVEN_EXP = new int[]{4, 20, 52, 104, 204};
    private static final int[] MODULES_ODD_EXP = new int[]{12, 10, 8, 6, 4};
    private static final int[] MODULES_EVEN_EXP = new int[]{5, 7, 9, 11, 13};
    private static final int[] WIDEST_ODD_EXP = new int[]{7, 5, 4, 3, 1};
    private static final int[] WIDEST_EVEN_EXP = new int[]{2, 4, 5, 6, 8};
    private static final int[] CHECKSUM_WEIGHT_EXP = new int[]{1, 3, 9, 27, 81, 32, 96, 77, 20, 60, 180, 118, 143, 7, 21, 63, 189, 145, 13, 39, 117, 140, 209, 205, 193, 157, 49, 147, 19, 57, 171, 91, 62, 186, 136, 197, 169, 85, 44, 132, 185, 133, 188, 142, 4, 12, 36, 108, 113, 128, 173, 97, 80, 29, 87, 50, 150, 28, 84, 41, 123, 158, 52, 156, 46, 138, 203, 187, 139, 206, 196, 166, 76, 17, 51, 153, 37, 111, 122, 155, 43, 129, 176, 106, 107, 110, 119, 146, 16, 48, 144, 10, 30, 90, 59, 177, 109, 116, 137, 200, 178, 112, 125, 164, 70, 210, 208, 202, 184, 130, 179, 115, 134, 191, 151, 31, 93, 68, 204, 190, 148, 22, 66, 198, 172, 94, 71, 2, 6, 18, 54, 162, 64, 192, 154, 40, 120, 149, 25, 75, 14, 42, 126, 167, 79, 26, 78, 23, 69, 207, 199, 175, 103, 98, 83, 38, 114, 131, 182, 124, 161, 61, 183, 127, 170, 88, 53, 159, 55, 165, 73, 8, 24, 72, 5, 15, 45, 135, 194, 160, 58, 174, 100, 89};
    private static final int[] FINDER_PATTERN_EXP = new int[]{1, 8, 4, 1, 1, 1, 1, 4, 8, 1, 3, 6, 4, 1, 1, 1, 1, 4, 6, 3, 3, 4, 6, 1, 1, 1, 1, 6, 4, 3, 3, 2, 8, 1, 1, 1, 1, 8, 2, 3, 2, 6, 5, 1, 1, 1, 1, 5, 6, 2, 2, 2, 9, 1, 1, 1, 1, 9, 2, 2};
    private static final int[] FINDER_SEQUENCE = new int[]{1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 3, 8, 0, 0, 0, 0, 0, 0, 0, 1, 10, 3, 8, 5, 0, 0, 0, 0, 0, 0, 1, 10, 3, 8, 7, 12, 0, 0, 0, 0, 0, 1, 10, 3, 8, 9, 12, 11, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 10, 9, 0, 0, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 0, 1, 2, 3, 4, 5, 8, 7, 10, 9, 12, 11};
    private static final int[] WEIGHT_ROWS = new int[]{0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 6, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 3, 4, 13, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 18, 3, 4, 13, 14, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 18, 3, 4, 13, 14, 11, 12, 21, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 18, 3, 4, 13, 14, 15, 16, 21, 22, 19, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 17, 18, 15, 16, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 17, 18, 19, 20, 21, 22, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 11, 12, 17, 18, 15, 16, 21, 22, 19, 20};
    private boolean linkageFlag;
    private int preferredColumns = 2;
    private boolean stacked = true;

    public DataBarExpanded() {
        this.inputDataType = Symbol.DataType.GS1;
    }

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    public void setPreferredColumns(int columns) {
        if (columns < 1 || columns > 10) {
            throw new IllegalArgumentException("Invalid column count: " + columns);
        }
        this.preferredColumns = columns;
    }

    public int getPreferredColumns() {
        return this.preferredColumns;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    protected void setLinkageFlag(boolean linkageFlag) {
        this.linkageFlag = linkageFlag;
    }

    @Override
    protected void encode() {
        int[] widths;
        int j;
        int i;
        int compositeOffset;
        int[] vs = new int[21];
        int[] group = new int[21];
        int[] v_odd = new int[21];
        int[] v_even = new int[21];
        int[][] char_widths = new int[21][8];
        int[] check_widths = new int[8];
        int[] elements = new int[235];
        int[] sub_elements = new int[235];
        this.inputData = DataBarExpanded.toBytes(this.content, StandardCharsets.US_ASCII, new int[0]);
        if (this.inputData == null) {
            throw new OkapiException("Invalid characters in input data");
        }
        StringBuilder binaryString = new StringBuilder(this.inputData.length * 8);
        if (this.linkageFlag) {
            binaryString.append('1');
            compositeOffset = 1;
        } else {
            binaryString.append('0');
            compositeOffset = 0;
        }
        int encodingMethod = DataBarExpanded.calculateBinaryString(this.stacked, this.preferredColumns, this.inputData, binaryString);
        this.infoLine("Encoding Method: " + encodingMethod);
        this.logBinaryStringInfo(binaryString);
        int data_chars = binaryString.length() / 12;
        this.info("Data Characters: ");
        for (i = 0; i < data_chars; ++i) {
            vs[i] = 0;
            for (j = 0; j < 12; ++j) {
                if (binaryString.charAt(i * 12 + j) != '1') continue;
                int n = i;
                vs[n] = vs[n] + (2048 >> j);
            }
            this.infoSpace(vs[i]);
        }
        this.infoLine();
        for (i = 0; i < data_chars; ++i) {
            if (vs[i] <= 347) {
                group[i] = 1;
            }
            if (vs[i] >= 348 && vs[i] <= 1387) {
                group[i] = 2;
            }
            if (vs[i] >= 1388 && vs[i] <= 2947) {
                group[i] = 3;
            }
            if (vs[i] >= 2948 && vs[i] <= 3987) {
                group[i] = 4;
            }
            if (vs[i] >= 3988) {
                group[i] = 5;
            }
            v_odd[i] = (vs[i] - G_SUM_EXP[group[i] - 1]) / T_EVEN_EXP[group[i] - 1];
            v_even[i] = (vs[i] - G_SUM_EXP[group[i] - 1]) % T_EVEN_EXP[group[i] - 1];
            widths = DataBarLimited.getWidths(v_odd[i], MODULES_ODD_EXP[group[i] - 1], 4, WIDEST_ODD_EXP[group[i] - 1], 0);
            char_widths[i][0] = widths[0];
            char_widths[i][2] = widths[1];
            char_widths[i][4] = widths[2];
            char_widths[i][6] = widths[3];
            widths = DataBarLimited.getWidths(v_even[i], MODULES_EVEN_EXP[group[i] - 1], 4, WIDEST_EVEN_EXP[group[i] - 1], 1);
            char_widths[i][1] = widths[0];
            char_widths[i][3] = widths[1];
            char_widths[i][5] = widths[2];
            char_widths[i][7] = widths[3];
        }
        int checksum = 0;
        for (i = 0; i < data_chars; ++i) {
            int row = WEIGHT_ROWS[(data_chars - 2) / 2 * 21 + i];
            for (j = 0; j < 8; ++j) {
                checksum += char_widths[i][j] * CHECKSUM_WEIGHT_EXP[row * 8 + j];
            }
        }
        int check_char = 211 * (data_chars + 1 - 4) + checksum % 211;
        this.infoLine("Check Character: " + check_char);
        int c_group = 1;
        if (check_char >= 348 && check_char <= 1387) {
            c_group = 2;
        }
        if (check_char >= 1388 && check_char <= 2947) {
            c_group = 3;
        }
        if (check_char >= 2948 && check_char <= 3987) {
            c_group = 4;
        }
        if (check_char >= 3988) {
            c_group = 5;
        }
        int c_odd = (check_char - G_SUM_EXP[c_group - 1]) / T_EVEN_EXP[c_group - 1];
        int c_even = (check_char - G_SUM_EXP[c_group - 1]) % T_EVEN_EXP[c_group - 1];
        widths = DataBarLimited.getWidths(c_odd, MODULES_ODD_EXP[c_group - 1], 4, WIDEST_ODD_EXP[c_group - 1], 0);
        check_widths[0] = widths[0];
        check_widths[2] = widths[1];
        check_widths[4] = widths[2];
        check_widths[6] = widths[3];
        widths = DataBarLimited.getWidths(c_even, MODULES_EVEN_EXP[c_group - 1], 4, WIDEST_EVEN_EXP[c_group - 1], 1);
        check_widths[1] = widths[0];
        check_widths[3] = widths[1];
        check_widths[5] = widths[2];
        check_widths[7] = widths[3];
        int pattern_width = ((data_chars + 1) / 2 + (data_chars + 1 & 1)) * 5 + (data_chars + 1) * 8 + 4;
        for (i = 0; i < pattern_width; ++i) {
            elements[i] = 0;
        }
        for (i = 0; i < (data_chars + 1) / 2 + (data_chars + 1 & 1); ++i) {
            int k = ((data_chars + 1 - 2) / 2 + (data_chars + 1 & 1) - 1) * 11 + i;
            for (j = 0; j < 5; ++j) {
                elements[21 * i + j + 10] = FINDER_PATTERN_EXP[(FINDER_SEQUENCE[k] - 1) * 5 + j];
            }
        }
        for (i = 0; i < 8; ++i) {
            elements[i + 2] = check_widths[i];
        }
        for (i = 1; i < data_chars; i += 2) {
            for (j = 0; j < 8; ++j) {
                elements[(i - 1) / 2 * 21 + 23 + j] = char_widths[i][j];
            }
        }
        for (i = 0; i < data_chars; i += 2) {
            for (j = 0; j < 8; ++j) {
                elements[i / 2 * 21 + 15 + j] = char_widths[i][7 - j];
            }
        }
        if (!this.stacked) {
            elements[0] = 1;
            elements[1] = 1;
            elements[pattern_width - 2] = 1;
            elements[pattern_width - 1] = 1;
            this.row_count = 1 + compositeOffset;
            this.row_height = new int[1 + compositeOffset];
            this.row_height[0 + compositeOffset] = -1;
            this.pattern = new String[1 + compositeOffset];
            boolean black = false;
            StringBuilder pat = new StringBuilder("0");
            for (i = 0; i < pattern_width; ++i) {
                pat.append((char)(elements[i] + 48));
                black = !black;
            }
            this.pattern[0 + compositeOffset] = pat.toString();
        } else {
            int codeblocks = (data_chars + 1) / 2 + (data_chars + 1) % 2;
            int blocksPerRow = this.preferredColumns;
            if (this.linkageFlag && blocksPerRow == 1) {
                blocksPerRow = 2;
            }
            int stack_rows = codeblocks / blocksPerRow;
            if (codeblocks % blocksPerRow > 0) {
                ++stack_rows;
            }
            this.row_count = stack_rows * 4 - 3;
            this.row_height = new int[this.row_count + compositeOffset];
            this.pattern = new String[this.row_count + compositeOffset];
            int symbol_row = 0;
            int current_block = 0;
            AtomicBoolean v2 = new AtomicBoolean(false);
            for (int current_row = 1; current_row <= stack_rows; ++current_row) {
                boolean left_to_right;
                Arrays.fill(sub_elements, 0);
                boolean special_case_row = false;
                int num_columns = current_row < stack_rows ? blocksPerRow : codeblocks - current_block;
                sub_elements[0] = 1;
                sub_elements[1] = 1;
                int elements_in_sub = 2;
                boolean bl = left_to_right = current_row % 2 == 1 || blocksPerRow % 2 == 1;
                if (!left_to_right && current_row == stack_rows && num_columns != blocksPerRow && num_columns % 2 == 1) {
                    special_case_row = true;
                    left_to_right = true;
                    sub_elements[0] = 2;
                } else {
                    special_case_row = false;
                }
                int reader = 0;
                do {
                    i = 2 + current_block * 21;
                    for (j = 0; j < 21; ++j) {
                        if (i + j < pattern_width) {
                            if (left_to_right) {
                                sub_elements[j + reader * 21 + 2] = elements[i + j];
                            } else {
                                sub_elements[20 - j + (num_columns - 1 - reader) * 21 + 2] = elements[i + j];
                            }
                        }
                        ++elements_in_sub;
                    }
                } while (++reader < blocksPerRow && ++current_block < codeblocks);
                sub_elements[elements_in_sub] = 1;
                sub_elements[elements_in_sub + 1] = 1;
                elements_in_sub += 2;
                boolean black = true;
                this.row_height[symbol_row + compositeOffset] = -1;
                StringBuilder pat = new StringBuilder();
                if (current_row % 2 == 1 || special_case_row) {
                    pat.append('0');
                    black = false;
                }
                for (i = 0; i < elements_in_sub; ++i) {
                    pat.append((char)(sub_elements[i] + 48));
                    black = !black;
                }
                this.pattern[symbol_row + compositeOffset] = pat.toString();
                if (current_row != 1) {
                    StringBuilder sep = new StringBuilder("05");
                    for (j = 5; j < 49 * blocksPerRow; j += 2) {
                        sep.append("11");
                    }
                    this.pattern[symbol_row - 2 + compositeOffset] = sep.toString();
                    this.row_height[symbol_row - 2 + compositeOffset] = 1;
                    boolean odd_last_row = current_row == stack_rows && data_chars % 2 == 0;
                    this.row_height[symbol_row - 1 + compositeOffset] = 1;
                    this.pattern[symbol_row - 1 + compositeOffset] = DataBarExpanded.separator(pat, reader, false, special_case_row, left_to_right, odd_last_row, v2);
                }
                if (current_row != stack_rows) {
                    this.row_height[symbol_row + 1 + compositeOffset] = 1;
                    this.pattern[symbol_row + 1 + compositeOffset] = DataBarExpanded.separator(pat, reader, true, false, left_to_right, false, v2);
                }
                symbol_row += 4;
            }
            this.readable = "";
            this.row_count += compositeOffset;
        }
        if (this.linkageFlag) {
            this.pattern[0] = DataBarExpanded.separator(this.pattern[1], 4, false, false, true, false, new AtomicBoolean(false));
            this.row_height[0] = 1;
        }
    }

    private static String separator(CharSequence pattern, int cols, boolean below, boolean specialCaseRow, boolean leftToRight, boolean oddLastRow, AtomicBoolean v2mutable) {
        int j;
        int i;
        StringBuilder linearBin = new StringBuilder();
        StringBuilder separator = new StringBuilder();
        boolean black = true;
        for (i = 0; i < pattern.length(); ++i) {
            int c = pattern.charAt(i) - 48;
            for (j = 0; j < c; ++j) {
                linearBin.append(black ? (char)'1' : '0');
                separator.append(black ? (char)'0' : '1');
            }
            black = !black;
        }
        for (i = 0; i < 4; ++i) {
            separator.setCharAt(i, '0');
            separator.setCharAt(separator.length() - 1 - i, '0');
        }
        boolean space = false;
        boolean v2 = v2mutable.get();
        for (j = 0; j < cols; ++j) {
            int i2;
            int end;
            int start;
            int k = 49 * j + 19 + (specialCaseRow ? 1 : 0);
            if (leftToRight) {
                start = v2 ? 2 : 0;
                end = v2 ? 15 : 13;
                for (i2 = start; i2 < end; ++i2) {
                    if (i2 + k >= linearBin.length()) continue;
                    if (linearBin.charAt(i2 + k) == '1') {
                        separator.setCharAt(i2 + k, '0');
                        space = false;
                        continue;
                    }
                    separator.setCharAt(i2 + k, space ? (char)'0' : '1');
                    space = !space;
                }
            } else {
                if (oddLastRow) {
                    k -= 17;
                }
                start = v2 ? 14 : 12;
                end = v2 ? 2 : 0;
                for (i2 = start; i2 >= end; --i2) {
                    if (i2 + k >= linearBin.length()) continue;
                    if (linearBin.charAt(i2 + k) == '1') {
                        separator.setCharAt(i2 + k, '0');
                        space = false;
                        continue;
                    }
                    separator.setCharAt(i2 + k, space ? (char)'0' : '1');
                    space = !space;
                }
            }
            v2 = !v2;
        }
        if (below) {
            v2mutable.set(v2);
        }
        return DataBarExpanded.bin2pat(separator);
    }

    private static int calculateBinaryString(boolean stacked, int blocksPerRow, int[] inputData, StringBuilder binaryString) {
        String padstring;
        int remainder;
        int[] generalField;
        int group;
        int read_posn;
        int i;
        EncodeMode last_mode = EncodeMode.NUMERIC;
        int encodingMethod = inputData.length >= 16 && inputData[0] == 48 && inputData[1] == 49 ? 1 : 2;
        if (inputData.length >= 20 && encodingMethod == 1 && inputData[2] == 57 && inputData[16] == 51) {
            double weight;
            if (inputData.length >= 26 && inputData[17] == 49 && inputData[18] == 48) {
                weight = 0.0;
                for (i = 0; i < 6; ++i) {
                    weight *= 10.0;
                    weight += (double)(inputData[20 + i] - 48);
                }
                if (weight < 99999.0) {
                    if (inputData[19] == 51 && inputData.length == 26 && (weight /= 1000.0) <= 32.767) {
                        encodingMethod = 3;
                    }
                    if (inputData.length == 34) {
                        if (inputData[26] == 49 && inputData[27] == 49) {
                            encodingMethod = 7;
                        }
                        if (inputData[26] == 49 && inputData[27] == 51) {
                            encodingMethod = 9;
                        }
                        if (inputData[26] == 49 && inputData[27] == 53) {
                            encodingMethod = 11;
                        }
                        if (inputData[26] == 49 && inputData[27] == 55) {
                            encodingMethod = 13;
                        }
                    }
                }
            }
            if (inputData.length >= 26 && inputData[17] == 50 && inputData[18] == 48) {
                weight = 0.0;
                for (i = 0; i < 6; ++i) {
                    weight *= 10.0;
                    weight += (double)(inputData[20 + i] - 48);
                }
                if (weight < 99999.0) {
                    if ((inputData[19] == 50 || inputData[19] == 51) && inputData.length == 26) {
                        if (inputData[19] == 51) {
                            if ((weight /= 1000.0) <= 22.767) {
                                encodingMethod = 4;
                            }
                        } else if ((weight /= 100.0) <= 99.99) {
                            encodingMethod = 4;
                        }
                    }
                    if (inputData.length == 34) {
                        if (inputData[26] == 49 && inputData[27] == 49) {
                            encodingMethod = 8;
                        }
                        if (inputData[26] == 49 && inputData[27] == 51) {
                            encodingMethod = 10;
                        }
                        if (inputData[26] == 49 && inputData[27] == 53) {
                            encodingMethod = 12;
                        }
                        if (inputData[26] == 49 && inputData[27] == 55) {
                            encodingMethod = 14;
                        }
                    }
                }
            }
            if (inputData[17] == 57) {
                if (inputData[18] == 50 && inputData[19] >= 48 && inputData[19] <= 51) {
                    encodingMethod = 5;
                }
                if (inputData[18] == 51 && inputData[19] >= 48 && inputData[19] <= 51) {
                    encodingMethod = 6;
                }
            }
        }
        switch (encodingMethod) {
            case 1: {
                binaryString.append("1XX");
                read_posn = 16;
                break;
            }
            case 2: {
                binaryString.append("00XX");
                read_posn = 0;
                break;
            }
            case 3: {
                binaryString.append("0100");
                read_posn = inputData.length;
                break;
            }
            case 4: {
                binaryString.append("0101");
                read_posn = inputData.length;
                break;
            }
            case 5: {
                binaryString.append("01100XX");
                read_posn = 20;
                break;
            }
            case 6: {
                binaryString.append("01101XX");
                read_posn = 23;
                break;
            }
            default: {
                binaryString.append("0" + Integer.toBinaryString(56 + encodingMethod - 7));
                read_posn = inputData.length;
            }
        }
        for (i = 0; i < read_posn; ++i) {
            if (inputData[i] >= 48 && inputData[i] <= 57) continue;
            throw new OkapiException("Invalid characters in input data");
        }
        if (encodingMethod == 1) {
            Strings.binaryAppend(binaryString, inputData[2] - 48, 4);
            for (i = 1; i < 5; ++i) {
                group = DataBarExpanded.parseInt(inputData, i * 3, 3);
                Strings.binaryAppend(binaryString, group, 10);
            }
        }
        if (encodingMethod == 3 || encodingMethod == 4) {
            for (i = 1; i < 5; ++i) {
                group = DataBarExpanded.parseInt(inputData, i * 3, 3);
                Strings.binaryAppend(binaryString, group, 10);
            }
            group = DataBarExpanded.parseInt(inputData, 20, 6);
            if (encodingMethod == 4 && inputData[19] == 51) {
                group += 10000;
            }
            Strings.binaryAppend(binaryString, group, 15);
        }
        if (encodingMethod == 5 || encodingMethod == 6) {
            for (i = 1; i < 5; ++i) {
                group = DataBarExpanded.parseInt(inputData, i * 3, 3);
                Strings.binaryAppend(binaryString, group, 10);
            }
            Strings.binaryAppend(binaryString, inputData[19] - 48, 2);
            if (encodingMethod == 6) {
                int currency = DataBarExpanded.parseInt(inputData, 20, 3);
                Strings.binaryAppend(binaryString, currency, 10);
            }
        }
        if (encodingMethod >= 7 && encodingMethod <= 14) {
            int date;
            for (i = 1; i < 5; ++i) {
                group = DataBarExpanded.parseInt(inputData, i * 3, 3);
                Strings.binaryAppend(binaryString, group, 10);
            }
            int weight = inputData[19] - 48;
            for (i = 0; i < 5; ++i) {
                weight *= 10;
                weight += inputData[21 + i] - 48;
            }
            Strings.binaryAppend(binaryString, weight, 20);
            if (inputData.length == 34) {
                date = DataBarExpanded.parseInt(inputData, 28, 2) * 384;
                date += (DataBarExpanded.parseInt(inputData, 30, 2) - 1) * 32;
                date += DataBarExpanded.parseInt(inputData, 32, 2);
            } else {
                date = 38400;
            }
            Strings.binaryAppend(binaryString, date, 16);
        }
        if ((generalField = Arrays.copyOfRange(inputData, read_posn, inputData.length)).length != 0) {
            int value;
            int d2;
            int d1;
            boolean latch = false;
            EncodeMode[] generalFieldType = new EncodeMode[generalField.length];
            for (i = 0; i < generalField.length; ++i) {
                EncodeMode mode;
                int c = generalField[i];
                if (c == -1) {
                    mode = EncodeMode.ANY_ENC;
                } else if (c >= 48 && c <= 57) {
                    mode = EncodeMode.ANY_ENC;
                } else if (c >= 65 && c <= 90 || c == 42 || c == 44 || c == 45 || c == 46 || c == 47) {
                    mode = EncodeMode.ALPHA_OR_ISO;
                } else if (c >= 97 && c <= 122 || c == 33 || c == 34 || c == 37 || c == 38 || c == 39 || c == 40 || c == 41 || c == 43 || c == 58 || c == 59 || c == 60 || c == 61 || c == 62 || c == 63 || c == 95 || c == 32) {
                    mode = EncodeMode.ISOIEC;
                } else {
                    mode = EncodeMode.INVALID_CHAR;
                    latch = true;
                }
                generalFieldType[i] = mode;
            }
            if (latch) {
                throw new OkapiException("Invalid characters in input data");
            }
            for (i = 0; i < generalField.length - 1; ++i) {
                if (generalFieldType[i] != EncodeMode.ISOIEC || generalField[i + 1] != -1) continue;
                generalFieldType[i + 1] = EncodeMode.ISOIEC;
            }
            for (i = 0; i < generalField.length - 1; ++i) {
                if (generalFieldType[i] != EncodeMode.ALPHA_OR_ISO || generalField[i + 1] != -1) continue;
                generalFieldType[i + 1] = EncodeMode.ALPHA_OR_ISO;
            }
            latch = DataBarExpanded.applyGeneralFieldRules(generalFieldType);
            if (generalFieldType[0] == EncodeMode.ALPHA) {
                binaryString.append("0000");
                last_mode = EncodeMode.ALPHA;
            }
            if (generalFieldType[0] == EncodeMode.ISOIEC) {
                binaryString.append("0000");
                binaryString.append("00100");
                last_mode = EncodeMode.ISOIEC;
            }
            int current_length = i = 0;
            if (latch) {
                ++current_length;
            }
            while (current_length < generalField.length) {
                switch (generalFieldType[i]) {
                    case NUMERIC: {
                        if (last_mode != EncodeMode.NUMERIC) {
                            binaryString.append("000");
                        }
                        d1 = generalField[i] != -1 ? generalField[i] - 48 : 10;
                        d2 = generalField[i + 1] != -1 ? generalField[i + 1] - 48 : 10;
                        value = 11 * d1 + d2 + 8;
                        Strings.binaryAppend(binaryString, value, 7);
                        i += 2;
                        last_mode = EncodeMode.NUMERIC;
                        break;
                    }
                    case ALPHA: {
                        if (i != 0) {
                            if (last_mode == EncodeMode.NUMERIC) {
                                binaryString.append("0000");
                            }
                            if (last_mode == EncodeMode.ISOIEC) {
                                binaryString.append("00100");
                            }
                        }
                        if (generalField[i] >= 48 && generalField[i] <= 57) {
                            value = generalField[i] - 43;
                            Strings.binaryAppend(binaryString, value, 5);
                        }
                        if (generalField[i] >= 65 && generalField[i] <= 90) {
                            value = generalField[i] - 33;
                            Strings.binaryAppend(binaryString, value, 6);
                        }
                        last_mode = EncodeMode.ALPHA;
                        if (generalField[i] == -1) {
                            binaryString.append("01111");
                        }
                        if (generalField[i] == 42) {
                            binaryString.append("111010");
                        }
                        if (generalField[i] == 44) {
                            binaryString.append("111011");
                        }
                        if (generalField[i] == 45) {
                            binaryString.append("111100");
                        }
                        if (generalField[i] == 46) {
                            binaryString.append("111101");
                        }
                        if (generalField[i] == 47) {
                            binaryString.append("111110");
                        }
                        break;
                    }
                    case ISOIEC: {
                        if (i != 0) {
                            if (last_mode == EncodeMode.NUMERIC) {
                                binaryString.append("0000");
                                binaryString.append("00100");
                            }
                            if (last_mode == EncodeMode.ALPHA) {
                                binaryString.append("00100");
                            }
                        }
                        if (generalField[i] >= 48 && generalField[i] <= 57) {
                            value = generalField[i] - 43;
                            Strings.binaryAppend(binaryString, value, 5);
                        }
                        if (generalField[i] >= 65 && generalField[i] <= 90) {
                            value = generalField[i] - 1;
                            Strings.binaryAppend(binaryString, value, 7);
                        }
                        if (generalField[i] >= 97 && generalField[i] <= 122) {
                            value = generalField[i] - 7;
                            Strings.binaryAppend(binaryString, value, 7);
                        }
                        last_mode = EncodeMode.ISOIEC;
                        if (generalField[i] == -1) {
                            binaryString.append("01111");
                        }
                        if (generalField[i] == 33) {
                            binaryString.append("11101000");
                        }
                        if (generalField[i] == 34) {
                            binaryString.append("11101001");
                        }
                        if (generalField[i] == 37) {
                            binaryString.append("11101010");
                        }
                        if (generalField[i] == 38) {
                            binaryString.append("11101011");
                        }
                        if (generalField[i] == 39) {
                            binaryString.append("11101100");
                        }
                        if (generalField[i] == 40) {
                            binaryString.append("11101101");
                        }
                        if (generalField[i] == 41) {
                            binaryString.append("11101110");
                        }
                        if (generalField[i] == 42) {
                            binaryString.append("11101111");
                        }
                        if (generalField[i] == 43) {
                            binaryString.append("11110000");
                        }
                        if (generalField[i] == 44) {
                            binaryString.append("11110001");
                        }
                        if (generalField[i] == 45) {
                            binaryString.append("11110010");
                        }
                        if (generalField[i] == 46) {
                            binaryString.append("11110011");
                        }
                        if (generalField[i] == 47) {
                            binaryString.append("11110100");
                        }
                        if (generalField[i] == 58) {
                            binaryString.append("11110101");
                        }
                        if (generalField[i] == 59) {
                            binaryString.append("11110110");
                        }
                        if (generalField[i] == 60) {
                            binaryString.append("11110111");
                        }
                        if (generalField[i] == 61) {
                            binaryString.append("11111000");
                        }
                        if (generalField[i] == 62) {
                            binaryString.append("11111001");
                        }
                        if (generalField[i] == 63) {
                            binaryString.append("11111010");
                        }
                        if (generalField[i] == 95) {
                            binaryString.append("11111011");
                        }
                        if (generalField[i] == 32) {
                            binaryString.append("11111100");
                        }
                        ++i;
                    }
                }
                current_length = ++i;
                if (!latch) continue;
                ++current_length;
            }
            remainder = DataBarExpanded.calculateRemainder(binaryString.length(), stacked, blocksPerRow);
            if (latch) {
                if (last_mode == EncodeMode.NUMERIC) {
                    if (remainder >= 4 && remainder <= 6) {
                        value = generalField[i] - 48;
                        Strings.binaryAppend(binaryString, ++value, 4);
                    } else {
                        d1 = generalField[i] - 48;
                        d2 = 10;
                        value = 11 * d1 + d2 + 8;
                        Strings.binaryAppend(binaryString, value, 7);
                    }
                } else {
                    value = generalField[i] - 43;
                    Strings.binaryAppend(binaryString, value, 5);
                }
            }
        }
        if (binaryString.length() > 252) {
            throw new OkapiException("Input too long");
        }
        i = remainder = DataBarExpanded.calculateRemainder(binaryString.length(), stacked, blocksPerRow);
        if (last_mode == EncodeMode.NUMERIC) {
            padstring = "0000";
            i -= 4;
        } else {
            padstring = "";
        }
        while (i > 0) {
            padstring = padstring + "00100";
            i -= 5;
        }
        binaryString.append(padstring.substring(0, remainder));
        char patchEvenOdd = (binaryString.length() / 12 + 1 & 1) == 0 ? (char)'0' : '1';
        char patchSize = binaryString.length() <= 156 ? (char)'0' : '1';
        if (encodingMethod == 1) {
            binaryString.setCharAt(2, patchEvenOdd);
            binaryString.setCharAt(3, patchSize);
        }
        if (encodingMethod == 2) {
            binaryString.setCharAt(3, patchEvenOdd);
            binaryString.setCharAt(4, patchSize);
        }
        if (encodingMethod == 5 || encodingMethod == 6) {
            binaryString.setCharAt(6, patchEvenOdd);
            binaryString.setCharAt(7, patchSize);
        }
        return encodingMethod;
    }

    private static int calculateRemainder(int binaryStringLength, boolean stacked, int blocksPerRow) {
        int symbolChars;
        int symbolCharsInLastRow;
        int remainder = 12 - binaryStringLength % 12;
        if (remainder == 12) {
            remainder = 0;
        }
        if (binaryStringLength < 36) {
            remainder = 36 - binaryStringLength;
        }
        if (stacked && (symbolCharsInLastRow = (symbolChars = (binaryStringLength + remainder) / 12 + 1) % (blocksPerRow * 2)) == 1) {
            remainder += 12;
        }
        return remainder;
    }

    private void logBinaryStringInfo(StringBuilder binaryString) {
        this.infoLine("Binary Length: " + binaryString.length());
        this.info("Binary String: ");
        int nibble = 0;
        block6: for (int i = 0; i < binaryString.length(); ++i) {
            switch (i % 4) {
                case 0: {
                    if (binaryString.charAt(i) != '1') continue block6;
                    nibble += 8;
                    continue block6;
                }
                case 1: {
                    if (binaryString.charAt(i) != '1') continue block6;
                    nibble += 4;
                    continue block6;
                }
                case 2: {
                    if (binaryString.charAt(i) != '1') continue block6;
                    nibble += 2;
                    continue block6;
                }
                case 3: {
                    if (binaryString.charAt(i) == '1') {
                        ++nibble;
                    }
                    this.info(Integer.toHexString(nibble));
                    nibble = 0;
                }
            }
        }
        if (binaryString.length() % 4 != 0) {
            this.info(Integer.toHexString(nibble));
        }
        this.infoLine();
    }

    private static boolean applyGeneralFieldRules(EncodeMode[] generalFieldType) {
        int j;
        EncodeMode current;
        int i;
        int[] blockLength = new int[200];
        EncodeMode[] blockType = new EncodeMode[200];
        int block_count = 0;
        blockLength[block_count] = 1;
        blockType[block_count] = generalFieldType[0];
        for (i = 1; i < generalFieldType.length; ++i) {
            current = generalFieldType[i];
            EncodeMode last = generalFieldType[i - 1];
            if (current == last) {
                blockLength[block_count] = blockLength[block_count] + 1;
                continue;
            }
            blockLength[++block_count] = 1;
            blockType[block_count] = generalFieldType[i];
        }
        ++block_count;
        for (i = 0; i < block_count; ++i) {
            current = blockType[i];
            EncodeMode next = blockType[i + 1];
            if (current == EncodeMode.ISOIEC && i != block_count - 1) {
                if (next == EncodeMode.ANY_ENC && blockLength[i + 1] >= 4) {
                    blockType[i + 1] = EncodeMode.NUMERIC;
                }
                if (next == EncodeMode.ANY_ENC && blockLength[i + 1] < 4) {
                    blockType[i + 1] = EncodeMode.ISOIEC;
                }
                if (next == EncodeMode.ALPHA_OR_ISO && blockLength[i + 1] >= 5) {
                    blockType[i + 1] = EncodeMode.ALPHA;
                }
                if (next == EncodeMode.ALPHA_OR_ISO && blockLength[i + 1] < 5) {
                    blockType[i + 1] = EncodeMode.ISOIEC;
                }
            }
            if (current == EncodeMode.ALPHA_OR_ISO) {
                blockType[i] = EncodeMode.ALPHA;
                current = EncodeMode.ALPHA;
            }
            if (current == EncodeMode.ALPHA && i != block_count - 1) {
                if (next == EncodeMode.ANY_ENC && blockLength[i + 1] >= 6) {
                    blockType[i + 1] = EncodeMode.NUMERIC;
                }
                if (next == EncodeMode.ANY_ENC && blockLength[i + 1] < 6) {
                    blockType[i + 1] = i == block_count - 2 && blockLength[i + 1] >= 4 ? EncodeMode.NUMERIC : EncodeMode.ALPHA;
                }
            }
            if (current != EncodeMode.ANY_ENC) continue;
            blockType[i] = EncodeMode.NUMERIC;
        }
        if (block_count > 1) {
            for (i = 1; i < block_count; ++i) {
                if (blockType[i - 1] != blockType[i]) continue;
                blockLength[i - 1] = blockLength[i - 1] + blockLength[i];
                for (j = i + 1; j < block_count; ++j) {
                    blockLength[j - 1] = blockLength[j];
                    blockType[j - 1] = blockType[j];
                }
                --block_count;
                --i;
            }
        }
        for (i = 0; i < block_count - 1; ++i) {
            if (blockType[i] != EncodeMode.NUMERIC || (blockLength[i] & 1) == 0) continue;
            blockLength[i] = blockLength[i] - 1;
            blockLength[i + 1] = blockLength[i + 1] + 1;
        }
        j = 0;
        for (i = 0; i < block_count; ++i) {
            for (int k = 0; k < blockLength[i]; ++k) {
                generalFieldType[j] = blockType[i];
                ++j;
            }
        }
        return blockType[block_count - 1] == EncodeMode.NUMERIC && (blockLength[block_count - 1] & 1) != 0;
    }

    private static int parseInt(int[] chars, int index, int length) {
        int val = 0;
        int pow = (int)Math.pow(10.0, length - 1);
        for (int i = 0; i < length; ++i) {
            int c = chars[index + i];
            val += (c - 48) * pow;
            pow /= 10;
        }
        return val;
    }

    private static enum EncodeMode {
        NUMERIC,
        ALPHA,
        ISOIEC,
        INVALID_CHAR,
        ANY_ENC,
        ALPHA_OR_ISO;

    }
}

