/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Code32
extends Symbol {
    private static final char[] TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    @Override
    protected void encode() {
        int i;
        int[] codeword = new int[6];
        Code3Of9 c39 = new Code3Of9();
        if (this.content.length() > 8) {
            throw new OkapiException("Input too long");
        }
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        String localstr = "";
        for (i = this.content.length(); i < 8; ++i) {
            localstr = localstr + "0";
        }
        localstr = localstr + this.content;
        int checksum = 0;
        int checkpart = 0;
        for (i = 0; i < 4; ++i) {
            checkpart = Character.getNumericValue(localstr.charAt(i * 2));
            checksum += checkpart;
            checkpart = 2 * Character.getNumericValue(localstr.charAt(i * 2 + 1));
            if (checkpart >= 10) {
                checksum += checkpart - 10 + 1;
                continue;
            }
            checksum += checkpart;
        }
        int checkdigit = checksum % 10;
        char check = (char)(checkdigit + 48);
        localstr = localstr + check;
        this.infoLine("Check Digit: " + check);
        int pharmacode = 0;
        for (i = 0; i < localstr.length(); ++i) {
            pharmacode *= 10;
            pharmacode += Character.getNumericValue(localstr.charAt(i));
        }
        int devisor = 0x2000000;
        for (i = 5; i >= 0; --i) {
            int remainder;
            codeword[i] = pharmacode / devisor;
            pharmacode = remainder = pharmacode % devisor;
            devisor /= 32;
        }
        String risultante = "";
        for (i = 5; i >= 0; --i) {
            risultante = risultante + TABLE[codeword[i]];
        }
        this.readable = "A" + localstr;
        this.pattern = new String[1];
        this.row_count = 1;
        this.row_height = new int[]{-1};
        this.infoLine("Code 39 Equivalent: " + risultante);
        c39.setContent(risultante);
        this.pattern[0] = c39.pattern[0];
    }
}

