/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import java.util.Stack;
import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DrawingUtil;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCEANBean;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;
import org.krysalis.barcode4j.output.Canvas;

public class UPCEANCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private UPCEANBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private BarcodeDimension dim;
    private String msg;
    private String lastgroup;
    private double groupx;
    private boolean inMsgGroup;
    private boolean inSupplemental;
    private Stack groupStack = new Stack();

    public UPCEANCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        if (!(bcBean instanceof UPCEANBean)) {
            throw new IllegalArgumentException("This LogicHandler can only be used with UPC and EAN barcode implementations");
        }
        this.bcBean = (UPCEANBean)bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        this.msg = msg;
        this.dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(this.dim);
        this.x = this.getStartX();
        this.inMsgGroup = false;
        this.inSupplemental = false;
    }

    public void startBarGroup(BarGroup type, String submsg) {
        if (type != BarGroup.UPC_EAN_GUARD) {
            if (type == BarGroup.UPC_EAN_GROUP) {
                this.inMsgGroup = true;
                this.groupx = this.x;
                this.lastgroup = submsg;
            } else if (type == BarGroup.UPC_EAN_LEAD) {
                this.lastgroup = submsg;
            } else if (type == BarGroup.UPC_EAN_CHECK) {
                if (!this.inMsgGroup) {
                    this.lastgroup = submsg;
                }
            } else if (type == BarGroup.UPC_EAN_SUPP) {
                this.inSupplemental = true;
                this.x += this.bcBean.getQuietZone();
                this.groupx = this.x;
            }
        }
        this.groupStack.push(type);
    }

    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            if (!this.inSupplemental) {
                if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                    this.canvas.drawRectWH(this.x, 0.0, w, this.bcBean.getHeight());
                } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                    double y;
                    double h2;
                    if (this.inMsgGroup) {
                        h2 = this.bcBean.getBarHeight();
                        y = this.bcBean.getHumanReadableHeight();
                    } else {
                        h2 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0;
                        y = this.bcBean.getHumanReadableHeight() / 2.0;
                    }
                    this.canvas.drawRectWH(this.x, y, w, h2);
                } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                    double h3 = this.inMsgGroup ? this.bcBean.getBarHeight() : this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0;
                    this.canvas.drawRectWH(this.x, 0.0, w, h3);
                }
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                double h4 = this.bcBean.getBarHeight();
                double y = this.bcBean.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, y, w, h4);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                double h5 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0 - this.bcBean.getHumanReadableHeight();
                double y = this.bcBean.getHumanReadableHeight() / 2.0;
                this.canvas.drawRectWH(this.x, y, w, h5);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                double h6 = this.bcBean.getBarHeight() + this.bcBean.getHumanReadableHeight() / 2.0 - this.bcBean.getHumanReadableHeight();
                double y = this.bcBean.getHumanReadableHeight();
                this.canvas.drawRectWH(this.x, y, w, h6);
            }
        }
        this.x += w;
    }

    private boolean isEAN() {
        return this.bcBean instanceof EAN13Bean || this.bcBean instanceof EAN8Bean;
    }

    public void endBarGroup() {
        BarGroup group = (BarGroup)this.groupStack.pop();
        if (group == BarGroup.UPC_EAN_GROUP) {
            this.inMsgGroup = false;
            if (this.lastgroup == null) {
                return;
            }
            int colonPos = this.lastgroup.indexOf(":");
            String grouptext = this.lastgroup;
            if (colonPos >= 0) {
                String lead = new Character(grouptext.charAt(0)).toString();
                this.drawLeadChar(lead);
                grouptext = grouptext.substring(colonPos + 1);
            }
            this.drawGroupText(grouptext);
        } else if (group == BarGroup.UPC_EAN_LEAD) {
            if (!this.isEAN()) {
                this.drawLeadChar(this.lastgroup);
            }
        } else if (group == BarGroup.UPC_EAN_CHECK) {
            if (!this.isEAN()) {
                this.drawTrailingChar(this.lastgroup);
            }
        } else if (group == BarGroup.UPC_EAN_SUPP) {
            this.drawSupplementalText(UPCEANLogicImpl.retrieveSupplemental(this.msg));
            this.inSupplemental = false;
        }
    }

    private void drawLeadChar(String lead) {
        double leadw = 7.0 * this.bcBean.getBarWidth(1);
        double leadx = this.getStartX() - 3.0 * this.bcBean.getBarWidth(1) - leadw;
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, lead, leadx, leadx + leadw, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, lead, leadx, leadx + leadw, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
            }
        }
    }

    private void drawTrailingChar(String trailer) {
        double trailerw = 7.0 * this.bcBean.getBarWidth(1);
        double trailerx = this.getStartX() + this.dim.getWidth() - this.bcBean.supplementalWidth(this.msg) + 3.0 * this.bcBean.getBarWidth(1);
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, trailer, trailerx, trailerx + trailerw, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, trailer, trailerx, trailerx + trailerw, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
            }
        }
    }

    private void drawGroupText(String text) {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawText(this.canvas, this.bcBean, text, this.groupx + this.bcBean.getBarWidth(1), this.x - this.bcBean.getBarWidth(1), this.bcBean.getHumanReadableHeight(), TextAlignment.TA_JUSTIFY);
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawText(this.canvas, this.bcBean, text, this.groupx + this.bcBean.getBarWidth(1), this.x - this.bcBean.getBarWidth(1), this.bcBean.getHeight(), TextAlignment.TA_JUSTIFY);
            }
        }
    }

    private void drawSupplementalText(String supp) {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            DrawingUtil.drawText(this.canvas, this.bcBean, supp, this.groupx, this.x, this.bcBean.getHeight(), TextAlignment.TA_CENTER);
        } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            DrawingUtil.drawText(this.canvas, this.bcBean, supp, this.groupx, this.x, this.bcBean.getHumanReadableHeight(), TextAlignment.TA_CENTER);
        }
    }

    public void endBarcode() {
    }
}

