/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.cli;

import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;

public class AdvancedConsoleLogger
implements Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int LEVEL_DISABLED = 5;
    private static final String[] LEVEL_STRINGS = new String[]{"[DEBUG] ", "[INFO] ", "[WARN] ", "[ERROR] ", "[FATAL] "};
    private int logLevel;
    private boolean prefix;
    private PrintStream out;
    private PrintStream err;

    public AdvancedConsoleLogger(int logLevel, boolean prefix, PrintStream out, PrintStream err) {
        this.logLevel = logLevel;
        this.prefix = prefix;
        this.out = out;
        this.err = err;
    }

    public AdvancedConsoleLogger() {
        this(0, true, System.out, System.err);
    }

    private void logMessage(String msg, Throwable t2, int logLevel) {
        if (logLevel >= this.logLevel) {
            PrintStream stream;
            PrintStream printStream = stream = logLevel >= 3 ? this.err : this.out;
            if (this.prefix) {
                stream.print(LEVEL_STRINGS[logLevel]);
            }
            stream.println(msg);
            if (t2 != null) {
                t2.printStackTrace(stream);
            }
        }
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String msg, Throwable t2) {
        this.logMessage(msg, t2, 0);
    }

    public boolean isDebugEnabled() {
        return this.logLevel <= 0;
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable t2) {
        this.logMessage(msg, t2, 1);
    }

    public boolean isInfoEnabled() {
        return this.logLevel <= 1;
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable t2) {
        this.logMessage(msg, t2, 2);
    }

    public boolean isWarnEnabled() {
        return this.logLevel <= 2;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Throwable t2) {
        this.logMessage(msg, t2, 3);
    }

    public boolean isErrorEnabled() {
        return this.logLevel <= 3;
    }

    public void fatalError(String msg) {
        this.fatalError(msg, null);
    }

    public void fatalError(String msg, Throwable t2) {
        this.logMessage(msg, t2, 4);
    }

    public boolean isFatalErrorEnabled() {
        return this.logLevel <= 4;
    }

    public Logger getChildLogger(String name) {
        return this;
    }
}

