/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;

public class ReflectUtil {
    private ReflectUtil() {
    }

    public static Object invoke(Object obj, String methodName) {
        try {
            Method method = obj.getClass().getMethod(methodName, null);
            return method.invoke(obj, (Object[])null);
        }
        catch (Exception t2) {
            ReflectUtil.throwBuildException(t2);
            return null;
        }
    }

    public static Object invokeStatic(Object obj, String methodName) {
        try {
            Method method = ((Class)obj).getMethod(methodName, null);
            return method.invoke(obj, (Object[])null);
        }
        catch (Exception t2) {
            ReflectUtil.throwBuildException(t2);
            return null;
        }
    }

    public static Object invoke(Object obj, String methodName, Class argType, Object arg) {
        try {
            Method method = obj.getClass().getMethod(methodName, argType);
            return method.invoke(obj, arg);
        }
        catch (Exception t2) {
            ReflectUtil.throwBuildException(t2);
            return null;
        }
    }

    public static Object invoke(Object obj, String methodName, Class argType1, Object arg1, Class argType2, Object arg2) {
        try {
            Method method = obj.getClass().getMethod(methodName, argType1, argType2);
            return method.invoke(obj, arg1, arg2);
        }
        catch (Exception t2) {
            ReflectUtil.throwBuildException(t2);
            return null;
        }
    }

    public static Object getField(Object obj, String fieldName) throws BuildException {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception t2) {
            ReflectUtil.throwBuildException(t2);
            return null;
        }
    }

    public static void throwBuildException(Exception t2) throws BuildException {
        throw ReflectUtil.toBuildException(t2);
    }

    public static BuildException toBuildException(Exception t2) {
        if (t2 instanceof InvocationTargetException) {
            Throwable t22 = ((InvocationTargetException)t2).getTargetException();
            if (t22 instanceof BuildException) {
                return (BuildException)t22;
            }
            return new BuildException(t22);
        }
        return new BuildException(t2);
    }

    public static boolean respondsTo(Object o, String methodName) throws BuildException {
        try {
            Method[] methods = o.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception t2) {
            throw ReflectUtil.toBuildException(t2);
        }
    }
}

