/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class SQLExec
extends JDBCTask {
    private int goodSql = 0;
    private int totalSql = 0;
    private Connection conn = null;
    private Union resources = new Union();
    private Statement statement = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private boolean showtrailers = true;
    private File output = null;
    private String onError = "abort";
    private String encoding = null;
    private boolean append = false;
    private boolean keepformat = false;
    private boolean escapeProcessing = true;
    private boolean expandProperties = true;
    private boolean rawBlobs;

    public void setSrc(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setExpandProperties(boolean expandProperties) {
        this.expandProperties = expandProperties;
    }

    public boolean getExpandProperties() {
        return this.expandProperties;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public Transaction createTransaction() {
        Transaction t2 = new Transaction();
        this.transactions.addElement(t2);
        return t2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setShowtrailers(boolean showtrailers) {
        this.showtrailers = showtrailers;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setOnerror(OnError action) {
        this.onError = action.getValue();
    }

    public void setKeepformat(boolean keepformat) {
        this.keepformat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    public void setRawBlobs(boolean rawBlobs) {
        this.rawBlobs = rawBlobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Vector savedTransaction = (Vector)this.transactions.clone();
        String savedSqlCommand = this.sqlCommand;
        this.sqlCommand = this.sqlCommand.trim();
        try {
            if (this.srcFile == null && this.sqlCommand.length() == 0 && this.resources.size() == 0 && this.transactions.size() == 0) {
                throw new BuildException("Source file or resource collection, transactions or sql statement must be set!", this.getLocation());
            }
            if (this.srcFile != null && !this.srcFile.isFile()) {
                throw new BuildException("Source file " + this.srcFile + " is not a file!", this.getLocation());
            }
            Iterator iter = this.resources.iterator();
            while (iter.hasNext()) {
                Resource r = (Resource)iter.next();
                Transaction t2 = this.createTransaction();
                t2.setSrcResource(r);
            }
            Transaction t3 = this.createTransaction();
            t3.setSrc(this.srcFile);
            t3.addText(this.sqlCommand);
            this.conn = this.getConnection();
            if (!this.isValidRdbms(this.conn)) {
                return;
            }
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                PrintStream out = System.out;
                try {
                    if (this.output != null) {
                        this.log("Opening PrintStream to output file " + this.output, 3);
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output.getAbsolutePath(), this.append)));
                    }
                    Enumeration e = this.transactions.elements();
                    while (e.hasMoreElements()) {
                        ((Transaction)e.nextElement()).runTransaction(out);
                        if (this.isAutocommit()) continue;
                        this.log("Committing transaction", 3);
                        this.conn.commit();
                    }
                }
                finally {
                    FileUtils.close(out);
                }
            }
            catch (IOException e) {
                this.closeQuietly();
                throw new BuildException(e, this.getLocation());
            }
            catch (SQLException e) {
                this.closeQuietly();
                throw new BuildException(e, this.getLocation());
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {}
                try {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                catch (SQLException ex) {}
            }
            this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
        }
        finally {
            this.transactions = savedTransaction;
            this.sqlCommand = savedSqlCommand;
        }
    }

    protected void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        StringBuffer sql = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String token;
            StringTokenizer st;
            if (!this.keepformat) {
                line = line.trim();
            }
            if (this.expandProperties) {
                line = this.getProject().replaceProperties(line);
            }
            if (!this.keepformat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            sql.append(this.keepformat ? "\n" : " ").append(line);
            if (!this.keepformat && line.indexOf("--") >= 0) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !StringUtils.endsWith(sql, this.delimiter)) && (!this.delimiterType.equals("row") || !line.equals(this.delimiter))) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.replace(0, sql.length(), "");
        }
        if (sql.length() > 0) {
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalSql;
            this.log("SQL: " + sql, 3);
            int updateCount = 0;
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            updateCount = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!ret) {
                    if (updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                } else if (this.print) {
                    this.printResults(resultSet, out);
                }
                if (!(ret = this.statement.getMoreResults())) continue;
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (ret);
            this.log(updateCountTotal + " rows affected", 3);
            if (this.print && this.showtrailers) {
                out.println(updateCountTotal + " rows affected");
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.log(warning + " sql warning", 3);
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException e) {
            this.log("Failed to execute: " + sql, 0);
            if (!this.onError.equals("continue")) {
                throw e;
            }
            this.log(e.toString(), 0);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printResults(PrintStream out) throws SQLException {
        ResultSet rs = this.statement.getResultSet();
        try {
            this.printResults(rs, out);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    protected void printResults(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            this.log("Processing new result set.", 3);
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            if (columnCount > 0) {
                int col;
                if (this.showheaders) {
                    out.print(md.getColumnName(1));
                    for (col = 2; col <= columnCount; ++col) {
                        out.write(44);
                        out.print(md.getColumnName(col));
                    }
                    out.println();
                }
                while (rs.next()) {
                    this.printValue(rs, 1, out);
                    for (col = 2; col <= columnCount; ++col) {
                        out.write(44);
                        this.printValue(rs, col, out);
                    }
                    out.println();
                }
            }
        }
        out.println();
    }

    private void printValue(ResultSet rs, int col, PrintStream out) throws SQLException {
        if (this.rawBlobs && rs.getMetaData().getColumnType(col) == 2004) {
            new StreamPumper(rs.getBlob(col).getBinaryStream(), out).run();
        } else {
            out.print(rs.getString(col));
        }
    }

    private void closeQuietly() {
        if (!this.isAutocommit() && this.conn != null && this.onError.equals("abort")) {
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public class Transaction {
        private Resource tSrcResource = null;
        private String tSqlCommand = "";

        public void setSrc(File src) {
            if (src != null) {
                this.setSrcResource(new FileResource(src));
            }
        }

        public void setSrcResource(Resource src) {
            if (this.tSrcResource != null) {
                throw new BuildException("only one resource per transaction");
            }
            this.tSrcResource = src;
        }

        public void addText(String sql) {
            if (sql != null) {
                this.tSqlCommand = this.tSqlCommand + sql;
            }
        }

        public void addConfigured(ResourceCollection a) {
            if (a.size() != 1) {
                throw new BuildException("only single argument resource collections are supported.");
            }
            this.setSrcResource((Resource)a.iterator().next());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcResource != null) {
                SQLExec.this.log("Executing resource: " + this.tSrcResource.toString(), 2);
                InputStream is = null;
                InputStreamReader reader = null;
                try {
                    is = this.tSrcResource.getInputStream();
                    reader = SQLExec.this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, SQLExec.this.encoding);
                    SQLExec.this.runStatements(reader, out);
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    FileUtils.close(reader);
                    throw throwable;
                }
                FileUtils.close(is);
                FileUtils.close(reader);
            }
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }
}

