/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.apache.tools.ant.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelper2
extends ProjectHelper {
    public static final String REFID_TARGETS = "ant.targets";
    private static AntHandler elementHandler = new ElementHandler();
    private static AntHandler targetHandler = new TargetHandler();
    private static AntHandler mainHandler = new MainHandler();
    private static AntHandler projectHandler = new ProjectHandler();
    private static final String REFID_CONTEXT = "ant.parsing.context";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public UnknownElement parseUnknownElement(Project project, URL source) throws BuildException {
        Target dummyTarget = new Target();
        dummyTarget.setProject(project);
        AntXMLContext context = new AntXMLContext(project);
        context.addTarget(dummyTarget);
        context.setImplicitTarget(dummyTarget);
        this.parse(context.getProject(), source, new RootHandler(context, elementHandler));
        Task[] tasks = dummyTarget.getTasks();
        if (tasks.length != 1) {
            throw new BuildException("No tasks defined");
        }
        return (UnknownElement)tasks[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Project project, Object source) throws BuildException {
        this.getImportStack().addElement(source);
        AntXMLContext context = null;
        context = (AntXMLContext)project.getReference(REFID_CONTEXT);
        if (context == null) {
            context = new AntXMLContext(project);
            project.addReference(REFID_CONTEXT, context);
            project.addReference(REFID_TARGETS, context.getTargets());
        }
        if (this.getImportStack().size() > 1) {
            context.setIgnoreProjectTag(true);
            Target currentTarget = context.getCurrentTarget();
            Target currentImplicit = context.getImplicitTarget();
            Map currentTargets = context.getCurrentTargets();
            try {
                Target newCurrent = new Target();
                newCurrent.setProject(project);
                newCurrent.setName("");
                context.setCurrentTarget(newCurrent);
                context.setCurrentTargets(new HashMap());
                context.setImplicitTarget(newCurrent);
                this.parse(project, source, new RootHandler(context, mainHandler));
                newCurrent.execute();
            }
            finally {
                context.setCurrentTarget(currentTarget);
                context.setImplicitTarget(currentImplicit);
                context.setCurrentTargets(currentTargets);
            }
        } else {
            context.setCurrentTargets(new HashMap());
            this.parse(project, source, new RootHandler(context, mainHandler));
            context.getImplicitTarget().execute();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object source, RootHandler handler) throws BuildException {
        AntXMLContext context = handler.context;
        File buildFile = null;
        URL url = null;
        String buildFileName = null;
        if (source instanceof File) {
            buildFile = (File)source;
            buildFile = FILE_UTILS.normalize(buildFile.getAbsolutePath());
            context.setBuildFile(buildFile);
            buildFileName = buildFile.toString();
        } else {
            if (!(source instanceof URL)) throw new BuildException("Source " + source.getClass().getName() + " not supported by this plugin");
            url = (URL)source;
            buildFileName = url.toString();
        }
        InputStream inputStream = null;
        InputSource inputSource = null;
        try {
            XMLReader parser = JAXPUtils.getNamespaceXMLReader();
            String uri = null;
            if (buildFile != null) {
                uri = FILE_UTILS.toURI(buildFile.getAbsolutePath());
                inputStream = new FileInputStream(buildFile);
            } else {
                inputStream = url.openStream();
                uri = url.toString();
            }
            inputSource = new InputSource(inputStream);
            if (uri != null) {
                inputSource.setSystemId(uri);
            }
            project.log("parsing buildfile " + buildFileName + " with URI = " + uri, 3);
            RootHandler hb = handler;
            parser.setContentHandler(hb);
            parser.setEntityResolver(hb);
            parser.setErrorHandler(hb);
            parser.setDTDHandler(hb);
            parser.parse(inputSource);
        }
        catch (SAXParseException exc) {
            try {
                Exception exception;
                Location location = new Location(exc.getSystemId(), exc.getLineNumber(), exc.getColumnNumber());
                Exception t2 = exc.getException();
                if (t2 instanceof BuildException) {
                    BuildException be = (BuildException)t2;
                    if (be.getLocation() != Location.UNKNOWN_LOCATION) throw be;
                    be.setLocation(location);
                    throw be;
                }
                String string = exc.getMessage();
                if (t2 == null) {
                    exception = exc;
                    throw new BuildException(string, exception, location);
                }
                exception = t2;
                throw new BuildException(string, exception, location);
                catch (SAXException exc2) {
                    Exception exception2;
                    Exception t3 = exc2.getException();
                    if (t3 instanceof BuildException) {
                        throw (BuildException)t3;
                    }
                    String string2 = exc2.getMessage();
                    if (t3 == null) {
                        exception2 = exc2;
                        throw new BuildException(string2, exception2);
                    }
                    exception2 = t3;
                    throw new BuildException(string2, exception2);
                }
                catch (FileNotFoundException exc3) {
                    throw new BuildException(exc3);
                }
                catch (UnsupportedEncodingException exc4) {
                    throw new BuildException("Encoding of project file " + buildFileName + " is invalid.", exc4);
                }
                catch (IOException exc5) {
                    throw new BuildException("Error reading project file " + buildFileName + ": " + exc5.getMessage(), exc5);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                throw throwable;
            }
        }
        FileUtils.close(inputStream);
    }

    protected static AntHandler getMainHandler() {
        return mainHandler;
    }

    protected static void setMainHandler(AntHandler handler) {
        mainHandler = handler;
    }

    protected static AntHandler getProjectHandler() {
        return projectHandler;
    }

    protected static void setProjectHandler(AntHandler handler) {
        projectHandler = handler;
    }

    protected static AntHandler getTargetHandler() {
        return targetHandler;
    }

    protected static void setTargetHandler(AntHandler handler) {
        targetHandler = handler;
    }

    protected static AntHandler getElementHandler() {
        return elementHandler;
    }

    protected static void setElementHandler(AntHandler handler) {
        elementHandler = handler;
    }

    public static class ElementHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable parentWrapper = context.currentWrapper();
            Object parent = null;
            if (parentWrapper != null) {
                parent = parentWrapper.getProxy();
            }
            UnknownElement task = new UnknownElement(tag);
            task.setProject(context.getProject());
            task.setNamespace(uri);
            task.setQName(qname);
            task.setTaskType(ProjectHelper.genComponentName(task.getNamespace(), tag));
            task.setTaskName(qname);
            Location location = new Location(context.getLocator().getSystemId(), context.getLocator().getLineNumber(), context.getLocator().getColumnNumber());
            task.setLocation(location);
            task.setOwningTarget(context.getCurrentTarget());
            if (parent != null) {
                ((UnknownElement)parent).addChild(task);
            } else {
                context.getCurrentTarget().addTask(task);
            }
            context.configureId(task, attrs);
            RuntimeConfigurable wrapper = new RuntimeConfigurable(task, task.getTaskName());
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getLocalName(i);
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !attrUri.equals("") && !attrUri.equals(uri)) {
                    name = attrUri + ":" + attrs.getQName(i);
                }
                String value = attrs.getValue(i);
                if ("ant-type".equals(name) || "antlib:org.apache.tools.ant".equals(attrUri) && "ant-type".equals(attrs.getLocalName(i))) {
                    context.getProject().log("WARNING: the ant-type mechanism has been deprecated" + StringUtils.LINE_SEP + "         and" + " will not be available in Ant 1.8.0 or higher", 1);
                    name = "ant-type";
                    int index = value.indexOf(":");
                    if (index >= 0) {
                        String prefix = value.substring(0, index);
                        String mappedUri = context.getPrefixMapping(prefix);
                        if (mappedUri == null) {
                            throw new BuildException("Unable to find XML NS prefix \"" + prefix + "\"");
                        }
                        value = ProjectHelper.genComponentName(mappedUri, value.substring(index + 1));
                    }
                }
                wrapper.setAttribute(name, value);
            }
            if (parentWrapper != null) {
                parentWrapper.addChild(wrapper);
            }
            context.pushWrapper(wrapper);
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            RuntimeConfigurable wrapper = context.currentWrapper();
            wrapper.addText(buf, start, count);
        }

        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.popWrapper();
        }
    }

    public static class TargetHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            String name = null;
            String depends = "";
            Project project = context.getProject();
            Target target = new Target();
            target.setProject(project);
            target.setLocation(new Location(context.getLocator()));
            context.addTarget(target);
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !attrUri.equals("") && !attrUri.equals(uri)) continue;
                String key = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if (key.equals("name")) {
                    name = value;
                    if (!"".equals(name)) continue;
                    throw new BuildException("name attribute must not be empty");
                }
                if (key.equals("depends")) {
                    depends = value;
                    continue;
                }
                if (key.equals("if")) {
                    target.setIf(value);
                    continue;
                }
                if (key.equals("unless")) {
                    target.setUnless(value);
                    continue;
                }
                if (key.equals("id")) {
                    if (value == null || value.equals("")) continue;
                    context.getProject().addReference(value, target);
                    continue;
                }
                if (key.equals("description")) {
                    target.setDescription(value);
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + key + "\"", context.getLocator());
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", context.getLocator());
            }
            if (context.getCurrentTargets().get(name) != null) {
                throw new BuildException("Duplicate target '" + name + "'", target.getLocation());
            }
            Hashtable projectTargets = project.getTargets();
            boolean usedTarget = false;
            if (projectTargets.containsKey(name)) {
                project.log("Already defined in main or a previous import, ignore " + name, 3);
            } else {
                target.setName(name);
                context.getCurrentTargets().put(name, target);
                project.addOrReplaceTarget(name, target);
                usedTarget = true;
            }
            if (depends.length() > 0) {
                target.setDepends(depends);
            }
            if (context.isIgnoringProjectTag() && context.getCurrentProjectName() != null && context.getCurrentProjectName().length() != 0) {
                String newName = context.getCurrentProjectName() + "." + name;
                Target newTarget = usedTarget ? new Target(target) : target;
                newTarget.setName(newName);
                context.getCurrentTargets().put(newName, newTarget);
                project.addOrReplaceTarget(newName, newTarget);
            }
        }

        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            context.setCurrentTarget(context.getImplicitTarget());
        }
    }

    public static class ProjectHandler
    extends AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            String baseDir = null;
            boolean nameAttributeSet = false;
            Project project = context.getProject();
            context.getImplicitTarget().setLocation(new Location(context.getLocator()));
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrUri = attrs.getURI(i);
                if (attrUri != null && !attrUri.equals("") && !attrUri.equals(uri)) continue;
                String key = attrs.getLocalName(i);
                String value = attrs.getValue(i);
                if (key.equals("default")) {
                    if (value == null || value.equals("") || context.isIgnoringProjectTag()) continue;
                    project.setDefault(value);
                    continue;
                }
                if (key.equals("name")) {
                    if (value == null) continue;
                    context.setCurrentProjectName(value);
                    nameAttributeSet = true;
                    if (context.isIgnoringProjectTag()) continue;
                    project.setName(value);
                    project.addReference(value, project);
                    continue;
                }
                if (key.equals("id")) {
                    if (value == null || context.isIgnoringProjectTag()) continue;
                    project.addReference(value, project);
                    continue;
                }
                if (key.equals("basedir")) {
                    if (context.isIgnoringProjectTag()) continue;
                    baseDir = value;
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + attrs.getQName(i) + "\"", context.getLocator());
            }
            String antFileProp = "ant.file." + context.getCurrentProjectName();
            String dup = project.getProperty(antFileProp);
            if (dup != null && nameAttributeSet) {
                File dupFile = new File(dup);
                if (context.isIgnoringProjectTag() && !dupFile.equals(context.getBuildFile())) {
                    project.log("Duplicated project name in import. Project " + context.getCurrentProjectName() + " defined first in " + dup + " and again in " + context.getBuildFile(), 1);
                }
            }
            if (context.getBuildFile() != null && nameAttributeSet) {
                project.setUserProperty("ant.file." + context.getCurrentProjectName(), context.getBuildFile().toString());
            }
            if (context.isIgnoringProjectTag()) {
                return;
            }
            if (project.getProperty("basedir") != null) {
                project.setBasedir(project.getProperty("basedir"));
            } else if (baseDir == null) {
                project.setBasedir(context.getBuildFileParent().getAbsolutePath());
            } else if (new File(baseDir).isAbsolute()) {
                project.setBasedir(baseDir);
            } else {
                project.setBaseDir(FILE_UTILS.resolveFile(context.getBuildFileParent(), baseDir));
            }
            project.addTarget("", context.getImplicitTarget());
            context.setCurrentTarget(context.getImplicitTarget());
        }

        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            return name.equals("target") && (uri.equals("") || uri.equals("antlib:org.apache.tools.ant")) ? targetHandler : elementHandler;
        }
    }

    public static class MainHandler
    extends AntHandler {
        public AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if (name.equals("project") && (uri.equals("") || uri.equals("antlib:org.apache.tools.ant"))) {
                return projectHandler;
            }
            if (name.equals(qname)) {
                throw new SAXParseException("Unexpected element \"{" + uri + "}" + name + "\" {" + "antlib:org.apache.tools.ant" + "}" + name, context.getLocator());
            }
            throw new SAXParseException("Unexpected element \"" + qname + "\" " + name, context.getLocator());
        }
    }

    public static class RootHandler
    extends DefaultHandler {
        private Stack antHandlers = new Stack();
        private AntHandler currentHandler = null;
        private AntXMLContext context;

        public RootHandler(AntXMLContext context, AntHandler rootHandler) {
            this.currentHandler = rootHandler;
            this.antHandlers.push(this.currentHandler);
            this.context = context;
        }

        public AntHandler getCurrentAntHandler() {
            return this.currentHandler;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.getProject().log("resolving systemId: " + systemId, 3);
            if (systemId.startsWith("file:")) {
                String path = FILE_UTILS.fromURI(systemId);
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = FILE_UTILS.resolveFile(this.context.getBuildFileParent(), path);
                    this.context.getProject().log("Warning: '" + systemId + "' in " + this.context.getBuildFile() + " should be expressed simply as '" + path.replace('\\', '/') + "' for compliance with other XML tools", 1);
                }
                this.context.getProject().log("file=" + file, 4);
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId(FILE_UTILS.toURI(file.getAbsolutePath()));
                    return inputSource;
                }
                catch (FileNotFoundException fne) {
                    this.context.getProject().log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            this.context.getProject().log("could not resolve systemId", 4);
            return null;
        }

        public void startElement(String uri, String tag, String qname, Attributes attrs) throws SAXParseException {
            AntHandler next = this.currentHandler.onStartChild(uri, tag, qname, attrs, this.context);
            this.antHandlers.push(this.currentHandler);
            this.currentHandler = next;
            this.currentHandler.onStartElement(uri, tag, qname, attrs, this.context);
        }

        public void setDocumentLocator(Locator locator) {
            this.context.setLocator(locator);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            AntHandler prev;
            this.currentHandler.onEndElement(uri, name, this.context);
            this.currentHandler = prev = (AntHandler)this.antHandlers.pop();
            if (this.currentHandler != null) {
                this.currentHandler.onEndChild(uri, name, qName, this.context);
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            this.currentHandler.characters(buf, start, count, this.context);
        }

        public void startPrefixMapping(String prefix, String uri) {
            this.context.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) {
            this.context.endPrefixMapping(prefix);
        }
    }

    public static class AntHandler {
        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
        }

        public AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + qname + " \"", context.getLocator());
        }

        public void onEndChild(String uri, String tag, String qname, AntXMLContext context) throws SAXParseException {
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) throws SAXParseException {
            String s2 = new String(buf, start, count).trim();
            if (s2.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s2 + "\"", context.getLocator());
            }
        }

        protected void checkNamespace(String uri) {
        }
    }
}

