/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import org.apache.struts2.ServletActionContext;
import org.imgscalr.Scalr;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.QrCode;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

@Scanned
public class QRCodeMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(QRCodeMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final XhtmlContent xhtmlContent;

    @Inject
    public QRCodeMacro(PluginLicenseManager pluginLicenseManager, XhtmlContent xhtmlContent) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
        this.xhtmlContent = xhtmlContent;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> map, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection;
        String height = map.get("height");
        QrCode code = new QrCode();
        if (!Boolean.valueOf(map.getOrDefault("useCurrentUrl", "false")).booleanValue() && (s2 == null || s2.equals(""))) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        try {
            s2 = this.xhtmlContent.convertStorageToView(s2, conversionContext);
        }
        catch (XMLStreamException e) {
            log.error("Error converting {} to view {}", (Object)s2, (Object)e);
        }
        catch (XhtmlException e) {
            log.error("Error converting {} to view", (Object)s2, (Object)e);
        }
        switch (errorCorrection = map.getOrDefault("errorCorrectionlevel", "L")) {
            default: {
                code.setPreferredEccLevel(QrCode.EccLevel.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setPreferredEccLevel(QrCode.EccLevel.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setPreferredEccLevel(QrCode.EccLevel.Q);
                log.debug("Setting ECC Level to Q");
                break;
            }
            case "H": {
                code.setPreferredEccLevel(QrCode.EccLevel.H);
                log.debug("Setting ECC Level to H");
            }
        }
        try {
            HttpServletRequest request;
            if (Boolean.valueOf(map.getOrDefault("useCurrentUrl", "false")).booleanValue() && (request = ServletActionContext.getRequest()) != null) {
                s2 = request.getRequestURL() + "?" + request.getQueryString();
            }
            code.setContent(Jsoup.parse(s2).text());
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    @Override
    protected String getRenderedImage(Symbol symbol, String heightParam) {
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(heightParam);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)heightParam);
        }
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int factor = (int)Math.ceil((double)preferredHeight / (double)height);
        String result = this.checkValidity();
        if (result == null) {
            BufferedImage image = new BufferedImage(width * factor, height * factor, 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            int preferredWidth = preferredHeight;
            image = Scalr.resize(image, Scalr.Method.BALANCED, preferredWidth, preferredHeight, new BufferedImageOp[0]);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return result;
    }
}

