/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.EanUpcAddOn;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class EANUPCCodeMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(EANUPCCodeMacro.class);
    public static final String INPUT_DATA_TOO_LONG = "<div class=\"aui-message aui-message-error\">Input data too long</div>";
    public static final String PLEASE_PROVIDE_CONTENT_INFO = "<div class=\"aui-message aui-message-error\">Please provide content</div>";
    public static final String EAN_CODE_MUST_CONTAIN_NUMBERS_WARNING = "<div class=\"aui-message aui-message-error\">Invalid input. EAN-Code must only contain numbers</div>";
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public EANUPCCodeMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String height = map.get("height");
        if (body == null || body.equals("")) {
            return PLEASE_PROVIDE_CONTENT_INFO;
        }
        if (!body.matches("\\d+")) {
            return EAN_CODE_MUST_CONTAIN_NUMBERS_WARNING;
        }
        log.debug("Generating EANUPC barcode with content {}", (Object)body);
        EanUpcAddOn code = new EanUpcAddOn();
        try {
            code.setContent(body);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

