/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Map;
import javax.inject.Inject;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.CodeOne;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

@Scanned
public class CodeOneMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(CodeOneMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public CodeOneMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String symbolsize = map.getOrDefault("symbolsize", "Auto");
        String height = map.getOrDefault("height", String.valueOf(100));
        if (s2 == null) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        CodeOne code = new CodeOne();
        switch (symbolsize) {
            case "16 X 18 (Version A)": {
                code.setPreferredVersion(CodeOne.Version.A);
                log.debug("Setting Version A");
                break;
            }
            case "22 X 22 (Version B)": {
                code.setPreferredVersion(CodeOne.Version.B);
                log.debug("Setting Version B");
                break;
            }
            case "28 X 32 (Version C)": {
                code.setPreferredVersion(CodeOne.Version.C);
                log.debug("Setting Version C");
                break;
            }
            case "40 X 42 (Version D)": {
                code.setPreferredVersion(CodeOne.Version.D);
                log.debug("Setting Version D");
                break;
            }
            case "52 X 54 (Version E)": {
                code.setPreferredVersion(CodeOne.Version.E);
                log.debug("Setting Version E");
                break;
            }
            case "70 X 76 (Version F)": {
                code.setPreferredVersion(CodeOne.Version.F);
                log.debug("Setting Version F");
                break;
            }
            case "104 X 98 (Version G)": {
                code.setPreferredVersion(CodeOne.Version.G);
                log.debug("Setting Version G");
                break;
            }
            case "148 X 134 (Version H)": {
                code.setPreferredVersion(CodeOne.Version.H);
                log.debug("Setting Version H");
                break;
            }
            case "8X Height (Version S)": {
                code.setPreferredVersion(CodeOne.Version.S);
                log.debug("Setting Version S");
                break;
            }
            case "16X Height (Version T)": {
                code.setPreferredVersion(CodeOne.Version.T);
                log.debug("Setting Version T");
                break;
            }
            default: {
                code.setPreferredVersion(CodeOne.Version.NONE);
            }
        }
        try {
            code.setContent(s2);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    protected String getRenderedImage(Symbol symbol, String heightParam) {
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(heightParam);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)heightParam);
        }
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int factor = (int)Math.ceil((double)preferredHeight / (double)height);
        String result = this.checkValidity();
        if (result == null) {
            BufferedImage image = new BufferedImage(width * factor, height * factor, 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            int preferredWidth = preferredHeight;
            image = Scalr.resize(image, Scalr.Method.BALANCED, preferredWidth, preferredHeight, new BufferedImageOp[0]);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return result;
    }
}

