/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.base;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

public abstract class AbstractBarcodeBase
implements Macro {
    public static final String EMPTY_BODY_ERROR_MSG = "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
    private static final String ERROR_IMG = "iVBORw0KGgoAAAANSUhEUgAAANEAAAARCAYAAABD0klbAAAFkUlEQVR42u1ae2jWVRhe7puM3GyiNhzajFWaaeWlf9RKULKQKBuRly3KipWFaHcLi64EGa4bjKK7BZZSChpZFhZeSiwKZ80oSrvfzG6rGa3nhecXr8dz++b3bVnnwMP8nfec9/ee57zP71w+S0pSSSWVVFJJpcdLZ0lJDihz4JDEUBSHvYTHPNrvw7OrzUHGQdm/wXeP8IaXfgb8BfxpwcwkkSgOrwQ25tH+W4PzDuBD4DoKsgboBIYeJOPvz3iHFcF3P/oeHtG2Z3ijiOYlKXS7iJqM3cBJwPfAwiSi/5iISNB7wGzga+AeWx3bDgaeA34APgHu4JbF2t7yLmt/Ze8LPAp8DmwG5oZs+DuQ765Rbc8HlnrGVwU8BXzDOG4FSlX/WsYpSb8WWHwgIlL1rwArzGSIiOcY4EXaxfcq4VLZLwE+Bn4GNgHjlc3r24jPxXEmojnAO5w/GUff2Pd4fO8jIvydxHdMCIkoIp+GAsuA74A3gAuFuxBnLhFJEowzMJb2agbWClwLnOuoKwW2AG8B04QE4Etgia29JQ5nf3XuWMM2Yq8HfgEmBmz7fZ24cmzyjG89J3IqcDGwC7hFnWfEto4TupjbsQMSEYXZweQyk8EXT46J9xgwmmP/CHic9uOAvcAsYCTQwvfnQr4t5z4Xx5mIJI5zCPFzv+rvG4PP9z8iAk4EfgQuC61EEfkk8/gm8Crn8U6gHWgLceYSUacFHUaSNag+trozWHesqpvHxKgz21vi8PWvBEZwYHpFuZQD9dliRdTA5/F8PkG1b+AXSSbmVE5wpbIv7YKIZHKfIbbwjPQpMMBIhlA8hwN3GfHcpsYnvO7OVib87QOcBZSHfBsx+zjORDRb2eTjsj6SU5/vTETTKIJrYrZzEfk0mXa9Yq+miJyc+UR0PYPVqDKSbIxFRLpugfgyfA9juylme0scvv7yhT1PlmRHX58tVkRj1DL+O4WRYZWaHPmivW2844ouiEi2CE8QS+i3wpIM3njYvjcwHbgdeIkJsJW2CuBdJunL9FcVM9Y8OM5ENNrYQrZGcurznYloN8cwIlJEoXySHHjfsM+niJycdfVMlCVZXaDuRmC70XcI200y21ve4+s/SrY/wA5HX58tI/ZIVbfQIqI6RaTsoa+2oJrkf1AAETVFJkMonsOAbdwePQI0chXYqvwdmu33gT+44g0K+c6D4/0uFrhla43k1Oc7E9F9wPPA666fXgzeQvm0CNhg2GXla/NxVmwRzWCdXpIv4PI5OEJEvv7ypT0N+E0Gp+yXcy/rs2UTPErZWjwiOpPPRxnnlSbGMdkS5/IiiigUzxxecFQo+wNy+Oa/JWFmGXO3hwni9W3EFMOxS0ShMfh86zOR9PkVuCiCt1A+1ZO3cmW/myuRkzOfiJrltsOCujxEJEvgVzzgVvMQKHv9F2ztLXE4+6sti9ywPMxzg8S2Ezg7YCvl7Usz203k4XSzQ0Tl7LuM4u/HG7gVKk45uD/EVWAq/W00tj7TCySiUDync6tUy+cJPGts5/NIJs4pfB7L55NDvo2YfByHRBQag8+3eTt3A5N/YIC3UD6VcXVZSU6uIm9tPs7yvVgQPBgrInWA3MFJbWeAfWJE5Ouv7OM4yHZeRzdnS3vA1sgv2F76d27nFGnbSNwe3hwdoezH8zavnQJtMUQkCbK8ECIKxcObrWeZAF8wUeYytkq2uYkJ8xO/+DfHjtWIy8pxSESRnLp8myLqzXZPRvAWyqejgdcYzwbgXjkLhTjrrt+eqp03GQXoT3suHxuvgmvyjGOA3mI43tWrG3l1xsOPVf+IHyNLuzLWWP4LxGmu2PnIM+EUo05uNdfGcpZKKv/3/2VSy53JAm4f67kiNSZ2UkklXkhynnya27Z1zouDVFJJpXjlbzO6K2e1+QmBAAAAAElFTkSuQmCC";
    private static final String APP_NAME = "Barcodes for Confluence";
    protected static final int DEFAULT_HEIGHT = 100;
    private static final Logger log = LoggerFactory.getLogger(AbstractBarcodeBase.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    protected AbstractBarcodeBase(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkValidity() {
        if (!this.pluginLicenseManager.getLicense().isDefined()) return "<div class=\"aui-message aui-message-error\">Barcodes for Confluence is not licensed</div>";
        PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
        if (!license.getError().isDefined()) return null;
        LicenseError error = (LicenseError)license.getError().get();
        switch (error) {
            case EDITION_MISMATCH: 
            case ROLE_EXCEEDED: 
            case ROLE_UNDEFINED: {
                return "<div class=\"aui-message aui-message-error\">License error</div>";
            }
            case EXPIRED: 
            case TYPE_MISMATCH: {
                return "<div class=\"aui-message aui-message-error\">Invalid license: Your evaluation license of Barcodes for Confluence expired. Please use the 'Buy' button to purchase a new license.</div>";
            }
            case USER_MISMATCH: {
                return "<div class=\"aui-message aui-message-error\">Invalid license: Barcodes for Confluence is not licensed for the correct amount of users</div>";
            }
            case VERSION_MISMATCH: {
                return "<div class=\"aui-message aui-message-error\">Invalid license: Your license of Barcodes for Confluence is not valid for the current version</div>";
            }
        }
        return "<div class=\"aui-message aui-message-error\">Unknown error</div>";
    }

    protected String getBase64FromByteArrayOutputStream(BufferedImage image) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(baos.toByteArray());
        }
        catch (IOException ioe) {
            log.debug("Error occured", (Throwable)ioe);
            return ERROR_IMG;
        }
    }

    protected String getRenderedImage(Symbol symbol, String enteredHeight) {
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(enteredHeight);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)enteredHeight);
        }
        double factor = (double)preferredHeight / (double)height;
        String resultCheck = this.checkValidity();
        if (resultCheck == null) {
            BufferedImage image = new BufferedImage((int)((double)width * factor), (int)((double)height * factor), 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            String base64result = this.getBase64FromByteArrayOutputStream(image);
            log.debug("Base64 result of code {} is {}", (Object)symbol.getContent(), (Object)base64result);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return resultCheck;
    }

    public String getRenderedImage(String code, int preferredHeight, BufferedImage image) {
        String resultCheck = this.checkValidity();
        if (resultCheck == null) {
            String base64result = this.getBase64FromByteArrayOutputStream(image);
            log.debug("Base64 result of code {} is {}", (Object)code, (Object)base64result);
            return "<div><img height=\"" + preferredHeight + "\"src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return resultCheck;
    }

    protected void checkAndSetHumanReadableLocation(Symbol symbol, String showText) {
        if ("Bottom".equals(showText)) {
            symbol.setHumanReadableLocation(HumanReadableLocation.BOTTOM);
            log.debug("Setting TextLocation to Bottom");
        } else if ("Top".equals(showText)) {
            symbol.setHumanReadableLocation(HumanReadableLocation.TOP);
            log.debug("Setting TextLocation to Top");
        } else {
            symbol.setHumanReadableLocation(HumanReadableLocation.NONE);
            log.debug("Setting TextLocation to None");
        }
    }

    private String getInvalidBarcodeImage(String errorMessage) {
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        Font font = new Font("Arial", 0, 12);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(errorMessage);
        int height = fm.getHeight();
        g2d.dispose();
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(Color.BLACK);
        g2d.drawString(errorMessage, 0, fm.getAscent());
        g2d.dispose();
        return this.getBase64FromByteArrayOutputStream(img);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    protected String displayErrorMessage(String msg) {
        log.error("Error occured: {}", (Object)msg);
        return "<div class=\"aui-message error shadowed\">" + msg + "</div>";
    }
}

