/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.osgi.Version;
import com.atlassian.upm.osgi.impl.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(VersionChecker.class);

    private VersionChecker() {
    }

    static boolean isUpm201OrLaterInstalled(PluginAccessor pluginAccessor) {
        Plugin plugin = pluginAccessor.getPlugin("com.atlassian.upm.atlassian-universal-plugin-manager-plugin");
        if (plugin == null) {
            return false;
        }
        try {
            Version upmVersion = Versions.fromPlugin(plugin, false);
            Version requiredVersion = Versions.fromString("2.0.1", false);
            return requiredVersion.compareTo(upmVersion) <= 0;
        }
        catch (Exception e) {
            log.debug("Error while detecting UPM version", (Throwable)e);
            return false;
        }
    }

    static PluginState getPluginLicenseStoragePluginState(PluginAccessor pluginAccessor, String incomingVersion) {
        Plugin plugin = pluginAccessor.getPlugin("com.atlassian.upm.plugin-license-storage-plugin");
        if (plugin == null) {
            return PluginState.NOT_INSTALLED;
        }
        try {
            Version installedPluginVersion = Versions.fromPlugin(plugin, false);
            Version newPluginVersion = Versions.fromString(incomingVersion, false);
            boolean sufficientVersion = newPluginVersion.compareTo(installedPluginVersion) <= 0;
            boolean enabled = pluginAccessor.isPluginEnabled("com.atlassian.upm.plugin-license-storage-plugin");
            return sufficientVersion ? (enabled ? PluginState.SUFFICIENT_VERSION_AND_ENABLED : PluginState.SUFFICIENT_VERSION_AND_DISABLED) : (enabled ? PluginState.INSUFFICIENT_VERSION_AND_ENABLED : PluginState.INSUFFICIENT_VERSION_AND_DISABLED);
        }
        catch (Exception e) {
            log.warn("Error while detecting Plugin License Storage plugin version", (Throwable)e);
            return PluginState.NOT_INSTALLED;
        }
    }

    static enum PluginState {
        SUFFICIENT_VERSION_AND_ENABLED(true, true),
        SUFFICIENT_VERSION_AND_DISABLED(true, false),
        INSUFFICIENT_VERSION_AND_ENABLED(false, true),
        INSUFFICIENT_VERSION_AND_DISABLED(false, false),
        NOT_INSTALLED(false, true);

        private final boolean enabled;
        private final boolean sufficientVersionInstalled;

        private PluginState(boolean sufficientVersionInstalled, boolean enabled) {
            this.sufficientVersionInstalled = sufficientVersionInstalled;
            this.enabled = enabled;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        boolean isSufficientVersionInstalled() {
            return this.sufficientVersionInstalled;
        }
    }
}

