/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import uk.org.okapibarcode.backend.EanUpcAddOn;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;

public class Ean
extends Symbol {
    private static final String[] EAN13_PARITY = new String[]{"AAAAAA", "AABABB", "AABBAB", "AABBBA", "ABAABB", "ABBAAB", "ABBBAA", "ABABAB", "ABABBA", "ABBABA"};
    private static final String[] EAN_SET_A = new String[]{"3211", "2221", "2122", "1411", "1132", "1231", "1114", "1312", "1213", "3112"};
    private static final String[] EAN_SET_B = new String[]{"1123", "1222", "2212", "1141", "2311", "1321", "4111", "2131", "3121", "2113"};
    private Mode mode = Mode.EAN13;
    private int guardPatternExtraHeight = 5;
    private boolean linkageFlag;
    private EanUpcAddOn addOn;

    public Ean() {
        this.humanReadableAlignment = HumanReadableAlignment.JUSTIFY;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setGuardPatternExtraHeight(int guardPatternExtraHeight) {
        this.guardPatternExtraHeight = guardPatternExtraHeight;
    }

    public int getGuardPatternExtraHeight() {
        return this.guardPatternExtraHeight;
    }

    protected void setLinkageFlag(boolean linkageFlag) {
        this.linkageFlag = linkageFlag;
    }

    @Override
    protected void encode() {
        this.separateContent();
        if (this.content.isEmpty()) {
            throw new OkapiException("Missing EAN data");
        }
        if (this.mode == Mode.EAN8) {
            this.ean8();
        } else {
            this.ean13();
        }
    }

    private void separateContent() {
        int splitPoint = this.content.indexOf(43);
        if (splitPoint == -1) {
            this.addOn = null;
        } else {
            if (splitPoint == this.content.length() - 1) {
                throw new OkapiException("Invalid add-on data");
            }
            this.addOn = new EanUpcAddOn();
            this.addOn.font = this.font;
            this.addOn.fontName = this.fontName;
            this.addOn.fontSize = this.fontSize;
            this.addOn.humanReadableLocation = this.humanReadableLocation == HumanReadableLocation.NONE ? HumanReadableLocation.NONE : HumanReadableLocation.TOP;
            this.addOn.moduleWidth = this.moduleWidth;
            this.addOn.default_height = this.default_height + this.guardPatternExtraHeight - 8;
            this.addOn.setContent(this.content.substring(splitPoint + 1));
            this.content = this.content.substring(0, splitPoint);
        }
    }

    private void ean13() {
        this.content = Ean.validateAndPad(this.content, 12);
        char check = Ean.calcDigit(this.content);
        this.infoLine("Check Digit: " + check);
        String hrt = this.content + check;
        char parityChar = hrt.charAt(0);
        String parity = EAN13_PARITY[parityChar - 48];
        this.infoLine("Parity Digit: " + parityChar);
        StringBuilder dest = new StringBuilder("111");
        for (int i = 1; i < 13; ++i) {
            if (i == 7) {
                dest.append("11111");
            }
            if (i <= 6) {
                if (parity.charAt(i - 1) == 'B') {
                    dest.append(EAN_SET_B[hrt.charAt(i) - 48]);
                    continue;
                }
                dest.append(EAN_SET_A[hrt.charAt(i) - 48]);
                continue;
            }
            dest.append(EAN_SET_A[hrt.charAt(i) - 48]);
        }
        dest.append("111");
        this.readable = hrt;
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void ean8() {
        this.content = Ean.validateAndPad(this.content, 7);
        char check = Ean.calcDigit(this.content);
        this.infoLine("Check Digit: " + check);
        String hrt = this.content + check;
        StringBuilder dest = new StringBuilder("111");
        for (int i = 0; i < 8; ++i) {
            if (i == 4) {
                dest.append("11111");
            }
            dest.append(EAN_SET_A[hrt.charAt(i) - 48]);
        }
        dest.append("111");
        this.readable = hrt;
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    protected static String validateAndPad(String s2, int targetLength) {
        if (!s2.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        if (s2.length() > targetLength) {
            throw new OkapiException("Input data too long");
        }
        if (s2.length() < targetLength) {
            for (int i = s2.length(); i < targetLength; ++i) {
                s2 = '0' + s2;
            }
        }
        return s2;
    }

    protected static char calcDigit(String s2) {
        int count = 0;
        int p = 0;
        for (int i = s2.length() - 1; i >= 0; --i) {
            int c = Character.getNumericValue(s2.charAt(i));
            if (p % 2 == 0) {
                c *= 3;
            }
            count += c;
            ++p;
        }
        int cdigit = 10 - count % 10;
        if (cdigit == 10) {
            cdigit = 0;
        }
        return (char)(cdigit + 48);
    }

    @Override
    protected void plotSymbol() {
        boolean black = true;
        int compositeOffset = this.linkageFlag ? 6 : 0;
        int hrtOffset = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        this.rectangles.clear();
        this.texts.clear();
        int x = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            int w = this.pattern[0].charAt(xBlock) - 48;
            if (black) {
                int y = 0;
                int h2 = this.default_height;
                if (this.mode == Mode.EAN13) {
                    if (x < 3 || x > 91 || x > 45 && x < 49) {
                        h2 += this.guardPatternExtraHeight;
                    }
                    if (this.linkageFlag && (x == 0 || x == 94)) {
                        h2 += 2;
                        y -= 2;
                    }
                } else {
                    if (x < 3 || x > 62 || x > 30 && x < 35) {
                        h2 += this.guardPatternExtraHeight;
                    }
                    if (this.linkageFlag && (x == 0 || x == 66)) {
                        h2 += 2;
                        y -= 2;
                    }
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(this.scale(x), y + compositeOffset + hrtOffset, this.scale(w), h2);
                this.rectangles.add(rect);
                this.symbol_width = Math.max(this.symbol_width, (int)rect.getMaxX());
                this.symbol_height = Math.max(this.symbol_height, (int)rect.getHeight());
            }
            black = !black;
            x += w;
        }
        if (this.linkageFlag) {
            if (this.mode == Mode.EAN13) {
                this.rectangles.add(new Rectangle2D.Double(this.scale(0), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(94), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(-1), 2.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(95), 2.0, this.scale(1), 2.0));
            } else {
                this.rectangles.add(new Rectangle2D.Double(this.scale(0), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(66), 0.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(-1), 2.0, this.scale(1), 2.0));
                this.rectangles.add(new Rectangle2D.Double(this.scale(67), 2.0, this.scale(1), 2.0));
            }
            this.symbol_height += 4;
        }
        if (this.humanReadableLocation == HumanReadableLocation.BOTTOM) {
            this.symbol_height -= this.guardPatternExtraHeight;
            double baseline = this.symbol_height + this.fontSize;
            if (this.mode == Mode.EAN13) {
                this.texts.add(new TextBox(this.scale(-9), baseline, this.scale(4), this.readable.substring(0, 1), HumanReadableAlignment.RIGHT));
                this.texts.add(new TextBox(this.scale(5), baseline, this.scale(39), this.readable.substring(1, 7), this.humanReadableAlignment));
                this.texts.add(new TextBox(this.scale(51), baseline, this.scale(39), this.readable.substring(7, 13), this.humanReadableAlignment));
            } else {
                this.texts.add(new TextBox(this.scale(5), baseline, this.scale(25), this.readable.substring(0, 4), this.humanReadableAlignment));
                this.texts.add(new TextBox(this.scale(37), baseline, this.scale(25), this.readable.substring(4, 8), this.humanReadableAlignment));
            }
        } else if (this.humanReadableLocation == HumanReadableLocation.TOP) {
            double baseline = this.fontSize;
            int width = this.mode == Mode.EAN13 ? 94 : 66;
            this.texts.add(new TextBox(this.scale(0), baseline, this.scale(width), this.readable, this.humanReadableAlignment));
        }
        if (this.addOn != null) {
            int gap = 9;
            int baseX = this.symbol_width + this.scale(gap);
            Rectangle2D.Double r1 = (Rectangle2D.Double)this.rectangles.get(0);
            Rectangle2D.Double ar1 = (Rectangle2D.Double)this.addOn.rectangles.get(0);
            int baseY = (int)(r1.y + r1.getHeight() - ar1.y - ar1.getHeight());
            for (TextBox t2 : this.addOn.getTexts()) {
                this.texts.add(new TextBox((double)baseX + t2.x, (double)baseY + t2.y, t2.width, t2.text, t2.alignment));
            }
            for (Rectangle2D.Double r : this.addOn.getRectangles()) {
                this.rectangles.add(new Rectangle2D.Double((double)baseX + r.x, (double)baseY + r.y, r.width, r.height));
            }
            this.symbol_width += this.scale(gap) + this.addOn.symbol_width;
            this.pattern[0] = this.pattern[0] + gap + this.addOn.pattern[0];
        }
    }

    private int scale(int w) {
        return this.moduleWidth * w;
    }

    public static enum Mode {
        EAN8,
        EAN13;

    }
}

