/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class CodablockF
extends Symbol {
    private static final String[] C_128_TABLE = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"};
    private int[][] blockmatrix = new int[44][62];
    private int columns_needed;
    private int rows_needed;
    private CfMode final_mode;
    private CfMode[] subset_selector = new CfMode[44];

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    @Override
    protected void encode() {
        int j;
        int i;
        int[] row_indicator = new int[44];
        int[] row_check = new int[44];
        this.final_mode = CfMode.MODEA;
        if (!this.content.matches("[\u0000-\u00ff]+")) {
            throw new OkapiException("Invalid characters in input data");
        }
        this.inputData = CodablockF.toBytes(this.content, StandardCharsets.ISO_8859_1, 0);
        int input_length = this.inputData.length - 1;
        if (input_length > 5450) {
            throw new OkapiException("Input data too long");
        }
        double estimate_codelength = 0.0;
        Mode last_mode = Mode.AORB;
        for (i = 0; i < input_length; ++i) {
            Mode this_mode = this.findSubset(this.inputData[i]);
            if (this_mode != last_mode) {
                estimate_codelength += 1.0;
            }
            estimate_codelength = this_mode != Mode.ABORC ? (estimate_codelength += 1.0) : (estimate_codelength += 0.5);
            if (this.inputData[i] > 127) {
                estimate_codelength += 1.0;
            }
            last_mode = this_mode;
        }
        this.rows_needed = (int)(0.5 + Math.sqrt((estimate_codelength + 2.0) / 1.45));
        if (this.rows_needed < 2) {
            this.rows_needed = 2;
        }
        if (this.rows_needed > 44) {
            this.rows_needed = 44;
        }
        this.columns_needed = (int)(estimate_codelength + 2.0) / this.rows_needed;
        if (this.columns_needed < 4) {
            this.columns_needed = 4;
        }
        if (this.columns_needed > 62) {
            throw new OkapiException("Input data too long");
        }
        this.data_encode_blockf();
        int k1_sum = 0;
        int k2_sum = 0;
        for (i = 0; i < input_length; ++i) {
            if (this.inputData[i] == -1) {
                k1_sum += (i + 1) * 29;
                k2_sum += i * 29;
                continue;
            }
            k1_sum += (i + 1) * this.inputData[i];
            k2_sum += i * this.inputData[i];
        }
        int k1_check = k1_sum % 86;
        int k2_check = k2_sum % 86;
        if (this.final_mode == CfMode.MODEA || this.final_mode == CfMode.MODEB) {
            if ((k1_check += 64) > 95) {
                k1_check -= 96;
            }
            if ((k2_check += 64) > 95) {
                k2_check -= 96;
            }
        }
        this.blockmatrix[this.rows_needed - 1][this.columns_needed - 2] = k1_check;
        this.blockmatrix[this.rows_needed - 1][this.columns_needed - 1] = k2_check;
        int min_module_height = (int)(0.55 * (double)(this.columns_needed + 3)) + 3;
        if (min_module_height < 8) {
            min_module_height = 8;
        }
        if (this.subset_selector[0] == CfMode.MODEC) {
            row_indicator[0] = this.rows_needed - 2;
        } else {
            row_indicator[0] = this.rows_needed + 62;
            if (row_indicator[0] > 95) {
                row_indicator[0] = row_indicator[0] - 95;
            }
        }
        for (i = 1; i < this.rows_needed; ++i) {
            row_indicator[i] = this.subset_selector[i] == CfMode.MODEC ? i + 42 : (i < 6 ? i + 10 : i + 20);
        }
        for (i = 0; i < this.rows_needed; ++i) {
            int k = 103;
            switch (this.subset_selector[i]) {
                case MODEA: {
                    k += 98;
                    break;
                }
                case MODEB: {
                    k += 100;
                    break;
                }
                case MODEC: {
                    k += 99;
                }
            }
            k += 2 * row_indicator[i];
            for (j = 0; j < this.columns_needed; ++j) {
                k += (j + 3) * this.blockmatrix[i][j];
            }
            row_check[i] = k % 103;
        }
        this.readable = "";
        this.row_count = this.rows_needed;
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        this.infoLine("Grid Size: " + this.columns_needed + " X " + this.rows_needed);
        this.infoLine("K1 Check Digit: " + k1_check);
        this.infoLine("K2 Check Digit: " + k2_check);
        this.info("Encoding: ");
        for (i = 0; i < this.rows_needed; ++i) {
            String row_pattern = "";
            row_pattern = row_pattern + C_128_TABLE[103];
            switch (this.subset_selector[i]) {
                case MODEA: {
                    row_pattern = row_pattern + C_128_TABLE[98];
                    this.info("MODEA ");
                    break;
                }
                case MODEB: {
                    row_pattern = row_pattern + C_128_TABLE[100];
                    this.info("MODEB ");
                    break;
                }
                case MODEC: {
                    row_pattern = row_pattern + C_128_TABLE[99];
                    this.info("MODEC ");
                }
            }
            row_pattern = row_pattern + C_128_TABLE[row_indicator[i]];
            this.infoSpace(row_indicator[i]);
            for (j = 0; j < this.columns_needed; ++j) {
                row_pattern = row_pattern + C_128_TABLE[this.blockmatrix[i][j]];
                this.infoSpace(this.blockmatrix[i][j]);
            }
            row_pattern = row_pattern + C_128_TABLE[row_check[i]];
            this.info("(" + row_check[i] + ") ");
            this.pattern[i] = row_pattern = row_pattern + C_128_TABLE[106];
            this.row_height[i] = 15;
        }
        this.infoLine();
        this.symbol_height = this.rows_needed * 15;
    }

    private Mode findSubset(int letter) {
        Mode mode = letter == -1 ? Mode.AORB : (letter <= 31 ? Mode.SHIFTA : (letter >= 48 && letter <= 57 ? Mode.ABORC : (letter <= 95 ? Mode.AORB : (letter <= 127 ? Mode.SHIFTB : (letter <= 159 ? Mode.SHIFTA : (letter <= 223 ? Mode.AORB : Mode.SHIFTB))))));
        return mode;
    }

    private void data_encode_blockf() {
        int input_length = this.inputData.length - 1;
        boolean exit_status = false;
        int current_row = 0;
        CfMode current_mode = CfMode.MODEA;
        int column_position = 0;
        int input_position = 0;
        int c = 0;
        do {
            boolean done = false;
            if (column_position == 0) {
                c = this.columns_needed;
                this.subset_selector[current_row] = current_mode = this.character_subset_select(input_position);
                if (current_row == 0 && this.inputDataType == Symbol.DataType.GS1) {
                    this.blockmatrix[current_row][column_position] = 102;
                    ++column_position;
                    --c;
                }
            }
            if (this.inputData[input_position] == -1) {
                this.blockmatrix[current_row][column_position] = 102;
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!done && c <= 2) {
                switch (current_mode) {
                    case MODEA: {
                        if (this.findSubset(this.inputData[input_position]) == Mode.ABORC) {
                            this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                            ++column_position;
                            --c;
                            ++input_position;
                            done = true;
                        }
                        if (this.findSubset(this.inputData[input_position]) == Mode.SHIFTB && c == 1) {
                            this.blockmatrix[current_row][column_position] = 100;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] >= 244 && !done) {
                            this.blockmatrix[current_row][column_position] = 100;
                            ++column_position;
                            if (--c == 1) {
                                this.blockmatrix[current_row][column_position] = 101;
                                ++column_position;
                                --c;
                            }
                            done = true;
                        }
                        if (this.inputData[input_position] < 128 || done || c != 1) break;
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                        done = true;
                        break;
                    }
                    case MODEB: {
                        if (this.findSubset(this.inputData[input_position]) == Mode.ABORC) {
                            this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                            ++column_position;
                            --c;
                            ++input_position;
                            done = true;
                        }
                        if (this.findSubset(this.inputData[input_position]) == Mode.SHIFTA && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] >= 128 && this.inputData[input_position] <= 159 && !done) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            if (--c == 1) {
                                this.blockmatrix[current_row][column_position] = 100;
                                ++column_position;
                                --c;
                            }
                            done = true;
                        }
                        if (this.inputData[input_position] < 160 || done || c != 1) break;
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                        done = true;
                        break;
                    }
                    case MODEC: {
                        if (this.findSubset(this.inputData[input_position]) != Mode.ABORC && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.findSubset(this.inputData[input_position]) == Mode.ABORC && this.findSubset(this.inputData[input_position + 1]) != Mode.ABORC && c == 1) {
                            this.blockmatrix[current_row][column_position] = 101;
                            ++column_position;
                            --c;
                            done = true;
                        }
                        if (this.inputData[input_position] < 128) break;
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        if (--c != 1) break;
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                }
            }
            if (!(done || this.findSubset(this.inputData[input_position]) != Mode.AORB && this.findSubset(this.inputData[input_position]) != Mode.SHIFTA || current_mode != CfMode.MODEA)) {
                if (this.inputData[input_position] >= 128) {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                }
                this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!(done || this.findSubset(this.inputData[input_position]) != Mode.AORB && this.findSubset(this.inputData[input_position]) != Mode.SHIFTB || current_mode != CfMode.MODEB)) {
                if (this.inputData[input_position] >= 128) {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                }
                this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                ++column_position;
                --c;
                ++input_position;
                done = true;
            }
            if (!done && this.findSubset(this.inputData[input_position]) == Mode.ABORC && this.findSubset(this.inputData[input_position + 1]) == Mode.ABORC && current_mode == CfMode.MODEC) {
                this.blockmatrix[current_row][column_position] = (this.inputData[input_position] - 48) * 10 + (this.inputData[input_position + 1] - 48);
                ++column_position;
                --c;
                input_position += 2;
                done = true;
            }
            if (!(done || current_mode != CfMode.MODEA && current_mode != CfMode.MODEB || this.findSubset(this.inputData[input_position]) != Mode.ABORC && this.inputData[input_position] != -1)) {
                int i = 0;
                int j = 0;
                do {
                    ++i;
                    if (this.inputData[input_position + j] != -1) continue;
                    ++i;
                } while (this.findSubset(this.inputData[input_position + ++j]) == Mode.ABORC || this.inputData[input_position + j] == -1);
                if (--i >= 4) {
                    if (i % 2 == 1) {
                        this.blockmatrix[current_row][column_position] = 99;
                        --c;
                        this.blockmatrix[current_row][++column_position] = (this.inputData[input_position] - 48) * 10 + (this.inputData[input_position + 1] - 48);
                        ++column_position;
                        --c;
                        input_position += 2;
                        current_mode = CfMode.MODEC;
                    } else {
                        this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                        ++column_position;
                        --c;
                        ++input_position;
                    }
                    done = true;
                } else {
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    done = true;
                }
            }
            if (!done && current_mode == CfMode.MODEB && this.findSubset(this.inputData[input_position]) == Mode.SHIFTA) {
                if (this.inputData[input_position + 1] >= 96 && this.inputData[input_position + 1] <= 127) {
                    this.blockmatrix[current_row][column_position] = 98;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                } else {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEA;
                }
                done = true;
            }
            if (!done && current_mode == CfMode.MODEA && this.findSubset(this.inputData[input_position]) == Mode.SHIFTB) {
                if (this.findSubset(this.inputData[input_position + 1]) == Mode.SHIFTA && this.findSubset(this.inputData[input_position + 2]) == Mode.SHIFTB) {
                    this.blockmatrix[current_row][column_position] = 98;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                } else {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEB;
                }
                done = true;
            }
            if (!(done || current_mode != CfMode.MODEC || this.findSubset(this.inputData[input_position]) == Mode.ABORC && this.findSubset(this.inputData[input_position + 1]) == Mode.ABORC)) {
                if (this.findSubset(this.inputData[input_position]) == Mode.SHIFTA) {
                    this.blockmatrix[current_row][column_position] = 101;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 101;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEA;
                } else {
                    this.blockmatrix[current_row][column_position] = 100;
                    ++column_position;
                    --c;
                    if (this.inputData[input_position] >= 128) {
                        this.blockmatrix[current_row][column_position] = 100;
                        ++column_position;
                        --c;
                    }
                    this.blockmatrix[current_row][column_position] = this.a3_convert(this.inputData[input_position]);
                    ++column_position;
                    --c;
                    ++input_position;
                    current_mode = CfMode.MODEB;
                }
                done = true;
            }
            if (input_position == input_length) {
                if (c == 1) {
                    if (current_mode == CfMode.MODEA) {
                        this.blockmatrix[current_row][column_position] = 100;
                        current_mode = CfMode.MODEB;
                    } else {
                        this.blockmatrix[current_row][column_position] = 101;
                        current_mode = CfMode.MODEA;
                    }
                    ++column_position;
                    --c;
                }
                if (c == 0) {
                    column_position = 0;
                    c = this.columns_needed;
                    this.subset_selector[++current_row] = CfMode.MODEA;
                    current_mode = CfMode.MODEA;
                }
                if (c > 2) {
                    do {
                        if (current_mode == CfMode.MODEA) {
                            this.blockmatrix[current_row][column_position] = 100;
                            current_mode = CfMode.MODEB;
                        } else {
                            this.blockmatrix[current_row][column_position] = 101;
                            current_mode = CfMode.MODEA;
                        }
                        ++column_position;
                    } while (--c > 2);
                }
                exit_status = true;
                this.final_mode = current_mode;
                continue;
            }
            if (c > 0) continue;
            column_position = 0;
            if (++current_row <= 43) continue;
            throw new OkapiException("Too many rows.");
        } while (!exit_status);
        if (current_row == 0) {
            for (c = column_position; c <= this.columns_needed; ++c) {
                if (current_mode == CfMode.MODEA) {
                    this.blockmatrix[current_row][c] = 100;
                    current_mode = CfMode.MODEB;
                    continue;
                }
                this.blockmatrix[current_row][c] = 101;
                current_mode = CfMode.MODEA;
            }
            this.subset_selector[++current_row] = CfMode.MODEA;
            current_mode = CfMode.MODEA;
            for (c = 0; c <= this.columns_needed - 2; ++c) {
                if (current_mode == CfMode.MODEA) {
                    this.blockmatrix[current_row][c] = 100;
                    current_mode = CfMode.MODEB;
                    continue;
                }
                this.blockmatrix[current_row][c] = 101;
                current_mode = CfMode.MODEA;
            }
        }
        this.rows_needed = current_row + 1;
    }

    private CfMode character_subset_select(int input_position) {
        if (this.inputData[input_position] >= 48 && this.inputData[input_position] <= 57) {
            return CfMode.MODEC;
        }
        if (this.inputData[input_position] >= 128 && this.inputData[input_position] <= 160) {
            return CfMode.MODEA;
        }
        if (this.inputData[input_position] >= 0 && this.inputData[input_position] <= 31) {
            return CfMode.MODEA;
        }
        return CfMode.MODEB;
    }

    private int a3_convert(int source) {
        if (source < 32) {
            return source + 64;
        }
        if (source >= 32 && source <= 127) {
            return source - 32;
        }
        if (source >= 128 && source <= 159) {
            return source - 128 + 64;
        }
        return source - 128 - 32;
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int y = 1;
        int h2 = 1;
        for (int yBlock = 0; yBlock < this.row_count; ++yBlock) {
            Rectangle2D.Double rect;
            boolean black = true;
            int x = 0;
            for (int xBlock = 0; xBlock < this.pattern[yBlock].length(); ++xBlock) {
                if (black) {
                    black = false;
                    int w = this.pattern[yBlock].charAt(xBlock) - 48;
                    h2 = this.row_height[yBlock] == -1 ? this.default_height : this.row_height[yBlock];
                    if (w != 0 && h2 != 0) {
                        rect = new Rectangle2D.Double(x, y, w, h2);
                        this.rectangles.add(rect);
                    }
                    if (x + w > this.symbol_width) {
                        this.symbol_width = x + w;
                    }
                } else {
                    black = true;
                }
                x += this.pattern[yBlock].charAt(xBlock) - 48;
            }
            if ((y += h2) > this.symbol_height) {
                this.symbol_height = y;
            }
            if (yBlock == this.row_count - 1) continue;
            rect = new Rectangle2D.Double(11.0, y - 1, this.symbol_width - 24, 2.0);
            this.rectangles.add(rect);
        }
        Rectangle2D.Double top = new Rectangle2D.Double(0.0, 0.0, this.symbol_width, 2.0);
        this.rectangles.add(top);
        Rectangle2D.Double bottom = new Rectangle2D.Double(0.0, y - 1, this.symbol_width, 2.0);
        this.rectangles.add(bottom);
        ++this.symbol_height;
    }

    private static enum CfMode {
        MODEA,
        MODEB,
        MODEC;

    }

    private static enum Mode {
        SHIFTA,
        LATCHA,
        SHIFTB,
        LATCHB,
        SHIFTC,
        LATCHC,
        AORB,
        ABORC,
        CANDB,
        CANDBB;

    }
}

