/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;

public class AztecRune
extends Symbol {
    private static final int[] BIT_PLACEMENT_MAP = new int[]{1, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 1, 0, 0, 0, 0, 0, 0, 0, 1, 9, 28, 1, 0, 1, 1, 1, 1, 1, 0, 1, 10, 27, 1, 0, 1, 0, 0, 0, 1, 0, 1, 11, 26, 1, 0, 1, 0, 1, 0, 1, 0, 1, 12, 25, 1, 0, 1, 0, 0, 0, 1, 0, 1, 13, 24, 1, 0, 1, 1, 1, 1, 1, 0, 1, 14, 23, 1, 0, 0, 0, 0, 0, 0, 0, 1, 15, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 22, 21, 20, 19, 18, 17, 16, 0, 0};

    @Override
    protected void encode() {
        int i;
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid input data");
        }
        int decimalValue = 0;
        switch (this.content.length()) {
            case 1: {
                decimalValue = this.content.charAt(0) - 48;
                break;
            }
            case 2: {
                decimalValue = 10 * (this.content.charAt(0) - 48);
                decimalValue += this.content.charAt(1) - 48;
                break;
            }
            case 3: {
                decimalValue = 100 * (this.content.charAt(0) - 48);
                decimalValue += 10 * (this.content.charAt(1) - 48);
                decimalValue += this.content.charAt(2) - 48;
                break;
            }
            default: {
                throw new OkapiException("Input too large");
            }
        }
        if (decimalValue > 255) {
            throw new OkapiException("Input too large");
        }
        StringBuilder binaryDataStream = new StringBuilder(28);
        for (int i2 = 128; i2 > 0; i2 >>= 1) {
            if ((decimalValue & i2) != 0) {
                binaryDataStream.append('1');
                continue;
            }
            binaryDataStream.append('0');
        }
        int[] dataCodeword = new int[3];
        dataCodeword[0] = 0;
        dataCodeword[1] = 0;
        for (int i3 = 0; i3 < 2; ++i3) {
            if (binaryDataStream.charAt(i3 * 4) == '1') {
                int n = i3;
                dataCodeword[n] = dataCodeword[n] + 8;
            }
            if (binaryDataStream.charAt(i3 * 4 + 1) == '1') {
                int n = i3;
                dataCodeword[n] = dataCodeword[n] + 4;
            }
            if (binaryDataStream.charAt(i3 * 4 + 2) == '1') {
                int n = i3;
                dataCodeword[n] = dataCodeword[n] + 2;
            }
            if (binaryDataStream.charAt(i3 * 4 + 3) != '1') continue;
            int n = i3;
            dataCodeword[n] = dataCodeword[n] + 1;
        }
        int[] errorCorrectionCodeword = new int[6];
        ReedSolomon rs = new ReedSolomon();
        rs.init_gf(19);
        rs.init_code(5, 1);
        rs.encode(2, dataCodeword);
        for (i = 0; i < 5; ++i) {
            errorCorrectionCodeword[i] = rs.getResult(i);
        }
        for (i = 0; i < 5; ++i) {
            if ((errorCorrectionCodeword[4 - i] & 8) != 0) {
                binaryDataStream.append('1');
            } else {
                binaryDataStream.append('0');
            }
            if ((errorCorrectionCodeword[4 - i] & 4) != 0) {
                binaryDataStream.append('1');
            } else {
                binaryDataStream.append('0');
            }
            if ((errorCorrectionCodeword[4 - i] & 2) != 0) {
                binaryDataStream.append('1');
            } else {
                binaryDataStream.append('0');
            }
            if ((errorCorrectionCodeword[4 - i] & 1) != 0) {
                binaryDataStream.append('1');
                continue;
            }
            binaryDataStream.append('0');
        }
        StringBuilder reversedBinaryDataStream = new StringBuilder(28);
        for (int i4 = 0; i4 < binaryDataStream.length(); ++i4) {
            if ((i4 & 1) == 0) {
                if (binaryDataStream.charAt(i4) == '0') {
                    reversedBinaryDataStream.append('1');
                    continue;
                }
                reversedBinaryDataStream.append('0');
                continue;
            }
            reversedBinaryDataStream.append(binaryDataStream.charAt(i4));
        }
        this.infoLine("Binary: " + reversedBinaryDataStream);
        this.readable = "";
        this.pattern = new String[11];
        this.row_count = 11;
        this.row_height = new int[11];
        for (int row = 0; row < 11; ++row) {
            StringBuilder rowBinary = new StringBuilder(11);
            for (int column = 0; column < 11; ++column) {
                if (BIT_PLACEMENT_MAP[row * 11 + column] == 1) {
                    rowBinary.append('1');
                }
                if (BIT_PLACEMENT_MAP[row * 11 + column] == 0) {
                    rowBinary.append('0');
                }
                if (BIT_PLACEMENT_MAP[row * 11 + column] < 2) continue;
                rowBinary.append(reversedBinaryDataStream.charAt(BIT_PLACEMENT_MAP[row * 11 + column] - 2));
            }
            this.pattern[row] = AztecRune.bin2pat(rowBinary);
            this.row_height[row] = 1;
        }
    }
}

