/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Retry
extends Task
implements TaskContainer {
    private Task nestedTask;
    private int retryCount = 1;

    public synchronized void addTask(Task t2) {
        if (this.nestedTask != null) {
            throw new BuildException("The retry task container accepts a single nested task (which may be a sequential task container)");
        }
        this.nestedTask = t2;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public void execute() throws BuildException {
        StringBuffer errorMessages = new StringBuffer();
        for (int i = 0; i <= this.retryCount; ++i) {
            try {
                this.nestedTask.perform();
                break;
            }
            catch (Exception e) {
                errorMessages.append(e.getMessage());
                if (i >= this.retryCount) {
                    StringBuffer exceptionMessage = new StringBuffer();
                    exceptionMessage.append("Task [").append(this.nestedTask.getTaskName());
                    exceptionMessage.append("] failed after [").append(this.retryCount);
                    exceptionMessage.append("] attempts; giving up.").append(StringUtils.LINE_SEP);
                    exceptionMessage.append("Error messages:").append(StringUtils.LINE_SEP);
                    exceptionMessage.append(errorMessages);
                    throw new BuildException(exceptionMessage.toString(), this.getLocation());
                }
                this.log("Attempt [" + i + "]: error occurred; retrying...", e, 2);
                errorMessages.append(StringUtils.LINE_SEP);
                continue;
            }
        }
    }
}

