/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;

public class EscapeUnicode
extends BaseParamFilterReader
implements ChainableReader {
    private StringBuffer unicodeBuf = new StringBuffer();

    public EscapeUnicode() {
    }

    public EscapeUnicode(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.unicodeBuf.length() == 0) {
            char achar;
            ch = this.in.read();
            if (ch != -1 && (achar = (char)ch) >= '\u0080') {
                this.unicodeBuf = new StringBuffer("u0000");
                String s2 = Integer.toHexString(ch);
                for (int i = 0; i < s2.length(); ++i) {
                    this.unicodeBuf.setCharAt(this.unicodeBuf.length() - s2.length() + i, s2.charAt(i));
                }
                ch = 92;
            }
        } else {
            ch = this.unicodeBuf.charAt(0);
            this.unicodeBuf.deleteCharAt(0);
        }
        return ch;
    }

    public final Reader chain(Reader rdr) {
        EscapeUnicode newFilter = new EscapeUnicode(rdr);
        newFilter.setInitialized(true);
        return newFilter;
    }

    private void initialize() {
    }
}

