/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;

public final class ExceptionUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String GET_CAUSE_NAME = "getCause";
    private static final Class[] GET_CAUSE_PARAMTYPES = new Class[0];

    private ExceptionUtil() {
    }

    public static String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, 0, printCascading);
    }

    public static String printStackTrace(Throwable throwable, int depth) {
        int dp = depth;
        String[] lines = ExceptionUtil.captureStackTrace(throwable);
        if (0 == dp || dp > lines.length) {
            dp = lines.length;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dp; ++i) {
            sb.append(lines[i]);
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable throwable, int depth, boolean printCascading) {
        return ExceptionUtil.printStackTrace(throwable, depth, printCascading, true);
    }

    public static String printStackTrace(Throwable throwable, int depth, boolean printCascading, boolean useReflection) {
        String result = ExceptionUtil.printStackTrace(throwable, depth);
        if (!printCascading) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(result);
        Throwable cause = ExceptionUtil.getCause(throwable, useReflection);
        while (null != cause) {
            sb.append("rethrown from");
            sb.append(LINE_SEPARATOR);
            sb.append(ExceptionUtil.printStackTrace(cause, depth));
            cause = ExceptionUtil.getCause(cause, useReflection);
        }
        return sb.toString();
    }

    public static Throwable getCause(Throwable throwable, boolean useReflection) {
        if (throwable instanceof CascadingThrowable) {
            CascadingThrowable cascadingThrowable = (CascadingThrowable)throwable;
            return cascadingThrowable.getCause();
        }
        if (useReflection) {
            try {
                Class<?> clazz = throwable.getClass();
                Method method = clazz.getMethod(GET_CAUSE_NAME, GET_CAUSE_PARAMTYPES);
                return (Throwable)method.invoke((Object)throwable, null);
            }
            catch (Throwable t2) {
                return null;
            }
        }
        return null;
    }

    public static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionUtil.splitStringInternal(sw.toString(), LINE_SEPARATOR);
    }

    public static String[] splitString(String string, String onToken) {
        return ExceptionUtil.splitStringInternal(string, onToken);
    }

    private static String[] splitStringInternal(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken();
        }
        return result;
    }
}

