/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Pdf417;

@Scanned
public class PDF417Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(PDF417Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public PDF417Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String height = map.get("height");
        String datacolumns = map.getOrDefault("datacolumns", "1");
        String mode = map.getOrDefault("mode", "Normal");
        String eccLevel = map.getOrDefault("ecclevel", "0");
        if (s2 == null || s2.length() == 0) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Pdf417 code = new Pdf417();
        switch (mode) {
            case "Normal": {
                log.debug("Setting mode to normal");
                code.setMode(Pdf417.Mode.NORMAL);
                break;
            }
            case "Micro": {
                log.debug("Setting mode to micro");
                code.setMode(Pdf417.Mode.MICRO);
                break;
            }
            case "Truncated": {
                log.debug("Setting mode to truncated");
                code.setMode(Pdf417.Mode.TRUNCATED);
                break;
            }
            default: {
                log.debug("Default: Setting mode to normal");
                code.setMode(Pdf417.Mode.NORMAL);
            }
        }
        int eccLevelInt = 0;
        try {
            eccLevelInt = Integer.parseInt(eccLevel);
        }
        catch (NumberFormatException e) {
            eccLevelInt = 0;
        }
        if (eccLevelInt < 0) {
            eccLevelInt = 0;
        }
        if (eccLevelInt > 8) {
            eccLevelInt = 8;
        }
        code.setPreferredEccLevel(eccLevelInt);
        int dataColumnsInt = 1;
        try {
            dataColumnsInt = Integer.parseInt(datacolumns);
        }
        catch (NumberFormatException e) {
            dataColumnsInt = 1;
        }
        if (dataColumnsInt < 1) {
            dataColumnsInt = 1;
        }
        if (dataColumnsInt > 30) {
            dataColumnsInt = 30;
        }
        code.setDataColumns(dataColumnsInt);
        log.debug("Generating barcode for content {}", (Object)s2);
        try {
            code.setContent(s2);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

