/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Map;
import javax.inject.Inject;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.DataMatrix;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

@Scanned
public class DataMatrixMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(DataMatrixMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public DataMatrixMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String forceMode = map.getOrDefault("forcemode", "None");
        String height = map.getOrDefault("height", String.valueOf(100));
        if (s2 == null) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        DataMatrix code = new DataMatrix();
        switch (forceMode) {
            case "Rectangular": {
                log.debug("Setting forceMode to Rectangular");
                code.setForceMode(DataMatrix.ForceMode.RECTANGULAR);
                break;
            }
            case "Square": {
                log.debug("Setting forceMode to Square");
                code.setForceMode(DataMatrix.ForceMode.SQUARE);
                break;
            }
            default: {
                log.debug("Setting forceMode to None");
                code.setForceMode(DataMatrix.ForceMode.NONE);
            }
        }
        try {
            code.setContent(s2);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    protected String getRenderedImage(Symbol symbol, String heightParam) {
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(heightParam);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)heightParam);
        }
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int factor = (int)Math.ceil((double)preferredHeight / (double)height);
        String result = this.checkValidity();
        if (result == null) {
            BufferedImage image = new BufferedImage(width * factor, height * factor, 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            int preferredWidth = preferredHeight;
            image = Scalr.resize(image, Scalr.Method.BALANCED, preferredWidth, preferredHeight, new BufferedImageOp[0]);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return result;
    }
}

