/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.Code2Of5;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class Code2of5Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(Code2of5Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public Code2of5Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s2, ConversionContext conversionContext) throws MacroExecutionException {
        String showText = map.get("showtext");
        String type = map.getOrDefault("type", "Standard (Matrix)");
        String height = map.getOrDefault("height", String.valueOf(100));
        if (s2 == null) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Code2Of5 code = new Code2Of5();
        this.checkAndSetHumanReadableLocation(code, showText);
        switch (type) {
            case "Standard (Matrix)": {
                code.setMode(Code2Of5.ToFMode.MATRIX);
                log.debug("Setting Standard (Matrix)");
                break;
            }
            case "Industrial": {
                code.setMode(Code2Of5.ToFMode.INDUSTRIAL);
                log.debug("Setting Industrial");
                break;
            }
            case "IATA": {
                code.setMode(Code2Of5.ToFMode.IATA);
                log.debug("Setting IATA");
                break;
            }
            case "Data_Logic": {
                code.setMode(Code2Of5.ToFMode.DATA_LOGIC);
                log.debug("Setting Data_Logic");
                break;
            }
            case "Interleaved": {
                code.setMode(Code2Of5.ToFMode.INTERLEAVED);
                log.debug("Setting Interleaved");
                break;
            }
            case "Interleaved with check digit": {
                code.setMode(Code2Of5.ToFMode.INTERLEAVED_WITH_CHECK_DIGIT);
                log.debug("Setting Interleaved with check digit");
                break;
            }
            case "ITF 14": {
                code.setMode(Code2Of5.ToFMode.ITF14);
                log.debug("Setting ITF 14");
                break;
            }
            case "Deutsche Post Leitcode": {
                code.setMode(Code2Of5.ToFMode.DP_LEITCODE);
                log.debug("Deutsche Post Leitcode");
                break;
            }
            case "Deutsche Post Identcode": {
                code.setMode(Code2Of5.ToFMode.DP_IDENTCODE);
                log.debug("Deutsche Post Identcode");
                break;
            }
            default: {
                code.setMode(Code2Of5.ToFMode.MATRIX);
            }
        }
        try {
            code.setContent(s2);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

