/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.Strings;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.storage.lib.AtlassianMarketplaceUriFactory;
import com.atlassian.upm.license.storage.lib.ManagerAccessor;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.atlassian.upm.license.storage.lib.UrlEncoder;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AtlassianMarketplaceUriFactoryImpl
implements AtlassianMarketplaceUriFactory,
ApplicationContextAware {
    private static final String CALLBACK_URL_KEY = "plugin.license.storage.callback.url";
    private final ThirdPartyPluginLicenseStorageManager licenseManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final TransactionTemplate txTemplate;
    private ManagerAccessor managerAccessor;

    public AtlassianMarketplaceUriFactoryImpl(ThirdPartyPluginLicenseStorageManager licenseManager, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, TransactionTemplate txTemplate) {
        this(licenseManager, pluginSettingsFactory, applicationProperties, txTemplate, null);
    }

    AtlassianMarketplaceUriFactoryImpl(ThirdPartyPluginLicenseStorageManager licenseManager, PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, TransactionTemplate txTemplate, ManagerAccessor managerAccessor) {
        this.licenseManager = Preconditions.checkNotNull(licenseManager, "licenseManager");
        this.pluginSettingsFactory = Preconditions.checkNotNull(pluginSettingsFactory, "pluginSettingsFactory");
        this.applicationProperties = Preconditions.checkNotNull(applicationProperties, "applicationProperties");
        this.txTemplate = Preconditions.checkNotNull(txTemplate, "txTemplate");
        this.managerAccessor = managerAccessor;
    }

    @Override
    public URI getBuyPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.getMyAtlassianUri("new").toASCIIString() + this.buildRequestParamString(this.getParentSen(), this.getUsers(), this.getReferrer(), this.getCallback(callback), this.getLicenseFieldName()));
    }

    @Override
    public URI getTryPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.getMyAtlassianUri("try").toASCIIString() + this.buildRequestParamString(this.getParentSen(), this.getOrganizationName(), this.getReferrer(), this.getCallback(callback), this.getLicenseFieldName()));
    }

    @Override
    public URI getRenewPluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.getMyAtlassianUri("renew").toASCIIString() + this.buildRequestParamString(this.getParentSen(), this.getAddonSen(), this.getOwner(), this.getUsers(), this.getReferrer(), this.getCallback(callback), this.getLicenseFieldName()));
    }

    @Override
    public URI getUpgradePluginUri(URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        return URI.create(this.getMyAtlassianUri("upgrade").toASCIIString() + this.buildRequestParamString(this.getParentSen(), this.getAddonSen(), this.getOwner(), this.getUsers(), this.getReferrer(), this.getCallback(callback), this.getLicenseFieldName()));
    }

    @Override
    public boolean isPluginBuyable() throws PluginLicenseStoragePluginUnresolvedException {
        return !this.licenseManager.isUpmLicensingAware() && PluginLicenses.isPluginBuyable(this.licenseManager.getLicense());
    }

    @Override
    public boolean isPluginTryable() throws PluginLicenseStoragePluginUnresolvedException {
        return !this.licenseManager.isUpmLicensingAware() && PluginLicenses.isPluginTryable(this.licenseManager.getLicense());
    }

    @Override
    public boolean isPluginRenewable() throws PluginLicenseStoragePluginUnresolvedException {
        return !this.licenseManager.isUpmLicensingAware() && PluginLicenses.isPluginRenewable(this.licenseManager.getLicense());
    }

    @Override
    public boolean isPluginUpgradable() throws PluginLicenseStoragePluginUnresolvedException {
        return !this.licenseManager.isUpmLicensingAware() && PluginLicenses.isPluginUpgradable(this.licenseManager.getLicense());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.managerAccessor = new ManagerAccessor(applicationContext);
    }

    private String getPluginKey() throws PluginLicenseStoragePluginUnresolvedException {
        return this.licenseManager.getPluginKey();
    }

    private URI getMyAtlassianUri(String type) throws PluginLicenseStoragePluginUnresolvedException {
        if (this.licenseManager.isUpmLicensingAware()) {
            throw new UnsupportedOperationException("Cannot build My Atlassian URI when UPM is licensing-aware: required data is unavailable. Please use UPM's licensingUI instead.");
        }
        String macBaseUrlSysProp = System.getProperty("mac.baseurl");
        String macBaseUrl = macBaseUrlSysProp != null ? macBaseUrlSysProp : "https://my.atlassian.com";
        return URI.create(macBaseUrl + "/addon/" + type + "/" + UrlEncoder.encode(this.getPluginKey()));
    }

    private String buildRequestParamString(Option<Pair<String, String>> ... params) {
        Iterable nonNoneParams = Options.catOptions(ImmutableList.of(params));
        Iterable<String> paramStrings = Iterables.transform(nonNoneParams, new Function<Pair<String, String>, String>(){

            @Override
            public String apply(Pair<String, String> param) {
                return (String)param.first() + "=" + (String)param.second();
            }
        });
        String joined = Joiner.on("&").join(paramStrings);
        if (StringUtils.isNotBlank(joined)) {
            joined = "?" + joined;
        }
        return joined;
    }

    private Option<Pair<String, String>> getParentSen() throws PluginLicenseStoragePluginUnresolvedException {
        Iterator i$ = this.managerAccessor.getStorageManager().getHostLicenseSupportEntitlementNumber().iterator();
        if (i$.hasNext()) {
            String hostSen = (String)i$.next();
            return Option.some((Object)Pair.pair((Object)"parent_sen", (Object)hostSen));
        }
        return Option.none();
    }

    private Option<Pair<String, String>> getAddonSen() throws PluginLicenseStoragePluginUnresolvedException {
        for (PluginLicense license : this.licenseManager.getLicense()) {
            Iterator i$ = license.getSupportEntitlementNumber().iterator();
            if (!i$.hasNext()) continue;
            String licenseSen = (String)i$.next();
            return Option.some((Object)Pair.pair((Object)"addon_sen", (Object)licenseSen));
        }
        return Option.none();
    }

    private Option<Pair<String, String>> getOrganizationName() throws PluginLicenseStoragePluginUnresolvedException {
        Iterator i$ = this.managerAccessor.getStorageManager().getHostLicenseOrganizationName().iterator();
        if (i$.hasNext()) {
            String orgName = (String)i$.next();
            return Option.some((Object)Pair.pair((Object)"organisation_name", (Object)UrlEncoder.encode(orgName)));
        }
        return Option.none();
    }

    private Option<Pair<String, String>> getOwner() throws PluginLicenseStoragePluginUnresolvedException {
        for (PluginLicense license : this.licenseManager.getLicense()) {
            Iterable<String> emails = Iterables.transform(license.getContacts(), new Function<Contact, String>(){

                @Override
                public String apply(Contact contact) {
                    return contact.getEmail();
                }
            });
            Iterator i$ = Strings.getFirstNonEmpty(emails).iterator();
            if (!i$.hasNext()) continue;
            String email = (String)i$.next();
            return Option.some((Object)Pair.pair((Object)"owner", (Object)UrlEncoder.encode(email)));
        }
        return Option.none();
    }

    private Option<Pair<String, String>> getReferrer() {
        return Option.some((Object)Pair.pair((Object)"referrer", (Object)"thirdpartyplugin"));
    }

    private Option<Pair<String, String>> getLicenseFieldName() {
        return Option.some((Object)Pair.pair((Object)"licensefieldname", (Object)"license"));
    }

    private Option<Pair<String, String>> getCallback(final URI callback) throws PluginLicenseStoragePluginUnresolvedException {
        if (!callback.isAbsolute()) {
            throw new IllegalArgumentException("Callback URI must be absolute: " + callback);
        }
        this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                return AtlassianMarketplaceUriFactoryImpl.this.getPluginSettings().put(AtlassianMarketplaceUriFactoryImpl.CALLBACK_URL_KEY, (Object)callback.toASCIIString());
            }
        });
        String licenseReceipt = this.applicationProperties.getBaseUrl() + "/plugins/servlet/pluginlicensereceipt/" + UrlEncoder.encode(this.getPluginKey());
        return Option.some((Object)Pair.pair((Object)"callback", (Object)licenseReceipt));
    }

    private Option<Pair<String, String>> getUsers() throws PluginLicenseStoragePluginUnresolvedException {
        Iterator i$ = this.managerAccessor.getStorageManager().getHostEdition().iterator();
        if (i$.hasNext()) {
            Integer maxEdition = (Integer)i$.next();
            return Option.some((Object)Pair.pair((Object)"users", (Object)maxEdition.toString()));
        }
        return Option.some((Object)Pair.pair((Object)"users", (Object)"-1"));
    }

    private PluginSettings getPluginSettings() {
        return this.pluginSettingsFactory.createGlobalSettings();
    }
}

