/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class UpmScheduler
implements LifecycleAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UpmScheduler.class);
    protected static final Long ONE_DAY = 86400000L;
    private static final String UPM_KEY = "com.atlassian.upm.atlassian-universal-plugin-manager-plugin";
    private final PluginScheduler pluginScheduler;
    private final EventPublisher eventPublisher;

    public UpmScheduler(PluginScheduler pluginScheduler, EventPublisher eventPublisher) {
        this.pluginScheduler = Preconditions.checkNotNull(pluginScheduler, "pluginScheduler");
        this.eventPublisher = Preconditions.checkNotNull(eventPublisher, "eventPublisher");
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (UPM_KEY.equals(event.getPlugin().getKey())) {
            this.getPluginJob().execute(this.getJobData());
        }
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
        this.scheduleJob();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.unschedulePreviouslyScheduledJob();
    }

    public abstract PluginJob getPluginJob();

    public abstract Map<String, Object> getJobData();

    protected String getJobName() {
        return this.getPluginJob().getClass().getSimpleName() + "-job";
    }

    private void scheduleJob() {
        try {
            this.unschedulePreviouslyScheduledJob();
            this.pluginScheduler.scheduleJob(this.getJobName(), this.getPluginJob().getClass(), this.getJobData(), new Date(), ONE_DAY.longValue());
        }
        catch (Exception e) {
            log.error("Error while scheduling job: " + this.getJobName(), (Throwable)e);
        }
    }

    private void unschedulePreviouslyScheduledJob() {
        try {
            this.pluginScheduler.unscheduleJob(this.getJobName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

