/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.util;

import uk.org.okapibarcode.backend.OkapiException;

public final class Gs1 {
    private Gs1() {
    }

    public static String verify(String s, String fnc1) {
        int i;
        char[] source = s.toCharArray();
        StringBuilder reduced = new StringBuilder(source.length);
        int[] ai_value = new int[100];
        int[] ai_location = new int[100];
        int[] data_location = new int[100];
        int[] data_length = new int[100];
        for (int i2 = 0; i2 < source.length; ++i2) {
            if (source[i2] >= '\u0080') {
                throw new OkapiException("Extended ASCII characters are not supported by GS1");
            }
            if (source[i2] >= ' ') continue;
            throw new OkapiException("Control characters are not supported by GS1");
        }
        if (source[0] != '[') {
            throw new OkapiException("Data does not start with an AI");
        }
        int bracket_level = 0;
        int max_bracket_level = 0;
        int ai_length = 0;
        int max_ai_length = 0;
        int min_ai_length = 5;
        int j = 0;
        boolean ai_latch = false;
        for (int i3 = 0; i3 < source.length; ++i3) {
            ai_length += j;
            if (j == 1 && source[i3] != ']' && (source[i3] < '0' || source[i3] > '9')) {
                ai_latch = true;
            }
            if (source[i3] == '[') {
                ++bracket_level;
                j = 1;
            }
            if (source[i3] == ']') {
                --bracket_level;
                if (ai_length < min_ai_length) {
                    min_ai_length = ai_length;
                }
                j = 0;
                ai_length = 0;
            }
            if (bracket_level > max_bracket_level) {
                max_bracket_level = bracket_level;
            }
            if (ai_length <= max_ai_length) continue;
            max_ai_length = ai_length;
        }
        --min_ai_length;
        if (bracket_level != 0) {
            throw new OkapiException("Malformed AI in input data (brackets don't match)");
        }
        if (max_bracket_level > 1) {
            throw new OkapiException("Found nested brackets in input data");
        }
        if (max_ai_length > 4) {
            throw new OkapiException("Invalid AI in input data (AI too long)");
        }
        if (min_ai_length <= 1) {
            throw new OkapiException("Invalid AI in input data (AI too short)");
        }
        if (ai_latch) {
            throw new OkapiException("Invalid AI in input data (non-numeric characters in AI)");
        }
        int ai_count = 0;
        for (i = 1; i < source.length; ++i) {
            if (source[i - 1] != '[') continue;
            ai_location[ai_count] = i;
            ai_value[ai_count] = 0;
            j = 0;
            while (source[i + j] != ']') {
                int n = ai_count;
                ai_value[n] = ai_value[n] * 10;
                int n2 = ai_count;
                ai_value[n2] = ai_value[n2] + Character.getNumericValue(source[i + j]);
                ++j;
            }
            ++ai_count;
        }
        for (i = 0; i < ai_count; ++i) {
            data_location[i] = ai_location[i] + 3;
            if (ai_value[i] >= 100) {
                int n = i;
                data_location[n] = data_location[n] + 1;
            }
            if (ai_value[i] >= 1000) {
                int n = i;
                data_location[n] = data_location[n] + 1;
            }
            data_length[i] = source.length - data_location[i];
            for (j = source.length - 1; j >= data_location[i]; --j) {
                if (source[j] != '[') continue;
                data_length[i] = j - data_location[i];
            }
        }
        for (i = 0; i < ai_count; ++i) {
            if (data_length[i] != 0) continue;
            throw new OkapiException("Empty data field in input data");
        }
        for (i = 0; i < ai_count; ++i) {
            int error_latch = 2;
            switch (ai_value[i]) {
                case 20: {
                    if (data_length[i] != 2) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 422: 
                case 424: 
                case 426: {
                    if (data_length[i] != 3) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 8111: {
                    if (data_length[i] != 4) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 7006: 
                case 8005: {
                    if (data_length[i] != 6) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 7003: {
                    if (data_length[i] != 10) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 410: 
                case 411: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 416: 
                case 7001: {
                    if (data_length[i] != 13) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 8001: {
                    if (data_length[i] != 14) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 402: {
                    if (data_length[i] != 17) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 0: 
                case 8006: 
                case 8017: 
                case 8018: {
                    if (data_length[i] != 18) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 7010: {
                    if (data_length[i] > 2) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 427: 
                case 7008: {
                    if (data_length[i] > 3) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 7004: {
                    if (data_length[i] > 4) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 242: {
                    if (data_length[i] > 6) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 30: 
                case 37: {
                    if (data_length[i] > 8) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 7009: 
                case 8019: {
                    if (data_length[i] > 10) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 7005: 
                case 8011: {
                    if (data_length[i] > 12) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 10: 
                case 21: 
                case 22: 
                case 243: 
                case 254: 
                case 420: 
                case 710: 
                case 711: 
                case 712: 
                case 713: 
                case 714: 
                case 7020: 
                case 7021: 
                case 7022: 
                case 8002: 
                case 8012: {
                    if (data_length[i] > 20) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 8020: {
                    if (data_length[i] > 25) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 90: 
                case 240: 
                case 241: 
                case 250: 
                case 251: 
                case 400: 
                case 401: 
                case 403: 
                case 7002: 
                case 7023: 
                case 8004: 
                case 8010: 
                case 8013: {
                    if (data_length[i] > 30) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 8007: {
                    if (data_length[i] > 34) {
                        error_latch = 1;
                        break;
                    }
                    error_latch = 0;
                    break;
                }
                case 8110: 
                case 8112: 
                case 8200: {
                    error_latch = data_length[i] > 70 ? 1 : 0;
                }
            }
            if (ai_value[i] == 253) {
                error_latch = data_length[i] < 13 || data_length[i] > 30 ? 1 : 0;
            }
            if (ai_value[i] == 255) {
                error_latch = data_length[i] < 13 || data_length[i] > 25 ? 1 : 0;
            }
            if (ai_value[i] >= 3100 && ai_value[i] <= 3169) {
                error_latch = data_length[i] != 6 ? 1 : 0;
            }
            if (ai_value[i] >= 3200 && ai_value[i] <= 3379) {
                error_latch = data_length[i] != 6 ? 1 : 0;
            }
            if (ai_value[i] >= 3400 && ai_value[i] <= 3579) {
                error_latch = data_length[i] != 6 ? 1 : 0;
            }
            if (ai_value[i] >= 3600 && ai_value[i] <= 3699) {
                error_latch = data_length[i] != 6 ? 1 : 0;
            }
            if (ai_value[i] >= 3900 && ai_value[i] <= 3909) {
                error_latch = data_length[i] > 15 ? 1 : 0;
            }
            if (ai_value[i] >= 3910 && ai_value[i] <= 3919) {
                error_latch = data_length[i] < 3 || data_length[i] > 18 ? 1 : 0;
            }
            if (ai_value[i] >= 3920 && ai_value[i] <= 3929) {
                error_latch = data_length[i] > 15 ? 1 : 0;
            }
            if (ai_value[i] >= 3930 && ai_value[i] <= 3939) {
                error_latch = data_length[i] < 3 || data_length[i] > 18 ? 1 : 0;
            }
            if (ai_value[i] >= 3940 && ai_value[i] <= 3949) {
                error_latch = data_length[i] != 4 ? 1 : 0;
            }
            if (ai_value[i] == 421) {
                error_latch = data_length[i] < 3 || data_length[i] > 12 ? 1 : 0;
            }
            if (ai_value[i] == 423 || ai_value[i] == 425) {
                error_latch = data_length[i] < 3 || data_length[i] > 15 ? 1 : 0;
            }
            if (ai_value[i] == 7007) {
                error_latch = data_length[i] < 6 || data_length[i] > 12 ? 1 : 0;
            }
            if (ai_value[i] >= 7030 && ai_value[i] <= 7039) {
                error_latch = data_length[i] < 3 || data_length[i] > 30 ? 1 : 0;
            }
            if (ai_value[i] == 8003) {
                error_latch = data_length[i] < 14 || data_length[i] > 30 ? 1 : 0;
            }
            if (ai_value[i] == 8008) {
                error_latch = data_length[i] < 8 || data_length[i] > 12 ? 1 : 0;
            }
            if (ai_value[i] >= 91 && ai_value[i] <= 99) {
                error_latch = data_length[i] > 90 ? 1 : 0;
            }
            if (error_latch == 1) {
                throw new OkapiException("Invalid data length for AI");
            }
            if (error_latch != 2) continue;
            throw new OkapiException("Invalid AI value");
        }
        int last_ai = 0;
        boolean fixedLengthAI = true;
        for (int i4 = 0; i4 < source.length; ++i4) {
            if (source[i4] != '[' && source[i4] != ']') {
                reduced.append(source[i4]);
            }
            if (source[i4] != '[') continue;
            if (!fixedLengthAI) {
                reduced.append(fnc1);
            }
            fixedLengthAI = (last_ai = 10 * Character.getNumericValue(source[i4 + 1]) + Character.getNumericValue(source[i4 + 2])) >= 0 && last_ai <= 4 || last_ai >= 11 && last_ai <= 20 || last_ai == 23 || last_ai >= 31 && last_ai <= 36 || last_ai == 41;
        }
        return reduced.toString();
    }
}

