/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Pharmacode2Track
extends Symbol {
    @Override
    protected void encode() {
        int i;
        int tester = 0;
        if (this.content.length() > 8) {
            throw new OkapiException("Input too long");
        }
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in data");
        }
        for (i = 0; i < this.content.length(); ++i) {
            tester *= 10;
            tester += Character.getNumericValue(this.content.charAt(i));
        }
        if (tester < 4 || tester > 64570080) {
            throw new OkapiException("Data out of range");
        }
        String inter = "";
        do {
            switch (tester % 3) {
                case 0: {
                    inter = inter + "F";
                    tester = (tester - 3) / 3;
                    break;
                }
                case 1: {
                    inter = inter + "D";
                    tester = (tester - 1) / 3;
                    break;
                }
                case 2: {
                    inter = inter + "A";
                    tester = (tester - 2) / 3;
                }
            }
        } while (tester != 0);
        String dest = "";
        for (i = inter.length() - 1; i >= 0; --i) {
            dest = dest + inter.charAt(i);
        }
        this.infoLine("Encoding: " + dest);
        this.readable = "";
        this.pattern = new String[1];
        this.pattern[0] = dest;
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h = this.default_height / 2;
                    break;
                }
                case 'D': {
                    y = this.default_height / 2;
                    h = this.default_height / 2;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = this.default_height;
                }
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = this.pattern[0].length() * 2;
        this.symbol_height = this.default_height;
    }
}

