/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class MsiPlessey
extends Symbol {
    private static final String[] MSI_PLESS_TABLE = new String[]{"12121212", "12121221", "12122112", "12122121", "12211212", "12211221", "12212112", "12212121", "21121212", "21121221"};
    private CheckDigit checkDigit = CheckDigit.NONE;

    public void setCheckDigit(CheckDigit checkDigit) {
        this.checkDigit = checkDigit;
    }

    public CheckDigit getCheckDigit() {
        return this.checkDigit;
    }

    @Override
    protected void encode() {
        int checkDigit1;
        int addup;
        String addupString;
        int spacer;
        String oddString;
        String evenString;
        int i;
        int length = this.content.length();
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        String intermediate = "21";
        for (i = 0; i < length; ++i) {
            intermediate = intermediate + MSI_PLESS_TABLE[Character.getNumericValue(this.content.charAt(i))];
        }
        this.readable = this.content;
        if (this.checkDigit == CheckDigit.MOD10 || this.checkDigit == CheckDigit.MOD10_MOD10) {
            evenString = "";
            oddString = "";
            spacer = this.content.length() & 1;
            for (i = this.content.length() - 1; i >= 0; --i) {
                if (spacer == 1) {
                    if ((i & 1) != 0) {
                        evenString = this.content.charAt(i) + evenString;
                        continue;
                    }
                    oddString = this.content.charAt(i) + oddString;
                    continue;
                }
                if ((i & 1) != 0) {
                    oddString = this.content.charAt(i) + oddString;
                    continue;
                }
                evenString = this.content.charAt(i) + evenString;
            }
            addupString = oddString.length() == 0 ? "0" : Integer.toString(Integer.parseInt(oddString) * 2);
            addupString = addupString + evenString;
            addup = 0;
            for (i = 0; i < addupString.length(); ++i) {
                addup += addupString.charAt(i) - 48;
            }
            checkDigit1 = 10 - addup % 10;
            if (checkDigit1 == 10) {
                checkDigit1 = 0;
            }
            intermediate = intermediate + MSI_PLESS_TABLE[checkDigit1];
            this.readable = this.readable + checkDigit1;
        }
        if (this.checkDigit == CheckDigit.MOD11 || this.checkDigit == CheckDigit.MOD11_MOD10) {
            int weight = 2;
            addup = 0;
            for (i = this.content.length() - 1; i >= 0; --i) {
                addup += (this.content.charAt(i) - 48) * weight;
                if (++weight != 8) continue;
                weight = 2;
            }
            checkDigit1 = 11 - addup % 11;
            if (checkDigit1 == 11) {
                checkDigit1 = 0;
            }
            this.readable = this.readable + checkDigit1;
            if (checkDigit1 == 10) {
                intermediate = intermediate + MSI_PLESS_TABLE[1];
                intermediate = intermediate + MSI_PLESS_TABLE[0];
            } else {
                intermediate = intermediate + MSI_PLESS_TABLE[checkDigit1];
            }
        }
        if (this.checkDigit == CheckDigit.MOD10_MOD10 || this.checkDigit == CheckDigit.MOD11_MOD10) {
            evenString = "";
            oddString = "";
            spacer = this.readable.length() & 1;
            for (i = this.readable.length() - 1; i >= 0; --i) {
                if (spacer == 1) {
                    if ((i & 1) != 0) {
                        evenString = this.readable.charAt(i) + evenString;
                        continue;
                    }
                    oddString = this.readable.charAt(i) + oddString;
                    continue;
                }
                if ((i & 1) != 0) {
                    oddString = this.readable.charAt(i) + oddString;
                    continue;
                }
                evenString = this.readable.charAt(i) + evenString;
            }
            addupString = oddString.length() == 0 ? "0" : Integer.toString(Integer.parseInt(oddString) * 2);
            addupString = addupString + evenString;
            addup = 0;
            for (i = 0; i < addupString.length(); ++i) {
                addup += addupString.charAt(i) - 48;
            }
            int checkDigit2 = 10 - addup % 10;
            if (checkDigit2 == 10) {
                checkDigit2 = 0;
            }
            intermediate = intermediate + MSI_PLESS_TABLE[checkDigit2];
            this.readable = this.readable + checkDigit2;
        }
        intermediate = intermediate + "121";
        this.pattern = new String[]{intermediate};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    public static enum CheckDigit {
        NONE,
        MOD10,
        MOD10_MOD10,
        MOD11,
        MOD11_MOD10;

    }
}

