/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.util.Locale;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class JapanPost
extends Symbol {
    private static final String[] JAPAN_TABLE = new String[]{"FFT", "FDA", "DFA", "FAD", "FTF", "DAF", "AFD", "ADF", "TFF", "FTT", "TFT", "DAT", "DTA", "ADT", "TDA", "ATD", "TAD", "TTF", "FFF"};
    private static final char[] KASUT_SET = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
    private static final char[] CH_KASUT_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};

    @Override
    protected void encode() {
        int i;
        this.content = this.content.toUpperCase(Locale.ENGLISH);
        if (!this.content.matches("[0-9A-Z\\-]+")) {
            throw new OkapiException("Invalid characters in data");
        }
        String inter = "";
        for (i = 0; i < this.content.length() && inter.length() < 20; ++i) {
            char c = this.content.charAt(i);
            if (c >= '0' && c <= '9') {
                inter = inter + c;
            }
            if (c == '-') {
                inter = inter + c;
            }
            if (c >= 'A' && c <= 'J') {
                inter = inter + 'a';
                inter = inter + CH_KASUT_SET[c - 65];
            }
            if (c >= 'K' && c <= 'O') {
                inter = inter + 'b';
                inter = inter + CH_KASUT_SET[c - 75];
            }
            if (c < 'U' || c > 'Z') continue;
            inter = inter + 'c';
            inter = inter + CH_KASUT_SET[c - 85];
        }
        for (i = inter.length(); i < 20; ++i) {
            inter = inter + "d";
        }
        String dest = "FD";
        int sum = 0;
        for (i = 0; i < 20; ++i) {
            dest = dest + JAPAN_TABLE[Arrays.positionOf(inter.charAt(i), KASUT_SET)];
            sum += Arrays.positionOf(inter.charAt(i), CH_KASUT_SET);
        }
        int check = 19 - sum % 19;
        if (check == 19) {
            check = 0;
        }
        dest = dest + JAPAN_TABLE[Arrays.positionOf(CH_KASUT_SET[check], KASUT_SET)];
        dest = dest + "DF";
        this.infoLine("Encoding: " + dest);
        this.infoLine("Check Digit: " + check);
        this.readable = "";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h = 5;
                    break;
                }
                case 'D': {
                    y = 3;
                    h = 5;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = 8;
                    break;
                }
                case 'T': {
                    y = 3;
                    h = 2;
                }
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = this.pattern[0].length() * 3;
        this.symbol_height = 8;
    }
}

