/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.util.Arrays;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;

public class DataMatrix
extends Symbol {
    private static final int[] C40_SHIFT = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] C40_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 22, 23, 24, 25, 26, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TEXT_SHIFT = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3};
    private static final int[] TEXT_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 22, 23, 24, 25, 26, 0, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 27, 28, 29, 30, 31};
    private static final int[] INT_SYMBOL = new int[]{0, 1, 3, 5, 7, 8, 10, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 2, 4, 6, 9, 11, 14};
    private static final int[] MATRIX_H = new int[]{10, 12, 8, 14, 8, 16, 12, 18, 20, 12, 22, 16, 24, 26, 16, 32, 36, 40, 44, 48, 52, 64, 72, 80, 88, 96, 104, 120, 132, 144};
    private static final int[] MATRIX_W = new int[]{10, 12, 18, 14, 32, 16, 26, 18, 20, 36, 22, 36, 24, 26, 48, 32, 36, 40, 44, 48, 52, 64, 72, 80, 88, 96, 104, 120, 132, 144};
    private static final int[] MATRIX_FH = new int[]{10, 12, 8, 14, 8, 16, 12, 18, 20, 12, 22, 16, 24, 26, 16, 16, 18, 20, 22, 24, 26, 16, 18, 20, 22, 24, 26, 20, 22, 24};
    private static final int[] MATRIX_FW = new int[]{10, 12, 18, 14, 16, 16, 26, 18, 20, 18, 22, 18, 24, 26, 24, 16, 18, 20, 22, 24, 26, 16, 18, 20, 22, 24, 26, 20, 22, 24};
    private static final int[] MATRIX_BYTES = new int[]{3, 5, 5, 8, 10, 12, 16, 18, 22, 22, 30, 32, 36, 44, 49, 62, 86, 114, 144, 174, 204, 280, 368, 456, 576, 696, 816, 1050, 1304, 1558};
    private static final int[] MATRIX_DATA_BLOCK = new int[]{3, 5, 5, 8, 10, 12, 16, 18, 22, 22, 30, 32, 36, 44, 49, 62, 86, 114, 144, 174, 102, 140, 92, 114, 144, 174, 136, 175, 163, 156};
    private static final int[] MATRIX_RS_BLOCK = new int[]{5, 7, 7, 10, 11, 12, 14, 14, 18, 18, 20, 24, 24, 28, 28, 36, 42, 48, 56, 68, 42, 56, 36, 48, 56, 68, 56, 68, 62, 62};
    private static final int DM_SIZES_COUNT = MATRIX_H.length;
    private ForceMode forceMode = ForceMode.NONE;
    private int preferredSize;
    private int structuredAppendFileId = 1;
    private int structuredAppendPosition = 1;
    private int structuredAppendTotal = 1;
    private int actualSize = -1;
    private int[] target = new int[2200];
    private int[] binary = new int[2200];
    private int binary_length;
    private Mode last_mode;
    private int[] places;
    private int process_p;
    private int[] process_buffer = new int[8];
    private int codewordCount;

    public void setForceMode(ForceMode forceMode) {
        this.forceMode = forceMode;
    }

    public ForceMode getForceMode() {
        return this.forceMode;
    }

    public void setPreferredSize(int size) {
        this.preferredSize = size;
    }

    public int getPreferredSize() {
        return this.preferredSize;
    }

    public int getActualSize() {
        if (this.actualSize != -1) {
            return this.actualSize;
        }
        throw new IllegalStateException("Actual size not calculated until symbol is encoded.");
    }

    public int getActualWidth() {
        int index1 = this.getActualSize() - 1;
        int index2 = INT_SYMBOL[index1];
        return MATRIX_W[index2];
    }

    public int getActualHeight() {
        int index1 = this.getActualSize() - 1;
        int index2 = INT_SYMBOL[index1];
        return MATRIX_H[index2];
    }

    public void setStructuredAppendPosition(int position) {
        if (position < 1 || position > 16) {
            throw new IllegalArgumentException("Invalid Data Matrix structured append position: " + position);
        }
        this.structuredAppendPosition = position;
    }

    public int getStructuredAppendPosition() {
        return this.structuredAppendPosition;
    }

    public void setStructuredAppendTotal(int total) {
        if (total < 1 || total > 16) {
            throw new IllegalArgumentException("Invalid Data Matrix structured append total: " + total);
        }
        this.structuredAppendTotal = total;
    }

    public int getStructuredAppendTotal() {
        return this.structuredAppendTotal;
    }

    public void setStructuredAppendFileId(int fileId) {
        if (fileId < 1 || fileId > 64516) {
            throw new IllegalArgumentException("Invalid Data Matrix structured append file ID: " + fileId);
        }
        this.structuredAppendFileId = fileId;
    }

    public int getStructuredAppendFileId() {
        return this.structuredAppendFileId;
    }

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    @Override
    protected void encode() {
        int x;
        int y;
        int symbolsize;
        int i;
        int skew = 0;
        StringBuilder bin = new StringBuilder();
        this.eciProcess();
        int binlen = this.generateCodewords();
        int optionsize = this.preferredSize >= 1 && this.preferredSize <= DM_SIZES_COUNT ? INT_SYMBOL[this.preferredSize - 1] : -1;
        int calcsize = DM_SIZES_COUNT - 1;
        for (i = DM_SIZES_COUNT - 1; i > -1; --i) {
            if (MATRIX_BYTES[i] < binlen + this.process_p) continue;
            calcsize = i;
        }
        if (optionsize == -1) {
            if (this.forceMode == ForceMode.SQUARE) {
                while (calcsize < DM_SIZES_COUNT && MATRIX_H[calcsize] != MATRIX_W[calcsize]) {
                    ++calcsize;
                }
            } else if (this.forceMode == ForceMode.RECTANGULAR) {
                while (calcsize < DM_SIZES_COUNT && MATRIX_H[calcsize] == MATRIX_W[calcsize]) {
                    ++calcsize;
                }
            }
            if (calcsize >= DM_SIZES_COUNT) {
                throw new OkapiException("Data too long to fit in symbol");
            }
            symbolsize = calcsize;
        } else {
            if (calcsize > optionsize) {
                throw new OkapiException("Input too long for selected symbol size");
            }
            symbolsize = optionsize;
        }
        int symbolsLeft = MATRIX_BYTES[symbolsize] - binlen;
        binlen = this.encodeRemainder(symbolsLeft, binlen);
        if (binlen > MATRIX_BYTES[symbolsize]) {
            throw new OkapiException("Data too long to fit in symbol");
        }
        int H = MATRIX_H[symbolsize];
        int W = MATRIX_W[symbolsize];
        int FH = MATRIX_FH[symbolsize];
        int FW = MATRIX_FW[symbolsize];
        int bytes = MATRIX_BYTES[symbolsize];
        int datablock = MATRIX_DATA_BLOCK[symbolsize];
        int rsblock = MATRIX_RS_BLOCK[symbolsize];
        this.codewordCount = datablock + rsblock;
        int taillength = bytes - binlen;
        if (taillength != 0) {
            this.addPadBits(binlen, taillength);
        }
        if (symbolsize == 29) {
            skew = 1;
        }
        this.calculateErrorCorrection(bytes, datablock, rsblock, skew);
        int NC = W - 2 * (W / FW);
        int NR = H - 2 * (H / FH);
        this.places = new int[NC * NR];
        this.placeData(NR, NC);
        int[] grid = new int[W * H];
        for (i = 0; i < W * H; ++i) {
            grid[i] = 0;
        }
        for (y = 0; y < H; y += FH) {
            for (x = 0; x < W; ++x) {
                grid[y * W + x] = 1;
            }
            for (x = 0; x < W; x += 2) {
                grid[(y + FH - 1) * W + x] = 1;
            }
        }
        for (x = 0; x < W; x += FW) {
            for (y = 0; y < H; ++y) {
                grid[y * W + x] = 1;
            }
            for (y = 0; y < H; y += 2) {
                grid[y * W + x + FW - 1] = 1;
            }
        }
        for (y = 0; y < NR; ++y) {
            for (x = 0; x < NC; ++x) {
                int v = this.places[(NR - y - 1) * NC + x];
                if (v != 1 && (v <= 7 || (this.target[(v >> 3) - 1] & 1 << (v & 7)) == 0)) continue;
                grid[(1 + y + 2 * (y / (FH - 2))) * W + 1 + x + 2 * (x / (FW - 2))] = 1;
            }
        }
        this.actualSize = uk.org.okapibarcode.util.Arrays.positionOf(symbolsize, INT_SYMBOL) + 1;
        this.readable = "";
        this.pattern = new String[H];
        this.row_count = H;
        this.row_height = new int[H];
        for (y = H - 1; y >= 0; --y) {
            bin.setLength(0);
            for (x = 0; x < W; ++x) {
                if (grid[W * y + x] == 1) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.pattern[H - y - 1] = DataMatrix.bin2pat(bin);
            this.row_height[H - y - 1] = this.moduleWidth;
        }
        this.infoLine("Grid Size: " + W + " X " + H);
        this.infoLine("Data Codewords: " + datablock);
        this.infoLine("ECC Codewords: " + rsblock);
    }

    @Override
    protected int[] getCodewords() {
        return Arrays.copyOf(this.target, this.codewordCount);
    }

    private int generateCodewords() {
        int i;
        this.info("Encoding: ");
        int inputlen = this.inputData.length;
        int sp = 0;
        int tp = 0;
        this.process_p = 0;
        for (i = 0; i < 8; ++i) {
            this.process_buffer[i] = 0;
        }
        this.binary_length = 0;
        Mode current_mode = Mode.DM_ASCII;
        Mode next_mode = Mode.DM_ASCII;
        if (this.structuredAppendTotal != 1) {
            int id2;
            int id1;
            int ssi;
            this.target[tp] = 233;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.info("FNC2 ");
            this.target[++tp] = ssi = this.structuredAppendPosition - 1 << 4 | 17 - this.structuredAppendTotal;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.infoSpace(ssi);
            this.target[++tp] = id1 = 1 + (this.structuredAppendFileId - 1) / 254;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.infoSpace(id1);
            this.target[++tp] = id2 = 1 + (this.structuredAppendFileId - 1) % 254;
            ++tp;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.infoSpace(id2);
        }
        if (this.inputDataType == Symbol.DataType.GS1) {
            this.target[tp] = 232;
            ++tp;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.info("FNC1 ");
        }
        if (this.readerInit) {
            if (this.inputDataType == Symbol.DataType.GS1) {
                throw new OkapiException("Cannot encode in GS1 mode and Reader Initialisation at the same time");
            }
            this.target[tp] = 234;
            ++tp;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            this.info("RP ");
        }
        if (this.eciMode != 3) {
            this.target[tp] = 241;
            ++tp;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            if (this.eciMode <= 126) {
                this.target[tp] = this.eciMode + 1;
                ++tp;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
            }
            if (this.eciMode >= 127 && this.eciMode <= 16382) {
                this.target[tp] = (this.eciMode - 127) / 254 + 128;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
                this.target[++tp] = (this.eciMode - 127) % 254 + 1;
                ++tp;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
            }
            if (this.eciMode >= 16383) {
                this.target[tp] = (this.eciMode - 16383) / 64516 + 192;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
                this.target[++tp] = (this.eciMode - 16383) / 254 % 254 + 1;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
                this.target[++tp] = (this.eciMode - 16383) % 254 + 1;
                ++tp;
                this.binary[this.binary_length] = 32;
                ++this.binary_length;
            }
            this.info("ECI " + this.eciMode + " ");
        }
        if (tp == 0 & sp == 0 && inputlen >= 9 && this.inputData[0] == 91 && this.inputData[1] == 41 && this.inputData[2] == 62 && this.inputData[3] == 30 && this.inputData[4] == 48 && (this.inputData[5] == 53 || this.inputData[5] == 54) && this.inputData[6] == 29 && this.inputData[inputlen - 2] == 30 && this.inputData[inputlen - 1] == 4) {
            if (this.inputData[5] == 53) {
                this.target[tp] = 236;
                this.info("Macro05 ");
            } else {
                this.target[tp] = 237;
                this.info("Macro06 ");
            }
            ++tp;
            this.binary[this.binary_length] = 32;
            ++this.binary_length;
            sp = 7;
            inputlen -= 2;
            this.inputData = Arrays.copyOf(this.inputData, this.inputData.length - 2);
        }
        while (sp < inputlen) {
            int value;
            int iv;
            int value2;
            int shift_set;
            current_mode = next_mode;
            if (current_mode == Mode.DM_ASCII) {
                next_mode = Mode.DM_ASCII;
                for (i = 0; i < 8; ++i) {
                    this.process_buffer[i] = 0;
                }
                if (this.isTwoDigits(sp)) {
                    this.target[tp] = 10 * Character.getNumericValue(this.inputData[sp]) + Character.getNumericValue(this.inputData[sp + 1]) + 130;
                    this.infoSpace(this.target[tp] - 130);
                    ++tp;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    sp += 2;
                } else {
                    next_mode = this.lookAheadTest(sp, current_mode);
                    if (next_mode != Mode.DM_ASCII) {
                        switch (next_mode) {
                            case DM_C40: {
                                this.target[tp] = 230;
                                ++tp;
                                this.binary[this.binary_length] = 32;
                                ++this.binary_length;
                                this.info("C40 ");
                                break;
                            }
                            case DM_TEXT: {
                                this.target[tp] = 239;
                                ++tp;
                                this.binary[this.binary_length] = 32;
                                ++this.binary_length;
                                this.info("TEX ");
                                break;
                            }
                            case DM_X12: {
                                this.target[tp] = 238;
                                ++tp;
                                this.binary[this.binary_length] = 32;
                                ++this.binary_length;
                                this.info("X12 ");
                                break;
                            }
                            case DM_EDIFACT: {
                                this.target[tp] = 240;
                                ++tp;
                                this.binary[this.binary_length] = 32;
                                ++this.binary_length;
                                this.info("EDI ");
                                break;
                            }
                            case DM_BASE256: {
                                this.target[tp] = 231;
                                ++tp;
                                this.binary[this.binary_length] = 32;
                                ++this.binary_length;
                                this.info("BAS ");
                            }
                        }
                    } else {
                        if (this.inputData[sp] > 127) {
                            this.target[tp] = 235;
                            this.info("FNC4 ");
                            this.target[++tp] = this.inputData[sp] - 128 + 1;
                            this.infoSpace(this.target[tp] - 1);
                            ++tp;
                            this.binary[this.binary_length] = 32;
                            ++this.binary_length;
                            this.binary[this.binary_length] = 32;
                            ++this.binary_length;
                        } else {
                            if (this.inputData[sp] == -1) {
                                this.target[tp] = 232;
                                this.info("FNC1 ");
                            } else {
                                this.target[tp] = this.inputData[sp] + 1;
                                this.infoSpace(this.target[tp] - 1);
                            }
                            ++tp;
                            this.binary[this.binary_length] = 32;
                            ++this.binary_length;
                        }
                        ++sp;
                    }
                }
            }
            if (current_mode == Mode.DM_C40) {
                next_mode = Mode.DM_C40;
                if (this.process_p == 0) {
                    next_mode = this.lookAheadTest(sp, current_mode);
                }
                if (next_mode != Mode.DM_C40) {
                    this.target[tp] = 254;
                    ++tp;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    next_mode = Mode.DM_ASCII;
                    this.info("ASC ");
                } else {
                    if (this.inputData[sp] == -1) {
                        shift_set = 2;
                        value2 = 27;
                    } else if (this.inputData[sp] > 127) {
                        this.process_buffer[this.process_p] = 1;
                        ++this.process_p;
                        this.process_buffer[this.process_p] = 30;
                        ++this.process_p;
                        shift_set = C40_SHIFT[this.inputData[sp] - 128];
                        value2 = C40_VALUE[this.inputData[sp] - 128];
                    } else {
                        shift_set = C40_SHIFT[this.inputData[sp]];
                        value2 = C40_VALUE[this.inputData[sp]];
                    }
                    if (shift_set != 0) {
                        this.process_buffer[this.process_p] = shift_set - 1;
                        ++this.process_p;
                    }
                    this.process_buffer[this.process_p] = value2;
                    ++this.process_p;
                    while (this.process_p >= 3) {
                        iv = 1600 * this.process_buffer[0] + 40 * this.process_buffer[1] + this.process_buffer[2] + 1;
                        this.target[tp] = iv / 256;
                        this.target[++tp] = iv % 256;
                        ++tp;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.info("(" + this.process_buffer[0] + " " + this.process_buffer[1] + " " + this.process_buffer[2] + ") ");
                        this.process_buffer[0] = this.process_buffer[3];
                        this.process_buffer[1] = this.process_buffer[4];
                        this.process_buffer[2] = this.process_buffer[5];
                        this.process_buffer[3] = 0;
                        this.process_buffer[4] = 0;
                        this.process_buffer[5] = 0;
                        this.process_p -= 3;
                    }
                    ++sp;
                }
            }
            if (current_mode == Mode.DM_TEXT) {
                next_mode = Mode.DM_TEXT;
                if (this.process_p == 0) {
                    next_mode = this.lookAheadTest(sp, current_mode);
                }
                if (next_mode != Mode.DM_TEXT) {
                    this.target[tp] = 254;
                    ++tp;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    next_mode = Mode.DM_ASCII;
                    this.info("ASC ");
                } else {
                    if (this.inputData[sp] == -1) {
                        shift_set = 2;
                        value2 = 27;
                    } else if (this.inputData[sp] > 127) {
                        this.process_buffer[this.process_p] = 1;
                        ++this.process_p;
                        this.process_buffer[this.process_p] = 30;
                        ++this.process_p;
                        shift_set = TEXT_SHIFT[this.inputData[sp] - 128];
                        value2 = TEXT_VALUE[this.inputData[sp] - 128];
                    } else {
                        shift_set = TEXT_SHIFT[this.inputData[sp]];
                        value2 = TEXT_VALUE[this.inputData[sp]];
                    }
                    if (shift_set != 0) {
                        this.process_buffer[this.process_p] = shift_set - 1;
                        ++this.process_p;
                    }
                    this.process_buffer[this.process_p] = value2;
                    ++this.process_p;
                    while (this.process_p >= 3) {
                        iv = 1600 * this.process_buffer[0] + 40 * this.process_buffer[1] + this.process_buffer[2] + 1;
                        this.target[tp] = iv / 256;
                        this.target[++tp] = iv % 256;
                        ++tp;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.info("(" + this.process_buffer[0] + " " + this.process_buffer[1] + " " + this.process_buffer[2] + ") ");
                        this.process_buffer[0] = this.process_buffer[3];
                        this.process_buffer[1] = this.process_buffer[4];
                        this.process_buffer[2] = this.process_buffer[5];
                        this.process_buffer[3] = 0;
                        this.process_buffer[4] = 0;
                        this.process_buffer[5] = 0;
                        this.process_p -= 3;
                    }
                    ++sp;
                }
            }
            if (current_mode == Mode.DM_X12) {
                value = 0;
                next_mode = Mode.DM_X12;
                if (this.process_p == 0) {
                    next_mode = this.lookAheadTest(sp, current_mode);
                }
                if (next_mode != Mode.DM_X12) {
                    this.target[tp] = 254;
                    ++tp;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    next_mode = Mode.DM_ASCII;
                    this.info("ASC ");
                } else {
                    if (this.inputData[sp] == 13) {
                        value = 0;
                    }
                    if (this.inputData[sp] == 42) {
                        value = 1;
                    }
                    if (this.inputData[sp] == 62) {
                        value = 2;
                    }
                    if (this.inputData[sp] == 32) {
                        value = 3;
                    }
                    if (this.inputData[sp] >= 48 && this.inputData[sp] <= 57) {
                        value = this.inputData[sp] - 48 + 4;
                    }
                    if (this.inputData[sp] >= 65 && this.inputData[sp] <= 90) {
                        value = this.inputData[sp] - 65 + 14;
                    }
                    this.process_buffer[this.process_p] = value;
                    ++this.process_p;
                    while (this.process_p >= 3) {
                        int iv2 = 1600 * this.process_buffer[0] + 40 * this.process_buffer[1] + this.process_buffer[2] + 1;
                        this.target[tp] = iv2 / 256;
                        this.target[++tp] = iv2 % 256;
                        ++tp;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.binary[this.binary_length] = 32;
                        ++this.binary_length;
                        this.info("(" + this.process_buffer[0] + " " + this.process_buffer[1] + " " + this.process_buffer[2] + ") ");
                        this.process_buffer[0] = this.process_buffer[3];
                        this.process_buffer[1] = this.process_buffer[4];
                        this.process_buffer[2] = this.process_buffer[5];
                        this.process_buffer[3] = 0;
                        this.process_buffer[4] = 0;
                        this.process_buffer[5] = 0;
                        this.process_p -= 3;
                    }
                    ++sp;
                }
            }
            if (current_mode == Mode.DM_EDIFACT) {
                value = 0;
                next_mode = Mode.DM_EDIFACT;
                if (this.process_p == 3) {
                    next_mode = this.lookAheadTest(sp, current_mode);
                }
                if (next_mode != Mode.DM_EDIFACT) {
                    this.process_buffer[this.process_p] = 31;
                    ++this.process_p;
                    next_mode = Mode.DM_ASCII;
                } else {
                    if (this.inputData[sp] >= 64 && this.inputData[sp] <= 94) {
                        value = this.inputData[sp] - 64;
                    }
                    if (this.inputData[sp] >= 32 && this.inputData[sp] <= 63) {
                        value = this.inputData[sp];
                    }
                    this.process_buffer[this.process_p] = value;
                    ++this.process_p;
                    ++sp;
                }
                while (this.process_p >= 4) {
                    this.target[tp] = (this.process_buffer[0] << 2) + ((this.process_buffer[1] & 0x30) >> 4);
                    this.target[++tp] = ((this.process_buffer[1] & 0xF) << 4) + ((this.process_buffer[2] & 0x3C) >> 2);
                    this.target[++tp] = ((this.process_buffer[2] & 3) << 6) + this.process_buffer[3];
                    ++tp;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    this.binary[this.binary_length] = 32;
                    ++this.binary_length;
                    this.info("(" + this.process_buffer[0] + " " + this.process_buffer[1] + " " + this.process_buffer[2] + ") ");
                    this.process_buffer[0] = this.process_buffer[4];
                    this.process_buffer[1] = this.process_buffer[5];
                    this.process_buffer[2] = this.process_buffer[6];
                    this.process_buffer[3] = this.process_buffer[7];
                    this.process_buffer[4] = 0;
                    this.process_buffer[5] = 0;
                    this.process_buffer[6] = 0;
                    this.process_buffer[7] = 0;
                    this.process_p -= 4;
                }
            }
            if (current_mode == Mode.DM_BASE256) {
                next_mode = this.lookAheadTest(sp, current_mode);
                if (next_mode == Mode.DM_BASE256) {
                    this.target[tp] = this.inputData[sp];
                    this.infoSpace(this.target[tp]);
                    ++tp;
                    ++sp;
                    this.binary[this.binary_length] = 98;
                    ++this.binary_length;
                } else {
                    next_mode = Mode.DM_ASCII;
                    this.info("ASC ");
                }
            }
            if (tp <= 1558) continue;
            throw new OkapiException("Data too long to fit in symbol");
        }
        for (i = 0; i < tp; ++i) {
            if (this.binary[i] != 98 || i != 0 && this.binary[i - 1] == 98) continue;
            int binary_count = 0;
            while (binary_count + i < tp && this.binary[binary_count + i] == 98) {
                ++binary_count;
            }
            if (binary_count <= 249) {
                this.insertAt(i, 'b');
                this.insertValueAt(i, tp, (char)binary_count);
                ++tp;
                continue;
            }
            this.insertAt(i, 'b');
            this.insertAt(i + 1, 'b');
            this.insertValueAt(i, tp, (char)(binary_count / 250 + 249));
            this.insertValueAt(i + 1, ++tp, (char)(binary_count % 250));
            ++tp;
        }
        for (i = 0; i < tp; ++i) {
            if (this.binary[i] != 98) continue;
            int prn = 149 * (i + 1) % 255 + 1;
            int temp = this.target[i] + prn;
            this.target[i] = temp <= 255 ? temp : temp - 256;
        }
        this.infoLine();
        this.info("Codewords: ");
        for (i = 0; i < tp; ++i) {
            this.infoSpace(this.target[i]);
        }
        this.infoLine();
        this.last_mode = current_mode;
        return tp;
    }

    private int encodeRemainder(int symbols_left, int target_length) {
        int inputlen = this.inputData.length;
        switch (this.last_mode) {
            case DM_C40: 
            case DM_TEXT: {
                if (this.process_p == 1) {
                    if (symbols_left > 1) {
                        this.target[target_length] = 254;
                        ++target_length;
                    }
                    this.target[target_length] = this.inputData[inputlen - 1] + 1;
                    ++target_length;
                    break;
                }
                if (this.process_p == 2) {
                    int intValue = 1600 * this.process_buffer[0] + 40 * this.process_buffer[1] + 1;
                    this.target[target_length] = intValue / 256;
                    this.target[++target_length] = intValue % 256;
                    ++target_length;
                    if (symbols_left <= 2) break;
                    this.target[target_length] = 254;
                    ++target_length;
                    break;
                }
                if (symbols_left <= 0) break;
                this.target[target_length] = 254;
                ++target_length;
                break;
            }
            case DM_X12: {
                if (symbols_left == this.process_p && this.process_p == 1) {
                    this.target[target_length] = this.inputData[inputlen - 1] + 1;
                    ++target_length;
                    break;
                }
                this.target[target_length] = 254;
                ++target_length;
                if (this.process_p == 1) {
                    this.target[target_length] = this.inputData[inputlen - 1] + 1;
                    ++target_length;
                }
                if (this.process_p != 2) break;
                this.target[target_length] = this.inputData[inputlen - 2] + 1;
                this.target[++target_length] = this.inputData[inputlen - 1] + 1;
                ++target_length;
                break;
            }
            case DM_EDIFACT: {
                if (symbols_left <= 2) {
                    if (this.process_p == 1) {
                        this.target[target_length] = this.inputData[inputlen - 1] + 1;
                        ++target_length;
                    }
                    if (this.process_p != 2) break;
                    this.target[target_length] = this.inputData[inputlen - 2] + 1;
                    this.target[++target_length] = this.inputData[inputlen - 1] + 1;
                    ++target_length;
                    break;
                }
                if (this.process_p == 0) {
                    this.target[target_length] = 124;
                    ++target_length;
                }
                if (this.process_p == 1) {
                    this.target[target_length] = (this.process_buffer[0] << 2) + 1;
                    this.target[++target_length] = 240;
                    ++target_length;
                }
                if (this.process_p == 2) {
                    this.target[target_length] = (this.process_buffer[0] << 2) + ((this.process_buffer[1] & 0x30) >> 4);
                    this.target[++target_length] = ((this.process_buffer[1] & 0xF) << 4) + 7;
                    this.target[++target_length] = 192;
                    ++target_length;
                }
                if (this.process_p != 3) break;
                this.target[target_length] = (this.process_buffer[0] << 2) + ((this.process_buffer[1] & 0x30) >> 4);
                this.target[++target_length] = ((this.process_buffer[1] & 0xF) << 4) + ((this.process_buffer[2] & 0x3C) >> 2);
                this.target[++target_length] = ((this.process_buffer[2] & 3) << 6) + 31;
                ++target_length;
            }
        }
        return target_length;
    }

    private boolean isTwoDigits(int pos) {
        return pos + 1 < this.inputData.length && Character.isDigit((char)this.inputData[pos]) && Character.isDigit((char)this.inputData[pos + 1]);
    }

    private Mode lookAheadTest(int position, Mode current_mode) {
        double b256_count;
        double edf_count;
        double x12_count;
        double text_count;
        double c40_count;
        double ascii_count;
        int sourcelen = this.inputData.length;
        Mode best_scheme = Mode.NULL;
        double stiction = 0.0416666679084301;
        if (current_mode == Mode.DM_ASCII) {
            ascii_count = 0.0;
            c40_count = 1.0;
            text_count = 1.0;
            x12_count = 1.0;
            edf_count = 1.0;
            b256_count = 1.25;
        } else {
            ascii_count = 1.0;
            c40_count = 2.0;
            text_count = 2.0;
            x12_count = 2.0;
            edf_count = 2.0;
            b256_count = 2.25;
        }
        switch (current_mode) {
            case DM_C40: {
                c40_count = 0.0;
                break;
            }
            case DM_TEXT: {
                text_count = 0.0;
                break;
            }
            case DM_X12: {
                x12_count = 0.0;
                break;
            }
            case DM_EDIFACT: {
                edf_count = 0.0;
                break;
            }
            case DM_BASE256: {
                b256_count = 0.0;
            }
        }
        int sp = position;
        do {
            if (sp == sourcelen) {
                ascii_count = Math.ceil(ascii_count);
                b256_count = Math.ceil(b256_count);
                edf_count = Math.ceil(edf_count);
                text_count = Math.ceil(text_count);
                x12_count = Math.ceil(x12_count);
                double best_count = c40_count = Math.ceil(c40_count);
                best_scheme = Mode.DM_C40;
                if (x12_count < best_count - stiction) {
                    best_count = x12_count;
                    best_scheme = Mode.DM_X12;
                }
                if (text_count < best_count - stiction) {
                    best_count = text_count;
                    best_scheme = Mode.DM_TEXT;
                }
                if (edf_count < best_count - stiction) {
                    best_count = edf_count;
                    best_scheme = Mode.DM_EDIFACT;
                }
                if (b256_count < best_count - stiction) {
                    best_count = b256_count;
                    best_scheme = Mode.DM_BASE256;
                }
                if (ascii_count <= best_count + stiction) {
                    best_scheme = Mode.DM_ASCII;
                }
            } else {
                ascii_count = this.inputData[sp] >= 48 && this.inputData[sp] <= 57 ? (ascii_count += 0.5) : (this.inputData[sp] > 127 ? Math.ceil(ascii_count) + 2.0 : Math.ceil(ascii_count) + 1.0);
                c40_count = this.inputData[sp] == 32 || this.inputData[sp] >= 48 && this.inputData[sp] <= 57 || this.inputData[sp] >= 65 && this.inputData[sp] <= 90 ? (c40_count += 0.6666666666666666) : (this.inputData[sp] > 127 ? (c40_count += 2.6666666666666665) : (c40_count += 1.3333333333333333));
                text_count = this.inputData[sp] == 32 || this.inputData[sp] >= 48 && this.inputData[sp] <= 57 || this.inputData[sp] >= 97 && this.inputData[sp] <= 122 ? (text_count += 0.6666666666666666) : (this.inputData[sp] > 127 ? (text_count += 2.6666666666666665) : (text_count += 1.3333333333333333));
                x12_count = this.isX12(this.inputData[sp]) ? (x12_count += 0.6666666666666666) : (this.inputData[sp] > 127 ? (x12_count += 4.333333333333333) : (x12_count += 3.3333333333333335));
                edf_count = this.inputData[sp] >= 32 && this.inputData[sp] <= 94 ? (edf_count += 0.75) : (this.inputData[sp] > 127 ? (edf_count += 17.0) : (edf_count += 13.0));
                if (this.inputData[sp] == -1) {
                    edf_count += 13.0;
                }
                b256_count = this.inputData[sp] == -1 ? (b256_count += 4.0) : (b256_count += 1.0);
            }
            if (sp > position + 3) {
                if (c40_count + 1.0 < ascii_count - stiction && c40_count + 1.0 < b256_count - stiction && c40_count + 1.0 < edf_count - stiction && c40_count + 1.0 < text_count - stiction) {
                    if (c40_count < x12_count - stiction) {
                        best_scheme = Mode.DM_C40;
                    }
                    if (c40_count >= x12_count - stiction && c40_count <= x12_count + stiction) {
                        best_scheme = this.p_r_6_2_1(sp, sourcelen) ? Mode.DM_X12 : Mode.DM_C40;
                    }
                }
                if (x12_count + 1.0 < ascii_count - stiction && x12_count + 1.0 < b256_count - stiction && x12_count + 1.0 < edf_count - stiction && x12_count + 1.0 < text_count - stiction && x12_count + 1.0 < c40_count - stiction) {
                    best_scheme = Mode.DM_X12;
                }
                if (text_count + 1.0 < ascii_count - stiction && text_count + 1.0 < b256_count - stiction && text_count + 1.0 < edf_count - stiction && text_count + 1.0 < x12_count - stiction && text_count + 1.0 < c40_count - stiction) {
                    best_scheme = Mode.DM_TEXT;
                }
                if (edf_count + 1.0 < ascii_count - stiction && edf_count + 1.0 < b256_count - stiction && edf_count + 1.0 < text_count - stiction && edf_count + 1.0 < x12_count - stiction && edf_count + 1.0 < c40_count - stiction) {
                    best_scheme = Mode.DM_EDIFACT;
                }
                if (b256_count + 1.0 <= ascii_count + stiction || b256_count + 1.0 < edf_count - stiction && b256_count + 1.0 < text_count - stiction && b256_count + 1.0 < x12_count - stiction && b256_count + 1.0 < c40_count - stiction) {
                    best_scheme = Mode.DM_BASE256;
                }
                if (ascii_count + 1.0 <= b256_count + stiction && ascii_count + 1.0 <= edf_count + stiction && ascii_count + 1.0 <= text_count + stiction && ascii_count + 1.0 <= x12_count + stiction && ascii_count + 1.0 <= c40_count + stiction) {
                    best_scheme = Mode.DM_ASCII;
                }
            }
            ++sp;
        } while (best_scheme == Mode.NULL);
        return best_scheme;
    }

    private boolean p_r_6_2_1(int position, int sourcelen) {
        int nonX12Position = 0;
        int specialX12Position = 0;
        boolean retval = false;
        for (int i = position; i < sourcelen; ++i) {
            if (nonX12Position == 0 && !this.isX12(this.inputData[i])) {
                nonX12Position = i;
            }
            if (specialX12Position != 0 || this.inputData[i] != 13 && this.inputData[i] != 42 && this.inputData[i] != 62) continue;
            specialX12Position = i;
        }
        if (nonX12Position != 0 && specialX12Position != 0 && specialX12Position < nonX12Position) {
            retval = true;
        }
        return retval;
    }

    private boolean isX12(int source) {
        if (source == 13) {
            return true;
        }
        if (source == 42) {
            return true;
        }
        if (source == 62) {
            return true;
        }
        if (source == 32) {
            return true;
        }
        if (source >= 48 && source <= 57) {
            return true;
        }
        return source >= 65 && source <= 90;
    }

    private void calculateErrorCorrection(int bytes, int datablock, int rsblock, int skew) {
        int blocks = (bytes + 2) / datablock;
        ReedSolomon rs = new ReedSolomon();
        rs.init_gf(301);
        rs.init_code(rsblock, 1);
        for (int b = 0; b < blocks; ++b) {
            int n;
            int[] buf = new int[256];
            int[] ecc = new int[256];
            int p = 0;
            for (n = b; n < bytes; n += blocks) {
                buf[p++] = this.target[n];
            }
            rs.encode(p, buf);
            for (n = 0; n < rsblock; ++n) {
                ecc[n] = rs.getResult(n);
            }
            p = rsblock - 1;
            for (n = b; n < rsblock * blocks; n += blocks) {
                if (skew == 1) {
                    if (b < 8) {
                        this.target[bytes + n + 2] = ecc[p--];
                        continue;
                    }
                    this.target[bytes + n - 8] = ecc[p--];
                    continue;
                }
                this.target[bytes + n] = ecc[p--];
            }
        }
    }

    private void insertAt(int pos, char newbit) {
        for (int i = this.binary_length; i > pos; --i) {
            this.binary[i] = this.binary[i - 1];
        }
        this.binary[pos] = newbit;
        ++this.binary_length;
    }

    private void insertValueAt(int posn, int streamlen, char newbit) {
        for (int i = streamlen; i > posn; --i) {
            this.target[i] = this.target[i - 1];
        }
        this.target[posn] = newbit;
    }

    private void addPadBits(int tp, int tail_length) {
        for (int i = tail_length; i > 0; --i) {
            if (i == tail_length) {
                this.target[tp] = 129;
                ++tp;
                continue;
            }
            int prn = 149 * (tp + 1) % 253 + 1;
            int temp = 129 + prn;
            if (temp <= 254) {
                this.target[tp] = temp;
                ++tp;
                continue;
            }
            this.target[tp] = temp - 254;
            ++tp;
        }
    }

    private void placeData(int NR, int NC) {
        int c;
        int r;
        for (r = 0; r < NR; ++r) {
            for (c = 0; c < NC; ++c) {
                this.places[r * NC + c] = 0;
            }
        }
        int p = 1;
        r = 4;
        c = 0;
        do {
            if (r == NR && c == 0) {
                this.placeCornerA(NR, NC, p++);
            }
            if (r == NR - 2 && c == 0 && NC % 4 != 0) {
                this.placeCornerB(NR, NC, p++);
            }
            if (r == NR - 2 && c == 0 && NC % 8 == 4) {
                this.placeCornerC(NR, NC, p++);
            }
            if (r == NR + 4 && c == 2 && NC % 8 == 0) {
                this.placeCornerD(NR, NC, p++);
            }
            do {
                if (r >= NR || c < 0 || this.places[r * NC + c] != 0) continue;
                this.placeBlock(NR, NC, r, c, p++);
            } while ((r -= 2) >= 0 && (c += 2) < NC);
            ++r;
            c += 3;
            do {
                if (r < 0 || c >= NC || this.places[r * NC + c] != 0) continue;
                this.placeBlock(NR, NC, r, c, p++);
            } while ((r += 2) < NR && (c -= 2) >= 0);
        } while ((r += 3) < NR || ++c < NC);
        if (this.places[NR * NC - 1] == 0) {
            this.places[NR * NC - NC - 2] = 1;
            this.places[NR * NC - 1] = 1;
        }
    }

    private void placeCornerA(int NR, int NC, int p) {
        this.placeBit(NR, NC, NR - 1, 0, p, 7);
        this.placeBit(NR, NC, NR - 1, 1, p, 6);
        this.placeBit(NR, NC, NR - 1, 2, p, 5);
        this.placeBit(NR, NC, 0, NC - 2, p, 4);
        this.placeBit(NR, NC, 0, NC - 1, p, 3);
        this.placeBit(NR, NC, 1, NC - 1, p, 2);
        this.placeBit(NR, NC, 2, NC - 1, p, 1);
        this.placeBit(NR, NC, 3, NC - 1, p, 0);
    }

    private void placeCornerB(int NR, int NC, int p) {
        this.placeBit(NR, NC, NR - 3, 0, p, 7);
        this.placeBit(NR, NC, NR - 2, 0, p, 6);
        this.placeBit(NR, NC, NR - 1, 0, p, 5);
        this.placeBit(NR, NC, 0, NC - 4, p, 4);
        this.placeBit(NR, NC, 0, NC - 3, p, 3);
        this.placeBit(NR, NC, 0, NC - 2, p, 2);
        this.placeBit(NR, NC, 0, NC - 1, p, 1);
        this.placeBit(NR, NC, 1, NC - 1, p, 0);
    }

    private void placeCornerC(int NR, int NC, int p) {
        this.placeBit(NR, NC, NR - 3, 0, p, 7);
        this.placeBit(NR, NC, NR - 2, 0, p, 6);
        this.placeBit(NR, NC, NR - 1, 0, p, 5);
        this.placeBit(NR, NC, 0, NC - 2, p, 4);
        this.placeBit(NR, NC, 0, NC - 1, p, 3);
        this.placeBit(NR, NC, 1, NC - 1, p, 2);
        this.placeBit(NR, NC, 2, NC - 1, p, 1);
        this.placeBit(NR, NC, 3, NC - 1, p, 0);
    }

    private void placeCornerD(int NR, int NC, int p) {
        this.placeBit(NR, NC, NR - 1, 0, p, 7);
        this.placeBit(NR, NC, NR - 1, NC - 1, p, 6);
        this.placeBit(NR, NC, 0, NC - 3, p, 5);
        this.placeBit(NR, NC, 0, NC - 2, p, 4);
        this.placeBit(NR, NC, 0, NC - 1, p, 3);
        this.placeBit(NR, NC, 1, NC - 3, p, 2);
        this.placeBit(NR, NC, 1, NC - 2, p, 1);
        this.placeBit(NR, NC, 1, NC - 1, p, 0);
    }

    private void placeBlock(int NR, int NC, int r, int c, int p) {
        this.placeBit(NR, NC, r - 2, c - 2, p, 7);
        this.placeBit(NR, NC, r - 2, c - 1, p, 6);
        this.placeBit(NR, NC, r - 1, c - 2, p, 5);
        this.placeBit(NR, NC, r - 1, c - 1, p, 4);
        this.placeBit(NR, NC, r - 1, c - 0, p, 3);
        this.placeBit(NR, NC, r - 0, c - 2, p, 2);
        this.placeBit(NR, NC, r - 0, c - 1, p, 1);
        this.placeBit(NR, NC, r - 0, c - 0, p, 0);
    }

    private void placeBit(int NR, int NC, int r, int c, int p, int b) {
        if (r < 0) {
            r += NR;
            c += 4 - (NR + 4) % 8;
        }
        if (c < 0) {
            c += NC;
            r += 4 - (NC + 4) % 8;
        }
        this.places[r * NC + c] = (p << 3) + b;
    }

    private static enum Mode {
        NULL,
        DM_ASCII,
        DM_C40,
        DM_TEXT,
        DM_X12,
        DM_EDIFACT,
        DM_BASE256;

    }

    public static enum ForceMode {
        NONE,
        SQUARE,
        RECTANGULAR;

    }
}

