/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class Code16k
extends Symbol {
    private static final String[] C16K_TABLE = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "211133"};
    private static final String[] C16K_START_STOP = new String[]{"3211", "2221", "2122", "1411", "1132", "1231", "1114", "3112"};
    private static final int[] C16K_START_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] C16K_STOP_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 4, 5, 6, 7, 0, 1, 2, 3};
    private Mode[] block_mode = new Mode[170];
    private int[] block_length = new int[170];
    private int block_count;

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    @Override
    protected void encode() {
        int k;
        int j;
        int i;
        if (!this.content.matches("[\u0000-\u00ff]+")) {
            throw new OkapiException("Invalid characters in input data");
        }
        this.inputData = Code16k.toBytes(this.content, StandardCharsets.ISO_8859_1, new int[0]);
        int input_length = this.inputData.length;
        int bar_characters = 0;
        char[] set = new char[160];
        char[] fset = new char[160];
        int[] values = new int[160];
        if (input_length > 157) {
            throw new OkapiException("Input too long");
        }
        for (i = 0; i < input_length; ++i) {
            fset[i] = this.inputData[i] >= 128 ? 102 : 32;
        }
        for (i = 0; i < input_length; ++i) {
            j = 0;
            if (fset[i] != 'f') continue;
            while (fset[i + ++j] == 'f') {
            }
            if (j < 5 && (j < 3 || i + j != input_length - 1)) continue;
            for (k = 0; k <= j; ++k) {
                fset[i + k] = 70;
            }
        }
        if (input_length > 1) {
            for (i = 1; i < input_length; ++i) {
                if (fset[i - 1] != 'F' || fset[i] != ' ') continue;
                j = 0;
                while (fset[i + j] == ' ' && i + j < input_length) {
                    ++j;
                }
                if (j >= 5 && (j >= 3 || i + j != input_length - 1)) continue;
                for (k = 0; k < j; ++k) {
                    fset[i + k] = 110;
                }
            }
        }
        this.block_count = 0;
        int indexchaine = 0;
        Mode mode = this.findSubset(this.inputData[indexchaine]);
        if (this.inputData[indexchaine] == -1) {
            mode = Mode.ABORC;
        }
        for (i = 0; i < 160; ++i) {
            this.block_length[i] = 0;
        }
        do {
            this.block_mode[this.block_count] = mode;
            while (this.block_mode[this.block_count] == mode && indexchaine < input_length) {
                int n = this.block_count;
                this.block_length[n] = this.block_length[n] + 1;
                if (++indexchaine >= input_length) continue;
                mode = this.findSubset(this.inputData[indexchaine]);
                if (this.inputData[indexchaine] != -1) continue;
                mode = Mode.ABORC;
            }
            ++this.block_count;
        } while (indexchaine < input_length);
        this.reduceSubsetChanges(this.block_count);
        int read = 0;
        for (i = 0; i < this.block_count; ++i) {
            for (j = 0; j < this.block_length[i]; ++j) {
                switch (this.block_mode[i]) {
                    case SHIFTA: {
                        set[read] = 97;
                        break;
                    }
                    case LATCHA: {
                        set[read] = 65;
                        break;
                    }
                    case SHIFTB: {
                        set[read] = 98;
                        break;
                    }
                    case LATCHB: {
                        set[read] = 66;
                        break;
                    }
                    case LATCHC: {
                        set[read] = 67;
                    }
                }
                ++read;
            }
        }
        if (set[0] == 'a') {
            i = 0;
            do {
                set[i] = 65;
            } while (set[++i] == 'a');
        }
        if (set[0] == 'b') {
            i = 0;
            do {
                set[i] = 66;
            } while (set[++i] == 'b');
        }
        int c_count = 0;
        for (i = 0; i < read; ++i) {
            if (set[i] == 'C') {
                if (this.inputData[i] == -1) {
                    if ((c_count & 1) != 0) {
                        if (i - c_count != 0) {
                            set[i - c_count] = 66;
                        } else {
                            set[i - 1] = 66;
                        }
                    }
                    c_count = 0;
                    continue;
                }
                ++c_count;
                continue;
            }
            if ((c_count & 1) != 0) {
                if (i - c_count != 0) {
                    set[i - c_count] = 66;
                } else {
                    set[i - 1] = 66;
                }
            }
            c_count = 0;
        }
        if (c_count & true) {
            if (i - c_count != 0) {
                set[i - c_count] = 66;
            } else {
                set[i - 1] = 66;
            }
        }
        for (i = 1; i < read - 1; ++i) {
            if (set[i] != 'C' || set[i - 1] != 'B' || set[i + 1] != 'B') continue;
            set[i] = 66;
        }
        char last_set = ' ';
        double glyph_count = 0.0;
        for (i = 0; i < input_length; ++i) {
            if (set[i] == 'a' || set[i] == 'b') {
                glyph_count += 1.0;
            }
            if (fset[i] == 'f' || fset[i] == 'n') {
                glyph_count += 1.0;
            }
            if ((set[i] == 'A' || set[i] == 'B' || set[i] == 'C') && set[i] != last_set) {
                last_set = set[i];
                glyph_count += 1.0;
            }
            if (i == 0) {
                if (set[i] == 'B' && set[1] == 'C') {
                    glyph_count -= 1.0;
                }
                if (set[i] == 'B' && set[1] == 'B' && set[2] == 'C') {
                    glyph_count -= 1.0;
                }
                if (fset[i] == 'F') {
                    glyph_count += 2.0;
                }
            } else {
                if (fset[i] == 'F' && fset[i - 1] != 'F') {
                    glyph_count += 2.0;
                }
                if (fset[i] != 'F' && fset[i - 1] == 'F') {
                    glyph_count += 2.0;
                }
            }
            if (set[i] == 'C' && this.inputData[i] != -1) {
                glyph_count += 0.5;
                continue;
            }
            glyph_count += 1.0;
        }
        if (this.inputDataType == Symbol.DataType.GS1 && set[0] != 'A') {
            glyph_count -= 1.0;
        }
        if (glyph_count > 77.0) {
            throw new OkapiException("Input too long");
        }
        i = (int)(glyph_count += 2.0);
        int rows_needed = i / 5;
        if (i % 5 > 0) {
            ++rows_needed;
        }
        if (rows_needed == 1) {
            rows_needed = 2;
        }
        int m = 0;
        switch (set[0]) {
            case 'A': {
                m = 0;
                break;
            }
            case 'B': {
                m = 1;
                break;
            }
            case 'C': {
                m = 2;
            }
        }
        if (this.readerInit) {
            if (m == 2) {
                m = 5;
            }
            if (this.inputDataType == Symbol.DataType.GS1) {
                throw new OkapiException("Cannot use both GS1 mode and Reader Initialisation");
            }
            if (set[0] == 'B' && set[1] == 'C') {
                m = 6;
            }
            values[bar_characters] = 7 * (rows_needed - 2) + m;
            values[bar_characters + 1] = 96;
            bar_characters += 2;
        } else if (this.inputDataType == Symbol.DataType.GS1) {
            switch (set[0]) {
                case 'B': {
                    m = 3;
                    break;
                }
                case 'C': {
                    m = 4;
                }
            }
        } else {
            if (set[0] == 'B' && set[1] == 'C') {
                m = 5;
            }
            if (set[0] == 'B' && set[1] == 'B' && set[2] == 'C') {
                m = 6;
            }
        }
        values[bar_characters] = 7 * (rows_needed - 2) + m;
        ++bar_characters;
        int current_set = set[0];
        boolean f_state = false;
        if (fset[0] == 'F') {
            switch (current_set) {
                case 65: {
                    values[bar_characters] = 101;
                    values[bar_characters + 1] = 101;
                    break;
                }
                case 66: {
                    values[bar_characters] = 100;
                    values[bar_characters + 1] = 100;
                }
            }
            bar_characters += 2;
            f_state = true;
        }
        read = 0;
        do {
            if (read != 0 && set[read] != set[read - 1]) {
                switch (set[read]) {
                    case 'A': {
                        values[bar_characters] = 101;
                        ++bar_characters;
                        current_set = 65;
                        break;
                    }
                    case 'B': {
                        values[bar_characters] = 100;
                        ++bar_characters;
                        current_set = 66;
                        break;
                    }
                    case 'C': {
                        if (!(read == 1 && set[0] == 'B' || read == 2 && set[0] == 'B' && set[1] == 'B')) {
                            values[bar_characters] = 99;
                            ++bar_characters;
                        }
                        current_set = 67;
                    }
                }
            }
            if (read != 0) {
                if (fset[read] == 'F' && !f_state) {
                    switch (current_set) {
                        case 65: {
                            values[bar_characters] = 101;
                            values[bar_characters + 1] = 101;
                            break;
                        }
                        case 66: {
                            values[bar_characters] = 100;
                            values[bar_characters + 1] = 100;
                        }
                    }
                    bar_characters += 2;
                    f_state = true;
                }
                if (fset[read] == ' ' && f_state) {
                    switch (current_set) {
                        case 65: {
                            values[bar_characters] = 101;
                            values[bar_characters + 1] = 101;
                            break;
                        }
                        case 66: {
                            values[bar_characters] = 100;
                            values[bar_characters + 1] = 100;
                        }
                    }
                    bar_characters += 2;
                    f_state = false;
                }
            }
            if (fset[i] == 'f' || fset[i] == 'n') {
                switch (current_set) {
                    case 65: {
                        values[bar_characters] = 101;
                        break;
                    }
                    case 66: {
                        values[bar_characters] = 100;
                    }
                }
                ++bar_characters;
            }
            if (set[i] == 'a' || set[i] == 'b') {
                values[bar_characters] = 98;
                ++bar_characters;
            }
            if (this.inputData[read] != -1) {
                switch (set[read]) {
                    case 'A': 
                    case 'a': {
                        this.getValueSubsetA(this.inputData[read], values, bar_characters);
                        ++bar_characters;
                        ++read;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.getValueSubsetB(this.inputData[read], values, bar_characters);
                        ++bar_characters;
                        ++read;
                        break;
                    }
                    case 'C': {
                        this.getValueSubsetC(this.inputData[read], this.inputData[read + 1], values, bar_characters);
                        ++bar_characters;
                        read += 2;
                    }
                }
                continue;
            }
            values[bar_characters] = 102;
            ++bar_characters;
            ++read;
        } while (read < input_length);
        int pads_needed = 5 - (bar_characters + 2) % 5;
        if (pads_needed == 5) {
            pads_needed = 0;
        }
        if (bar_characters + pads_needed < 8) {
            pads_needed += 8 - (bar_characters + pads_needed);
        }
        for (i = 0; i < pads_needed; ++i) {
            values[bar_characters] = 106;
            ++bar_characters;
        }
        int first_sum = 0;
        int second_sum = 0;
        for (i = 0; i < bar_characters; ++i) {
            first_sum += (i + 2) * values[i];
            second_sum += (i + 1) * values[i];
        }
        int first_check = first_sum % 107;
        int second_check = (second_sum += first_check * (bar_characters + 1)) % 107;
        values[bar_characters] = first_check;
        values[bar_characters + 1] = second_check;
        bar_characters += 2;
        this.readable = "";
        this.pattern = new String[rows_needed];
        this.row_count = rows_needed;
        this.row_height = new int[rows_needed];
        this.infoLine("Symbol Rows: " + rows_needed);
        this.infoLine("First Check Digit: " + first_check);
        this.infoLine("Second Check Digit: " + second_check);
        this.info("Codewords: ");
        for (int current_row = 0; current_row < rows_needed; ++current_row) {
            String width_pattern = "";
            width_pattern = width_pattern + C16K_START_STOP[C16K_START_VALUES[current_row]];
            width_pattern = width_pattern + "1";
            for (i = 0; i < 5; ++i) {
                width_pattern = width_pattern + C16K_TABLE[values[current_row * 5 + i]];
                this.infoSpace(values[current_row * 5 + i]);
            }
            this.pattern[current_row] = width_pattern = width_pattern + C16K_START_STOP[C16K_STOP_VALUES[current_row]];
            this.row_height[current_row] = 10;
        }
        this.infoLine();
    }

    private void getValueSubsetA(int source, int[] values, int bar_chars) {
        values[bar_chars] = source > 127 ? (source < 160 ? source + 64 - 128 : source - 32 - 128) : (source < 32 ? source + 64 : source - 32);
    }

    private void getValueSubsetB(int source, int[] values, int bar_chars) {
        values[bar_chars] = source > 127 ? source - 32 - 128 : source - 32;
    }

    private void getValueSubsetC(int source_a, int source_b, int[] values, int bar_chars) {
        int weight;
        values[bar_chars] = weight = 10 * Character.getNumericValue(source_a) + Character.getNumericValue(source_b);
    }

    private Mode findSubset(int letter) {
        Mode mode = letter <= 31 ? Mode.SHIFTA : (letter >= 48 && letter <= 57 ? Mode.ABORC : (letter <= 95 ? Mode.AORB : (letter <= 127 ? Mode.SHIFTB : (letter <= 159 ? Mode.SHIFTA : (letter <= 223 ? Mode.AORB : Mode.SHIFTB)))));
        return mode;
    }

    private void reduceSubsetChanges(int block_count) {
        for (int i = 0; i < block_count; ++i) {
            Mode current = this.block_mode[i];
            int length = this.block_length[i];
            Mode last = i != 0 ? this.block_mode[i - 1] : Mode.NULL;
            Mode next = i != block_count - 1 ? this.block_mode[i + 1] : Mode.NULL;
            if (i == 0) {
                if (block_count == 1 && length == 2 && current == Mode.ABORC) {
                    this.block_mode[i] = Mode.LATCHC;
                }
                if (current == Mode.ABORC) {
                    if (length >= 4) {
                        this.block_mode[i] = Mode.LATCHC;
                    } else {
                        this.block_mode[i] = Mode.AORB;
                        current = Mode.AORB;
                    }
                }
                if (current == Mode.SHIFTA) {
                    this.block_mode[i] = Mode.LATCHA;
                }
                if (current == Mode.AORB && next == Mode.SHIFTA) {
                    this.block_mode[i] = Mode.LATCHA;
                    current = Mode.LATCHA;
                }
                if (current != Mode.AORB) continue;
                this.block_mode[i] = Mode.LATCHB;
                continue;
            }
            if (current == Mode.ABORC && length >= 4) {
                this.block_mode[i] = Mode.LATCHC;
                current = Mode.LATCHC;
            }
            if (current == Mode.ABORC) {
                this.block_mode[i] = Mode.AORB;
                current = Mode.AORB;
            }
            if (current == Mode.AORB && last == Mode.LATCHA) {
                this.block_mode[i] = Mode.LATCHA;
                current = Mode.LATCHA;
            }
            if (current == Mode.AORB && last == Mode.LATCHB) {
                this.block_mode[i] = Mode.LATCHB;
                current = Mode.LATCHB;
            }
            if (current == Mode.AORB && next == Mode.SHIFTA) {
                this.block_mode[i] = Mode.LATCHA;
                current = Mode.LATCHA;
            }
            if (current == Mode.AORB && next == Mode.SHIFTB) {
                this.block_mode[i] = Mode.LATCHB;
                current = Mode.LATCHB;
            }
            if (current == Mode.AORB) {
                this.block_mode[i] = Mode.LATCHB;
                current = Mode.LATCHB;
            }
            if (current == Mode.SHIFTA && length > 1) {
                this.block_mode[i] = Mode.LATCHA;
                current = Mode.LATCHA;
            }
            if (current == Mode.SHIFTB && length > 1) {
                this.block_mode[i] = Mode.LATCHB;
                current = Mode.LATCHB;
            }
            if (current == Mode.SHIFTA && last == Mode.LATCHA) {
                this.block_mode[i] = Mode.LATCHA;
                current = Mode.LATCHA;
            }
            if (current == Mode.SHIFTB && last == Mode.LATCHB) {
                this.block_mode[i] = Mode.LATCHB;
                current = Mode.LATCHB;
            }
            if (current == Mode.SHIFTA && last == Mode.LATCHC) {
                this.block_mode[i] = Mode.LATCHA;
                current = Mode.LATCHA;
            }
            if (current != Mode.SHIFTB || last != Mode.LATCHC) continue;
            this.block_mode[i] = Mode.LATCHB;
            current = Mode.LATCHB;
        }
        this.combineSubsetBlocks(block_count);
    }

    private void combineSubsetBlocks(int block_count) {
        if (block_count > 1) {
            for (int i = 1; i < block_count; ++i) {
                if (this.block_mode[i - 1] != this.block_mode[i]) continue;
                this.block_length[i - 1] = this.block_length[i - 1] + this.block_length[i];
                for (int j = i + 1; j < block_count; ++j) {
                    this.block_length[j - 1] = this.block_length[j];
                    this.block_mode[j - 1] = this.block_mode[j];
                }
                --block_count;
                --i;
            }
        }
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int y = 1;
        int h = 1;
        for (int yBlock = 0; yBlock < this.row_count; ++yBlock) {
            Rectangle2D.Double rect;
            boolean black = true;
            int x = 15;
            for (int xBlock = 0; xBlock < this.pattern[yBlock].length(); ++xBlock) {
                if (black) {
                    black = false;
                    int w = this.pattern[yBlock].charAt(xBlock) - 48;
                    h = this.row_height[yBlock] == -1 ? this.default_height : this.row_height[yBlock];
                    if (w != 0 && h != 0) {
                        rect = new Rectangle2D.Double(x, y, w, h);
                        this.rectangles.add(rect);
                    }
                    if (x + w > this.symbol_width) {
                        this.symbol_width = x + w;
                    }
                } else {
                    black = true;
                }
                x += this.pattern[yBlock].charAt(xBlock) - 48;
            }
            if ((y += h) > this.symbol_height) {
                this.symbol_height = y;
            }
            if (yBlock == this.row_count - 1) continue;
            rect = new Rectangle2D.Double(15.0, y - 1, this.symbol_width - 15, 2.0);
            this.rectangles.add(rect);
        }
        Rectangle2D.Double top = new Rectangle2D.Double(0.0, 0.0, this.symbol_width + 15, 2.0);
        this.rectangles.add(top);
        Rectangle2D.Double bottom = new Rectangle2D.Double(0.0, y - 1, this.symbol_width + 15, 2.0);
        this.rectangles.add(bottom);
        this.symbol_width += 15;
        ++this.symbol_height;
    }

    private static enum Mode {
        NULL,
        SHIFTA,
        LATCHA,
        SHIFTB,
        LATCHB,
        SHIFTC,
        LATCHC,
        AORB,
        ABORC,
        CANDB,
        CANDBB;

    }
}

