/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class AztecCode
extends Symbol {
    private static final int[] COMPACT_AZTEC_MAP;
    private static final int[][] AZTEC_MAP;
    private static final int[] AZTEC_CODE_SET;
    private static final int[] AZTEC_SYMBOL_CHAR;
    private static final String[] PENTBIT;
    private static final String[] QUADBIT;
    private static final String[] TRIBIT;
    private static final int[] AZTEC_SIZES;
    private static final int[] AZTEC_COMPACT_SIZES;
    private static final int[] AZTEC_10_DATA_SIZES;
    private static final int[] AZTEC_23_DATA_SIZES;
    private static final int[] AZTEC_36_DATA_SIZES;
    private static final int[] AZTEC_50_DATA_SIZES;
    private static final int[] AZTEC_COMPACT_10_DATA_SIZES;
    private static final int[] AZTEC_COMPACT_23_DATA_SIZES;
    private static final int[] AZTEC_COMPACT_36_DATA_SIZES;
    private static final int[] AZTEC_COMPACT_50_DATA_SIZES;
    private static final int[] AZTEC_OFFSET;
    private static final int[] AZTEC_COMPACT_OFFSET;
    private int preferredSize = 0;
    private int preferredEccLevel = 2;
    private String structuredAppendMessageId;
    private int structuredAppendPosition = 1;
    private int structuredAppendTotal = 1;

    private static int avoidReferenceGrid(int input) {
        int output = input;
        if (output > 10) {
            ++output;
        }
        if (output > 26) {
            ++output;
        }
        if (output > 42) {
            ++output;
        }
        if (output > 58) {
            ++output;
        }
        if (output > 74) {
            ++output;
        }
        if (output > 90) {
            ++output;
        }
        if (output > 106) {
            ++output;
        }
        if (output > 122) {
            ++output;
        }
        if (output > 138) {
            ++output;
        }
        return output;
    }

    public void setPreferredSize(int size) {
        if (size < 1 || size > 36) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.preferredSize = size;
    }

    public int getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredEccLevel(int eccLevel) {
        if (eccLevel < 1 || eccLevel > 4) {
            throw new IllegalArgumentException("Invalid ECC level: " + eccLevel);
        }
        this.preferredEccLevel = eccLevel;
    }

    public int getPreferredEccLevel() {
        return this.preferredEccLevel;
    }

    public void setStructuredAppendPosition(int position) {
        if (position < 1 || position > 26) {
            throw new IllegalArgumentException("Invalid Aztec Code structured append position: " + position);
        }
        this.structuredAppendPosition = position;
    }

    public int getStructuredAppendPosition() {
        return this.structuredAppendPosition;
    }

    public void setStructuredAppendTotal(int total) {
        if (total < 1 || total > 26) {
            throw new IllegalArgumentException("Invalid Aztec Code structured append total: " + total);
        }
        this.structuredAppendTotal = total;
    }

    public int getStructuredAppendTotal() {
        return this.structuredAppendTotal;
    }

    public void setStructuredAppendMessageId(String messageId) {
        if (messageId != null && !messageId.matches("^[\\x21-\\x7F]+$")) {
            throw new IllegalArgumentException("Invalid Aztec Code structured append message ID: " + messageId);
        }
        this.structuredAppendMessageId = messageId;
    }

    public String getStructuredAppendMessageId() {
        return this.structuredAppendMessageId;
    }

    @Override
    protected boolean gs1Supported() {
        return true;
    }

    @Override
    protected void encode() {
        int y;
        int codewordSize;
        int layers;
        boolean compact;
        StringBuilder adjustedString;
        if (this.inputDataType == Symbol.DataType.GS1 && this.readerInit) {
            throw new OkapiException("Cannot encode in GS1 and Reader Initialisation mode at the same time");
        }
        this.eciProcess();
        if (this.structuredAppendTotal != 1) {
            StringBuilder prefix = new StringBuilder();
            if (this.structuredAppendMessageId != null) {
                prefix.append(' ').append(this.structuredAppendMessageId).append(' ');
            }
            prefix.append((char)(this.structuredAppendPosition + 64));
            prefix.append((char)(this.structuredAppendTotal + 64));
            int[] prefixArray = AztecCode.toBytes(prefix.toString(), StandardCharsets.US_ASCII, new int[0]);
            this.inputData = Arrays.insertArray(this.inputData, 0, prefixArray);
        }
        String binaryString = this.generateAztecBinary();
        int dataLength = binaryString.length();
        if (this.preferredSize == 0) {
            int dataMaxSize = 0;
            int compLoop = this.readerInit ? 1 : 4;
            do {
                int i;
                int[] compactDataSizes;
                int[] dataSizes;
                switch (this.preferredEccLevel) {
                    case 1: {
                        dataSizes = AZTEC_10_DATA_SIZES;
                        compactDataSizes = AZTEC_COMPACT_10_DATA_SIZES;
                        break;
                    }
                    case 2: {
                        dataSizes = AZTEC_23_DATA_SIZES;
                        compactDataSizes = AZTEC_COMPACT_23_DATA_SIZES;
                        break;
                    }
                    case 3: {
                        dataSizes = AZTEC_36_DATA_SIZES;
                        compactDataSizes = AZTEC_COMPACT_36_DATA_SIZES;
                        break;
                    }
                    case 4: {
                        dataSizes = AZTEC_50_DATA_SIZES;
                        compactDataSizes = AZTEC_COMPACT_50_DATA_SIZES;
                        break;
                    }
                    default: {
                        throw new OkapiException("Unrecognized ECC level: " + this.preferredEccLevel);
                    }
                }
                layers = 0;
                compact = false;
                for (i = 32; i > 0; --i) {
                    if (dataLength >= dataSizes[i - 1]) continue;
                    layers = i;
                    compact = false;
                    dataMaxSize = dataSizes[i - 1];
                }
                for (i = compLoop; i > 0; --i) {
                    if (dataLength >= compactDataSizes[i - 1]) continue;
                    layers = i;
                    compact = true;
                    dataMaxSize = compactDataSizes[i - 1];
                }
                if (layers != 0) continue;
                throw new OkapiException("Input too long (too many bits for selected ECC)");
            } while ((dataLength = (adjustedString = this.adjustBinaryString(binaryString, compact, layers)).length()) > dataMaxSize);
        } else {
            if (this.preferredSize >= 1 && this.preferredSize <= 4) {
                compact = true;
                layers = this.preferredSize;
            } else {
                compact = false;
                layers = this.preferredSize - 4;
            }
            adjustedString = this.adjustBinaryString(binaryString, compact, layers);
            codewordSize = AztecCode.getCodewordSize(layers);
            int[] sizes = compact ? AZTEC_COMPACT_SIZES : AZTEC_SIZES;
            int dataMaxSize = codewordSize * (sizes[layers - 1] - 3);
            if (adjustedString.length() > dataMaxSize) {
                throw new OkapiException("Data too long for specified Aztec Code symbol size");
            }
        }
        if (this.readerInit && compact && layers > 1) {
            throw new OkapiException("Symbol is too large for reader initialization");
        }
        if (this.readerInit && layers > 22) {
            throw new OkapiException("Symbol is too large for reader initialization");
        }
        codewordSize = AztecCode.getCodewordSize(layers);
        int dataBlocks = adjustedString.length() / codewordSize;
        int eccBlocks = compact ? AZTEC_COMPACT_SIZES[layers - 1] - dataBlocks : AZTEC_SIZES[layers - 1] - dataBlocks;
        this.infoLine("Compact Mode: " + compact);
        this.infoLine("Layers: " + layers);
        this.infoLine("Codeword Length: " + codewordSize + " bits");
        this.infoLine("Data Codewords: " + dataBlocks);
        this.infoLine("ECC Codewords: " + eccBlocks);
        this.addErrorCorrection(adjustedString, codewordSize, dataBlocks, eccBlocks);
        for (int i = 0; i < adjustedString.length() / 2; ++i) {
            int mirror = adjustedString.length() - i - 1;
            char c = adjustedString.charAt(i);
            adjustedString.setCharAt(i, adjustedString.charAt(mirror));
            adjustedString.setCharAt(mirror, c);
        }
        String descriptor = this.createDescriptor(compact, layers, dataBlocks);
        if (compact) {
            this.readable = "";
            this.row_count = 27 - 2 * AZTEC_COMPACT_OFFSET[layers - 1];
            this.row_height = new int[this.row_count];
            this.row_height[0] = -1;
            this.pattern = new String[this.row_count];
            for (y = AZTEC_COMPACT_OFFSET[layers - 1]; y < 27 - AZTEC_COMPACT_OFFSET[layers - 1]; ++y) {
                StringBuilder bin = new StringBuilder(27);
                for (int x = AZTEC_COMPACT_OFFSET[layers - 1]; x < 27 - AZTEC_COMPACT_OFFSET[layers - 1]; ++x) {
                    int j = COMPACT_AZTEC_MAP[y * 27 + x];
                    if (j == 0) {
                        bin.append('0');
                    }
                    if (j == 1) {
                        bin.append('1');
                    }
                    if (j < 2) continue;
                    if (j - 2 < adjustedString.length()) {
                        bin.append(adjustedString.charAt(j - 2));
                        continue;
                    }
                    if (j >= 2000) {
                        bin.append(descriptor.charAt(j - 2000));
                        continue;
                    }
                    bin.append('0');
                }
                this.row_height[y - AztecCode.AZTEC_COMPACT_OFFSET[layers - 1]] = 1;
                this.pattern[y - AztecCode.AZTEC_COMPACT_OFFSET[layers - 1]] = AztecCode.bin2pat(bin);
            }
        } else {
            this.readable = "";
            this.row_count = 151 - 2 * AZTEC_OFFSET[layers - 1];
            this.row_height = new int[this.row_count];
            this.row_height[0] = -1;
            this.pattern = new String[this.row_count];
            for (y = AZTEC_OFFSET[layers - 1]; y < 151 - AZTEC_OFFSET[layers - 1]; ++y) {
                StringBuilder bin = new StringBuilder(151);
                for (int x = AZTEC_OFFSET[layers - 1]; x < 151 - AZTEC_OFFSET[layers - 1]; ++x) {
                    int j = AZTEC_MAP[x][y];
                    if (j == 1) {
                        bin.append('1');
                    }
                    if (j == 0) {
                        bin.append('0');
                    }
                    if (j < 2) continue;
                    if (j - 2 < adjustedString.length()) {
                        bin.append(adjustedString.charAt(j - 2));
                        continue;
                    }
                    if (j >= 20000) {
                        bin.append(descriptor.charAt(j - 20000));
                        continue;
                    }
                    bin.append('0');
                }
                this.row_height[y - AztecCode.AZTEC_OFFSET[layers - 1]] = 1;
                this.pattern[y - AztecCode.AZTEC_OFFSET[layers - 1]] = AztecCode.bin2pat(bin);
            }
        }
    }

    private String generateAztecBinary() {
        int curtable;
        int j;
        int i;
        int[] charmap = new int[2 * this.inputData.length];
        int[] typemap = new int[2 * this.inputData.length];
        int[] blockType = new int[this.inputData.length + 1];
        int[] blockLength = new int[this.inputData.length + 1];
        int maplength = 0;
        if (this.inputDataType == Symbol.DataType.GS1) {
            charmap[maplength] = 0;
            typemap[maplength++] = 8;
            charmap[maplength] = 400;
            typemap[maplength++] = 8;
        }
        if (this.eciMode != 3) {
            charmap[maplength] = 0;
            typemap[maplength++] = 8;
            int flagNumber = 6;
            if (this.eciMode < 100000) {
                flagNumber = 5;
            }
            if (this.eciMode < 10000) {
                flagNumber = 4;
            }
            if (this.eciMode < 1000) {
                flagNumber = 3;
            }
            if (this.eciMode < 100) {
                flagNumber = 2;
            }
            if (this.eciMode < 10) {
                flagNumber = 1;
            }
            charmap[maplength] = 400 + flagNumber;
            typemap[maplength++] = 8;
        }
        for (i = 0; i < this.inputData.length; ++i) {
            if (this.inputData[i] == -1) {
                charmap[maplength] = 0;
                typemap[maplength++] = 8;
                charmap[maplength] = 400;
                typemap[maplength++] = 8;
                continue;
            }
            if (this.inputData[i] > 127 || this.inputData[i] == 0) {
                charmap[maplength] = this.inputData[i];
                typemap[maplength++] = 32;
                continue;
            }
            charmap[maplength] = AZTEC_SYMBOL_CHAR[this.inputData[i]];
            typemap[maplength++] = AZTEC_CODE_SET[this.inputData[i]];
        }
        for (i = 0; i < maplength - 1; ++i) {
            if (charmap[i] == 300 && charmap[i + 1] == 11 && typemap[i] == 12 && typemap[i + 1] == 4) {
                charmap[i] = 2;
                typemap[i] = 8;
                if (i + 1 != maplength) {
                    for (j = i + 1; j < maplength; ++j) {
                        charmap[j] = charmap[j + 1];
                        typemap[j] = typemap[j + 1];
                    }
                }
                --maplength;
            }
            if (charmap[i] == 302 && charmap[i + 1] == 1 && typemap[i] == 24 && typemap[i + 1] == 23) {
                charmap[i] = 3;
                typemap[i] = 8;
                if (i + 1 != maplength) {
                    for (j = i + 1; j < maplength; ++j) {
                        charmap[j] = charmap[j + 1];
                        typemap[j] = typemap[j + 1];
                    }
                }
                --maplength;
            }
            if (charmap[i] == 301 && charmap[i + 1] == 1 && typemap[i] == 24 && typemap[i + 1] == 23) {
                charmap[i] = 4;
                typemap[i] = 8;
                if (i + 1 != maplength) {
                    for (j = i + 1; j < maplength; ++j) {
                        charmap[j] = charmap[j + 1];
                        typemap[j] = typemap[j + 1];
                    }
                }
                --maplength;
            }
            if (charmap[i] != 21 || charmap[i + 1] != 1 || typemap[i] != 8 || typemap[i + 1] != 23) continue;
            charmap[i] = 5;
            typemap[i] = 8;
            if (i + 1 != maplength) {
                for (j = i + 1; j < maplength; ++j) {
                    charmap[j] = charmap[j + 1];
                    typemap[j] = typemap[j + 1];
                }
            }
            --maplength;
        }
        int blocks = 0;
        for (i = 0; i < maplength; ++i) {
            if (i > 0 && typemap[i] == typemap[i - 1]) {
                int n = blocks - 1;
                blockLength[n] = blockLength[n] + 1;
                continue;
            }
            blockType[++blocks - 1] = typemap[i];
            blockLength[blocks - 1] = 1;
        }
        if ((blockType[0] & 1) != 0) {
            blockType[0] = 1;
        }
        if ((blockType[0] & 2) != 0) {
            blockType[0] = 2;
        }
        if ((blockType[0] & 4) != 0) {
            blockType[0] = 4;
        }
        if ((blockType[0] & 8) != 0) {
            blockType[0] = 8;
        }
        if (blocks > 1) {
            for (i = 1; i < blocks; ++i) {
                if ((blockType[i] & blockType[i - 1]) == 0) continue;
                blockType[i] = blockType[i] & blockType[i - 1];
            }
            if ((blockType[blocks - 1] & 1) != 0) {
                blockType[blocks - 1] = 1;
            }
            if ((blockType[blocks - 1] & 2) != 0) {
                blockType[blocks - 1] = 2;
            }
            if ((blockType[blocks - 1] & 4) != 0) {
                blockType[blocks - 1] = 4;
            }
            if ((blockType[blocks - 1] & 8) != 0) {
                blockType[blocks - 1] = 8;
            }
            for (i = blocks - 2; i > 0; --i) {
                if ((blockType[i] & blockType[i + 1]) == 0) continue;
                blockType[i] = blockType[i] & blockType[i + 1];
            }
            for (i = 1; i < blocks; ++i) {
                if ((blockType[i] & 8) != 0) {
                    blockType[i] = 8;
                }
                if ((blockType[i] & 4) != 0) {
                    blockType[i] = 4;
                }
                if ((blockType[i] & 2) != 0) {
                    blockType[i] = 2;
                }
                if ((blockType[i] & 1) == 0) continue;
                blockType[i] = 1;
            }
            i = 0;
            do {
                if (blockType[i] == blockType[i + 1]) {
                    int n = i;
                    blockLength[n] = blockLength[n] + blockLength[i + 1];
                    for (j = i + 1; j < blocks - 1; ++j) {
                        blockType[j] = blockType[j + 1];
                        blockLength[j] = blockLength[j + 1];
                    }
                    --blocks;
                    continue;
                }
                ++i;
            } while (i < blocks - 1);
        }
        j = 0;
        for (i = 0; i < blocks; ++i) {
            int k;
            if (blockLength[i] < 3 && blockType[i] != 32) {
                for (k = 0; k < blockLength[i]; ++k) {
                    typemap[j + k] = blockType[i] + 64;
                }
            } else {
                for (k = 0; k < blockLength[i]; ++k) {
                    typemap[j + k] = blockType[i];
                }
            }
            j += blockLength[i];
        }
        if (maplength > 0 && typemap[0] == 65) {
            typemap[0] = 1;
        }
        block119: for (i = 0; i < maplength; ++i) {
            if (charmap[i] < 300 || charmap[i] >= 400) continue;
            curtable = typemap[i];
            if (curtable > 64) {
                curtable -= 64;
            }
            block0 : switch (charmap[i]) {
                case 300: {
                    switch (curtable) {
                        case 8: {
                            charmap[i] = 1;
                            break;
                        }
                        case 4: {
                            charmap[i] = 14;
                        }
                    }
                    continue block119;
                }
                case 301: {
                    switch (curtable) {
                        case 8: {
                            charmap[i] = 17;
                            break;
                        }
                        case 16: {
                            charmap[i] = 12;
                        }
                    }
                    continue block119;
                }
                case 302: {
                    switch (curtable) {
                        case 8: {
                            charmap[i] = 19;
                            break block0;
                        }
                        case 16: {
                            charmap[i] = 13;
                        }
                    }
                }
            }
        }
        StringBuilder binaryString = new StringBuilder();
        this.info("Encoding: ");
        curtable = 1;
        int lasttable = 1;
        if (this.structuredAppendTotal != 1) {
            binaryString.append(PENTBIT[29]);
            this.info("ML ");
            binaryString.append(PENTBIT[29]);
            this.info("UL ");
        }
        block120: for (i = 0; i < maplength; ++i) {
            int weight;
            int newtable = curtable;
            if (typemap[i] != curtable && charmap[i] < 400) {
                if (curtable == 32) {
                    curtable = lasttable;
                    newtable = lasttable;
                }
                if (typemap[i] > 64) {
                    block17 : switch (typemap[i]) {
                        case 65: {
                            switch (curtable) {
                                case 2: {
                                    binaryString.append(PENTBIT[28]);
                                    this.info("US ");
                                    break block17;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("UL ");
                                    newtable = 1;
                                    break block17;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    newtable = 1;
                                    break block17;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[15]);
                                    this.info("US ");
                                }
                            }
                            break;
                        }
                        case 66: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break block17;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break block17;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break block17;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                }
                            }
                            break;
                        }
                        case 68: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break block17;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break block17;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break block17;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                }
                            }
                            break;
                        }
                        case 72: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[0]);
                                    this.info("PS ");
                                    break block17;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[0]);
                                    this.info("PS ");
                                    break block17;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[0]);
                                    this.info("PS ");
                                    break block17;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[0]);
                                    this.info("PS ");
                                }
                            }
                            break;
                        }
                        case 80: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break block17;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break block17;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break block17;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                }
                            }
                        }
                    }
                } else {
                    switch (typemap[i]) {
                        case 1: {
                            switch (curtable) {
                                case 2: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("UL ");
                                    newtable = 1;
                                    break;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("UL ");
                                    newtable = 1;
                                    break;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    newtable = 1;
                                    break;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    newtable = 1;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                    break;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[28]);
                                    this.info("LL ");
                                    newtable = 2;
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                    break;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    newtable = 4;
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("PL ");
                                    newtable = 8;
                                    break;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("PL ");
                                    newtable = 8;
                                    break;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[30]);
                                    this.info("PL ");
                                    newtable = 8;
                                    break;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[29]);
                                    this.info("ML ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("PL ");
                                    newtable = 8;
                                }
                            }
                            break;
                        }
                        case 16: {
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[29]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                    break;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[30]);
                                    this.info("DL ");
                                    newtable = 16;
                                }
                            }
                            break;
                        }
                        case 32: {
                            lasttable = curtable;
                            switch (curtable) {
                                case 1: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("BS ");
                                    newtable = 32;
                                    break;
                                }
                                case 2: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("BS ");
                                    newtable = 32;
                                    break;
                                }
                                case 4: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("BS ");
                                    newtable = 32;
                                    break;
                                }
                                case 8: {
                                    binaryString.append(PENTBIT[31]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[31]);
                                    this.info("BS ");
                                    lasttable = 1;
                                    newtable = 32;
                                    break;
                                }
                                case 16: {
                                    binaryString.append(QUADBIT[14]);
                                    this.info("UL ");
                                    binaryString.append(PENTBIT[31]);
                                    this.info("BS ");
                                    lasttable = 1;
                                    newtable = 32;
                                }
                            }
                            int bytes = 0;
                            while (typemap[i + (++bytes - 1)] == 32) {
                            }
                            if (--bytes > 2079) {
                                throw new OkapiException("Input too long");
                            }
                            if (bytes > 31) {
                                binaryString.append("00000");
                                for (weight = 1024; weight > 0; weight >>= 1) {
                                    if ((bytes - 31 & weight) != 0) {
                                        binaryString.append('1');
                                        continue;
                                    }
                                    binaryString.append('0');
                                }
                            } else {
                                for (weight = 16; weight > 0; weight >>= 1) {
                                    if ((bytes & weight) != 0) {
                                        binaryString.append('1');
                                        continue;
                                    }
                                    binaryString.append('0');
                                }
                            }
                            break;
                        }
                    }
                }
            }
            curtable = newtable;
            int chartype = typemap[i];
            if (chartype > 64) {
                chartype -= 64;
            }
            switch (chartype) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    if (charmap[i] >= 400) {
                        this.info("FLG(" + (charmap[i] - 400) + ") ");
                        binaryString.append(TRIBIT[charmap[i] - 400]);
                        if (charmap[i] == 400) continue block120;
                        binaryString.append(this.eciToBinary());
                        continue block120;
                    }
                    binaryString.append(PENTBIT[charmap[i]]);
                    this.infoSpace(charmap[i]);
                    continue block120;
                }
                case 16: {
                    binaryString.append(QUADBIT[charmap[i]]);
                    this.infoSpace(charmap[i]);
                    continue block120;
                }
                case 32: {
                    for (weight = 128; weight > 0; weight >>= 1) {
                        if ((charmap[i] & weight) != 0) {
                            binaryString.append('1');
                            continue;
                        }
                        binaryString.append('0');
                    }
                    this.infoSpace(charmap[i]);
                }
            }
        }
        this.infoLine();
        return binaryString.toString();
    }

    private StringBuilder adjustBinaryString(String binaryString, boolean compact, int layers) {
        int i;
        StringBuilder adjustedString = new StringBuilder();
        int codewordSize = AztecCode.getCodewordSize(layers);
        int ones = 0;
        for (int i2 = 0; i2 < binaryString.length(); ++i2) {
            if ((adjustedString.length() + 1) % codewordSize == 0) {
                if (ones == codewordSize - 1) {
                    adjustedString.append('0');
                    --i2;
                } else if (ones == 0) {
                    adjustedString.append('1');
                    --i2;
                } else {
                    adjustedString.append(binaryString.charAt(i2));
                }
                ones = 0;
                continue;
            }
            adjustedString.append(binaryString.charAt(i2));
            if (binaryString.charAt(i2) != '1') continue;
            ++ones;
        }
        int adjustedLength = adjustedString.length();
        int remainder = adjustedLength % codewordSize;
        int padBits = codewordSize - remainder;
        if (padBits == codewordSize) {
            padBits = 0;
        }
        for (i = 0; i < padBits; ++i) {
            adjustedString.append('1');
        }
        adjustedLength = adjustedString.length();
        ones = 0;
        for (i = adjustedLength - codewordSize; i < adjustedLength && i >= 0; ++i) {
            if (adjustedString.charAt(i) != '1') continue;
            ++ones;
        }
        if (ones == codewordSize) {
            adjustedString.setCharAt(adjustedLength - 1, '0');
        }
        this.info("Codewords: ");
        for (i = 0; i < adjustedLength / codewordSize; ++i) {
            int l = 0;
            int m = 1 << codewordSize - 1;
            for (int j = 0; j < codewordSize; ++j) {
                if (adjustedString.charAt(i * codewordSize + j) == '1') {
                    l += m;
                }
                m >>= 1;
            }
            this.infoSpace(l);
        }
        this.infoLine();
        return adjustedString;
    }

    private String eciToBinary() {
        String eciNumber = Integer.toString(this.eciMode);
        StringBuilder binary = new StringBuilder(4 * eciNumber.length());
        for (int i = 0; i < eciNumber.length(); ++i) {
            binary.append(QUADBIT[eciNumber.charAt(i) - 48 + 2]);
            this.infoSpace(eciNumber.charAt(i));
        }
        return binary.toString();
    }

    private String createDescriptor(boolean compact, int layers, int dataBlocks) {
        int descDataSize;
        int i;
        StringBuilder descriptor = new StringBuilder();
        if (compact) {
            if ((layers - 1 & 2) != 0) {
                descriptor.append('1');
            } else {
                descriptor.append('0');
            }
            if ((layers - 1 & 1) != 0) {
                descriptor.append('1');
            } else {
                descriptor.append('0');
            }
            if (this.readerInit) {
                descriptor.append('1');
            } else if ((dataBlocks - 1 & 0x20) != 0) {
                descriptor.append('1');
            } else {
                descriptor.append('0');
            }
            for (i = 16; i > 0; i >>= 1) {
                if ((dataBlocks - 1 & i) != 0) {
                    descriptor.append('1');
                    continue;
                }
                descriptor.append('0');
            }
            descDataSize = 2;
        } else {
            for (i = 16; i > 0; i >>= 1) {
                if ((layers - 1 & i) != 0) {
                    descriptor.append('1');
                    continue;
                }
                descriptor.append('0');
            }
            if (this.readerInit) {
                descriptor.append('1');
            } else if ((dataBlocks - 1 & 0x400) != 0) {
                descriptor.append('1');
            } else {
                descriptor.append('0');
            }
            for (i = 512; i > 0; i >>= 1) {
                if ((dataBlocks - 1 & i) != 0) {
                    descriptor.append('1');
                    continue;
                }
                descriptor.append('0');
            }
            descDataSize = 4;
        }
        this.infoLine("Mode Message: " + descriptor);
        int[] desc_data = new int[descDataSize];
        for (int i2 = 0; i2 < descDataSize; ++i2) {
            for (int weight = 0; weight < 4; ++weight) {
                if (descriptor.charAt(i2 * 4 + weight) != '1') continue;
                int n = i2;
                desc_data[n] = desc_data[n] + (8 >> weight);
            }
        }
        ReedSolomon rs = new ReedSolomon();
        rs.init_gf(19);
        if (compact) {
            int i3;
            rs.init_code(5, 1);
            rs.encode(2, desc_data);
            int[] desc_ecc = new int[6];
            for (i3 = 0; i3 < 5; ++i3) {
                desc_ecc[i3] = rs.getResult(i3);
            }
            for (i3 = 0; i3 < 5; ++i3) {
                for (int weight = 8; weight > 0; weight >>= 1) {
                    if ((desc_ecc[4 - i3] & weight) != 0) {
                        descriptor.append('1');
                        continue;
                    }
                    descriptor.append('0');
                }
            }
        } else {
            int i4;
            rs.init_code(6, 1);
            rs.encode(4, desc_data);
            int[] desc_ecc = new int[6];
            for (i4 = 0; i4 < 6; ++i4) {
                desc_ecc[i4] = rs.getResult(i4);
            }
            for (i4 = 0; i4 < 6; ++i4) {
                for (int weight = 8; weight > 0; weight >>= 1) {
                    if ((desc_ecc[5 - i4] & weight) != 0) {
                        descriptor.append('1');
                        continue;
                    }
                    descriptor.append('0');
                }
            }
        }
        return descriptor.toString();
    }

    private void addErrorCorrection(StringBuilder adjustedString, int codewordSize, int dataBlocks, int eccBlocks) {
        int weight;
        int i;
        int poly;
        int x;
        switch (codewordSize) {
            case 6: {
                x = 32;
                poly = 67;
                int startWeight = 32;
                break;
            }
            case 8: {
                x = 128;
                poly = 301;
                int startWeight = 128;
                break;
            }
            case 10: {
                x = 512;
                poly = 1033;
                int startWeight = 512;
                break;
            }
            case 12: {
                x = 2048;
                poly = 4201;
                int startWeight = 2048;
                break;
            }
            default: {
                throw new OkapiException("Unrecognized codeword size: " + codewordSize);
            }
        }
        ReedSolomon rs = new ReedSolomon();
        int[] data = new int[dataBlocks + 3];
        int[] ecc = new int[eccBlocks + 3];
        for (i = 0; i < dataBlocks; ++i) {
            for (weight = 0; weight < codewordSize; ++weight) {
                if (adjustedString.charAt(i * codewordSize + weight) != '1') continue;
                int n = i;
                data[n] = data[n] + (x >> weight);
            }
        }
        rs.init_gf(poly);
        rs.init_code(eccBlocks, 1);
        rs.encode(dataBlocks, data);
        for (i = 0; i < eccBlocks; ++i) {
            ecc[i] = rs.getResult(i);
        }
        for (i = eccBlocks - 1; i >= 0; --i) {
            for (weight = startWeight; weight > 0; weight >>= 1) {
                if ((ecc[i] & weight) != 0) {
                    adjustedString.append('1');
                    continue;
                }
                adjustedString.append('0');
            }
        }
    }

    private static int getCodewordSize(int layers) {
        if (layers >= 23) {
            return 12;
        }
        if (layers >= 9 && layers <= 22) {
            return 10;
        }
        if (layers >= 3 && layers <= 8) {
            return 8;
        }
        assert (layers <= 2);
        return 6;
    }

    static {
        int i;
        int y;
        int x;
        COMPACT_AZTEC_MAP = new int[]{609, 608, 411, 413, 415, 417, 419, 421, 423, 425, 427, 429, 431, 433, 435, 437, 439, 441, 443, 445, 447, 449, 451, 453, 455, 457, 459, 607, 606, 410, 412, 414, 416, 418, 420, 422, 424, 426, 428, 430, 432, 434, 436, 438, 440, 442, 444, 446, 448, 450, 452, 454, 456, 458, 605, 604, 409, 408, 243, 245, 247, 249, 251, 253, 255, 257, 259, 261, 263, 265, 267, 269, 271, 273, 275, 277, 279, 281, 283, 460, 461, 603, 602, 407, 406, 242, 244, 246, 248, 250, 252, 254, 256, 258, 260, 262, 264, 266, 268, 270, 272, 274, 276, 278, 280, 282, 462, 463, 601, 600, 405, 404, 241, 240, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 135, 137, 139, 284, 285, 464, 465, 599, 598, 403, 402, 239, 238, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126, 128, 130, 132, 134, 136, 138, 286, 287, 466, 467, 597, 596, 401, 400, 237, 236, 105, 104, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 140, 141, 288, 289, 468, 469, 595, 594, 399, 398, 235, 234, 103, 102, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 142, 143, 290, 291, 470, 471, 593, 592, 397, 396, 233, 232, 101, 100, 1, 1, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 0, 1, 28, 29, 144, 145, 292, 293, 472, 473, 591, 590, 395, 394, 231, 230, 99, 98, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 30, 31, 146, 147, 294, 295, 474, 475, 589, 588, 393, 392, 229, 228, 97, 96, 2027, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2007, 32, 33, 148, 149, 296, 297, 476, 477, 587, 586, 391, 390, 227, 226, 95, 94, 2026, 1, 0, 1, 1, 1, 1, 1, 0, 1, 2008, 34, 35, 150, 151, 298, 299, 478, 479, 585, 584, 389, 388, 225, 224, 93, 92, 2025, 1, 0, 1, 0, 0, 0, 1, 0, 1, 2009, 36, 37, 152, 153, 300, 301, 480, 481, 583, 582, 387, 386, 223, 222, 91, 90, 2024, 1, 0, 1, 0, 1, 0, 1, 0, 1, 2010, 38, 39, 154, 155, 302, 303, 482, 483, 581, 580, 385, 384, 221, 220, 89, 88, 2023, 1, 0, 1, 0, 0, 0, 1, 0, 1, 2011, 40, 41, 156, 157, 304, 305, 484, 485, 579, 578, 383, 382, 219, 218, 87, 86, 2022, 1, 0, 1, 1, 1, 1, 1, 0, 1, 2012, 42, 43, 158, 159, 306, 307, 486, 487, 577, 576, 381, 380, 217, 216, 85, 84, 2021, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2013, 44, 45, 160, 161, 308, 309, 488, 489, 575, 574, 379, 378, 215, 214, 83, 82, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 46, 47, 162, 163, 310, 311, 490, 491, 573, 572, 377, 376, 213, 212, 81, 80, 0, 0, 2020, 2019, 2018, 2017, 2016, 2015, 2014, 0, 0, 48, 49, 164, 165, 312, 313, 492, 493, 571, 570, 375, 374, 211, 210, 78, 76, 74, 72, 70, 68, 66, 64, 62, 60, 58, 56, 54, 50, 51, 166, 167, 314, 315, 494, 495, 569, 568, 373, 372, 209, 208, 79, 77, 75, 73, 71, 69, 67, 65, 63, 61, 59, 57, 55, 52, 53, 168, 169, 316, 317, 496, 497, 567, 566, 371, 370, 206, 204, 202, 200, 198, 196, 194, 192, 190, 188, 186, 184, 182, 180, 178, 176, 174, 170, 171, 318, 319, 498, 499, 565, 564, 369, 368, 207, 205, 203, 201, 199, 197, 195, 193, 191, 189, 187, 185, 183, 181, 179, 177, 175, 172, 173, 320, 321, 500, 501, 563, 562, 366, 364, 362, 360, 358, 356, 354, 352, 350, 348, 346, 344, 342, 340, 338, 336, 334, 332, 330, 328, 326, 322, 323, 502, 503, 561, 560, 367, 365, 363, 361, 359, 357, 355, 353, 351, 349, 347, 345, 343, 341, 339, 337, 335, 333, 331, 329, 327, 324, 325, 504, 505, 558, 556, 554, 552, 550, 548, 546, 544, 542, 540, 538, 536, 534, 532, 530, 528, 526, 524, 522, 520, 518, 516, 514, 512, 510, 506, 507, 559, 557, 555, 553, 551, 549, 547, 545, 543, 541, 539, 537, 535, 533, 531, 529, 527, 525, 523, 521, 519, 517, 515, 513, 511, 508, 509};
        AZTEC_MAP = new int[151][151];
        AZTEC_CODE_SET = new int[]{32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 4, 4, 4, 4, 4, 23, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 8, 24, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 8, 8, 8, 8, 8, 8, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 4, 8, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 4, 8, 4, 4};
        AZTEC_SYMBOL_CHAR = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 300, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 15, 16, 17, 18, 19, 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 301, 18, 302, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 24, 25, 26, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 27, 21, 28, 22, 23, 24, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 25, 30, 26, 27};
        PENTBIT = new String[]{"00000", "00001", "00010", "00011", "00100", "00101", "00110", "00111", "01000", "01001", "01010", "01011", "01100", "01101", "01110", "01111", "10000", "10001", "10010", "10011", "10100", "10101", "10110", "10111", "11000", "11001", "11010", "11011", "11100", "11101", "11110", "11111"};
        QUADBIT = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
        TRIBIT = new String[]{"000", "001", "010", "011", "100", "101", "110", "111"};
        AZTEC_SIZES = new int[]{21, 48, 60, 88, 120, 156, 196, 240, 230, 272, 316, 364, 416, 470, 528, 588, 652, 720, 790, 864, 940, 1020, 920, 992, 1066, 1144, 1224, 1306, 1392, 1480, 1570, 1664};
        AZTEC_COMPACT_SIZES = new int[]{17, 40, 51, 76};
        AZTEC_10_DATA_SIZES = new int[]{96, 246, 408, 616, 840, 1104, 1392, 1704, 2040, 2420, 2820, 3250, 3720, 4200, 4730, 5270, 5840, 6450, 7080, 7750, 8430, 9150, 9900, 10680, 11484, 12324, 13188, 14076, 15000, 15948, 16920, 17940};
        AZTEC_23_DATA_SIZES = new int[]{84, 204, 352, 520, 720, 944, 1184, 1456, 1750, 2070, 2410, 2780, 3180, 3590, 4040, 4500, 5000, 5520, 6060, 6630, 7210, 7830, 8472, 9132, 9816, 10536, 11280, 12036, 12828, 13644, 14472, 15348};
        AZTEC_36_DATA_SIZES = new int[]{66, 168, 288, 432, 592, 776, 984, 1208, 1450, 1720, 2000, 2300, 2640, 2980, 3350, 3740, 4150, 4580, 5030, 5500, 5990, 6500, 7032, 7584, 8160, 8760, 9372, 9996, 10656, 11340, 12024, 12744};
        AZTEC_50_DATA_SIZES = new int[]{48, 126, 216, 328, 456, 600, 760, 936, 1120, 1330, 1550, 1790, 2050, 2320, 2610, 2910, 3230, 3570, 3920, 4290, 4670, 5070, 5484, 5916, 6360, 6828, 7308, 7800, 8316, 8844, 9384, 9948};
        AZTEC_COMPACT_10_DATA_SIZES = new int[]{78, 198, 336, 520};
        AZTEC_COMPACT_23_DATA_SIZES = new int[]{66, 168, 288, 440};
        AZTEC_COMPACT_36_DATA_SIZES = new int[]{48, 138, 232, 360};
        AZTEC_COMPACT_50_DATA_SIZES = new int[]{36, 102, 176, 280};
        AZTEC_OFFSET = new int[]{66, 64, 62, 60, 57, 55, 53, 51, 49, 47, 45, 42, 40, 38, 36, 34, 32, 30, 28, 25, 23, 21, 19, 17, 15, 13, 10, 8, 6, 4, 2, 0};
        AZTEC_COMPACT_OFFSET = new int[]{6, 4, 2, 0};
        for (x = 0; x < 151; ++x) {
            for (y = 0; y < 151; ++y) {
                AztecCode.AZTEC_MAP[x][y] = 0;
            }
        }
        for (int layer = 1; layer < 33; ++layer) {
            int n;
            int start = 112 * (layer - 1) + 16 * (layer - 1) * (layer - 1) + 2;
            int length = 28 + (layer - 1) * 4 + layer * 4;
            i = 0;
            x = 64 - (layer - 1) * 2;
            y = 63 - (layer - 1) * 2;
            for (n = start; n < start + length; n += 2) {
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x + i))][AztecCode.avoidReferenceGrid((int)y)] = n;
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x + i))][AztecCode.avoidReferenceGrid((int)(y - 1))] = n + 1;
                ++i;
            }
            i = 0;
            x = 78 + (layer - 1) * 2;
            y = 64 - (layer - 1) * 2;
            for (n = start + length; n < start + length * 2; n += 2) {
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)x)][AztecCode.avoidReferenceGrid((int)(y + i))] = n;
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x + 1))][AztecCode.avoidReferenceGrid((int)(y + i))] = n + 1;
                ++i;
            }
            i = 0;
            x = 77 + (layer - 1) * 2;
            y = 78 + (layer - 1) * 2;
            for (n = start + length * 2; n < start + length * 3; n += 2) {
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x - i))][AztecCode.avoidReferenceGrid((int)y)] = n;
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x - i))][AztecCode.avoidReferenceGrid((int)(y + 1))] = n + 1;
                ++i;
            }
            i = 0;
            x = 63 - (layer - 1) * 2;
            y = 77 + (layer - 1) * 2;
            for (n = start + length * 3; n < start + length * 4; n += 2) {
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)x)][AztecCode.avoidReferenceGrid((int)(y - i))] = n;
                AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(x - 1))][AztecCode.avoidReferenceGrid((int)(y - i))] = n + 1;
                ++i;
            }
        }
        for (y = 69; y <= 81; ++y) {
            for (x = 69; x <= 81; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 1;
            }
        }
        for (y = 70; y <= 80; ++y) {
            for (x = 70; x <= 80; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 0;
            }
        }
        for (y = 71; y <= 79; ++y) {
            for (x = 71; x <= 79; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 1;
            }
        }
        for (y = 72; y <= 78; ++y) {
            for (x = 72; x <= 78; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 0;
            }
        }
        for (y = 73; y <= 77; ++y) {
            for (x = 73; x <= 77; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 1;
            }
        }
        for (y = 74; y <= 76; ++y) {
            for (x = 74; x <= 76; ++x) {
                AztecCode.AZTEC_MAP[x][y] = 0;
            }
        }
        for (y = 11; y < 151; y += 16) {
            for (x = 1; x < 151; x += 2) {
                AztecCode.AZTEC_MAP[x][y] = 1;
                AztecCode.AZTEC_MAP[y][x] = 1;
            }
        }
        for (i = 0; i < 10; ++i) {
            AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(66 + i))][AztecCode.avoidReferenceGrid((int)64)] = 20000 + i;
        }
        for (i = 0; i < 10; ++i) {
            AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)77)][AztecCode.avoidReferenceGrid((int)(66 + i))] = 20010 + i;
        }
        for (i = 0; i < 10; ++i) {
            AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)(75 - i))][AztecCode.avoidReferenceGrid((int)77)] = 20020 + i;
        }
        for (i = 0; i < 10; ++i) {
            AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)64)][AztecCode.avoidReferenceGrid((int)(75 - i))] = 20030 + i;
        }
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)64)][AztecCode.avoidReferenceGrid((int)64)] = 1;
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)65)][AztecCode.avoidReferenceGrid((int)64)] = 1;
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)64)][AztecCode.avoidReferenceGrid((int)65)] = 1;
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)77)][AztecCode.avoidReferenceGrid((int)64)] = 1;
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)77)][AztecCode.avoidReferenceGrid((int)65)] = 1;
        AztecCode.AZTEC_MAP[AztecCode.avoidReferenceGrid((int)77)][AztecCode.avoidReferenceGrid((int)76)] = 1;
    }
}

