/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class AustraliaPost
extends Symbol {
    private static final char[] CHARACTER_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '#'};
    private static final String[] N_ENCODING_TABLE = new String[]{"00", "01", "02", "10", "11", "12", "20", "21", "22", "30"};
    private static final String[] C_ENCODING_TABLE = new String[]{"222", "300", "301", "302", "310", "311", "312", "320", "321", "322", "000", "001", "002", "010", "011", "012", "020", "021", "022", "100", "101", "102", "110", "111", "112", "120", "121", "122", "200", "201", "202", "210", "211", "212", "220", "221", "023", "030", "031", "032", "033", "103", "113", "123", "130", "131", "132", "133", "203", "213", "223", "230", "231", "232", "233", "303", "313", "323", "330", "331", "332", "333", "003", "013"};
    private static final String[] BAR_VALUE_TABLE = new String[]{"000", "001", "002", "003", "010", "011", "012", "013", "020", "021", "022", "023", "030", "031", "032", "033", "100", "101", "102", "103", "110", "111", "112", "113", "120", "121", "122", "123", "130", "131", "132", "133", "200", "201", "202", "203", "210", "211", "212", "213", "220", "221", "222", "223", "230", "231", "232", "233", "300", "301", "302", "303", "310", "311", "312", "313", "320", "321", "322", "323", "330", "331", "332", "333"};
    private ausMode mode = ausMode.AUSPOST;

    public void setPostMode() {
        this.mode = ausMode.AUSPOST;
    }

    public void setReplyMode() {
        this.mode = ausMode.AUSREPLY;
    }

    public void setRouteMode() {
        this.mode = ausMode.AUSROUTE;
    }

    public void setRedirectMode() {
        this.mode = ausMode.AUSREDIRECT;
    }

    @Override
    protected void encode() {
        int i;
        String formatControlCode = "00";
        String zeroPaddedInput = "";
        block0 : switch (this.mode) {
            case AUSPOST: {
                switch (this.content.length()) {
                    case 8: {
                        formatControlCode = "11";
                        break block0;
                    }
                    case 13: {
                        formatControlCode = "59";
                        break block0;
                    }
                    case 16: {
                        formatControlCode = "59";
                        if (this.content.matches("[0-9]+")) break block0;
                        throw new OkapiException("Invalid characters in data");
                    }
                    case 18: {
                        formatControlCode = "62";
                        break block0;
                    }
                    case 23: {
                        formatControlCode = "62";
                        if (this.content.matches("[0-9]+")) break block0;
                        throw new OkapiException("Invalid characters in data");
                    }
                }
                throw new OkapiException("Auspost input is wrong length");
            }
            case AUSREPLY: {
                if (this.content.length() > 8) {
                    throw new OkapiException("Auspost input is too long");
                }
                formatControlCode = "45";
                break;
            }
            case AUSROUTE: {
                if (this.content.length() > 8) {
                    throw new OkapiException("Auspost input is too long");
                }
                formatControlCode = "87";
                break;
            }
            case AUSREDIRECT: {
                if (this.content.length() > 8) {
                    throw new OkapiException("Auspost input is too long");
                }
                formatControlCode = "92";
            }
        }
        this.infoLine("FCC: " + formatControlCode);
        if (this.mode != ausMode.AUSPOST) {
            for (i = this.content.length(); i < 8; ++i) {
                zeroPaddedInput = zeroPaddedInput + "0";
            }
        }
        zeroPaddedInput = zeroPaddedInput + this.content;
        if (!this.content.matches("[0-9A-Za-z #]+")) {
            throw new OkapiException("Invalid characters in data");
        }
        String deliveryPointId = zeroPaddedInput.substring(0, 8);
        if (!deliveryPointId.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in DPID");
        }
        this.infoLine("DPID: " + deliveryPointId);
        String barStateValues = "13";
        for (i = 0; i < 2; ++i) {
            barStateValues = barStateValues + N_ENCODING_TABLE[formatControlCode.charAt(i) - 48];
        }
        for (i = 0; i < 8; ++i) {
            barStateValues = barStateValues + N_ENCODING_TABLE[deliveryPointId.charAt(i) - 48];
        }
        switch (zeroPaddedInput.length()) {
            case 13: 
            case 18: {
                for (i = 8; i < zeroPaddedInput.length(); ++i) {
                    barStateValues = barStateValues + C_ENCODING_TABLE[Arrays.positionOf(zeroPaddedInput.charAt(i), CHARACTER_SET)];
                }
                break;
            }
            case 16: 
            case 23: {
                for (i = 8; i < zeroPaddedInput.length(); ++i) {
                    barStateValues = barStateValues + N_ENCODING_TABLE[Arrays.positionOf(zeroPaddedInput.charAt(i), CHARACTER_SET)];
                }
                break;
            }
        }
        switch (barStateValues.length()) {
            case 22: 
            case 37: 
            case 52: {
                barStateValues = barStateValues + "3";
            }
        }
        barStateValues = barStateValues + this.calcReedSolomon(barStateValues);
        barStateValues = barStateValues + "13";
        this.infoLine("Total Length: " + barStateValues.length());
        this.info("Encoding: ");
        block31: for (i = 0; i < barStateValues.length(); ++i) {
            switch (barStateValues.charAt(i)) {
                case '1': {
                    this.info("A");
                    continue block31;
                }
                case '2': {
                    this.info("D");
                    continue block31;
                }
                case '0': {
                    this.info("F");
                    continue block31;
                }
                case '3': {
                    this.info("T");
                }
            }
        }
        this.infoLine();
        this.readable = "";
        this.pattern = new String[1];
        this.pattern[0] = barStateValues;
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
    }

    private String calcReedSolomon(String oldBarStateValues) {
        ReedSolomon rs = new ReedSolomon();
        String newBarStateValues = "";
        int tripleValueCount = 0;
        int[] tripleValue = new int[31];
        int barStateCount = 2;
        while (barStateCount < oldBarStateValues.length()) {
            tripleValue[tripleValueCount] = this.barStateToDecimal(oldBarStateValues.charAt(barStateCount), 4) + this.barStateToDecimal(oldBarStateValues.charAt(barStateCount + 1), 2) + this.barStateToDecimal(oldBarStateValues.charAt(barStateCount + 2), 0);
            barStateCount += 3;
            ++tripleValueCount;
        }
        rs.init_gf(67);
        rs.init_code(4, 1);
        rs.encode(tripleValueCount, tripleValue);
        for (barStateCount = 4; barStateCount > 0; --barStateCount) {
            newBarStateValues = newBarStateValues + BAR_VALUE_TABLE[rs.getResult(barStateCount - 1)];
        }
        return newBarStateValues;
    }

    private int barStateToDecimal(char oldBarStateValues, int shift) {
        return oldBarStateValues - 48 << shift;
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case '1': {
                    y = 0;
                    h = 5;
                    break;
                }
                case '2': {
                    y = 3;
                    h = 5;
                    break;
                }
                case '0': {
                    y = 0;
                    h = 8;
                    break;
                }
                case '3': {
                    y = 3;
                    h = 2;
                }
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = (this.pattern[0].length() - 1) * 2 + 1;
        this.symbol_height = 8;
    }

    private static enum ausMode {
        AUSPOST,
        AUSREPLY,
        AUSROUTE,
        AUSREDIRECT;

    }
}

