/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.macro.QRCodeMacro;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.QrCode;

@Scanned
public class QRCodeTelephoneMacro
extends QRCodeMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QRCodeTelephoneMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public QRCodeTelephoneMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager, null);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection = map.getOrDefault("errorCorrectionlevel", "L");
        String height = map.get("height");
        String tel = map.getOrDefault("tel", "+123456789");
        QrCode code = new QrCode();
        String result = "tel:" + tel;
        switch (errorCorrection) {
            default: {
                code.setPreferredEccLevel(QrCode.EccLevel.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setPreferredEccLevel(QrCode.EccLevel.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setPreferredEccLevel(QrCode.EccLevel.Q);
                log.debug("Setting ECC Level to Q");
                break;
            }
            case "H": {
                code.setPreferredEccLevel(QrCode.EccLevel.H);
                log.debug("Setting ECC Level to H");
            }
        }
        log.debug("Generating qr code for {}", (Object)result);
        try {
            code.setContent(result);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

