/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.macro.QRCodeMacro;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.QrCode;

@Scanned
public class QRCodeEmailMacro
extends QRCodeMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QRCodeEmailMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private XhtmlContent xhtmlContent;

    @Inject
    public QRCodeEmailMacro(PluginLicenseManager pluginLicenseManager, XhtmlContent xhtmlContent) {
        super(pluginLicenseManager, xhtmlContent);
        this.pluginLicenseManager = pluginLicenseManager;
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection = map.getOrDefault("errorCorrectionlevel", "L");
        String to = map.getOrDefault("to", "sample@example.com");
        String cc = map.get("cc");
        String bcc = map.get("bcc");
        String subject = map.get("subject");
        String body = map.get("body");
        String height = map.get("height");
        QrCode code = new QrCode();
        StringBuilder result = new StringBuilder("mailto:");
        result.append(to);
        boolean appendedQuestionMark = false;
        if (cc != null && cc.length() > 0) {
            result.append("?cc=").append(cc);
            appendedQuestionMark = true;
        }
        if (bcc != null && bcc.length() > 0) {
            if (appendedQuestionMark) {
                result.append("&bcc=").append(bcc);
            } else {
                result.append("?bcc=").append(bcc);
                appendedQuestionMark = true;
            }
        }
        if (subject != null && subject.length() > 0) {
            if (appendedQuestionMark) {
                result.append("&subject=").append(subject);
            } else {
                result.append("?subject=").append(subject);
                appendedQuestionMark = true;
            }
        }
        if (body != null && body.length() > 0) {
            if (appendedQuestionMark) {
                result.append("&body=").append(body);
            } else {
                result.append("?body=").append(body);
            }
        }
        switch (errorCorrection) {
            default: {
                code.setPreferredEccLevel(QrCode.EccLevel.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setPreferredEccLevel(QrCode.EccLevel.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setPreferredEccLevel(QrCode.EccLevel.Q);
                log.debug("Setting ECC Level to Q");
                break;
            }
            case "H": {
                code.setPreferredEccLevel(QrCode.EccLevel.H);
                log.debug("Setting ECC Level to H");
            }
        }
        log.debug("Generating qr code for {}", (Object)result);
        try {
            code.setContent(result.toString());
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

