/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.Code49;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class Code49Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(Code49Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public Code49Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String height = map.getOrDefault("height", String.valueOf(100));
        log.debug("Generating Code49 barcode with content {}", (Object)s);
        if (s == null) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Code49 code = new Code49();
        try {
            code.setContent(s);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

