/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.Code11;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class Code11Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(Code11Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public Code11Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String showText = map.get("showtext");
        String checkdigitCount = map.getOrDefault("checkdigitcount", "1");
        String startDelimiter = map.get("startdelimiter");
        String stopDelimiter = map.get("stopdelimiter");
        String height = map.getOrDefault("height", String.valueOf(100));
        if (s == null) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Code11 code = new Code11();
        this.checkAndSetHumanReadableLocation(code, showText);
        if (checkdigitCount != null) {
            try {
                int count = Integer.parseInt(checkdigitCount);
                code.setCheckDigitCount(count);
            }
            catch (NumberFormatException e) {
                log.error("Invalid number for checkdigit count: {}", (Object)checkdigitCount);
                code.setCheckDigitCount(0);
            }
        }
        if (startDelimiter != null && startDelimiter.length() >= 1) {
            code.setStartDelimiter(Character.valueOf(startDelimiter.charAt(0)));
        }
        if (stopDelimiter != null && stopDelimiter.length() >= 1) {
            code.setStopDelimiter(Character.valueOf(stopDelimiter.charAt(0)));
        }
        try {
            code.setContent(s);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

