/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.awt.geom.Rectangle2D;
import java.math.BigInteger;
import uk.org.okapibarcode.backend.HumanReadableAlignment;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.TextBox;

public class UspsOneCode
extends Symbol {
    private static final int[] APPX_D_I = new int[]{31, 7936, 47, 7808, 55, 7552, 59, 7040, 61, 6016, 62, 3968, 79, 7744, 87, 7488, 91, 6976, 93, 5952, 94, 3904, 103, 7360, 107, 6848, 109, 5824, 110, 3776, 115, 6592, 117, 5568, 118, 3520, 121, 5056, 122, 3008, 124, 1984, 143, 7712, 151, 7456, 155, 6944, 157, 5920, 158, 3872, 167, 7328, 171, 6816, 173, 5792, 174, 3744, 179, 6560, 181, 5536, 182, 3488, 185, 5024, 186, 2976, 188, 1952, 199, 7264, 203, 6752, 205, 5728, 206, 3680, 211, 6496, 213, 5472, 214, 3424, 217, 4960, 218, 2912, 220, 1888, 227, 6368, 229, 5344, 230, 3296, 233, 4832, 234, 2784, 236, 1760, 241, 4576, 242, 2528, 244, 1504, 248, 992, 271, 7696, 279, 7440, 283, 6928, 285, 5904, 286, 3856, 295, 7312, 299, 6800, 301, 5776, 302, 3728, 307, 6544, 309, 5520, 310, 3472, 313, 5008, 314, 2960, 316, 1936, 327, 7248, 331, 6736, 333, 5712, 334, 3664, 339, 6480, 341, 5456, 342, 3408, 345, 4944, 346, 2896, 348, 1872, 355, 6352, 357, 5328, 358, 3280, 361, 4816, 362, 2768, 364, 1744, 369, 4560, 370, 2512, 372, 1488, 376, 976, 391, 7216, 395, 6704, 397, 5680, 398, 3632, 403, 6448, 405, 5424, 406, 3376, 409, 4912, 410, 2864, 412, 1840, 419, 6320, 421, 5296, 422, 3248, 425, 4784, 426, 2736, 428, 1712, 433, 4528, 434, 2480, 436, 1456, 440, 944, 451, 6256, 453, 5232, 454, 3184, 457, 4720, 458, 2672, 460, 1648, 465, 4464, 466, 2416, 468, 1392, 472, 880, 481, 4336, 482, 2288, 484, 1264, 488, 752, 527, 7688, 535, 7432, 539, 6920, 541, 5896, 542, 3848, 551, 7304, 555, 6792, 557, 5768, 558, 3720, 563, 6536, 565, 5512, 566, 3464, 569, 5000, 570, 2952, 572, 1928, 583, 7240, 587, 6728, 589, 5704, 590, 3656, 595, 6472, 597, 5448, 598, 3400, 601, 4936, 602, 2888, 604, 1864, 611, 6344, 613, 5320, 614, 3272, 617, 4808, 618, 2760, 620, 1736, 625, 4552, 626, 2504, 628, 1480, 632, 968, 647, 7208, 651, 6696, 653, 5672, 654, 3624, 659, 6440, 661, 5416, 662, 3368, 665, 4904, 666, 2856, 668, 1832, 675, 6312, 677, 5288, 678, 3240, 681, 4776, 682, 2728, 684, 1704, 689, 4520, 690, 2472, 692, 1448, 696, 936, 707, 6248, 709, 5224, 710, 3176, 713, 4712, 714, 2664, 716, 1640, 721, 4456, 722, 2408, 724, 1384, 728, 872, 737, 4328, 738, 2280, 740, 1256, 775, 7192, 779, 6680, 781, 5656, 782, 3608, 787, 6424, 789, 5400, 790, 3352, 793, 4888, 794, 2840, 796, 1816, 803, 6296, 805, 5272, 806, 3224, 809, 4760, 810, 2712, 812, 1688, 817, 4504, 818, 2456, 820, 1432, 824, 920, 835, 6232, 837, 5208, 838, 3160, 841, 4696, 842, 2648, 844, 1624, 849, 4440, 850, 2392, 852, 1368, 865, 4312, 866, 2264, 868, 1240, 899, 6200, 901, 5176, 902, 3128, 905, 4664, 906, 2616, 908, 1592, 913, 4408, 914, 2360, 916, 1336, 929, 4280, 930, 2232, 932, 1208, 961, 4216, 962, 2168, 964, 1144, 1039, 7684, 1047, 7428, 1051, 6916, 1053, 5892, 1054, 3844, 1063, 7300, 1067, 6788, 1069, 5764, 1070, 3716, 1075, 6532, 1077, 5508, 1078, 3460, 1081, 4996, 1082, 2948, 1084, 1924, 1095, 7236, 1099, 6724, 1101, 5700, 1102, 3652, 1107, 6468, 1109, 5444, 1110, 3396, 1113, 4932, 1114, 2884, 1116, 1860, 1123, 6340, 1125, 5316, 1126, 3268, 1129, 4804, 1130, 2756, 1132, 1732, 1137, 4548, 1138, 2500, 1140, 1476, 1159, 7204, 1163, 6692, 1165, 5668, 1166, 3620, 1171, 6436, 1173, 5412, 1174, 3364, 1177, 4900, 1178, 2852, 1180, 1828, 1187, 6308, 1189, 5284, 1190, 3236, 1193, 4772, 1194, 2724, 1196, 1700, 1201, 4516, 1202, 2468, 1204, 1444, 1219, 6244, 1221, 5220, 1222, 3172, 1225, 4708, 1226, 2660, 1228, 1636, 1233, 4452, 1234, 2404, 1236, 1380, 1249, 4324, 1250, 2276, 1287, 7188, 1291, 6676, 1293, 5652, 1294, 3604, 1299, 6420, 1301, 5396, 1302, 3348, 1305, 4884, 1306, 2836, 1308, 1812, 1315, 6292, 1317, 5268, 1318, 3220, 1321, 4756, 1322, 2708, 1324, 1684, 1329, 4500, 1330, 2452, 1332, 1428, 1347, 6228, 1349, 5204, 1350, 3156, 1353, 4692, 1354, 2644, 1356, 1620, 1361, 4436, 1362, 2388, 1377, 4308, 1378, 2260, 1411, 6196, 1413, 5172, 1414, 3124, 1417, 4660, 1418, 2612, 1420, 1588, 1425, 4404, 1426, 2356, 1441, 4276, 1442, 2228, 1473, 4212, 1474, 2164, 1543, 7180, 1547, 6668, 1549, 5644, 1550, 3596, 1555, 6412, 1557, 5388, 1558, 3340, 1561, 4876, 1562, 2828, 1564, 1804, 1571, 6284, 1573, 5260, 1574, 3212, 1577, 4748, 1578, 2700, 1580, 1676, 1585, 4492, 1586, 2444, 1603, 6220, 1605, 5196, 1606, 3148, 1609, 4684, 1610, 2636, 1617, 4428, 1618, 2380, 1633, 4300, 1634, 2252, 1667, 6188, 1669, 5164, 1670, 3116, 1673, 4652, 1674, 2604, 1681, 4396, 1682, 2348, 1697, 4268, 1698, 2220, 1729, 4204, 1730, 2156, 1795, 6172, 1797, 5148, 1798, 3100, 1801, 4636, 1802, 2588, 1809, 4380, 1810, 2332, 1825, 4252, 1826, 2204, 1857, 4188, 1858, 2140, 1921, 4156, 1922, 2108, 2063, 7682, 2071, 7426, 2075, 6914, 2077, 5890, 2078, 3842, 2087, 7298, 2091, 6786, 2093, 5762, 2094, 3714, 2099, 6530, 2101, 5506, 2102, 3458, 2105, 4994, 2106, 2946, 2119, 7234, 2123, 6722, 2125, 5698, 2126, 3650, 2131, 6466, 2133, 5442, 2134, 3394, 2137, 4930, 2138, 2882, 2147, 6338, 2149, 5314, 2150, 3266, 2153, 4802, 2154, 2754, 2161, 4546, 2162, 2498, 2183, 7202, 2187, 6690, 2189, 5666, 2190, 3618, 2195, 6434, 2197, 5410, 2198, 3362, 2201, 4898, 2202, 2850, 2211, 6306, 2213, 5282, 2214, 3234, 2217, 4770, 2218, 2722, 2225, 4514, 2226, 2466, 2243, 6242, 2245, 5218, 2246, 3170, 2249, 4706, 2250, 2658, 2257, 4450, 2258, 2402, 2273, 4322, 2311, 7186, 2315, 6674, 2317, 5650, 2318, 3602, 2323, 6418, 2325, 5394, 2326, 3346, 2329, 4882, 2330, 2834, 2339, 6290, 2341, 5266, 2342, 3218, 2345, 4754, 2346, 2706, 2353, 4498, 2354, 2450, 2371, 6226, 2373, 5202, 2374, 3154, 2377, 4690, 2378, 2642, 2385, 4434, 2401, 4306, 2435, 6194, 2437, 5170, 2438, 3122, 2441, 4658, 2442, 2610, 2449, 4402, 2465, 4274, 2497, 4210, 2567, 7178, 2571, 6666, 2573, 5642, 2574, 3594, 2579, 6410, 2581, 5386, 2582, 3338, 2585, 4874, 2586, 2826, 2595, 6282, 2597, 5258, 2598, 3210, 2601, 4746, 2602, 2698, 2609, 4490, 2627, 6218, 2629, 5194, 2630, 3146, 2633, 4682, 2641, 4426, 2657, 4298, 2691, 6186, 2693, 5162, 2694, 3114, 2697, 4650, 2705, 4394, 2721, 4266, 2753, 4202, 2819, 6170, 2821, 5146, 2822, 3098, 2825, 4634, 2833, 4378, 2849, 4250, 2881, 4186, 2945, 4154, 3079, 7174, 3083, 6662, 3085, 5638, 3086, 3590, 3091, 6406, 3093, 5382, 3094, 3334, 3097, 4870, 3107, 6278, 3109, 5254, 3110, 3206, 3113, 4742, 3121, 4486, 3139, 6214, 3141, 5190, 3145, 4678, 3153, 4422, 3169, 4294, 3203, 6182, 3205, 5158, 3209, 4646, 3217, 4390, 3233, 4262, 3265, 4198, 3331, 6166, 3333, 5142, 3337, 4630, 3345, 4374, 3361, 4246, 3393, 4182, 3457, 4150, 3587, 6158, 3589, 5134, 3593, 4622, 3601, 4366, 3617, 4238, 3649, 4174, 3713, 4142, 3841, 4126, 4111, 7681, 4119, 7425, 4123, 6913, 4125, 5889, 4135, 7297, 4139, 6785, 4141, 5761, 4147, 6529, 4149, 5505, 4153, 4993, 4167, 7233, 4171, 6721, 4173, 5697, 4179, 6465, 4181, 5441, 4185, 4929, 4195, 6337, 4197, 5313, 4201, 4801, 4209, 4545, 4231, 7201, 4235, 6689, 4237, 5665, 4243, 6433, 4245, 5409, 4249, 4897, 4259, 6305, 4261, 5281, 4265, 4769, 4273, 4513, 4291, 6241, 4293, 5217, 4297, 4705, 4305, 4449, 4359, 7185, 4363, 6673, 4365, 5649, 4371, 6417, 4373, 5393, 4377, 4881, 4387, 6289, 4389, 5265, 4393, 4753, 4401, 4497, 4419, 6225, 4421, 5201, 4425, 4689, 4483, 6193, 4485, 5169, 4489, 4657, 4615, 7177, 4619, 6665, 4621, 5641, 4627, 6409, 4629, 5385, 4633, 4873, 4643, 6281, 4645, 5257, 4649, 4745, 4675, 6217, 4677, 5193, 4739, 6185, 4741, 5161, 4867, 6169, 4869, 5145, 5127, 7173, 5131, 6661, 5133, 5637, 5139, 6405, 5141, 5381, 5155, 6277, 5157, 5253, 5187, 6213, 5251, 6181, 5379, 6165, 5635, 6157, 6151, 7171, 6155, 6659, 6163, 6403, 6179, 6275, 6211, 5189, 4681, 4433, 4321, 3142, 2634, 2386, 2274, 1612, 1364, 1252, 856, 744, 496};
    private static final int[] APPX_D_II = new int[]{3, 6144, 5, 5120, 6, 3072, 9, 4608, 10, 2560, 12, 1536, 17, 4352, 18, 2304, 20, 1280, 24, 768, 33, 4224, 34, 2176, 36, 1152, 40, 640, 48, 384, 65, 4160, 66, 2112, 68, 1088, 72, 576, 80, 320, 96, 192, 129, 4128, 130, 2080, 132, 1056, 136, 544, 144, 288, 257, 4112, 258, 2064, 260, 1040, 264, 528, 513, 4104, 514, 2056, 516, 1032, 1025, 4100, 1026, 2052, 2049, 4098, 4097, 2050, 1028, 520, 272, 160};
    private static final int[] APPX_D_IV = new int[]{67, 6, 78, 16, 86, 95, 34, 40, 45, 113, 117, 121, 62, 87, 18, 104, 41, 76, 57, 119, 115, 72, 97, 2, 127, 26, 105, 35, 122, 52, 114, 7, 24, 82, 68, 63, 94, 44, 77, 112, 70, 100, 39, 30, 107, 15, 125, 85, 10, 65, 54, 88, 20, 106, 46, 66, 8, 116, 29, 61, 99, 80, 90, 37, 123, 51, 25, 84, 129, 56, 4, 109, 96, 28, 36, 47, 11, 71, 33, 102, 21, 9, 17, 49, 124, 79, 64, 91, 42, 69, 53, 60, 14, 1, 27, 103, 126, 75, 89, 50, 120, 19, 32, 110, 92, 111, 130, 59, 31, 12, 81, 43, 55, 5, 74, 22, 101, 128, 58, 118, 48, 108, 38, 98, 93, 23, 83, 13, 73, 3};
    private double moduleWidthRatio;
    private double shortHeightPercentage;
    private double longHeightPercentage;

    public UspsOneCode() {
        this.default_height = 8;
        this.humanReadableLocation = HumanReadableLocation.NONE;
        this.humanReadableAlignment = HumanReadableAlignment.LEFT;
        this.moduleWidthRatio = 1.43;
        this.shortHeightPercentage = 0.25;
        this.longHeightPercentage = 0.625;
    }

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    public void setShortHeightPercentage(double shortHeightPercentage) {
        if (shortHeightPercentage < 0.0 || shortHeightPercentage > 1.0) {
            throw new IllegalArgumentException("Height percentage must be between 0 and 1.");
        }
        this.shortHeightPercentage = shortHeightPercentage;
    }

    public double getShortHeightPercentage() {
        return this.shortHeightPercentage;
    }

    public void setLongHeightPercentage(double longHeightPercentage) {
        if (longHeightPercentage < 0.0 || longHeightPercentage > 1.0) {
            throw new IllegalArgumentException("Height percentage must be between 0 and 1.");
        }
        this.longHeightPercentage = longHeightPercentage;
    }

    public double getLongHeightPercentage() {
        return this.longHeightPercentage;
    }

    @Override
    protected void encode() {
        int i;
        String zip = "";
        String tracker = "";
        int length = this.content.length();
        int[] codeword = new int[10];
        int[] characters = new int[10];
        boolean[] bar_map = new boolean[130];
        if (!this.content.matches("[0-9-]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        if (length > 32) {
            throw new OkapiException("Input too long");
        }
        int j = 0;
        for (i = 0; i < length; ++i) {
            if (this.content.charAt(i) == '-') {
                j = 1;
                continue;
            }
            if (j == 0) {
                tracker = tracker + this.content.charAt(i);
                continue;
            }
            zip = zip + this.content.charAt(i);
        }
        if (tracker.length() != 20) {
            throw new OkapiException("Invalid length tracking code");
        }
        if (zip.length() > 11) {
            throw new OkapiException("Invalid ZIP code");
        }
        BigInteger x_reg = zip.length() > 0 ? new BigInteger(zip) : new BigInteger("0");
        String zip_adder = zip.length() > 9 ? "1000100001" : (zip.length() > 5 ? "100001" : (zip.length() > 0 ? "1" : "0"));
        BigInteger accum = new BigInteger(zip_adder);
        accum = accum.add(x_reg);
        accum = accum.multiply(BigInteger.valueOf(10L));
        accum = accum.add(BigInteger.valueOf(Character.getNumericValue(tracker.charAt(0))));
        accum = accum.multiply(BigInteger.valueOf(5L));
        accum = accum.add(BigInteger.valueOf(Character.getNumericValue(tracker.charAt(1))));
        for (i = 2; i < tracker.length(); ++i) {
            accum = accum.multiply(BigInteger.valueOf(10L));
            accum = accum.add(BigInteger.valueOf(Character.getNumericValue(tracker.charAt(i))));
        }
        int[] byte_array = new int[13];
        for (i = 0; i < byte_array.length; ++i) {
            BigInteger mask = accum.shiftRight(96 - 8 * i);
            mask = mask.and(new BigInteger("255"));
            byte_array[i] = mask.intValue();
        }
        int usps_crc = UspsOneCode.USPS_MSB_Math_CRC11GenerateFrameCheckSequence(byte_array);
        x_reg = accum.mod(BigInteger.valueOf(636L));
        codeword[9] = x_reg.intValue();
        accum = accum.subtract(x_reg);
        accum = accum.divide(BigInteger.valueOf(636L));
        for (i = 8; i >= 0; --i) {
            x_reg = accum.mod(BigInteger.valueOf(1365L));
            codeword[i] = x_reg.intValue();
            accum = accum.subtract(x_reg);
            accum = accum.divide(BigInteger.valueOf(1365L));
        }
        for (i = 0; i < 9; ++i) {
            if (codeword[i] != 1365) continue;
            codeword[i] = 0;
        }
        codeword[9] = codeword[9] * 2;
        if (usps_crc >= 1024) {
            codeword[0] = codeword[0] + 659;
        }
        this.info("Codewords: ");
        for (i = 0; i < 10; ++i) {
            this.infoSpace(codeword[i]);
        }
        this.infoLine();
        for (i = 0; i < 10; ++i) {
            characters[i] = codeword[i] < 1287 ? APPX_D_I[codeword[i]] : APPX_D_II[codeword[i] - 1287];
        }
        for (i = 0; i < 10; ++i) {
            if ((usps_crc & 1 << i) == 0) continue;
            characters[i] = 8191 - characters[i];
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 13; ++j) {
                bar_map[UspsOneCode.APPX_D_IV[13 * i + j] - 1] = (characters[i] & 1 << j) != 0;
            }
        }
        this.readable = UspsOneCode.formatHumanReadableText(this.content);
        this.pattern = new String[1];
        this.row_count = 1;
        this.row_height = new int[1];
        this.row_height[0] = -1;
        this.pattern[0] = "";
        for (i = 0; i < 65; ++i) {
            char c = 'T';
            if (bar_map[i]) {
                c = 'D';
            }
            if (bar_map[i + 65]) {
                c = 'A';
            }
            if (bar_map[i] && bar_map[i + 65]) {
                c = 'F';
            }
            this.pattern[0] = this.pattern[0] + c;
        }
        this.infoLine("Encoding: " + this.pattern[0]);
    }

    private static int USPS_MSB_Math_CRC11GenerateFrameCheckSequence(int[] bytes) {
        int bit;
        int generatorPolynomial = 3893;
        int frameCheckSequence = 2047;
        int byteArrayPtr = 0;
        int data = bytes[byteArrayPtr] << 5;
        ++byteArrayPtr;
        for (bit = 2; bit < 8; ++bit) {
            frameCheckSequence = ((frameCheckSequence ^ data) & 0x400) != 0 ? frameCheckSequence << 1 ^ generatorPolynomial : (frameCheckSequence <<= 1);
            frameCheckSequence &= 0x7FF;
            data <<= 1;
        }
        for (int byteIndex = 1; byteIndex < 13; ++byteIndex) {
            data = bytes[byteArrayPtr] << 3;
            ++byteArrayPtr;
            for (bit = 0; bit < 8; ++bit) {
                frameCheckSequence = ((frameCheckSequence ^ data) & 0x400) != 0 ? frameCheckSequence << 1 ^ generatorPolynomial : (frameCheckSequence <<= 1);
                frameCheckSequence &= 0x7FF;
                data <<= 1;
            }
        }
        return frameCheckSequence;
    }

    protected static String formatHumanReadableText(String content) {
        StringBuilder hrt = new StringBuilder(50);
        boolean mid9 = false;
        boolean tracing = true;
        boolean pimb = true;
        boolean mpe5 = false;
        int i = 0;
        for (char c : content.toCharArray()) {
            if (c < '0' || c > '9') continue;
            if (i == 5 && c == '9') {
                mid9 = true;
            }
            if (i == 2 && c != '0' || i == 3 && c != '5' || i == 4 && c != '0' && c != '2') {
                tracing = false;
            }
            if (i == 0 && c != '9' || i == 1 && c != '4') {
                pimb = false;
            }
            if (i == 5 && c == '5') {
                mpe5 = true;
            }
            if (i == 2 || i == 5 || i == 6 && pimb || i == 10 && pimb || i == 13 && pimb && !mpe5 || i == 15 && pimb && !mpe5 || i == 11 && !mid9 && !tracing && !pimb || i == 14 && mid9 && !tracing && !pimb || i == 20 || i == 25 || i == 29) {
                hrt.append(' ');
            }
            hrt.append(c);
            ++i;
        }
        return hrt.toString().trim();
    }

    @Override
    protected void plotSymbol() {
        this.rectangles.clear();
        this.texts.clear();
        int baseY = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        double x = 0.0;
        double w = this.moduleWidth;
        double y = 0.0;
        double h = 0.0;
        double dx = (1.0 + this.moduleWidthRatio) * w;
        int shortHeight = (int)(this.shortHeightPercentage * (double)this.default_height);
        int longHeight = (int)(this.longHeightPercentage * (double)this.default_height);
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = baseY;
                    h = longHeight;
                    break;
                }
                case 'D': {
                    y = baseY + this.default_height - longHeight;
                    h = longHeight;
                    break;
                }
                case 'F': {
                    y = baseY;
                    h = this.default_height;
                    break;
                }
                case 'T': {
                    y = baseY + this.default_height - longHeight;
                    h = shortHeight;
                }
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
            this.rectangles.add(rect);
            x += dx;
        }
        this.symbol_width = (int)Math.ceil((double)(this.pattern[0].length() - 1) * dx + w);
        this.symbol_height = this.default_height;
        if (this.humanReadableLocation != HumanReadableLocation.NONE && !this.readable.isEmpty()) {
            double baseline = this.humanReadableLocation == HumanReadableLocation.TOP ? (double)this.fontSize : (double)(this.symbol_height + this.fontSize);
            this.texts.add(new TextBox(0.0, baseline, this.symbol_width, this.readable, this.humanReadableAlignment));
        }
    }
}

