/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.io.UnsupportedEncodingException;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.util.Arrays;

public class MicroQrCode
extends Symbol {
    private static final char[] RHODIUM = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int[] QR_ANNEX_C1 = new int[]{17477, 16754, 20011, 19228, 21934, 20633, 24512, 23287, 26515, 25252, 28157, 26826, 30328, 29519, 31766, 31009, 1758, 1001, 3248, 2439, 5941, 4610, 7515, 6252, 9480, 8255, 12134, 10833, 13539, 12756, 16013, 15290};
    private static final int[] MICRO_QR_SIZES = new int[]{11, 13, 15, 17};
    private int preferredVersion;
    private EccMode preferredEccLevel = EccMode.L;
    private qrMode[] inputMode;
    private StringBuilder binary;
    private int[] binaryCount = new int[4];
    private int[] grid;
    private int[] eval;

    public void setPreferredVersion(int version) {
        if (version < 0 || version > 4) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        this.preferredVersion = version;
    }

    public int getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setEccMode(EccMode eccMode) {
        this.preferredEccLevel = eccMode;
    }

    public EccMode getEccMode() {
        return this.preferredEccLevel;
    }

    @Override
    protected void encode() {
        int j;
        int i;
        boolean[] version_valid = new boolean[4];
        StringBuilder bin = new StringBuilder();
        if (this.content.length() > 35) {
            throw new OkapiException("Input data too long");
        }
        this.inputCharCheck();
        for (i = 0; i < 4; ++i) {
            version_valid[i] = true;
        }
        this.inputMode = new qrMode[40];
        this.selectEncodingMode();
        int n_count = 0;
        int a_count = 0;
        for (i = 0; i < this.content.length(); ++i) {
            if (this.content.charAt(i) >= '0' && this.content.charAt(i) <= '9') {
                ++n_count;
            }
            if (!this.isAlphanumeric(this.content.charAt(i))) continue;
            ++a_count;
        }
        if (a_count == this.content.length()) {
            for (i = 0; i < this.content.length(); ++i) {
                this.inputMode[i] = qrMode.ALPHANUM;
            }
        }
        if (n_count == this.content.length()) {
            for (i = 0; i < this.content.length(); ++i) {
                this.inputMode[i] = qrMode.NUMERIC;
            }
        }
        boolean byteModeUsed = false;
        boolean alphanumModeUsed = false;
        boolean kanjiModeUsed = false;
        for (i = 0; i < this.content.length(); ++i) {
            if (this.inputMode[i] == qrMode.BINARY) {
                byteModeUsed = true;
            }
            if (this.inputMode[i] == qrMode.ALPHANUM) {
                alphanumModeUsed = true;
            }
            if (this.inputMode[i] != qrMode.KANJI) continue;
            kanjiModeUsed = true;
        }
        this.getBinaryLength();
        if (byteModeUsed) {
            version_valid[0] = false;
            version_valid[1] = false;
        }
        if (alphanumModeUsed) {
            version_valid[0] = false;
        }
        if (kanjiModeUsed) {
            version_valid[0] = false;
            version_valid[1] = false;
        }
        if (this.binaryCount[0] > 20) {
            version_valid[0] = false;
        }
        if (this.binaryCount[1] > 40) {
            version_valid[1] = false;
        }
        if (this.binaryCount[2] > 84) {
            version_valid[2] = false;
        }
        if (this.binaryCount[3] > 128) {
            throw new OkapiException("Input data too long");
        }
        EccMode ecc_level = this.preferredEccLevel;
        if (ecc_level == EccMode.H) {
            throw new OkapiException("Error correction level H not available");
        }
        if (ecc_level == EccMode.Q) {
            version_valid[0] = false;
            version_valid[1] = false;
            version_valid[2] = false;
            if (this.binaryCount[3] > 80) {
                throw new OkapiException("Input data too long");
            }
        }
        if (ecc_level == EccMode.M) {
            version_valid[0] = false;
            if (this.binaryCount[1] > 32) {
                version_valid[1] = false;
            }
            if (this.binaryCount[2] > 68) {
                version_valid[2] = false;
            }
            if (this.binaryCount[3] > 112) {
                throw new OkapiException("Input data too long");
            }
        }
        int autoversion = 3;
        if (version_valid[2]) {
            autoversion = 2;
        }
        if (version_valid[1]) {
            autoversion = 1;
        }
        if (version_valid[0]) {
            autoversion = 0;
        }
        int version = autoversion;
        if (this.preferredVersion >= 1 && this.preferredVersion <= 4 && this.preferredVersion - 1 >= autoversion) {
            version = this.preferredVersion - 1;
        }
        if (version == 3) {
            if (this.binaryCount[3] <= 112) {
                ecc_level = EccMode.M;
            }
            if (this.binaryCount[3] <= 80) {
                ecc_level = EccMode.Q;
            }
        }
        if (version == 2 && this.binaryCount[2] <= 68) {
            ecc_level = EccMode.M;
        }
        if (version == 1 && this.binaryCount[1] <= 32) {
            ecc_level = EccMode.M;
        }
        this.binary = new StringBuilder();
        this.generateBinary(version);
        if (this.binary.length() > 128) {
            throw new OkapiException("Input data too long");
        }
        switch (version) {
            case 0: {
                this.generateM1Symbol();
                this.infoLine("Version: M1");
                break;
            }
            case 1: {
                this.generateM2Symbol(ecc_level);
                this.infoLine("Version: M2");
                this.infoLine("ECC Level: " + this.levelToLetter(ecc_level));
                break;
            }
            case 2: {
                this.generateM3Symbol(ecc_level);
                this.infoLine("Version: M3");
                this.infoLine("ECC Level: " + this.levelToLetter(ecc_level));
                break;
            }
            case 3: {
                this.generateM4Symbol(ecc_level);
                this.infoLine("Version: M4");
                this.infoLine("ECC Level: " + this.levelToLetter(ecc_level));
            }
        }
        int size = MICRO_QR_SIZES[version];
        this.grid = new int[size * size];
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                this.grid[i * size + j] = 0;
            }
        }
        this.setupBitGrid(size);
        this.populateBitGrid(size);
        int bitmask = this.applyBitmask(size);
        this.infoLine("Mask Pattern: " + Integer.toBinaryString(bitmask));
        int format = 0;
        block6 : switch (version) {
            case 1: {
                switch (ecc_level) {
                    case L: {
                        format = 1;
                        break;
                    }
                    case M: {
                        format = 2;
                    }
                }
                break;
            }
            case 2: {
                switch (ecc_level) {
                    case L: {
                        format = 3;
                        break;
                    }
                    case M: {
                        format = 4;
                    }
                }
                break;
            }
            case 3: {
                switch (ecc_level) {
                    case L: {
                        format = 5;
                        break block6;
                    }
                    case M: {
                        format = 6;
                        break block6;
                    }
                    case Q: {
                        format = 7;
                    }
                }
            }
        }
        int format_full = QR_ANNEX_C1[(format << 2) + bitmask];
        if ((format_full & 0x4000) != 0) {
            int n = 8 * size + 1;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x2000) != 0) {
            int n = 8 * size + 2;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x1000) != 0) {
            int n = 8 * size + 3;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x800) != 0) {
            int n = 8 * size + 4;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x400) != 0) {
            int n = 8 * size + 5;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x200) != 0) {
            int n = 8 * size + 6;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x100) != 0) {
            int n = 8 * size + 7;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x80) != 0) {
            int n = 8 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x40) != 0) {
            int n = 7 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x20) != 0) {
            int n = 6 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 0x10) != 0) {
            int n = 5 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 8) != 0) {
            int n = 4 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 4) != 0) {
            int n = 3 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 2) != 0) {
            int n = 2 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        if ((format_full & 1) != 0) {
            int n = 1 * size + 8;
            this.grid[n] = this.grid[n] + 1;
        }
        this.readable = "";
        this.pattern = new String[size];
        this.row_count = size;
        this.row_height = new int[size];
        for (i = 0; i < size; ++i) {
            bin.setLength(0);
            for (j = 0; j < size; ++j) {
                if ((this.grid[i * size + j] & 1) != 0) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.pattern[i] = MicroQrCode.bin2pat(bin);
            this.row_height[i] = 1;
        }
    }

    private void inputCharCheck() {
        byte[] temp;
        int i;
        if (this.content.matches("[\u0000-\u00ff]+")) {
            return;
        }
        int qmarkBefore = 0;
        for (i = 0; i < this.content.length(); ++i) {
            if (this.content.charAt(i) != '?') continue;
            ++qmarkBefore;
        }
        try {
            temp = this.content.getBytes("SJIS");
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiException("Character encoding error");
        }
        int qmarkAfter = 0;
        for (i = 0; i < temp.length; ++i) {
            if (temp[i] != 63) continue;
            ++qmarkAfter;
        }
        if (qmarkBefore != qmarkAfter) {
            throw new OkapiException("Invalid characters in input data");
        }
    }

    private char levelToLetter(EccMode ecc_mode) {
        switch (ecc_mode) {
            case L: {
                return 'L';
            }
            case M: {
                return 'M';
            }
            case Q: {
                return 'Q';
            }
            case H: {
                return 'H';
            }
        }
        return ' ';
    }

    private void selectEncodingMode() {
        int j;
        int mlen;
        int i;
        int length = this.content.length();
        for (i = 0; i < length; ++i) {
            if (this.content.charAt(i) > '\u00ff') {
                this.inputMode[i] = qrMode.KANJI;
                continue;
            }
            this.inputMode[i] = qrMode.BINARY;
            if (this.isAlphanumeric(this.content.charAt(i))) {
                this.inputMode[i] = qrMode.ALPHANUM;
            }
            if (this.content.charAt(i) < '0' || this.content.charAt(i) > '9') continue;
            this.inputMode[i] = qrMode.NUMERIC;
        }
        for (i = 0; i < length; ++i) {
            if (this.inputMode[i] != qrMode.NUMERIC || (i == 0 || this.inputMode[i - 1] == qrMode.NUMERIC) && i != 0) continue;
            mlen = 0;
            while (mlen + i < length && this.inputMode[mlen + i] == qrMode.NUMERIC) {
                ++mlen;
            }
            if (mlen >= 6) continue;
            for (j = 0; j < mlen; ++j) {
                this.inputMode[i + j] = qrMode.ALPHANUM;
            }
        }
        for (i = 0; i < length; ++i) {
            if (this.inputMode[i] != qrMode.ALPHANUM || (i == 0 || this.inputMode[i - 1] == qrMode.ALPHANUM) && i != 0) continue;
            mlen = 0;
            while (mlen + i < length && this.inputMode[mlen + i] == qrMode.ALPHANUM) {
                ++mlen;
            }
            if (mlen >= 6) continue;
            for (j = 0; j < mlen; ++j) {
                this.inputMode[i + j] = qrMode.BINARY;
            }
        }
    }

    private boolean isAlphanumeric(char cglyph) {
        boolean retval = false;
        if (cglyph >= '0' && cglyph <= '9') {
            retval = true;
        }
        if (cglyph >= 'A' && cglyph <= 'Z') {
            retval = true;
        }
        switch (cglyph) {
            case ' ': 
            case '$': 
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': {
                retval = true;
            }
        }
        return retval;
    }

    private String toBinary(int data, int h) {
        StringBuilder binary = new StringBuilder();
        while (h != 0) {
            if ((data & h) != 0) {
                binary.append('1');
            } else {
                binary.append('0');
            }
            h >>= 1;
        }
        return binary.toString();
    }

    private void getBinaryLength() {
        int i;
        qrMode currentMode = qrMode.NULL;
        for (i = 0; i < 4; ++i) {
            this.binaryCount[i] = 0;
        }
        for (i = 0; i < this.content.length(); ++i) {
            if (currentMode == this.inputMode[i]) continue;
            int blockLength = 0;
            while (i + ++blockLength < this.content.length() && this.inputMode[i + blockLength] == this.inputMode[i]) {
            }
            switch (this.inputMode[i]) {
                case KANJI: {
                    this.binaryCount[2] = this.binaryCount[2] + (5 + blockLength * 13);
                    this.binaryCount[3] = this.binaryCount[3] + (7 + blockLength * 13);
                    break;
                }
                case BINARY: {
                    this.binaryCount[2] = this.binaryCount[2] + (6 + blockLength * 8);
                    this.binaryCount[3] = this.binaryCount[3] + (8 + blockLength * 8);
                    break;
                }
                case ALPHANUM: {
                    int alphaLength;
                    if (blockLength % 2 == 1) {
                        alphaLength = (blockLength - 1) / 2 * 11;
                        alphaLength += 6;
                    } else {
                        alphaLength = blockLength / 2 * 11;
                    }
                    this.binaryCount[1] = this.binaryCount[1] + (4 + alphaLength);
                    this.binaryCount[2] = this.binaryCount[2] + (6 + alphaLength);
                    this.binaryCount[3] = this.binaryCount[3] + (8 + alphaLength);
                    break;
                }
                case NUMERIC: {
                    int numLength;
                    switch (blockLength % 3) {
                        case 1: {
                            numLength = (blockLength - 1) / 3 * 10;
                            numLength += 4;
                            break;
                        }
                        case 2: {
                            numLength = (blockLength - 2) / 3 * 10;
                            numLength += 7;
                            break;
                        }
                        default: {
                            numLength = blockLength / 3 * 10;
                        }
                    }
                    this.binaryCount[0] = this.binaryCount[0] + (3 + numLength);
                    this.binaryCount[1] = this.binaryCount[1] + (5 + numLength);
                    this.binaryCount[2] = this.binaryCount[2] + (7 + numLength);
                    this.binaryCount[3] = this.binaryCount[3] + (9 + numLength);
                }
            }
            currentMode = this.inputMode[i];
        }
        if (this.binaryCount[1] < 37) {
            this.binaryCount[1] = this.binaryCount[1] + 5;
        }
        if (this.binaryCount[2] < 81) {
            this.binaryCount[2] = this.binaryCount[2] + 7;
        }
        if (this.binaryCount[3] < 125) {
            this.binaryCount[3] = this.binaryCount[3] + 9;
        }
    }

    private void generateBinary(int version) {
        int blockLength;
        int position = 0;
        this.info("Encoding: ");
        block32: do {
            qrMode data_block = this.inputMode[position];
            blockLength = 0;
            while (++blockLength + position < this.content.length() && this.inputMode[position + blockLength] == data_block) {
            }
            switch (data_block) {
                case KANJI: {
                    int prod;
                    int i;
                    switch (version) {
                        case 2: {
                            this.binary.append("11");
                            break;
                        }
                        case 3: {
                            this.binary.append("011");
                        }
                    }
                    this.binary.append(this.toBinary(blockLength, 1 << version));
                    this.info("KANJ (" + blockLength + ") ");
                    for (i = 0; i < blockLength; ++i) {
                        byte[] jisBytes;
                        String oneChar = "";
                        oneChar = oneChar + this.content.charAt(position + i);
                        try {
                            jisBytes = oneChar.getBytes("SJIS");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new OkapiException("Character encoding error");
                        }
                        int jis = (jisBytes[0] & 0xFF) << 8;
                        if (jisBytes.length > 1) {
                            jis += jisBytes[1] & 0xFF;
                        }
                        jis = jis > 40959 ? (jis -= 49472) : (jis -= 33088);
                        int msb = (jis & 0xFF00) >> 8;
                        int lsb = jis & 0xFF;
                        prod = msb * 192 + lsb;
                        this.binary.append(this.toBinary(prod, 4096));
                        this.infoSpace(prod);
                    }
                    continue block32;
                }
                case BINARY: {
                    int i;
                    switch (version) {
                        case 2: {
                            this.binary.append("10");
                            break;
                        }
                        case 3: {
                            this.binary.append("010");
                        }
                    }
                    this.binary.append(this.toBinary(blockLength, 2 << version));
                    this.info("BYTE (" + blockLength + ") ");
                    for (i = 0; i < blockLength; ++i) {
                        char lbyte = this.content.charAt(position + i);
                        this.binary.append(this.toBinary(lbyte, 128));
                        this.infoSpace((int)lbyte);
                    }
                    continue block32;
                }
                case ALPHANUM: {
                    int second;
                    int count;
                    int first;
                    int prod;
                    int i;
                    switch (version) {
                        case 1: {
                            this.binary.append("1");
                            break;
                        }
                        case 2: {
                            this.binary.append("01");
                            break;
                        }
                        case 3: {
                            this.binary.append("001");
                        }
                    }
                    this.binary.append(this.toBinary(blockLength, 2 << version));
                    this.info("ALPH (" + blockLength + ") ");
                    for (i = 0; i < blockLength; i += 2) {
                        first = Arrays.positionOf(this.content.charAt(position + i), RHODIUM);
                        count = 1;
                        prod = first;
                        if (i + 1 < blockLength && this.inputMode[position + i + 1] == qrMode.ALPHANUM) {
                            second = Arrays.positionOf(this.content.charAt(position + i + 1), RHODIUM);
                            count = 2;
                            prod = first * 45 + second;
                        }
                        this.binary.append(this.toBinary(prod, 1 << 5 * count));
                        this.infoSpace(prod);
                    }
                    continue block32;
                }
                case NUMERIC: {
                    int second;
                    int count;
                    int first;
                    int prod;
                    int i;
                    switch (version) {
                        case 1: {
                            this.binary.append("0");
                            break;
                        }
                        case 2: {
                            this.binary.append("00");
                            break;
                        }
                        case 3: {
                            this.binary.append("000");
                        }
                    }
                    this.binary.append(this.toBinary(blockLength, 4 << version));
                    this.info("NUMB (" + blockLength + ") ");
                    for (i = 0; i < blockLength; i += 3) {
                        first = Character.getNumericValue(this.content.charAt(position + i));
                        count = 1;
                        prod = first;
                        if (i + 1 < blockLength && this.inputMode[position + i + 1] == qrMode.NUMERIC) {
                            second = Character.getNumericValue(this.content.charAt(position + i + 1));
                            count = 2;
                            prod = prod * 10 + second;
                        }
                        if (i + 2 < blockLength && this.inputMode[position + i + 2] == qrMode.NUMERIC) {
                            int third = Character.getNumericValue(this.content.charAt(position + i + 2));
                            count = 3;
                            prod = prod * 10 + third;
                        }
                        this.binary.append(this.toBinary(prod, 1 << 3 * count));
                        this.infoSpace(prod);
                    }
                }
            }
        } while ((position += blockLength) < this.content.length() - 1);
        switch (version) {
            case 0: {
                this.binary.append("000");
                break;
            }
            case 1: {
                if (this.binary.length() >= 37) break;
                this.binary.append("00000");
                break;
            }
            case 2: {
                if (this.binary.length() >= 81) break;
                this.binary.append("0000000");
                break;
            }
            case 3: {
                if (this.binary.length() >= 125) break;
                this.binary.append("000000000");
            }
        }
        this.infoLine();
    }

    private void generateM1Symbol() {
        int i;
        int[] data_blocks = new int[4];
        int[] ecc_blocks = new int[3];
        ReedSolomon rs = new ReedSolomon();
        int bits_total = 20;
        boolean latch = false;
        int bits_left = bits_total - this.binary.length();
        if (bits_left <= 4) {
            for (i = 0; i < bits_left; ++i) {
                this.binary.append("0");
            }
            latch = true;
        }
        if (!latch) {
            int remainder = 8 - this.binary.length() % 8;
            if (remainder == 8) {
                remainder = 0;
            }
            for (i = 0; i < remainder; ++i) {
                this.binary.append("0");
            }
            bits_left = bits_total - this.binary.length();
            if (bits_left > 4) {
                remainder = (bits_left - 4) / 8;
                for (i = 0; i < remainder; ++i) {
                    if ((i & 1) != 0) {
                        this.binary.append("00010001");
                        continue;
                    }
                    this.binary.append("11101100");
                }
            }
            this.binary.append("0000");
        }
        int data_codewords = 3;
        int ecc_codewords = 2;
        for (i = 0; i < data_codewords - 1; ++i) {
            data_blocks[i] = 0;
            if (this.binary.charAt(i * 8) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 128;
            }
            if (this.binary.charAt(i * 8 + 1) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 64;
            }
            if (this.binary.charAt(i * 8 + 2) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 32;
            }
            if (this.binary.charAt(i * 8 + 3) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 16;
            }
            if (this.binary.charAt(i * 8 + 4) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 8;
            }
            if (this.binary.charAt(i * 8 + 5) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 4;
            }
            if (this.binary.charAt(i * 8 + 6) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 2;
            }
            if (this.binary.charAt(i * 8 + 7) != '1') continue;
            int n = i;
            data_blocks[n] = data_blocks[n] + 1;
        }
        data_blocks[2] = 0;
        if (this.binary.charAt(16) == '1') {
            data_blocks[2] = data_blocks[2] + 8;
        }
        if (this.binary.charAt(17) == '1') {
            data_blocks[2] = data_blocks[2] + 4;
        }
        if (this.binary.charAt(18) == '1') {
            data_blocks[2] = data_blocks[2] + 2;
        }
        if (this.binary.charAt(19) == '1') {
            data_blocks[2] = data_blocks[2] + 1;
        }
        this.info("Codewords: ");
        for (i = 0; i < data_codewords; ++i) {
            this.infoSpace(data_blocks[i]);
        }
        this.infoLine();
        rs.init_gf(285);
        rs.init_code(ecc_codewords, 0);
        rs.encode(data_codewords, data_blocks);
        for (i = 0; i < ecc_codewords; ++i) {
            ecc_blocks[i] = rs.getResult(i);
        }
        for (i = 0; i < ecc_codewords; ++i) {
            this.binary.append(this.toBinary(ecc_blocks[ecc_codewords - i - 1], 128));
        }
    }

    private void generateM2Symbol(EccMode ecc_mode) {
        int i;
        int remainder;
        int[] data_blocks = new int[6];
        int[] ecc_blocks = new int[7];
        ReedSolomon rs = new ReedSolomon();
        int bits_total = 40;
        if (ecc_mode == EccMode.M) {
            bits_total = 32;
        }
        if ((remainder = 8 - this.binary.length() % 8) == 8) {
            remainder = 0;
        }
        for (i = 0; i < remainder; ++i) {
            this.binary.append("0");
        }
        int bits_left = bits_total - this.binary.length();
        remainder = bits_left / 8;
        for (i = 0; i < remainder; ++i) {
            if ((i & 1) != 0) {
                this.binary.append("00010001");
                continue;
            }
            this.binary.append("11101100");
        }
        int data_codewords = 5;
        int ecc_codewords = 5;
        if (ecc_mode == EccMode.M) {
            data_codewords = 4;
            ecc_codewords = 6;
        }
        for (i = 0; i < data_codewords; ++i) {
            data_blocks[i] = 0;
            if (this.binary.charAt(i * 8) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 128;
            }
            if (this.binary.charAt(i * 8 + 1) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 64;
            }
            if (this.binary.charAt(i * 8 + 2) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 32;
            }
            if (this.binary.charAt(i * 8 + 3) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 16;
            }
            if (this.binary.charAt(i * 8 + 4) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 8;
            }
            if (this.binary.charAt(i * 8 + 5) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 4;
            }
            if (this.binary.charAt(i * 8 + 6) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 2;
            }
            if (this.binary.charAt(i * 8 + 7) != '1') continue;
            int n = i;
            data_blocks[n] = data_blocks[n] + 1;
        }
        this.info("Codewords: ");
        for (i = 0; i < data_codewords; ++i) {
            this.infoSpace(data_blocks[i]);
        }
        this.infoLine();
        rs.init_gf(285);
        rs.init_code(ecc_codewords, 0);
        rs.encode(data_codewords, data_blocks);
        for (i = 0; i < ecc_codewords; ++i) {
            ecc_blocks[i] = rs.getResult(i);
        }
        for (i = 0; i < ecc_codewords; ++i) {
            this.binary.append(this.toBinary(ecc_blocks[ecc_codewords - i - 1], 128));
        }
    }

    private void generateM3Symbol(EccMode ecc_mode) {
        int i;
        int bits_left;
        int[] data_blocks = new int[12];
        int[] ecc_blocks = new int[12];
        ReedSolomon rs = new ReedSolomon();
        boolean latch = false;
        int bits_total = 84;
        if (ecc_mode == EccMode.M) {
            bits_total = 68;
        }
        if ((bits_left = bits_total - this.binary.length()) <= 4) {
            for (i = 0; i < bits_left; ++i) {
                this.binary.append("0");
            }
            latch = true;
        }
        if (!latch) {
            int remainder = 8 - this.binary.length() % 8;
            if (remainder == 8) {
                remainder = 0;
            }
            for (i = 0; i < remainder; ++i) {
                this.binary.append("0");
            }
            bits_left = bits_total - this.binary.length();
            if (bits_left > 4) {
                remainder = (bits_left - 4) / 8;
                for (i = 0; i < remainder; ++i) {
                    if ((i & 1) != 0) {
                        this.binary.append("00010001");
                        continue;
                    }
                    this.binary.append("11101100");
                }
            }
            this.binary.append("0000");
        }
        int data_codewords = 11;
        int ecc_codewords = 6;
        if (ecc_mode == EccMode.M) {
            data_codewords = 9;
            ecc_codewords = 8;
        }
        for (i = 0; i < data_codewords - 1; ++i) {
            data_blocks[i] = 0;
            if (this.binary.charAt(i * 8) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 128;
            }
            if (this.binary.charAt(i * 8 + 1) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 64;
            }
            if (this.binary.charAt(i * 8 + 2) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 32;
            }
            if (this.binary.charAt(i * 8 + 3) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 16;
            }
            if (this.binary.charAt(i * 8 + 4) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 8;
            }
            if (this.binary.charAt(i * 8 + 5) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 4;
            }
            if (this.binary.charAt(i * 8 + 6) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 2;
            }
            if (this.binary.charAt(i * 8 + 7) != '1') continue;
            int n = i;
            data_blocks[n] = data_blocks[n] + 1;
        }
        if (ecc_mode == EccMode.L) {
            data_blocks[10] = 0;
            if (this.binary.charAt(80) == '1') {
                data_blocks[10] = data_blocks[10] + 8;
            }
            if (this.binary.charAt(81) == '1') {
                data_blocks[10] = data_blocks[10] + 4;
            }
            if (this.binary.charAt(82) == '1') {
                data_blocks[10] = data_blocks[10] + 2;
            }
            if (this.binary.charAt(83) == '1') {
                data_blocks[10] = data_blocks[10] + 1;
            }
        }
        if (ecc_mode == EccMode.M) {
            data_blocks[8] = 0;
            if (this.binary.charAt(64) == '1') {
                data_blocks[8] = data_blocks[8] + 8;
            }
            if (this.binary.charAt(65) == '1') {
                data_blocks[8] = data_blocks[8] + 4;
            }
            if (this.binary.charAt(66) == '1') {
                data_blocks[8] = data_blocks[8] + 2;
            }
            if (this.binary.charAt(67) == '1') {
                data_blocks[8] = data_blocks[8] + 1;
            }
        }
        this.info("Codewords: ");
        for (i = 0; i < data_codewords; ++i) {
            this.infoSpace(data_blocks[i]);
        }
        this.infoLine();
        rs.init_gf(285);
        rs.init_code(ecc_codewords, 0);
        rs.encode(data_codewords, data_blocks);
        for (i = 0; i < ecc_codewords; ++i) {
            ecc_blocks[i] = rs.getResult(i);
        }
        for (i = 0; i < ecc_codewords; ++i) {
            this.binary.append(this.toBinary(ecc_blocks[ecc_codewords - i - 1], 128));
        }
    }

    private void generateM4Symbol(EccMode ecc_mode) {
        int i;
        int remainder;
        int[] data_blocks = new int[17];
        int[] ecc_blocks = new int[15];
        ReedSolomon rs = new ReedSolomon();
        int bits_total = 128;
        if (ecc_mode == EccMode.M) {
            bits_total = 112;
        }
        if (ecc_mode == EccMode.Q) {
            bits_total = 80;
        }
        if ((remainder = 8 - this.binary.length() % 8) == 8) {
            remainder = 0;
        }
        for (i = 0; i < remainder; ++i) {
            this.binary.append("0");
        }
        int bits_left = bits_total - this.binary.length();
        remainder = bits_left / 8;
        for (i = 0; i < remainder; ++i) {
            if ((i & 1) != 0) {
                this.binary.append("00010001");
                continue;
            }
            this.binary.append("11101100");
        }
        int data_codewords = 16;
        int ecc_codewords = 8;
        if (ecc_mode == EccMode.M) {
            data_codewords = 14;
            ecc_codewords = 10;
        }
        if (ecc_mode == EccMode.Q) {
            data_codewords = 10;
            ecc_codewords = 14;
        }
        for (i = 0; i < data_codewords; ++i) {
            data_blocks[i] = 0;
            if (this.binary.charAt(i * 8) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 128;
            }
            if (this.binary.charAt(i * 8 + 1) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 64;
            }
            if (this.binary.charAt(i * 8 + 2) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 32;
            }
            if (this.binary.charAt(i * 8 + 3) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 16;
            }
            if (this.binary.charAt(i * 8 + 4) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 8;
            }
            if (this.binary.charAt(i * 8 + 5) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 4;
            }
            if (this.binary.charAt(i * 8 + 6) == '1') {
                int n = i;
                data_blocks[n] = data_blocks[n] + 2;
            }
            if (this.binary.charAt(i * 8 + 7) != '1') continue;
            int n = i;
            data_blocks[n] = data_blocks[n] + 1;
        }
        this.info("Codewords: ");
        for (i = 0; i < data_codewords; ++i) {
            this.infoSpace(data_blocks[i]);
        }
        this.infoLine();
        rs.init_gf(285);
        rs.init_code(ecc_codewords, 0);
        rs.encode(data_codewords, data_blocks);
        for (i = 0; i < ecc_codewords; ++i) {
            ecc_blocks[i] = rs.getResult(i);
        }
        for (i = 0; i < ecc_codewords; ++i) {
            this.binary.append(this.toBinary(ecc_blocks[ecc_codewords - i - 1], 128));
        }
    }

    private void setupBitGrid(int size) {
        int i;
        boolean toggle = true;
        for (i = 0; i < size; ++i) {
            if (toggle) {
                this.grid[i] = 33;
                this.grid[i * size] = 33;
                toggle = false;
                continue;
            }
            this.grid[i] = 32;
            this.grid[i * size] = 32;
            toggle = true;
        }
        this.placeFinderPattern(size, 0, 0);
        for (i = 0; i < 7; ++i) {
            this.grid[7 * size + i] = 16;
            this.grid[i * size + 7] = 16;
        }
        this.grid[7 * size + 7] = 16;
        for (i = 0; i < 8; ++i) {
            int n = 8 * size + i;
            this.grid[n] = this.grid[n] + 32;
            int n2 = i * size + 8;
            this.grid[n2] = this.grid[n2] + 32;
        }
        int n = 8 * size + 8;
        this.grid[n] = this.grid[n] + 32;
    }

    private void placeFinderPattern(int size, int x, int y) {
        int[] finder = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        for (int xp = 0; xp < 7; ++xp) {
            for (int yp = 0; yp < 7; ++yp) {
                this.grid[(yp + y) * size + (xp + x)] = finder[xp + 7 * yp] == 1 ? 17 : 16;
            }
        }
    }

    private void populateBitGrid(int size) {
        boolean goingUp = true;
        int row = 0;
        int n = this.binary.length();
        int y = size - 1;
        int i = 0;
        do {
            int x;
            if ((this.grid[y * size + ((x = size - 2 - row * 2) + 1)] & 0xF0) == 0) {
                this.grid[y * size + (x + 1)] = this.binary.charAt(i) == '1' ? 1 : 0;
                ++i;
            }
            if (i < n && (this.grid[y * size + x] & 0xF0) == 0) {
                this.grid[y * size + x] = this.binary.charAt(i) == '1' ? 1 : 0;
                ++i;
            }
            y = goingUp ? --y : ++y;
            if (y == 0) {
                ++row;
                y = 1;
                goingUp = false;
            }
            if (y != size) continue;
            ++row;
            y = size - 1;
            goingUp = true;
        } while (i < n);
    }

    private int applyBitmask(int size) {
        int local_pattern;
        int y;
        int x;
        int[] value = new int[8];
        int[] mask = new int[size * size];
        this.eval = new int[size * size];
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                mask[y * size + x] = 0;
                if ((this.grid[y * size + x] & 0xF0) != 0) continue;
                if ((y & 1) == 0) {
                    int n = y * size + x;
                    mask[n] = mask[n] + 1;
                }
                if ((y / 2 + x / 3 & 1) == 0) {
                    int n = y * size + x;
                    mask[n] = mask[n] + 2;
                }
                if (((y * x & 1) + y * x % 3 & 1) == 0) {
                    int n = y * size + x;
                    mask[n] = mask[n] + 4;
                }
                if (((y + x & 1) + y * x % 3 & 1) != 0) continue;
                int n = y * size + x;
                mask[n] = mask[n] + 8;
            }
        }
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                int p = (this.grid[y * size + x] & 1) != 0 ? 255 : 0;
                this.eval[y * size + x] = mask[y * size + x] ^ p;
            }
        }
        for (local_pattern = 0; local_pattern < 4; ++local_pattern) {
            value[local_pattern] = this.evaluateBitmask(size, local_pattern);
        }
        int best_pattern = 0;
        int best_val = value[0];
        for (local_pattern = 1; local_pattern < 4; ++local_pattern) {
            if (value[local_pattern] <= best_val) continue;
            best_pattern = local_pattern;
            best_val = value[local_pattern];
        }
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                boolean bit = false;
                switch (best_pattern) {
                    case 0: {
                        if ((mask[y * size + x] & 1) == 0) break;
                        bit = true;
                        break;
                    }
                    case 1: {
                        if ((mask[y * size + x] & 2) == 0) break;
                        bit = true;
                        break;
                    }
                    case 2: {
                        if ((mask[y * size + x] & 4) == 0) break;
                        bit = true;
                        break;
                    }
                    case 3: {
                        if ((mask[y * size + x] & 8) == 0) break;
                        bit = true;
                    }
                }
                if (!bit) continue;
                this.grid[y * size + x] = (this.grid[y * size + x] & 1) != 0 ? 0 : 1;
            }
        }
        return best_pattern;
    }

    private int evaluateBitmask(int size, int pattern) {
        int filter = 0;
        switch (pattern) {
            case 0: {
                filter = 1;
                break;
            }
            case 1: {
                filter = 2;
                break;
            }
            case 2: {
                filter = 4;
                break;
            }
            case 3: {
                filter = 8;
            }
        }
        int sum1 = 0;
        int sum2 = 0;
        for (int i = 1; i < size; ++i) {
            if ((this.eval[i * size + size - 1] & filter) != 0) {
                ++sum1;
            }
            if ((this.eval[(size - 1) * size + i] & filter) == 0) continue;
            ++sum2;
        }
        int retval = sum1 <= sum2 ? sum1 * 16 + sum2 : sum2 * 16 + sum1;
        return retval;
    }

    private static enum qrMode {
        NULL,
        KANJI,
        BINARY,
        ALPHANUM,
        NUMERIC;

    }

    public static enum EccMode {
        L,
        M,
        Q,
        H;

    }
}

