/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;

public class ChannelCode
extends Symbol {
    private int preferredNumberOfChannels;
    private int[] space = new int[11];
    private int[] bar = new int[11];
    private double currentValue;
    private double targetValue;

    public void setPreferredNumberOfChannels(int channels) {
        if (channels < 3 || channels > 8) {
            throw new IllegalArgumentException("Invalid Channel Code number of channels: " + channels);
        }
        this.preferredNumberOfChannels = channels;
    }

    public int getPreferredNumberOfChannels() {
        return this.preferredNumberOfChannels;
    }

    @Override
    protected void encode() {
        int i;
        if (this.content.length() > 7) {
            throw new OkapiException("Input too long");
        }
        if (!this.content.matches("[0-9]+")) {
            throw new OkapiException("Invalid characters in input");
        }
        int channels = this.preferredNumberOfChannels <= 2 || this.preferredNumberOfChannels > 8 ? 3 : this.preferredNumberOfChannels;
        this.targetValue = Integer.parseInt(this.content);
        switch (channels) {
            case 3: {
                if (this.targetValue > 26.0) {
                    ++channels;
                }
            }
            case 4: {
                if (this.targetValue > 292.0) {
                    ++channels;
                }
            }
            case 5: {
                if (this.targetValue > 3493.0) {
                    ++channels;
                }
            }
            case 6: {
                if (this.targetValue > 44072.0) {
                    ++channels;
                }
            }
            case 7: {
                if (this.targetValue > 576688.0) {
                    ++channels;
                }
            }
            case 8: {
                if (!(this.targetValue > 7742862.0)) break;
                ++channels;
            }
        }
        if (channels == 9) {
            throw new OkapiException("Value out of range");
        }
        this.infoLine("Channels Used: " + channels);
        for (i = 0; i < 11; ++i) {
            this.bar[i] = 0;
            this.space[i] = 0;
        }
        this.bar[2] = 1;
        this.space[2] = 1;
        this.bar[1] = 1;
        this.space[1] = 1;
        this.bar[0] = 1;
        this.currentValue = 0.0;
        this.pattern = new String[1];
        this.nextSpace(channels, 3, channels, channels);
        int leadingZeroCount = channels - 1 - this.content.length();
        this.readable = "";
        for (i = 0; i < leadingZeroCount; ++i) {
            this.readable = this.readable + "0";
        }
        this.readable = this.readable + this.content;
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void nextSpace(int channels, int i, int maxSpace, int maxBar) {
        int s;
        int n = s = i < channels + 2 ? 1 : maxSpace;
        while (s <= maxSpace) {
            this.space[i] = s;
            this.nextBar(channels, i, maxBar, maxSpace + 1 - s);
            ++s;
        }
    }

    private void nextBar(int channels, int i, int maxBar, int maxSpace) {
        int b;
        int n = b = this.space[i] + this.bar[i - 1] + this.space[i - 1] + this.bar[i - 2] > 4 ? 1 : 2;
        if (i < channels + 2) {
            while (b <= maxBar) {
                this.bar[i] = b;
                this.nextSpace(channels, i + 1, maxSpace, maxBar + 1 - b);
                ++b;
            }
        } else if (b <= maxBar) {
            this.bar[i] = maxBar;
            this.checkIfDone();
            this.currentValue += 1.0;
        }
    }

    private void checkIfDone() {
        if (this.currentValue == this.targetValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("11110");
            for (int i = 0; i < 11; ++i) {
                sb.append((char)(this.space[i] + 48));
                sb.append((char)(this.bar[i] + 48));
            }
            this.pattern[0] = sb.toString();
        }
    }
}

