/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode;

import com.beust.jcommander.Parameter;
import java.awt.Color;
import uk.org.okapibarcode.backend.HumanReadableLocation;

public class Settings {
    @Parameter(names={"-cli"}, description="Supress GUI loading", required=false)
    private boolean supressGui = false;
    @Parameter(names={"-t", "--types"}, description="Display table of barcode types", required=false)
    private boolean displayTypes = false;
    @Parameter(names={"-i", "--input"}, description="Read data from file", required=false)
    private String inputFile = "";
    @Parameter(names={"-o", "--output"}, description="Write image to file", required=false)
    private String outputFile = "out.png";
    @Parameter(names={"-d", "--data"}, description="Barcode content", required=false)
    private String inputData = "";
    @Parameter(names={"-b", "--barcode"}, description="Select barcode type", required=false)
    private int symbolType = 20;
    @Parameter(names={"--height"}, description="Height of the symbol in multiples of x-dimension", required=false)
    private int symbolHeight = 0;
    @Parameter(names={"-r", "--reverse"}, description="Reverse colours (white on black)", required=false)
    private boolean reverseColour = false;
    @Parameter(names={"--fg"}, description="Specify a foreground (ink) colour", required=false)
    private String foregroundColour = "000000";
    @Parameter(names={"--bg"}, description="Specify a background (paper) colour", required=false)
    private String backgroundColour = "FFFFFF";
    @Parameter(names={"--scale"}, description="Adjust size of output image", required=false)
    private int symbolScale = 0;
    @Parameter(names={"--cols"}, description="Number of columns in PDF417", required=false)
    private int symbolColumns = 0;
    @Parameter(names={"--vers"}, description="Set QR Code version number", required=false)
    private int symbolVersion = 0;
    @Parameter(names={"--secure"}, description="Set error correction level", required=false)
    private int symbolECC = 0;
    @Parameter(names={"--primary"}, description="Add structured primary message", required=false)
    private String primaryData = "";
    @Parameter(names={"--mode"}, description="Set encoding mode", required=false)
    private int encodeMode = 0;
    @Parameter(names={"--gs1"}, description="Treat input as GS1 data", required=false)
    private boolean dataGs1Mode = false;
    @Parameter(names={"--binary"}, description="Treat input as binary data", required=false)
    private boolean dataBinaryMode = false;
    @Parameter(names={"--notext"}, description="Remove human readable text", required=false)
    private boolean supressHrt = false;
    @Parameter(names={"--textabove"}, description="Place human readable text above symbol", required=false)
    private boolean superHrt = false;
    @Parameter(names={"--square"}, description="Force Data Matrix symbols to be square", required=false)
    private boolean makeSquare = false;
    @Parameter(names={"--init"}, description="Add reader initialisation code", required=false)
    private boolean addReaderInit = false;
    @Parameter(names={"--batch"}, description="Treat each line of input as a separate data set", required=false)
    private boolean batchMode = false;

    public boolean isGuiSupressed() {
        return this.supressGui;
    }

    public boolean isDisplayTypes() {
        return this.displayTypes;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getInputData() {
        return this.inputData;
    }

    public int getSymbolType() {
        return this.symbolType;
    }

    public int getSymbolHeight() {
        return this.symbolHeight;
    }

    public boolean isReverseColour() {
        return this.reverseColour;
    }

    public Color getForegroundColour() {
        Color inkColour = Color.BLACK;
        String fgColour = this.foregroundColour.toUpperCase();
        if (fgColour.matches("[0-9A-F]+") && fgColour.length() == 6) {
            inkColour = Color.decode("0x" + fgColour);
        }
        return inkColour;
    }

    public Color getBackgroundColour() {
        Color paperColour = Color.WHITE;
        String bgColour = this.backgroundColour.toUpperCase();
        if (bgColour.matches("[0-9A-F]+") && bgColour.length() == 6) {
            paperColour = Color.decode("0x" + bgColour);
        }
        return paperColour;
    }

    public int getSymbolScale() {
        return this.symbolScale;
    }

    public int getSymbolColumns() {
        return this.symbolColumns;
    }

    public int getSymbolVersion() {
        return this.symbolVersion;
    }

    public int getSymbolECC() {
        return this.symbolECC;
    }

    public String getPrimaryData() {
        return this.primaryData;
    }

    public int getEncodeMode() {
        return this.encodeMode;
    }

    public boolean isDataGs1Mode() {
        return this.dataGs1Mode;
    }

    public boolean isDataBinaryMode() {
        return this.dataBinaryMode;
    }

    public HumanReadableLocation getHrtPosition() {
        HumanReadableLocation temp = HumanReadableLocation.BOTTOM;
        if (this.superHrt) {
            temp = HumanReadableLocation.TOP;
        }
        if (this.supressHrt) {
            temp = HumanReadableLocation.NONE;
        }
        return temp;
    }

    public boolean isMakeSquare() {
        return this.makeSquare;
    }

    public boolean isReaderInit() {
        return this.addReaderInit;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }
}

