/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.macro.QRCodeMacro;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.QrCode;

@Scanned
public class QRCodeWifiMacro
extends QRCodeMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QRCodeWifiMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public QRCodeWifiMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager, null);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection;
        String encryption;
        StringBuilder result = new StringBuilder("WIFI:");
        String height = map.get("height");
        switch (encryption = map.getOrDefault("encryption", "WPA")) {
            case "None": {
                result.append("T:nopass;");
                log.debug("Setting encryption to none");
                break;
            }
            case "WEP": {
                result.append("T:WEP;");
                log.debug("Setting encryption to WEP");
                break;
            }
            default: {
                result.append("T:WPA;");
                log.debug("Setting encryption to WPA");
            }
        }
        String ssid = map.getOrDefault("ssid", "ssid");
        result.append("S:").append(ssid).append(";");
        String password = map.getOrDefault("password", "");
        result.append("P:").append(password).append(";");
        Boolean hidden = Boolean.valueOf(map.getOrDefault("hidden", "false"));
        if (Boolean.TRUE.equals(hidden)) {
            result.append("H:true;");
        } else {
            result.append(";");
        }
        QrCode code = new QrCode();
        switch (errorCorrection = map.getOrDefault("errorCorrectionlevel", "L")) {
            default: {
                code.setPreferredEccLevel(QrCode.EccLevel.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setPreferredEccLevel(QrCode.EccLevel.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setPreferredEccLevel(QrCode.EccLevel.Q);
                log.debug("Setting ECC Level to Q");
                break;
            }
            case "H": {
                code.setPreferredEccLevel(QrCode.EccLevel.H);
                log.debug("Setting ECC Level to H");
            }
        }
        try {
            code.setContent(result.toString());
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

