/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.macro.QRCodeMacro;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.QrCode;

@Scanned
public class QRCodeContactMacro
extends QRCodeMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(QRCodeContactMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public QRCodeContactMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager, null);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Override
    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection = map.getOrDefault("errorCorrectionlevel", "L");
        String height = map.get("height");
        String firstname = map.getOrDefault("firstname", "");
        String lastname = map.getOrDefault("lastname", "");
        String title = map.getOrDefault("title", "");
        String email = map.getOrDefault("email", "");
        String telephone = map.getOrDefault("telephone", "");
        String company = map.getOrDefault("company", "");
        String street = map.getOrDefault("street", "");
        String postalcode = map.getOrDefault("postalcode", "");
        String city = map.getOrDefault("city", "");
        String country = map.getOrDefault("country", "");
        String website = map.getOrDefault("website", "");
        QrCode code = new QrCode();
        StringBuilder result = new StringBuilder();
        result.append("BEGIN:VCARD\n");
        result.append("VERSION:3.0");
        if (firstname.length() > 0 || lastname.length() > 0 || title.length() > 0) {
            result.append("N:").append(lastname).append(";").append(firstname).append(";;").append(title).append(";\n");
            result.append("FN:").append(title).append(" ").append(firstname).append(" ").append(lastname).append("\n");
        }
        if (email.length() > 0) {
            result.append("EMAIL;TYPE=INTERNET:").append(email).append("\n");
        }
        if (telephone.length() > 0) {
            result.append("TYPE=WORK,VOICE:").append(telephone).append("\n");
        }
        if (company.length() > 0) {
            result.append("ORG:").append(company).append("\n");
        }
        if (street.length() > 0 || postalcode.length() > 0 || city.length() > 0 || country.length() > 0) {
            result.append("ADR;TYPE=WORK:;;").append(street).append(";").append(city).append(";;").append(postalcode).append(";").append(country).append("\n");
        }
        if (website.length() > 0) {
            result.append("URL:").append(website).append("\n");
        }
        result.append("END:VCARD");
        switch (errorCorrection) {
            default: {
                code.setPreferredEccLevel(QrCode.EccLevel.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setPreferredEccLevel(QrCode.EccLevel.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setPreferredEccLevel(QrCode.EccLevel.Q);
                log.debug("Setting ECC Level to Q");
                break;
            }
            case "H": {
                code.setPreferredEccLevel(QrCode.EccLevel.H);
                log.debug("Setting ECC Level to H");
            }
        }
        log.debug("Generating qr code for {}", (Object)result);
        try {
            code.setContent(result.toString());
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

