/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.imgscalr.Scalr;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.MicroQrCode;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

@Scanned
public class MicroQRCodeMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(MicroQRCodeMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private XhtmlContent xhtmlContent;

    @Inject
    public MicroQRCodeMacro(PluginLicenseManager pluginLicenseManager, XhtmlContent xhtmlContent) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
        this.xhtmlContent = xhtmlContent;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String errorCorrection;
        String height = map.get("height");
        MicroQrCode code = new MicroQrCode();
        if (s == null || s.equals("")) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        try {
            s = this.xhtmlContent.convertStorageToView(s, conversionContext);
        }
        catch (XhtmlException | XMLStreamException e) {
            log.error("Error converting {} to view", (Object)s, (Object)e);
        }
        switch (errorCorrection = map.getOrDefault("errorCorrectionlevel", "L")) {
            default: {
                code.setEccMode(MicroQrCode.EccMode.L);
                log.debug("Setting ECC Level to L");
                break;
            }
            case "M": {
                code.setEccMode(MicroQrCode.EccMode.M);
                log.debug("Setting ECC Level to M");
                break;
            }
            case "Q": {
                code.setEccMode(MicroQrCode.EccMode.Q);
                log.debug("Setting ECC Level to Q");
            }
        }
        try {
            code.setContent(Jsoup.parse(s).text());
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    @Override
    protected String getRenderedImage(Symbol symbol, String heightParam) {
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(heightParam);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)heightParam);
        }
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int factor = (int)Math.ceil((double)preferredHeight / (double)height);
        String result = this.checkValidity();
        if (result == null) {
            BufferedImage image = new BufferedImage(width * factor, height * factor, 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            int preferredWidth = preferredHeight;
            image = Scalr.resize(image, Scalr.Method.BALANCED, preferredWidth, preferredHeight, new BufferedImageOp[0]);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return result;
    }
}

