/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Map;
import javax.inject.Inject;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.GridMatrix;
import uk.org.okapibarcode.backend.OkapiException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.output.Java2DRenderer;

@Scanned
public class GridMatrixMacro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(GridMatrixMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public GridMatrixMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String eccLevel = map.getOrDefault("ecclevel", "10");
        String size = map.getOrDefault("size", "18x18");
        String height = map.get("height");
        if (s == null || s.length() == 0) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        GridMatrix code = new GridMatrix();
        Integer eccLevelInt = 1;
        try {
            eccLevelInt = Integer.valueOf(eccLevel.substring(0, 1));
            log.debug("Setting eccLevel to {}", (Object)eccLevel);
        }
        catch (NumberFormatException e) {
            log.debug("Illegal int: {}", (Object)eccLevel.substring(0, 1));
            eccLevelInt = 1;
        }
        log.debug("Setting size to {}", (Object)size);
        switch (size) {
            case "18x18": {
                code.setPreferredVersion(1);
                break;
            }
            case "30x30": {
                code.setPreferredVersion(2);
                break;
            }
            case "42x42": {
                code.setPreferredVersion(3);
                break;
            }
            case "54x54": {
                code.setPreferredVersion(4);
                break;
            }
            case "66x66": {
                code.setPreferredVersion(5);
                break;
            }
            case "78x78": {
                code.setPreferredVersion(6);
                break;
            }
            case "90x90": {
                code.setPreferredVersion(7);
                break;
            }
            case "102x102": {
                code.setPreferredVersion(8);
                break;
            }
            case "114x114": {
                code.setPreferredVersion(9);
                break;
            }
            case "126x126": {
                code.setPreferredVersion(10);
                break;
            }
            case "138x138": {
                code.setPreferredVersion(11);
                break;
            }
            case "150x150": {
                code.setPreferredVersion(12);
                break;
            }
            case "162x162": {
                code.setPreferredVersion(13);
                break;
            }
            default: {
                code.setPreferredVersion(1);
            }
        }
        code.setPreferredEccLevel(eccLevelInt);
        try {
            code.setContent(s);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }

    @Override
    protected String getRenderedImage(Symbol symbol, String heightParam) {
        int preferredHeight = 100;
        try {
            preferredHeight = Integer.parseInt(heightParam);
        }
        catch (NumberFormatException ignored) {
            log.debug("Invalid height {}", (Object)heightParam);
        }
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int factor = (int)Math.ceil((double)preferredHeight / (double)height);
        String result = this.checkValidity();
        if (result == null) {
            BufferedImage image = new BufferedImage(width * factor, height * factor, 10);
            Graphics2D g2d = image.createGraphics();
            Java2DRenderer renderer = new Java2DRenderer(g2d, factor, Color.WHITE, Color.BLACK);
            renderer.render(symbol);
            int preferredWidth = preferredHeight;
            image = Scalr.resize(image, Scalr.Method.BALANCED, preferredWidth, preferredHeight, new BufferedImageOp[0]);
            return "<div><img src=\"data:image/png;base64," + this.getBase64FromByteArrayOutputStream(image) + "\"/></div>";
        }
        return result;
    }
}

